/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.screens;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.ui.screens.PushdozerConfigScreen;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3481;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class BlockSelectionScreen
extends class_437 {
    private final PushdozerConfigScreen parent;
    private final PushdozerConfig config;
    private List<BlockCategory> blockCategories;
    private final Set<class_2248> selectedBlocks;
    private static List<BlockCategory> cachedCategories = null;
    private static Map<class_2248, String> globalSearchStrings = new HashMap<class_2248, String>();
    private int currentPage = 0;
    private String searchText = "";
    private class_342 searchBox;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 80;
    private static final int BUTTON_SPACING = 10;
    private static final int SEARCH_WIDTH = 260;
    private static final int CATEGORIES_PER_PAGE = 4;
    private static final int CATEGORY_BUTTON_HEIGHT = 20;
    private static final int BLOCK_SIZE = 20;
    private static final int TOP_MARGIN = 35;
    private static final int BOTTOM_MARGIN = 10;
    private static final int SEARCH_BOTTOM_SPACING = 5;
    private static final int PAGE_NUMBER_SPACING = 10;
    private static final int PANEL_BACKGROUND_COLOR = 0x40000000;
    private static final int BLOCK_BORDER_COLOR = -7631989;
    private static final int BLOCK_BACKGROUND_COLOR = -13158601;
    private static final int BLOCK_HOVER_COLOR = -11184811;
    private static final int SCROLL_BAR_BACKGROUND_COLOR = 0x33FFFFFF;
    private static final int SCROLL_BAR_COLOR = -5592406;
    private static final int SCROLL_BAR_HIGHLIGHT_COLOR = -1;
    private static final int SCROLL_BAR_SHADOW_COLOR = -11184811;
    private static final int SELECTED_BLOCK_BORDER_COLOR = -1;

    public BlockSelectionScreen(PushdozerConfigScreen parent, PushdozerConfig config) {
        super((class_2561)class_2561.method_43471((String)"pushdozer.screen.block_selection.title"));
        this.parent = parent;
        this.config = config;
        this.blockCategories = this.getAllRelevantBlocks();
        this.selectedBlocks = new HashSet<class_2248>(config.getBreakableBlocks());
    }

    protected void method_25426() {
        super.method_25426();
        this.addSearchAndButtons(false);
        this.refreshCategoryButtons();
    }

    public void method_25393() {
        super.method_25393();
    }

    private void addSearchAndButtons(boolean restoreFocus) {
        int totalWidth = 260;
        int startX = (this.field_22789 - totalWidth) / 2;
        int buttonY = this.field_22790 - 20 - 10;
        int searchBoxY = buttonY - 20 - 5;
        this.searchBox = new class_342(this.field_22793, startX, searchBoxY, 260, 20, (class_2561)class_2561.method_43471((String)"pushdozer.screen.block_selection.search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(true);
        this.searchBox.method_1862(true);
        this.searchBox.method_1888(true);
        this.searchBox.method_1852(this.searchText);
        this.searchBox.method_25365(restoreFocus);
        this.searchBox.method_1863(this::onSearchTextChanged);
        this.method_37063((class_364)this.searchBox);
        this.addPageButtons();
        this.addSelectionButtons();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean result = super.method_25402(mouseX, mouseY, button);
        if (this.searchBox != null) {
            if (this.searchBox.method_25405(mouseX, mouseY)) {
                this.searchBox.method_25365(true);
                return true;
            }
            this.searchBox.method_25365(false);
        }
        return result;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.method_25370()) {
            if (keyCode == 256) {
                this.searchBox.method_25365(false);
                return true;
            }
            if (keyCode == 257) {
                this.focusOnMatch();
                return true;
            }
            if (this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.searchBox != null && this.searchBox.method_25370() && this.searchBox.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    private void focusOnMatch() {
        if (this.searchText.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.blockCategories.size(); ++i) {
            BlockCategory category = this.blockCategories.get(i);
            for (int j = 0; j < category.blocks.size(); ++j) {
                class_2248 block = category.blocks.get(j);
                String blockName = class_2561.method_43471((String)block.method_63499()).getString().toLowerCase();
                String blockId = class_7923.field_41175.method_10221((Object)block).method_12832().toLowerCase();
                if (!blockName.contains(this.searchText.toLowerCase()) && !blockId.contains(this.searchText.toLowerCase())) continue;
                int targetPage = i / 4;
                if (this.currentPage != targetPage) {
                    this.currentPage = targetPage;
                    this.refreshCategoryButtons();
                }
                this.scrollToBlock(block, j);
                return;
            }
        }
    }

    private void scrollToBlock(class_2248 targetBlock, int blockIndex) {
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof ScrollablePanel)) continue;
            ScrollablePanel panel = (ScrollablePanel)child;
            if (!panel.blocks.contains(targetBlock)) continue;
            int row = blockIndex / 4;
            int targetScrollOffset = row * 24;
            int maxScroll = Math.max(0, (panel.blocks.size() + 3) / 4 - panel.getVisibleRows()) * 24;
            panel.scrollOffset = Math.max(0, Math.min(targetScrollOffset, maxScroll));
            break;
        }
    }

    private void onSearchTextChanged(String text) {
        if (!text.equals(this.searchText)) {
            this.searchText = text;
            this.refreshCategoryButtons();
        }
    }

    private boolean matchesSearch(class_2248 block) {
        if (this.searchText.isEmpty()) {
            return true;
        }
        String searchLower = this.searchText.toLowerCase();
        String searchString = globalSearchStrings.get(block);
        if (searchString != null) {
            return searchString.contains(searchLower);
        }
        String blockName = class_2561.method_43471((String)block.method_63499()).getString().toLowerCase();
        String blockId = class_7923.field_41175.method_10221((Object)block).method_12832().toLowerCase();
        return blockName.contains(searchLower) || blockId.contains(searchLower);
    }

    private void addPageButtons() {
        this.method_37063((class_364)new PageButtonWidget(10, this.field_22790 / 2, 20, 20, (class_2561)class_2561.method_43470((String)"<"), button -> this.changePage(-1), (class_2561)class_2561.method_43471((String)"pushdozer.screen.block_selection.previous_page")));
        this.method_37063((class_364)new PageButtonWidget(this.field_22789 - 30, this.field_22790 / 2, 20, 20, (class_2561)class_2561.method_43470((String)">"), button -> this.changePage(1), (class_2561)class_2561.method_43471((String)"pushdozer.screen.block_selection.next_page")));
    }

    private void changePage(int delta) {
        int totalPages = (this.blockCategories.size() - 1) / 4 + 1;
        this.currentPage += delta;
        if (this.currentPage < 0) {
            this.currentPage = totalPages - 1;
        } else if (this.currentPage >= totalPages) {
            this.currentPage = 0;
        }
        this.refreshCategoryButtons();
    }

    private void refreshCategoryButtons() {
        boolean wasFocused = this.searchBox != null && this.searchBox.method_25370();
        this.method_37067();
        this.addSearchAndButtons(wasFocused);
        int categorySpacing = 8;
        int blockSpacing = 4;
        int categoryToBlockSpacing = 10;
        int scrollBarWidth = 4;
        int categoryWidth = 80 + blockSpacing * 3 + scrollBarWidth;
        int totalWidth2 = 4 * categoryWidth + 3 * categorySpacing;
        int startX2 = (this.field_22789 - totalWidth2) / 2;
        int startY = 35;
        int startIndex = this.currentPage * 4;
        for (int i = 0; i < 4 && startIndex + i < this.blockCategories.size(); ++i) {
            BlockCategory category = this.blockCategories.get(startIndex + i);
            int columnX = startX2 + i * (categoryWidth + categorySpacing);
            List<class_2248> filteredBlocks = category.blocks.stream().filter(this::matchesSearch).collect(Collectors.toList());
            class_5250 categoryText = class_2561.method_43470((String)(category.getTranslatedName().getString() + " (" + filteredBlocks.size() + ")"));
            this.method_37063((class_364)class_4185.method_46430((class_2561)categoryText, button -> this.toggleCategorySelection(category)).method_46434(columnX, startY, categoryWidth, 20).method_46431());
            int bottomSpace = 65;
            int panelHeight = this.field_22790 - startY - 20 - categoryToBlockSpacing - bottomSpace + 2;
            ScrollablePanel scrollPanel = new ScrollablePanel(columnX, startY + 20 + categoryToBlockSpacing, categoryWidth, panelHeight, filteredBlocks);
            this.method_37063((class_364)scrollPanel);
        }
    }

    private void addSelectionButtons() {
        int y = this.field_22790 - 20 - 10;
        int totalWidth = 260;
        int startX = (this.field_22789 - totalWidth) / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.screen.block_selection.select_all"), button -> this.selectAll()).method_46434(startX, y, 80, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.screen.block_selection.deselect_all"), button -> this.deselectAll()).method_46434(startX + 80 + 10, y, 80, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.screen.block_selection.confirm"), button -> this.confirmSelection()).method_46434(startX + 180, y, 80, 20).method_46431());
    }

    private String getPageText() {
        int totalPages = (this.blockCategories.size() - 1) / 4 + 1;
        return String.format("%d/%d", this.currentPage + 1, totalPages);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.method_25440(), this.field_22789 / 2, 10, 0xFFFFFF);
        String selectedCountText = String.format("\u5df2\u9009\u62e9: %d \u4e2a\u65b9\u5757", this.selectedBlocks.size());
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)selectedCountText), this.field_22789 / 2, 25, 0xFFFFFF);
        String pageText = this.getPageText();
        int searchBoxY = this.field_22790 - 20 - 10 - 20 - 5;
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)pageText), this.field_22789 / 2, searchBoxY - 10, 0xFFFFFF);
    }

    private void toggleBlockSelection(class_2248 block) {
        if (this.selectedBlocks.contains(block)) {
            this.selectedBlocks.remove(block);
        } else {
            this.selectedBlocks.add(block);
        }
    }

    private void toggleCategorySelection(BlockCategory category) {
        boolean allSelected = this.selectedBlocks.containsAll(category.blocks);
        if (allSelected) {
            category.blocks.forEach(this.selectedBlocks::remove);
        } else {
            this.selectedBlocks.addAll(category.blocks);
        }
        this.refreshCategoryButtons();
    }

    private void selectAll() {
        this.selectedBlocks.clear();
        for (BlockCategory category : this.blockCategories) {
            this.selectedBlocks.addAll(category.blocks);
        }
        this.refreshCategoryButtons();
    }

    private void deselectAll() {
        this.selectedBlocks.clear();
        this.refreshCategoryButtons();
    }

    private void confirmSelection() {
        this.config.setBreakableBlocks(new ArrayList<class_2248>(this.selectedBlocks));
        class_310.method_1551().method_1507((class_437)this.parent);
    }

    private List<BlockCategory> getAllRelevantBlocks() {
        if (cachedCategories == null) {
            LinkedHashMap<String, BlockCategory> categoryMap = new LinkedHashMap<String, BlockCategory>();
            HashSet<String> processedBlockIds = new HashSet<String>();
            for (class_2248 block : class_7923.field_41175) {
                class_1792 item = block.method_8389();
                String blockId = class_7923.field_41175.method_10221((Object)block).toString();
                String blockIdPath = class_7923.field_41175.method_10221((Object)block).method_12832().toLowerCase();
                if (item == class_1802.field_8162 && !blockIdPath.equals("water") && !blockIdPath.equals("lava") && !blockIdPath.equals("kelp_plant") && !blockIdPath.equals("tall_seagrass") || processedBlockIds.contains(blockId)) continue;
                processedBlockIds.add(blockId);
                List<String> categoryKeys = this.getCategoriesForBlock(block);
                if (categoryKeys.size() > 3) {
                    categoryKeys.sort((a, b) -> Integer.compare(this.getCategoryPriority((String)a), this.getCategoryPriority((String)b)));
                    categoryKeys = categoryKeys.subList(0, 3);
                }
                for (String categoryKey : categoryKeys) {
                    BlockCategory category = categoryMap.computeIfAbsent(categoryKey, key -> new BlockCategory((String)key, this.getCategoryPriority((String)key)));
                    category.addBlock(block);
                }
            }
            cachedCategories = new ArrayList(categoryMap.values());
            cachedCategories.sort(Comparator.comparingInt(BlockCategory::getPriority));
            for (BlockCategory category : cachedCategories) {
                category.blocks.sort(Comparator.comparing(b -> class_7923.field_41175.method_10221(b).method_12832()));
            }
        }
        return cachedCategories;
    }

    private int getCategoryPriority(String categoryKey) {
        return switch (categoryKey) {
            case "pushdozer.category.terrain" -> 1;
            case "pushdozer.category.ores" -> 2;
            case "pushdozer.category.wood" -> 3;
            case "pushdozer.category.doors_and_trapdoors" -> 4;
            case "pushdozer.category.leaves" -> 5;
            case "pushdozer.category.plants_and_flowers" -> 6;
            case "pushdozer.category.crops" -> 7;
            case "pushdozer.category.fungi" -> 8;
            case "pushdozer.category.coral" -> 9;
            case "pushdozer.category.nether" -> 10;
            case "pushdozer.category.stairs_and_slabs" -> 11;
            case "pushdozer.category.fences_and_walls" -> 12;
            case "pushdozer.category.buttons_and_pressure_plates" -> 13;
            case "pushdozer.category.copper" -> 14;
            case "pushdozer.category.amethyst" -> 15;
            case "pushdozer.category.valuable" -> 16;
            case "pushdozer.category.redstone" -> 17;
            case "pushdozer.category.decorative" -> 18;
            case "pushdozer.category.dyed" -> 19;
            case "pushdozer.category.functional" -> 20;
            case "pushdozer.category.heads" -> 21;
            case "pushdozer.category.rails" -> 22;
            case "pushdozer.category.cave_decorations" -> 23;
            case "pushdozer.category.fluids" -> 24;
            case "pushdozer.category.bricks_and_tiles" -> 25;
            case "pushdozer.category.technical" -> 26;
            case "pushdozer.category.miscellaneous" -> 27;
            default -> 100;
        };
    }

    private List<String> getCategoriesForBlock(class_2248 block) {
        ArrayList<String> categories = new ArrayList<String>();
        String blockId = class_7923.field_41175.method_10221((Object)block).method_12832().toLowerCase();
        try {
            if (block.method_9564().method_26164(class_3481.field_29822) || block.method_9564().method_26164(class_3481.field_25806) || block.method_9564().method_26164(class_3481.field_15466) || block.method_9564().method_26164(class_3481.field_15467) || block.method_9564().method_26164(class_3481.field_29823) || this.isTerrainManual(blockId)) {
                categories.add("pushdozer.category.terrain");
            }
            if ((blockId.contains("ore") || blockId.equals("ancient_debris")) && !blockId.equals("spore_blossom") && !blockId.equals("heavy_core")) {
                categories.add("pushdozer.category.ores");
            }
            if (block.method_9564().method_26164(class_3481.field_15475) || block.method_9564().method_26164(class_3481.field_15471) || this.isWoodManual(blockId)) {
                categories.add("pushdozer.category.wood");
            }
            if (block.method_9564().method_26164(class_3481.field_15495) || block.method_9564().method_26164(class_3481.field_15487)) {
                categories.add("pushdozer.category.doors_and_trapdoors");
            }
            if (block.method_9564().method_26164(class_3481.field_15503)) {
                categories.add("pushdozer.category.leaves");
            }
            if (block.method_9564().method_26164(class_3481.field_20339) || block.method_9564().method_26164(class_3481.field_15462) || blockId.equals("spore_blossom") || blockId.equals("chorus_plant") || blockId.equals("chorus_flower") || this.isPlantManual(blockId)) {
                categories.add("pushdozer.category.plants_and_flowers");
            }
            if (!(!block.method_9564().method_26164(class_3481.field_20341) && !block.method_9564().method_26164(class_3481.field_20342) && !this.isCropManual(blockId) || blockId.equals("nether_wart") || blockId.equals("torchflower_crop") || blockId.equals("chorus_plant") || blockId.equals("chorus_flower"))) {
                categories.add("pushdozer.category.crops");
            }
            if (block.method_9564().method_26164(class_3481.field_25739) || this.isFungiManual(blockId)) {
                categories.add("pushdozer.category.fungi");
            }
            if (block.method_9564().method_26164(class_3481.field_15488) || block.method_9564().method_26164(class_3481.field_15461) || block.method_9564().method_26164(class_3481.field_15483) || block.method_9564().method_26164(class_3481.field_15476) || this.isCoralManual(blockId)) {
                categories.add("pushdozer.category.coral");
            }
            if (block.method_9564().method_26164(class_3481.field_25807) || block.method_9564().method_26164(class_3481.field_21953) || block.method_9564().method_26164(class_3481.field_23119) || block.method_9564().method_26164(class_3481.field_23063) || blockId.equals("nether_wart") || blockId.equals("torchflower_crop") || blockId.equals("nether_sprouts") || blockId.equals("nether_wart_block") || this.isNetherManual(blockId)) {
                categories.add("pushdozer.category.nether");
            }
            if (block.method_9564().method_26164(class_3481.field_15459) || block.method_9564().method_26164(class_3481.field_15469)) {
                categories.add("pushdozer.category.stairs_and_slabs");
            }
            if (block.method_9564().method_26164(class_3481.field_16584) || block.method_9564().method_26164(class_3481.field_15504) || block.method_9564().method_26164(class_3481.field_25147)) {
                categories.add("pushdozer.category.fences_and_walls");
            }
            if (block.method_9564().method_26164(class_3481.field_15493) || block.method_9564().method_26164(class_3481.field_24076)) {
                categories.add("pushdozer.category.buttons_and_pressure_plates");
            }
            if (block.method_9564().method_26164(class_3481.field_29195) || this.isCopperManual(blockId)) {
                categories.add("pushdozer.category.copper");
            }
            if (this.isAmethystManual(blockId)) {
                categories.add("pushdozer.category.amethyst");
            }
            if (block.method_9564().method_26164(class_3481.field_22275) || this.isValuableManual(blockId)) {
                categories.add("pushdozer.category.valuable");
            }
            if (block.method_9564().method_26164(class_3481.field_28990) || this.isRedstoneManual(blockId)) {
                categories.add("pushdozer.category.redstone");
            }
            if (this.isDecorativeManual(blockId)) {
                categories.add("pushdozer.category.decorative");
            }
            if (block.method_9564().method_26164(class_3481.field_15481) || block.method_9564().method_26164(class_3481.field_15479) || block.method_9564().method_26164(class_3481.field_36265) || this.isDyedManual(blockId)) {
                categories.add("pushdozer.category.dyed");
            }
            if (block.method_9564().method_26164(class_3481.field_15486) || block.method_9564().method_26164(class_3481.field_26985) || block.method_9564().method_26164(class_3481.field_21490) || this.isFunctionalManual(blockId)) {
                categories.add("pushdozer.category.functional");
            }
            if (this.isHeadManual(blockId)) {
                categories.add("pushdozer.category.heads");
            }
            if (block.method_9564().method_26164(class_3481.field_15463)) {
                categories.add("pushdozer.category.rails");
            }
            if (this.isCaveManual(blockId)) {
                categories.add("pushdozer.category.cave_decorations");
            }
            if (this.isFluidManual(blockId)) {
                categories.add("pushdozer.category.fluids");
            }
            if (this.isBrickManual(blockId)) {
                categories.add("pushdozer.category.bricks_and_tiles");
            }
            if (this.isTechnicalManual(blockId)) {
                categories.add("pushdozer.category.technical");
            }
        }
        catch (NoSuchFieldError e) {
            System.err.println("Missing tag for block: " + blockId + ", using manual classification");
        }
        catch (Exception e) {
            System.err.println("Failed to check tags for block: " + blockId + ", using manual classification: " + e.getMessage());
        }
        if (categories.isEmpty()) {
            System.out.println("Unclassified block: " + blockId);
            categories.add("pushdozer.category.miscellaneous");
        }
        return categories;
    }

    private boolean isTerrainManual(String blockId) {
        return blockId.equals("obsidian") || blockId.equals("bedrock") || blockId.equals("mud") || blockId.equals("muddy_mangrove_roots") || blockId.equals("packed_mud") || blockId.equals("dirt_path") || blockId.equals("farmland") || blockId.equals("gravel") || blockId.equals("snow_block") || blockId.equals("powder_snow") || blockId.equals("calcite") || blockId.equals("clay") || blockId.equals("deepslate") || blockId.equals("stone") || blockId.equals("cobblestone") || blockId.equals("cobbled_deepslate") || blockId.equals("end_stone") || blockId.equals("glowstone") || blockId.equals("infested_stone") || blockId.equals("infested_deepslate") || blockId.equals("infested_cobblestone") || blockId.equals("suspicious_gravel") || blockId.contains("soil") && !blockId.contains("soul");
    }

    private boolean isWoodManual(String blockId) {
        return blockId.contains("bamboo_block") || blockId.contains("stripped_bamboo") || blockId.contains("hyphae") || blockId.equals("bamboo_mosaic");
    }

    private boolean isPlantManual(String blockId) {
        return blockId.contains("grass") && !blockId.equals("grass_block") && !blockId.contains("seagrass") || blockId.contains("fern") || blockId.contains("vine") || blockId.contains("azalea") || blockId.contains("bush") || blockId.contains("roots") || blockId.contains("dripleaf") || blockId.equals("cactus") || blockId.equals("dead_bush") || blockId.equals("lily_pad") || blockId.equals("spore_blossom") || blockId.equals("glow_lichen") || blockId.contains("hanging_roots") || blockId.contains("big_dripleaf_stem") || blockId.equals("cocoa") || blockId.equals("bamboo") || blockId.equals("sea_pickle") || blockId.equals("tall_seagrass") || blockId.equals("kelp_plant") || blockId.equals("seagrass") || blockId.contains("chorus") || blockId.equals("kelp") || blockId.contains("leaf_litter");
    }

    private boolean isCropManual(String blockId) {
        if (blockId.equals("nether_wart") || blockId.equals("torchflower_crop") || blockId.equals("chorus_plant") || blockId.equals("chorus_flower")) {
            return false;
        }
        return blockId.equals("sugar_cane") || blockId.equals("pumpkin") || blockId.equals("melon") || blockId.equals("pumpkin_stem") || blockId.equals("melon_stem") || blockId.equals("attached_pumpkin_stem") || blockId.equals("attached_melon_stem") || blockId.equals("sweet_berry_bush");
    }

    private boolean isFungiManual(String blockId) {
        return blockId.equals("brown_mushroom") || blockId.equals("red_mushroom") || blockId.equals("brown_mushroom_block") || blockId.equals("red_mushroom_block") || blockId.equals("mushroom_stem");
    }

    private boolean isCoralManual(String blockId) {
        return blockId.contains("coral") || blockId.contains("coral_block") || blockId.contains("coral_fan") || blockId.contains("coral_wall_fan");
    }

    private boolean isNetherManual(String blockId) {
        return blockId.equals("netherrack") || blockId.equals("magma_block") || blockId.equals("soul_sand") || blockId.equals("soul_soil") || blockId.equals("nether_quartz_ore") || blockId.equals("nether_gold_ore") || blockId.equals("ancient_debris") || blockId.equals("basalt") || blockId.equals("smooth_basalt") || blockId.contains("blackstone") || blockId.equals("crying_obsidian") || blockId.equals("crimson_nylium") || blockId.equals("warped_nylium") || blockId.contains("crimson_stem") || blockId.contains("warped_stem") || blockId.equals("crimson_fungus") || blockId.equals("warped_fungus") || blockId.equals("crimson_roots") || blockId.equals("warped_roots") || blockId.equals("nether_wart_block") || blockId.equals("warped_wart_block") || blockId.equals("weeping_vines") || blockId.equals("twisting_vines") || blockId.equals("shroomlight") || blockId.equals("nether_sprouts") || blockId.contains("nether_brick") || blockId.contains("red_nether_brick") || blockId.equals("blaze_spawner") || blockId.equals("magma_cube_spawner") || blockId.equals("respawn_anchor") || blockId.equals("lodestone");
    }

    private boolean isCopperManual(String blockId) {
        return blockId.contains("copper") && !blockId.contains("copper_ore");
    }

    private boolean isAmethystManual(String blockId) {
        return blockId.contains("amethyst");
    }

    private boolean isValuableManual(String blockId) {
        return blockId.endsWith("_block") && (blockId.contains("gold") || blockId.contains("iron") || blockId.contains("diamond") || blockId.contains("emerald") || blockId.contains("netherite") || blockId.contains("lapis"));
    }

    private boolean isRedstoneManual(String blockId) {
        return blockId.contains("redstone") || blockId.contains("piston") || blockId.contains("dispenser") || blockId.contains("observer") || blockId.contains("hopper") || blockId.contains("comparator") || blockId.contains("repeater") || blockId.equals("tnt") || blockId.contains("target") || blockId.contains("note_block") || blockId.contains("jukebox") || blockId.contains("daylight_detector");
    }

    private boolean isDecorativeManual(String blockId) {
        return blockId.contains("torch") && !blockId.contains("torchflower") || blockId.contains("lantern") || blockId.contains("frame") || blockId.contains("bell") || blockId.equals("scaffolding") || blockId.equals("chain") || blockId.equals("campfire") || blockId.equals("soul_campfire") || blockId.equals("sea_lantern") || blockId.equals("conduit") || blockId.equals("end_rod") || blockId.equals("beacon") || blockId.equals("decorated_pot") || blockId.equals("painting") || blockId.equals("carved_pumpkin") || blockId.equals("cake") || blockId.equals("iron_bars") || blockId.equals("ladder") || blockId.equals("tripwire_hook") || blockId.equals("lever") || blockId.equals("lightning_rod") || blockId.equals("dried_kelp_block") || blockId.equals("hay_bale") || blockId.startsWith("potted_") || blockId.contains("flower_pot");
    }

    private boolean isDyedManual(String blockId) {
        String[] colors;
        if (blockId.equals("bedrock")) {
            return false;
        }
        if (blockId.contains("glass")) {
            return true;
        }
        if (blockId.contains("concrete")) {
            return true;
        }
        if (blockId.contains("banner") || blockId.contains("candle") || blockId.contains("bed")) {
            return true;
        }
        for (String color : colors = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"}) {
            if (!blockId.startsWith(color + "_") || blockId.contains("mushroom") || blockId.contains("tulip") || blockId.equals("pink_petals") || blockId.contains("orchid")) continue;
            return true;
        }
        return false;
    }

    private boolean isFunctionalManual(String blockId) {
        return blockId.contains("table") || blockId.contains("chest") || blockId.contains("sign") || blockId.contains("anvil") || blockId.contains("barrel") || blockId.contains("furnace") || blockId.contains("smoker") || blockId.contains("grindstone") || blockId.contains("loom") || blockId.contains("stonecutter") || blockId.contains("lectern") || blockId.contains("composter") || blockId.contains("cauldron") || blockId.contains("brewing_stand") || blockId.contains("enchanting_table") || blockId.contains("ender_chest") || blockId.contains("shulker_box") || blockId.contains("crafting_table") || blockId.contains("bookshelf") || blockId.contains("jukebox") || blockId.contains("note_block") || blockId.equals("crafter") || blockId.equals("dropper") || blockId.equals("heavy_core") || blockId.equals("spawner") || blockId.equals("trial_spawner") || blockId.equals("vault");
    }

    private boolean isHeadManual(String blockId) {
        return blockId.endsWith("_head") || blockId.endsWith("_skull");
    }

    private boolean isCaveManual(String blockId) {
        return blockId.contains("dripstone") || blockId.contains("spore") && !blockId.equals("spore_blossom") || blockId.contains("lichen") || blockId.contains("moss") || blockId.contains("sculk");
    }

    private boolean isFluidManual(String blockId) {
        return blockId.equals("water") || blockId.equals("lava");
    }

    private boolean isBrickManual(String blockId) {
        return blockId.contains("brick") || blockId.contains("tile") || blockId.contains("sandstone") || blockId.contains("prismarine") || blockId.contains("quartz") || blockId.equals("smooth_stone") || blockId.equals("smooth_quartz") || blockId.equals("smooth_sandstone") || blockId.equals("smooth_red_sandstone") || blockId.equals("cut_sandstone") || blockId.equals("cut_red_sandstone") || blockId.equals("chiseled_sandstone") || blockId.equals("chiseled_red_sandstone") || blockId.equals("chiseled_quartz_block") || blockId.equals("quartz_pillar") || blockId.contains("terracotta") || blockId.equals("chiseled_deepslate") || blockId.equals("chiseled_polished_blackstone") || blockId.equals("chiseled_tuff") || blockId.equals("polished_andesite") || blockId.equals("polished_basalt") || blockId.equals("polished_blackstone") || blockId.equals("polished_deepslate") || blockId.equals("polished_diorite") || blockId.equals("polished_granite") || blockId.equals("polished_tuff") || blockId.equals("purpur_block") || blockId.equals("purpur_pillar") || blockId.equals("reinforced_deepslate");
    }

    private boolean isTechnicalManual(String blockId) {
        return blockId.equals("barrier") || blockId.equals("command_block") || blockId.equals("repeating_command_block") || blockId.equals("chain_command_block") || blockId.equals("structure_block") || blockId.equals("jigsaw") || blockId.equals("light") || blockId.equals("fire") || blockId.equals("soul_fire") || blockId.equals("structure_void") || blockId.equals("test_block") || blockId.equals("test_instance") || blockId.equals("test_example") || blockId.equals("test_sample") || blockId.equals("test_case") || blockId.equals("test_unit");
    }

    private static class BlockCategory {
        String translationKey;
        List<class_2248> blocks;
        private int priority;
        private Set<String> addedBlockIds;

        BlockCategory(String translationKey, int priority) {
            this.translationKey = translationKey;
            this.priority = priority;
            this.blocks = new ArrayList<class_2248>();
            this.addedBlockIds = new HashSet<String>();
        }

        public class_2561 getTranslatedName() {
            return class_2561.method_43471((String)this.translationKey);
        }

        public void addBlock(class_2248 block) {
            String blockId = class_7923.field_41175.method_10221((Object)block).toString();
            if (!this.addedBlockIds.contains(blockId)) {
                this.blocks.add(block);
                this.addedBlockIds.add(blockId);
                if (!globalSearchStrings.containsKey(block)) {
                    String blockName = class_2561.method_43471((String)block.method_63499()).getString().toLowerCase();
                    String blockIdPath = class_7923.field_41175.method_10221((Object)block).method_12832().toLowerCase();
                    globalSearchStrings.put(block, blockName + "|" + blockIdPath);
                }
            }
        }

        public int getPriority() {
            return this.priority;
        }
    }

    private class ScrollablePanel
    extends class_4185 {
        private final List<class_2248> blocks;
        private int scrollOffset;
        private static final int SCROLL_BAR_WIDTH = 4;
        private static final int BLOCK_SPACING = 4;
        private int hoveredX;
        private int hoveredY;
        private boolean isDraggingScrollBar;
        private int dragStartY;
        private int dragStartScrollOffset;
        private long hoverStartTime;
        private static final long TOOLTIP_DELAY = 500L;
        private class_2248 lastHoveredBlock;

        public ScrollablePanel(int x, int y, int width, int height, List<class_2248> blocks) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), button -> {}, field_40754);
            this.scrollOffset = 0;
            this.isDraggingScrollBar = false;
            this.dragStartY = 0;
            this.dragStartScrollOffset = 0;
            this.hoverStartTime = 0L;
            this.lastHoveredBlock = null;
            this.blocks = blocks;
        }

        private int getVisibleRows() {
            return this.field_22759 / 24;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            int totalRows = (this.blocks.size() + 3) / 4;
            int visibleRows = this.getVisibleRows();
            class_2248 hoveredBlock = null;
            int backgroundWidth = 92;
            int backgroundHeight = visibleRows * 24 - 4;
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + backgroundWidth, this.method_46427() + backgroundHeight, 0x40000000);
            context.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);
            for (int i = 0; i < this.blocks.size(); ++i) {
                int row = i / 4;
                int col = i % 4;
                if (row < this.scrollOffset / 24 || row >= this.scrollOffset / 24 + visibleRows) continue;
                int blockX = this.method_46426() + col * 24;
                int blockY = this.method_46427() + (row - this.scrollOffset / 24) * 24;
                this.renderBlockButton(context, this.blocks.get(i), blockX, blockY, mouseX, mouseY);
                if (mouseX < blockX || mouseX >= blockX + 20 || mouseY < blockY || mouseY >= blockY + 20) continue;
                hoveredBlock = this.blocks.get(i);
                this.hoveredX = mouseX;
                this.hoveredY = mouseY;
            }
            context.method_44380();
            context.method_25294(this.method_46426() + this.field_22758 - 4, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + backgroundHeight, 0x33FFFFFF);
            if (totalRows > visibleRows) {
                int scrollBarHeight = Math.max(20, backgroundHeight * visibleRows / totalRows);
                int scrollBarY = this.method_46427() + (int)((float)(backgroundHeight - scrollBarHeight) * (float)this.scrollOffset / (float)((totalRows - visibleRows) * 24));
                this.drawScrollBar(context, this.method_46426() + this.field_22758 - 4, scrollBarY, scrollBarHeight);
            }
            if (hoveredBlock != null) {
                long currentTime = System.currentTimeMillis();
                if (this.lastHoveredBlock != hoveredBlock) {
                    this.hoverStartTime = currentTime;
                    this.lastHoveredBlock = hoveredBlock;
                }
                if (currentTime - this.hoverStartTime >= 500L) {
                    context.method_51438(BlockSelectionScreen.this.field_22793, (class_2561)hoveredBlock.method_9518(), this.hoveredX, this.hoveredY);
                }
            } else {
                this.lastHoveredBlock = null;
            }
        }

        private void renderBlockButton(class_332 context, class_2248 block, int x, int y, int mouseX, int mouseY) {
            String blockId;
            class_1799 displayStack;
            int borderColor = BlockSelectionScreen.this.selectedBlocks.contains(block) ? -1 : -7631989;
            context.method_25294(x, y, x + 20, y + 20, borderColor);
            context.method_25294(x + 1, y + 1, x + 20 - 1, y + 20 - 1, -13158601);
            if (mouseX >= x && mouseX < x + 20 && mouseY >= y && mouseY < y + 20) {
                context.method_25294(x + 1, y + 1, x + 20 - 1, y + 20 - 1, -11184811);
            }
            if (!(displayStack = this.getDisplayStack(block)).method_7960()) {
                context.method_51427(displayStack, x + 2, y + 2);
            }
            if ((blockId = class_7923.field_41175.method_10221((Object)block).method_12832()).contains("wall_head") || blockId.contains("wall_skull") || blockId.contains("wall_sign")) {
                int underlineY = y + 20 - 3;
                int underlineColor = BlockSelectionScreen.this.selectedBlocks.contains(block) ? -1 : -10066330;
                context.method_25294(x + 2, underlineY, x + 20 - 2, underlineY + 1, underlineColor);
            }
            if (BlockSelectionScreen.this.selectedBlocks.contains(block)) {
                context.method_25294(x + 1, y + 1, x + 20 - 1, y + 20 - 1, -2130706433);
                context.method_51439(BlockSelectionScreen.this.field_22793, (class_2561)class_2561.method_43470((String)"\u2611"), x + 20 - 8, y + 20 - 9, -16777216, false);
            }
        }

        private class_1799 getDisplayStack(class_2248 block) {
            if (block == class_2246.field_10382) {
                return class_1802.field_8705.method_7854();
            }
            if (block == class_2246.field_10164) {
                return class_1802.field_8187.method_7854();
            }
            if (block == class_2246.field_10238) {
                return class_1802.field_8158.method_7854();
            }
            if (block == class_2246.field_10463) {
                return class_1802.field_17532.method_7854();
            }
            if (block == class_2246.field_22124) {
                return class_1802.field_21992.method_7854();
            }
            if (block == class_2246.field_23079) {
                return class_1802.field_23070.method_7854();
            }
            String translationKey = block.method_63499();
            if (translationKey.contains("wall_sign")) {
                String baseSignKey = translationKey.replace("wall_sign", "sign");
                try {
                    class_2248 baseSign = (class_2248)class_7923.field_41175.method_63535(class_7923.field_41175.method_10221((Object)block).method_45136(baseSignKey));
                    if (baseSign != class_2246.field_10124) {
                        return baseSign.method_8389().method_7854();
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to find base sign for wall sign: " + block.method_63499() + ", using original block");
                }
            }
            if (block == class_2246.field_10293) {
                return class_1802.field_8317.method_7854();
            }
            if (block == class_2246.field_10609) {
                return class_1802.field_8179.method_7854();
            }
            if (block == class_2246.field_10247) {
                return class_1802.field_8567.method_7854();
            }
            if (block == class_2246.field_10341) {
                return class_1802.field_8186.method_7854();
            }
            if (block == class_2246.field_10036) {
                return class_1802.field_8884.method_7854();
            }
            String blockId = class_7923.field_41175.method_10221((Object)block).method_12832();
            if (blockId.contains("wall_head") || blockId.contains("wall_skull")) {
                String baseHeadId = blockId.replace("wall_", "");
                try {
                    class_2248 baseHead = (class_2248)class_7923.field_41175.method_63535(class_7923.field_41175.method_10221((Object)block).method_45136(baseHeadId));
                    if (baseHead != class_2246.field_10124) {
                        return baseHead.method_8389().method_7854();
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to find base head for wall head: " + block.method_63499() + ", using original block");
                }
            }
            return block.method_8389().method_7854();
        }

        public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            if (this.method_25405(mouseX, mouseY)) {
                int totalRows = (this.blocks.size() + 3) / 4;
                int maxScroll = Math.max(0, (totalRows - this.getVisibleRows()) * 24);
                this.scrollOffset = Math.max(0, Math.min(this.scrollOffset - (int)(verticalAmount * 10.0), maxScroll));
                return true;
            }
            return false;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25405(mouseX, mouseY)) {
                int totalRows = (this.blocks.size() + 3) / 4;
                int backgroundHeight = this.getVisibleRows() * 24 - 4;
                if (mouseX >= (double)(this.method_46426() + this.field_22758 - 4) && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + backgroundHeight) && totalRows > this.getVisibleRows()) {
                    this.isDraggingScrollBar = true;
                    this.dragStartY = (int)mouseY;
                    this.dragStartScrollOffset = this.scrollOffset;
                    return true;
                }
                int startRow = this.scrollOffset / 24;
                for (int i = startRow * 4; i < Math.min(this.blocks.size(), (startRow + this.getVisibleRows()) * 4); ++i) {
                    int row = i / 4 - startRow;
                    int col = i % 4;
                    int blockX = this.method_46426() + col * 24;
                    int blockY = this.method_46427() + row * 24;
                    if (!(mouseX >= (double)blockX) || !(mouseX < (double)(blockX + 20)) || !(mouseY >= (double)blockY) || !(mouseY < (double)(blockY + 20))) continue;
                    BlockSelectionScreen.this.toggleBlockSelection(this.blocks.get(i));
                    return true;
                }
            }
            return false;
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.isDraggingScrollBar) {
                int totalRows = (this.blocks.size() + 3) / 4;
                int backgroundHeight = this.getVisibleRows() * 24 - 4;
                int maxScroll = Math.max(0, (totalRows - this.getVisibleRows()) * 24);
                int dragDistance = (int)mouseY - this.dragStartY;
                int scrollBarHeight = Math.max(20, backgroundHeight * this.getVisibleRows() / totalRows);
                int scrollableHeight = backgroundHeight - scrollBarHeight;
                if (scrollableHeight > 0) {
                    double scrollRatio = (double)dragDistance / (double)scrollableHeight;
                    int newScrollOffset = this.dragStartScrollOffset + (int)(scrollRatio * (double)maxScroll);
                    this.scrollOffset = Math.max(0, Math.min(newScrollOffset, maxScroll));
                }
                return true;
            }
            return false;
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            if (this.isDraggingScrollBar) {
                this.isDraggingScrollBar = false;
                return true;
            }
            return false;
        }

        private void drawScrollBar(class_332 context, int x, int y, int height) {
            context.method_25294(x, y, x + 4, y + height, 0x33FFFFFF);
            context.method_25294(x, y, x + 4, y + height, -5592406);
            context.method_25294(x, y, x + 4 - 1, y + 1, -1);
            context.method_25294(x, y, x + 1, y + height - 1, -1);
            context.method_25294(x + 4 - 1, y, x + 4, y + height, -11184811);
            context.method_25294(x, y + height - 1, x + 4, y + height, -11184811);
        }
    }

    private class PageButtonWidget
    extends class_4185 {
        private final class_2561 tooltipText;

        public PageButtonWidget(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress, class_2561 tooltipText) {
            super(x, y, width, height, message, onPress, field_40754);
            this.tooltipText = tooltipText;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_48579(context, mouseX, mouseY, delta);
            if (this.method_25405(mouseX, mouseY)) {
                context.method_51438(BlockSelectionScreen.this.field_22793, this.tooltipText, mouseX, mouseY);
            }
        }
    }
}

