/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.items.handlers;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.items.handlers.AbstractTerrainToolHandler;
import com.pushdozer.operations.UndoAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class SmoothLowerHandler
extends AbstractTerrainToolHandler {
    private static final float MIN_SIGMA = 1.0f;
    private static final float MAX_LOWER_DEPTH = 8.0f;
    private static final float GAUSSIAN_KERNEL_RADIUS_FACTOR = 2.5f;
    private static final Map<Integer, List<class_2338>> OFFSETS_CACHE = new HashMap<Integer, List<class_2338>>();

    public SmoothLowerHandler(PushdozerConfig config) {
        super(config);
    }

    public void handleSmoothLower(class_1657 player, class_1937 world) {
        this.handleOperation(player, world, UndoAction.ActionType.SMOOTH_LOWER);
    }

    @Override
    protected int calculateTargetHeight(Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> columns, AbstractTerrainToolHandler.TerrainColumn currentColumn, class_2338 columnXZ, class_2338 brushCenter) {
        float smoothStrength = this.config.getSmoothStrength();
        int brushRadius = this.config.getRadius();
        float smoothedHeight = this.calculateColumnCenteredSmoothedHeight(columns, columnXZ, brushCenter, brushRadius);
        float lowerAmount = this.calculateLowerAmount(columnXZ, brushCenter, brushRadius, smoothStrength);
        float t = Math.max(0.0f, Math.min(1.0f, smoothStrength));
        float s = t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
        float targetHeight = (float)currentColumn.getOriginalHeight() + (smoothedHeight - (float)currentColumn.getOriginalHeight()) * s - lowerAmount;
        float minLower = (float)currentColumn.getOriginalHeight() - 8.0f;
        targetHeight = Math.max(targetHeight, minLower);
        return Math.min(Math.round(targetHeight), currentColumn.getOriginalHeight());
    }

    private float calculateLowerAmount(class_2338 columnXZ, class_2338 brushCenter, int brushRadius, float strength) {
        class_2338 brushCenterXZ = new class_2338(brushCenter.method_10263(), 0, brushCenter.method_10260());
        double distanceSq = columnXZ.method_10262((class_2382)brushCenterXZ);
        float sigmaFactor = this.getSigmaFactor(brushRadius);
        float sigma = (float)brushRadius * sigmaFactor;
        if (sigma < 1.0f) {
            sigma = 1.0f;
        }
        double twoSigmaSquared = 2.0 * (double)sigma * (double)sigma;
        float falloff = (float)Math.exp(-distanceSq / twoSigmaSquared);
        float maxLowerAmount = strength * 1.5f;
        return Math.min(strength * falloff, maxLowerAmount);
    }

    private float calculateColumnCenteredSmoothedHeight(Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> columns, class_2338 columnXZ, class_2338 brushCenter, int brushRadius) {
        float sigmaFactor = this.getSigmaFactor(brushRadius);
        float sigma = (float)brushRadius * sigmaFactor;
        if (sigma < 1.0f) {
            sigma = 1.0f;
        }
        double twoSigmaSquared = 2.0 * (double)sigma * (double)sigma;
        float kernelRadius = sigma * 2.5f;
        List<class_2338> offsets = this.getOffsetsForRadius(kernelRadius);
        float totalWeight = 0.0f;
        float weightedSum = 0.0f;
        for (class_2338 offset : offsets) {
            class_2338 neighborXZ = new class_2338(columnXZ.method_10263() + offset.method_10263(), 0, columnXZ.method_10260() + offset.method_10260());
            AbstractTerrainToolHandler.TerrainColumn neighbor = columns.get(neighborXZ);
            if (neighbor == null) continue;
            int dx = offset.method_10263();
            int dz = offset.method_10260();
            int d2 = dx * dx + dz * dz;
            float weight = (float)Math.exp((double)(-d2) / twoSigmaSquared);
            weightedSum += (float)neighbor.getOriginalHeight() * weight;
            totalWeight += weight;
        }
        if (totalWeight <= 0.0f) {
            return columns.get(columnXZ) != null ? (float)columns.get(columnXZ).getOriginalHeight() : 0.0f;
        }
        return weightedSum / totalWeight;
    }

    private List<class_2338> getOffsetsForRadius(float radius) {
        int maxR = Math.max(1, Math.round(radius));
        int key = maxR * maxR;
        List<class_2338> cached = OFFSETS_CACHE.get(key);
        if (cached != null) {
            return cached;
        }
        ArrayList<class_2338> offsets = new ArrayList<class_2338>();
        int r2 = maxR * maxR;
        for (int dz = -maxR; dz <= maxR; ++dz) {
            for (int dx = -maxR; dx <= maxR; ++dx) {
                int d2 = dx * dx + dz * dz;
                if (d2 > r2) continue;
                offsets.add(new class_2338(dx, 0, dz));
            }
        }
        OFFSETS_CACHE.put(key, Collections.unmodifiableList(offsets));
        return OFFSETS_CACHE.get(key);
    }
}

