/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.operations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"pushdozer");
    private static final int MAX_BATCH_SIZE = 4096;

    public static BoundaryExtension collectBoundaryExtension(List<class_2338> positions, class_1937 world) {
        HashSet<class_2338> boundaryPositions = new HashSet<class_2338>();
        ArrayList<class_2680> boundaryOriginalStates = new ArrayList<class_2680>();
        ArrayList<class_2680> boundaryNewStates = new ArrayList<class_2680>();
        HashSet<class_2338> allPositions = new HashSet<class_2338>(positions);
        for (class_2338 pos : positions) {
            class_2338[] diagonalNeighbors;
            class_2338[] neighbors;
            for (class_2338 neighbor : neighbors = new class_2338[]{pos.method_10095(), pos.method_10072(), pos.method_10078(), pos.method_10067(), pos.method_10084(), pos.method_10074()}) {
                if (allPositions.contains(neighbor) || !BlockOperation.isValidBoundaryPosition(neighbor, world) || !boundaryPositions.add(neighbor)) continue;
                class_2680 s = world.method_8320(neighbor);
                boundaryOriginalStates.add(s);
                boundaryNewStates.add(s);
            }
            for (class_2338 diagonalNeighbor : diagonalNeighbors = new class_2338[]{pos.method_10095().method_10078(), pos.method_10095().method_10067(), pos.method_10072().method_10078(), pos.method_10072().method_10067(), pos.method_10084().method_10095(), pos.method_10084().method_10072(), pos.method_10084().method_10078(), pos.method_10084().method_10067(), pos.method_10074().method_10095(), pos.method_10074().method_10072(), pos.method_10074().method_10078(), pos.method_10074().method_10067()}) {
                if (allPositions.contains(diagonalNeighbor) || !BlockOperation.isValidBoundaryPosition(diagonalNeighbor, world) || !boundaryPositions.add(diagonalNeighbor)) continue;
                class_2680 s = world.method_8320(diagonalNeighbor);
                boundaryOriginalStates.add(s);
                boundaryNewStates.add(s);
            }
        }
        return new BoundaryExtension(boundaryPositions, boundaryOriginalStates, boundaryNewStates);
    }

    private static boolean isValidBoundaryPosition(class_2338 pos, class_1937 world) {
        try {
            if (pos.method_10264() < world.method_31607() || pos.method_10264() > world.method_31605()) {
                return false;
            }
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                return serverWorld.method_37116(new class_1923(pos).method_8324());
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("\u8fb9\u754c\u4f4d\u7f6e\u9a8c\u8bc1\u5931\u8d25: {}", (Object)pos, (Object)e);
            return false;
        }
    }

    public static void batchSetBlockStates(List<class_2338> positions, List<class_2680> states, class_1937 world, int flags) {
        if (positions.size() != states.size()) {
            LOGGER.error("\u4f4d\u7f6e\u548c\u72b6\u6001\u5217\u8868\u5927\u5c0f\u4e0d\u5339\u914d: {} vs {}", (Object)positions.size(), (Object)states.size());
            return;
        }
        for (int i = 0; i < positions.size(); i += 4096) {
            int endIndex = Math.min(i + 4096, positions.size());
            List<class_2338> batchPositions = positions.subList(i, endIndex);
            List<class_2680> batchStates = states.subList(i, endIndex);
            for (int j = 0; j < batchPositions.size(); ++j) {
                class_2338 pos = batchPositions.get(j);
                class_2680 newState = batchStates.get(j);
                try {
                    world.method_8652(pos, newState, flags);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("\u8bbe\u7f6e\u65b9\u5757\u72b6\u6001\u5931\u8d25: {} -> {}", new Object[]{pos, newState, e});
                }
            }
        }
    }

    public static class BoundaryExtension {
        private final Set<class_2338> positions;
        private final List<class_2680> originalStates;
        private final List<class_2680> newStates;

        public BoundaryExtension(Set<class_2338> positions, List<class_2680> originalStates, List<class_2680> newStates) {
            this.positions = positions;
            this.originalStates = originalStates;
            this.newStates = newStates;
        }

        public Set<class_2338> getPositions() {
            return this.positions;
        }

        public List<class_2680> getOriginalStates() {
            return this.originalStates;
        }

        public List<class_2680> getNewStates() {
            return this.newStates;
        }

        public int getSize() {
            return this.positions.size();
        }
    }
}

