/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.shapes;

import com.pushdozer.shapes.GeometryShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class OctahedronShape
implements GeometryShape {
    private final int radius;
    private class_2338 center;

    public OctahedronShape(int radius, class_2338 center) {
        this.radius = radius;
        this.center = center;
    }

    @Override
    public class_238 getBoundingBox(class_2338 basePos) {
        return new class_238((double)(basePos.method_10263() - this.radius), (double)(basePos.method_10264() - this.radius), (double)(basePos.method_10260() - this.radius), (double)(basePos.method_10263() + this.radius + 1), (double)(basePos.method_10264() + this.radius + 1), (double)(basePos.method_10260() + this.radius + 1));
    }

    @Override
    public void renderOutline(class_4587 matrices, class_4588 vertexConsumer, class_243 center, float red, float green, float blue, float alpha) {
    }

    @Override
    public void renderSolid(class_4587 matrices, class_4588 vertexConsumer, class_243 center, float red, float green, float blue, float alpha) {
    }

    @Override
    public boolean isInside(class_243 pos) {
        int distance = (int)(Math.abs(pos.field_1352 - (double)this.center.method_10263()) + Math.abs(pos.field_1351 - (double)this.center.method_10264()) + Math.abs(pos.field_1350 - (double)this.center.method_10260()));
        return distance <= this.radius;
    }

    @Override
    public boolean isInside(class_2338 pos) {
        int distance = Math.abs(pos.method_10263() - this.center.method_10263()) + Math.abs(pos.method_10264() - this.center.method_10264()) + Math.abs(pos.method_10260() - this.center.method_10260());
        return distance <= this.radius;
    }

    @Override
    public int getMinY(class_2338 basePos) {
        return basePos.method_10264() - this.radius;
    }

    @Override
    public int getMaxY(class_2338 basePos) {
        return basePos.method_10264() + this.radius;
    }

    @Override
    public List<class_2338> getBlocksInLayer(class_2338 basePos, int y) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        int yDistance = Math.abs(y - basePos.method_10264());
        int maxXZ = this.radius - yDistance;
        if (maxXZ >= 0) {
            for (int x = basePos.method_10263() - maxXZ; x <= basePos.method_10263() + maxXZ; ++x) {
                for (int z = basePos.method_10260() - maxXZ; z <= basePos.method_10260() + maxXZ; ++z) {
                    int distance = Math.abs(x - basePos.method_10263()) + yDistance + Math.abs(z - basePos.method_10260());
                    if (distance > this.radius) continue;
                    positions.add(new class_2338(x, y, z));
                }
            }
        }
        return positions;
    }

    @Override
    public List<class_2338> getBlocksInRadius(class_243 center, int maxDistance) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        class_2338 centerPos = class_2338.method_49638((class_2374)center);
        for (int x = centerPos.method_10263() - maxDistance; x <= centerPos.method_10263() + maxDistance; ++x) {
            for (int y = centerPos.method_10264() - maxDistance; y <= centerPos.method_10264() + maxDistance; ++y) {
                for (int z = centerPos.method_10260() - maxDistance; z <= centerPos.method_10260() + maxDistance; ++z) {
                    int distance = Math.abs(x - centerPos.method_10263()) + Math.abs(y - centerPos.method_10264()) + Math.abs(z - centerPos.method_10260());
                    if (distance > Math.min(this.radius, maxDistance)) continue;
                    positions.add(new class_2338(x, y, z));
                }
            }
        }
        return positions;
    }

    @Override
    public boolean isWithinBounds(class_2338 pos, class_2338 basePos) {
        return this.isInside(pos);
    }

    @Override
    public void setCenter(class_2338 center) {
        this.center = center;
    }

    @Override
    public List<class_2338> getBlocks() {
        return this.getBlockPositions();
    }

    @Override
    public Iterator<class_2338> getBlocksIterator() {
        return this.getBlockPositions().iterator();
    }

    @Override
    public class_2338 getCenter() {
        return this.center;
    }

    @Override
    public List<class_2338> getBlockPositions() {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        int centerX = this.center.method_10263();
        int centerY = this.center.method_10264();
        int centerZ = this.center.method_10260();
        for (int x = centerX - this.radius; x <= centerX + this.radius; ++x) {
            for (int y = centerY - this.radius; y <= centerY + this.radius; ++y) {
                for (int z = centerZ - this.radius; z <= centerZ + this.radius; ++z) {
                    int distance = Math.abs(x - centerX) + Math.abs(y - centerY) + Math.abs(z - centerZ);
                    if (distance > this.radius) continue;
                    positions.add(new class_2338(x, y, z));
                }
            }
        }
        return positions;
    }

    public int getRadius() {
        return this.radius;
    }
}

