/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.items.handlers;

import com.pushdozer.PushdozerMod;
import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.operations.UndoAction;
import com.pushdozer.shapes.GeometryShape;
import com.pushdozer.tags.PushdozerBiomeTags;
import com.pushdozer.util.ShapeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2211;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2266;
import net.minecraft.class_2299;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2356;
import net.minecraft.class_2362;
import net.minecraft.class_2381;
import net.minecraft.class_2393;
import net.minecraft.class_2473;
import net.minecraft.class_2523;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;

public class ShorelineProcessHandler {
    private final PushdozerConfig config;
    private static final float BASE_KEEP_PROBABILITY = 0.1f;
    private static final float DISTANCE_PROBABILITY_INCREMENT = 0.075f;
    private static final float MAX_KEEP_PROBABILITY = 0.9f;
    private static final int MAX_SHORELINE_WIDTH = 20;
    private static final int DEFAULT_SHORELINE_WIDTH = 5;
    private static final float DEFAULT_VEGETATION_DENSITY = 0.3f;
    private static final int MAX_VISITED_BLOCKS = 10000;
    private static final int MAX_ITERATIONS = 10000;
    private static final int MAX_PLANTS = 500;
    private static final int MAX_PLANT_ATTEMPTS = 1000;
    private static final Map<class_6862<class_1959>, BiFunction<Integer, class_5819, class_2680>> BIOME_BLOCK_GENERATORS = new HashMap<class_6862<class_1959>, BiFunction<Integer, class_5819, class_2680>>();

    public ShorelineProcessHandler(PushdozerConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("PushdozerConfig cannot be null");
        }
        this.validateConfig(config);
        this.config = config;
    }

    private void validateConfig(PushdozerConfig config) {
        if (config.getShorelineWidth() < 1) {
            PushdozerMod.LOGGER.warn("Invalid shoreline width {}, resetting to default ({})", (Object)config.getShorelineWidth(), (Object)5);
            config.setShorelineWidth(5);
        }
        if (config.getVegetationDensity() < 0.0f || config.getVegetationDensity() > 1.0f) {
            PushdozerMod.LOGGER.warn("Invalid vegetation density {}, resetting to default ({})", (Object)Float.valueOf(config.getVegetationDensity()), (Object)Float.valueOf(0.3f));
            config.setVegetationDensity(0.3f);
        }
        if (config.getShorelineWidth() > 20) {
            PushdozerMod.LOGGER.warn("Shoreline width {} is too large, capping at {}", (Object)config.getShorelineWidth(), (Object)20);
            config.setShorelineWidth(20);
        }
    }

    private boolean validateParameters(class_1657 player, class_1937 world) {
        if (player == null) {
            PushdozerMod.LOGGER.warn("Invalid parameters for shoreline processing: player is null");
            return false;
        }
        return true;
    }

    private GeometryShape getProcessingShape(class_1657 player) {
        class_2338 basePos = ShapeUtil.getTargetBlockPos(player, this.config);
        GeometryShape shape = ShapeUtil.createShape(player, this.config, basePos);
        if (shape == null) {
            PushdozerMod.LOGGER.debug("No valid shape created for shoreline processing");
            return null;
        }
        return shape;
    }

    private Map<class_2338, ShorelineTransition> computeShorelineTransitions(class_1937 world, Set<class_2338> shorelineEdges) {
        int expectedSize = Math.min(shorelineEdges.size() * 2, 10000);
        HashMap<class_2338, ShorelineTransition> transitions = new HashMap<class_2338, ShorelineTransition>(expectedSize);
        LinkedList<class_2338> queue = new LinkedList<class_2338>(shorelineEdges);
        HashSet<class_2338> visited = new HashSet<class_2338>(shorelineEdges);
        HashMap<class_2338, class_1959> biomeCache = new HashMap<class_2338, class_1959>();
        this.initializeFirstLayer(world, shorelineEdges, transitions, biomeCache);
        this.expandShorelineLayers(world, queue, visited, transitions, biomeCache);
        return transitions;
    }

    private void initializeFirstLayer(class_1937 world, Set<class_2338> shorelineEdges, Map<class_2338, ShorelineTransition> transitions, Map<class_2338, class_1959> biomeCache) {
        for (class_2338 edgePos : shorelineEdges) {
            class_1959 biome;
            class_2680 newState = this.generateShorelineBlock(world, edgePos, 1, biome = biomeCache.computeIfAbsent(edgePos, p -> (class_1959)world.method_23753(p).comp_349()));
            if (newState == null || !this.isReplaceableLandBlock(world, edgePos, world.method_8320(edgePos))) continue;
            transitions.put(edgePos, ShorelineTransition.valid(edgePos, newState, 1));
        }
    }

    private void expandShorelineLayers(class_1937 world, Queue<class_2338> queue, Set<class_2338> visited, Map<class_2338, ShorelineTransition> transitions, Map<class_2338, class_1959> biomeCache) {
        int currentDistance = 1;
        int iterationCount = 0;
        while (!queue.isEmpty() && currentDistance < this.config.getShorelineWidth() && iterationCount < 10000) {
            int levelSize = queue.size();
            ++currentDistance;
            ++iterationCount;
            for (int i = 0; i < levelSize; ++i) {
                class_2338 currentPos = queue.poll();
                if (currentPos == null) continue;
                this.processNeighbors(world, currentPos, queue, visited, transitions, biomeCache, currentDistance);
            }
        }
    }

    private void processNeighbors(class_1937 world, class_2338 currentPos, Queue<class_2338> queue, Set<class_2338> visited, Map<class_2338, ShorelineTransition> transitions, Map<class_2338, class_1959> biomeCache, int currentDistance) {
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            this.processNeighbor(world, currentPos, dir, queue, visited, transitions, biomeCache, currentDistance);
        }
        for (class_2350 dir : class_2350.class_2353.field_11064) {
            this.processNeighbor(world, currentPos, dir, queue, visited, transitions, biomeCache, currentDistance);
        }
    }

    private void processNeighbor(class_1937 world, class_2338 currentPos, class_2350 dir, Queue<class_2338> queue, Set<class_2338> visited, Map<class_2338, ShorelineTransition> transitions, Map<class_2338, class_1959> biomeCache, int currentDistance) {
        class_2338 neighborPos = currentPos.method_10093(dir);
        if (visited.size() >= 10000) {
            PushdozerMod.LOGGER.warn("Shoreline processing reached maximum visited blocks limit");
            return;
        }
        if (!visited.contains(neighborPos) && this.isReplaceableLandBlock(world, neighborPos, world.method_8320(neighborPos))) {
            visited.add(neighborPos);
            queue.add(neighborPos);
            class_1959 biome = biomeCache.computeIfAbsent(neighborPos, p -> (class_1959)world.method_23753(p).comp_349());
            class_2680 newState = this.generateShorelineBlock(world, neighborPos, currentDistance, biome);
            if (newState != null && this.isReplaceableLandBlock(world, neighborPos, world.method_8320(neighborPos))) {
                transitions.put(neighborPos, ShorelineTransition.valid(neighborPos, newState, currentDistance));
            }
        }
    }

    public void handleShorelineProcess(class_1657 player, class_1937 world) {
        if (world.field_9236) {
            return;
        }
        if (!this.validateParameters(player, world)) {
            return;
        }
        GeometryShape shape = this.getProcessingShape(player);
        if (shape == null) {
            return;
        }
        Set<class_2338> shorelineEdges = this.findShorelineEdges(world, shape);
        if (shorelineEdges.isEmpty()) {
            return;
        }
        Map<class_2338, ShorelineTransition> transitions = this.computeShorelineTransitions(world, shorelineEdges);
        ProcessingResult result = this.applyShorelineTransitions(world, player, transitions);
        List<VegetationPlacement> vegetationPlacements = this.collectVegetationPositions(world, result.vegetationPositions);
        int vegetationCount = this.plantVegetation(world, vegetationPlacements, result.affectedPositions, result.originalStates, result.newStates, player);
        this.createUndoActionAndNotifyPlayer(player, result, vegetationCount);
    }

    private ProcessingResult applyShorelineTransitions(class_1937 world, class_1657 player, Map<class_2338, ShorelineTransition> transitions) {
        ArrayList<class_2338> affectedPositions = new ArrayList<class_2338>();
        ArrayList<class_2680> originalStates = new ArrayList<class_2680>();
        ArrayList<class_2680> newStates = new ArrayList<class_2680>();
        ArrayList<class_2338> vegetationPositions = new ArrayList<class_2338>();
        int processedCount = 0;
        for (ShorelineTransition transition : transitions.values()) {
            if (!transition.isValid() || !this.isValidHeightForShorelineProcess(transition.pos, player) || !this.isChunkLoaded(world, transition.pos)) continue;
            class_2680 originalState = world.method_8320(transition.pos);
            world.method_8501(transition.pos, transition.newState);
            affectedPositions.add(transition.pos);
            originalStates.add(originalState);
            newStates.add(transition.newState);
            ++processedCount;
            if (!this.shouldPlantVegetation(world, transition.pos, transition.distance, player)) continue;
            vegetationPositions.add(transition.pos);
            PushdozerMod.LOGGER.debug("Added vegetation position at {} with distance {}", (Object)transition.pos, (Object)transition.distance);
        }
        return new ProcessingResult(affectedPositions, originalStates, newStates, vegetationPositions, processedCount, 0);
    }

    private void createUndoActionAndNotifyPlayer(class_1657 player, ProcessingResult result, int vegetationCount) {
        if (!result.affectedPositions.isEmpty()) {
            UndoAction undoAction = new UndoAction(UndoAction.ActionType.PLACE, result.affectedPositions, result.originalStates, result.newStates);
            PushdozerMod.pushUndoAction(player, undoAction);
        }
        if (result.processedCount > 0) {
            PushdozerMod.LOGGER.debug("Shoreline processing completed: {} blocks processed, {} plants planted", (Object)result.processedCount, (Object)vegetationCount);
        } else {
            PushdozerMod.LOGGER.debug("Shoreline processing completed with no changes");
        }
    }

    private boolean isValidHeightForShorelineProcess(class_2338 pos, class_1657 player) {
        if (!this.config.isShorelineHeightAboveEnabled() && !this.config.isShorelineHeightBelowEnabled()) {
            return true;
        }
        int targetHeight = this.getTargetHeight(player);
        int posY = pos.method_10264();
        if (this.config.isShorelineHeightAboveEnabled()) {
            return posY >= targetHeight;
        }
        if (this.config.isShorelineHeightBelowEnabled()) {
            return posY <= targetHeight;
        }
        return true;
    }

    private int getTargetHeight(class_1657 player) {
        PushdozerConfig.HeightMode heightMode = this.config.getHeightMode();
        return switch (heightMode) {
            case PushdozerConfig.HeightMode.FOLLOW_PLAYER -> player.method_31478();
            case PushdozerConfig.HeightMode.LOCKED_ONCE, PushdozerConfig.HeightMode.CUSTOM -> this.config.getLockedHeight();
            default -> 0;
        };
    }

    private class_2680 generateShorelineBlock(class_1937 world, class_2338 pos, int distance, class_1959 biome) {
        class_2680 result;
        if (distance > this.config.getShorelineWidth()) {
            PushdozerMod.LOGGER.warn("Invalid distance {} at pos {}", (Object)distance, (Object)pos);
            return null;
        }
        PushdozerConfig.ShorelineType shorelineType = this.config.getShorelineType();
        switch (shorelineType) {
            default: {
                throw new MatchException(null, null);
            }
            case BEACH: {
                class_2680 class_26802 = this.generateBeachBlock(world, pos, distance);
                break;
            }
            case EMBANKMENT: {
                class_2680 class_26802 = this.generateEmbankmentBlock(world, pos, distance);
                break;
            }
            case ADAPTIVE: {
                class_2680 class_26802 = this.generateAdaptiveShorelineBlock(world, pos, distance, biome);
                break;
            }
            case MUDDY: {
                class_2680 class_26802 = this.generateMuddyBlock(world, pos, distance);
                break;
            }
            case ROCKY: {
                class_2680 class_26802 = this.generateRockyBlock(world, pos, distance);
                break;
            }
            case CUSTOM: {
                class_2680 class_26802 = result = this.generateCustomShorelineBlock(world, pos, distance);
            }
        }
        if (result == null) {
            PushdozerMod.LOGGER.warn("No block generated for shoreline type {} at pos {}, distance {}", new Object[]{shorelineType, pos, distance});
        }
        return result;
    }

    private class_2680 generateBeachBlock(class_1937 world, class_2338 pos, int distance) {
        class_2680 secondary;
        class_2680 primary;
        class_6880 biomeEntry = world.method_23753(pos);
        if (biomeEntry.method_40220(class_6908.field_37393) && ((class_1959)biomeEntry.comp_349()).toString().toLowerCase().contains("snowy")) {
            primary = class_2246.field_10491.method_9564();
            secondary = class_2246.field_10295.method_9564();
        } else if (biomeEntry.method_40220(class_6908.field_36513)) {
            primary = class_2246.field_10534.method_9564();
            secondary = class_2246.field_10344.method_9564();
        } else {
            primary = class_2246.field_10102.method_9564();
            secondary = class_2246.field_10566.method_9564();
        }
        return ShorelineProcessHandler.applyBeachTransitionProbability(distance, primary, secondary, world.method_8409(), (class_6880<class_1959>)world.method_23753(pos));
    }

    private class_2680 generateEmbankmentBlock(class_1937 world, class_2338 pos, int distance) {
        class_2680 secondary;
        class_2680 primary;
        class_6880 biomeEntry = world.method_23753(pos);
        if (biomeEntry.method_40220(class_6908.field_36512)) {
            primary = class_2246.field_10340.method_9564();
            secondary = class_2246.field_10445.method_9564();
        } else if (biomeEntry.method_40220(class_6908.field_36513)) {
            primary = class_2246.field_9979.method_9564();
            secondary = class_2246.field_10467.method_9564();
        } else if (biomeEntry.method_40220(class_6908.field_37393) && ((class_1959)biomeEntry.comp_349()).toString().toLowerCase().contains("snowy")) {
            primary = class_2246.field_10491.method_9564();
            secondary = class_2246.field_10225.method_9564();
        } else {
            primary = class_2246.field_10445.method_9564();
            secondary = class_2246.field_10255.method_9564();
        }
        return ShorelineProcessHandler.applyTransitionProbability(distance, primary, secondary, world.method_8409());
    }

    private class_2680 generateAdaptiveShorelineBlock(class_1937 world, class_2338 pos, int distance, class_1959 biome) {
        class_6880 biomeEntry = world.method_23753(pos);
        PushdozerMod.LOGGER.debug("Checking biome {} for adaptive shoreline at pos {}", (Object)((class_1959)biomeEntry.comp_349()).toString(), (Object)pos);
        for (Map.Entry<class_6862<class_1959>, BiFunction<Integer, class_5819, class_2680>> entry : BIOME_BLOCK_GENERATORS.entrySet()) {
            class_6862<class_1959> tagKey = entry.getKey();
            if (!biomeEntry.method_40220(tagKey)) continue;
            PushdozerMod.LOGGER.debug("Matched biome tag {} for adaptive shoreline at pos {}", (Object)tagKey.comp_327(), (Object)pos);
            return entry.getValue().apply(distance, world.method_8409());
        }
        PushdozerMod.LOGGER.debug("No specific biome tag matched, using fallback for biome {} at pos {}", (Object)((class_1959)biomeEntry.comp_349()).toString(), (Object)pos);
        return this.getSmartFallbackBlock(world, pos, distance, (class_6880<class_1959>)biomeEntry);
    }

    private class_2680 getSmartFallbackBlock(class_1937 world, class_2338 pos, int distance, class_6880<class_1959> biomeEntry) {
        class_2680 smartChoice = this.getBiomeAwareFallback(world, pos, distance, biomeEntry);
        if (smartChoice != null) {
            return smartChoice;
        }
        return ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_10102.method_9564(), class_2246.field_10566.method_9564(), world.method_8409());
    }

    private class_2680 getBiomeAwareFallback(class_1937 world, class_2338 pos, int distance, class_6880<class_1959> biomeEntry) {
        if (biomeEntry.method_40220(class_6908.field_37393) && ((class_1959)biomeEntry.comp_349()).toString().toLowerCase().contains("snowy")) {
            return ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_10491.method_9564(), class_2246.field_10295.method_9564(), world.method_8409());
        }
        if (((class_1959)biomeEntry.comp_349()).toString().toLowerCase().contains("desert")) {
            return ShorelineProcessHandler.applyBeachTransitionProbability(distance, class_2246.field_10102.method_9564(), class_2246.field_10566.method_9564(), world.method_8409(), (class_6880<class_1959>)world.method_23753(pos));
        }
        if (biomeEntry.method_40220(class_6908.field_36513)) {
            return ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_10534.method_9564(), class_2246.field_10344.method_9564(), world.method_8409());
        }
        if (((class_1959)biomeEntry.comp_349()).toString().toLowerCase().contains("swamp")) {
            return ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_37576.method_9564(), class_2246.field_10566.method_9564(), world.method_8409());
        }
        if (biomeEntry.method_40220(class_6908.field_36511)) {
            return ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_10255.method_9564(), class_2246.field_10566.method_9564(), world.method_8409());
        }
        if (biomeEntry.method_40220(class_6908.field_36512)) {
            return ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_10340.method_9564(), class_2246.field_10445.method_9564(), world.method_8409());
        }
        if (biomeEntry.method_40220(class_6908.field_36510)) {
            return ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_10102.method_9564(), class_2246.field_10566.method_9564(), world.method_8409());
        }
        if (biomeEntry.method_40220(class_6908.field_36516) || biomeEntry.method_40220(class_6908.field_36517)) {
            return ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_10219.method_9564(), class_2246.field_10566.method_9564(), world.method_8409());
        }
        return null;
    }

    private static class_2680 applyTransitionProbability(int distance, class_2680 primary, class_2680 secondary, class_5819 random) {
        float keepOriginalProbability = ShorelineProcessHandler.calculateKeepOriginalProbability(distance);
        if (random.method_43057() < keepOriginalProbability) {
            return null;
        }
        return ShorelineProcessHandler.getThreeStageBlock(distance, primary, secondary, random);
    }

    private static class_2680 applyBeachTransitionProbability(int distance, class_2680 primary, class_2680 secondary, class_5819 random, class_6880<class_1959> biomeEntry) {
        float keepOriginalProbability = ShorelineProcessHandler.calculateKeepOriginalProbability(distance);
        if (random.method_43057() < keepOriginalProbability) {
            return null;
        }
        return ShorelineProcessHandler.getBeachThreeStageBlock(distance, primary, secondary, random, biomeEntry);
    }

    private static float getBeachPrimaryProbability(int distance) {
        if (distance == 1) {
            return 0.9f;
        }
        if (distance == 2) {
            return 0.8f;
        }
        if (distance == 3) {
            return 0.7f;
        }
        if (distance <= 5) {
            return 0.6f;
        }
        if (distance <= 8) {
            return 0.5f;
        }
        return 0.3f;
    }

    private static class_2680 getBeachThreeStageBlock(int distance, class_2680 primary, class_2680 secondary, class_5819 random, class_6880<class_1959> biomeEntry) {
        if (biomeEntry != null && ((class_1959)biomeEntry.comp_349()).toString().toLowerCase().contains("desert")) {
            return ShorelineProcessHandler.getDesertThreeStageBlock(distance, primary, secondary, random);
        }
        return ShorelineProcessHandler.getBeachOptimizedThreeStageBlock(distance, primary, secondary, random);
    }

    private static class_2680 getBeachOptimizedThreeStageBlock(int distance, class_2680 primary, class_2680 secondary, class_5819 random) {
        float rand = random.method_43057();
        if (distance <= 3) {
            float sandProb = ShorelineProcessHandler.getBeachPrimaryProbability(distance);
            return rand < sandProb ? primary : secondary;
        }
        if (distance <= 6) {
            if (rand < 0.4f) {
                return primary;
            }
            if (rand < 0.5f) {
                return secondary;
            }
            return class_2246.field_10219.method_9564();
        }
        if (distance <= 10) {
            if (rand < 0.2f) {
                return primary;
            }
            if (rand < 0.3f) {
                return secondary;
            }
            return class_2246.field_10219.method_9564();
        }
        if (rand < 0.1f) {
            return primary;
        }
        if (rand < 0.2f) {
            return secondary;
        }
        return class_2246.field_10219.method_9564();
    }

    private static class_2680 getDesertThreeStageBlock(int distance, class_2680 primary, class_2680 secondary, class_5819 random) {
        float rand = random.method_43057();
        if (distance <= 3) {
            float sandProb = ShorelineProcessHandler.getBeachPrimaryProbability(distance);
            return rand < sandProb ? primary : secondary;
        }
        if (distance <= 6) {
            return rand < 0.4f ? primary : secondary;
        }
        if (distance <= 10) {
            return rand < 0.2f ? primary : secondary;
        }
        return rand < 0.1f ? primary : secondary;
    }

    private static class_2680 getThreeStageBlock(int distance, class_2680 primary, class_2680 secondary, class_5819 random) {
        float rand = random.method_43057();
        if (distance <= 3) {
            float primaryProbability = ShorelineProcessHandler.getPrimaryProbability(distance);
            return rand < primaryProbability ? primary : secondary;
        }
        if (distance <= 6) {
            if (rand < 0.4f) {
                return primary;
            }
            if (rand < 0.6f) {
                return secondary;
            }
            return class_2246.field_10219.method_9564();
        }
        if (distance <= 10) {
            if (rand < 0.2f) {
                return primary;
            }
            if (rand < 0.4f) {
                return secondary;
            }
            return class_2246.field_10219.method_9564();
        }
        if (rand < 0.1f) {
            return primary;
        }
        if (rand < 0.3f) {
            return secondary;
        }
        return class_2246.field_10219.method_9564();
    }

    private static float calculateKeepOriginalProbability(int distance) {
        if (distance == 1) {
            return 0.1f;
        }
        if (distance == 2) {
            return 0.2f;
        }
        if (distance == 3) {
            return 0.3f;
        }
        if (distance <= 5) {
            return 0.3f + (float)(distance - 3) * 0.075f;
        }
        if (distance <= 8) {
            return 0.45f + (float)(distance - 5) * 0.033f;
        }
        float probability = 0.6f + (float)(distance - 8) * 0.02f;
        return Math.min(probability, 0.9f);
    }

    private static float getPrimaryProbability(int distance) {
        float primaryProbability = distance == 1 ? 0.8f : (distance == 2 ? 0.7f : (distance == 3 ? 0.6f : (distance <= 5 ? 0.4f : (distance <= 8 ? 0.2f : 0.1f))));
        return primaryProbability;
    }

    private class_2680 generateMuddyBlock(class_1937 world, class_2338 pos, int distance) {
        return ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_37576.method_9564(), class_2246.field_10566.method_9564(), world.method_8409());
    }

    private class_2680 generateRockyBlock(class_1937 world, class_2338 pos, int distance) {
        return ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_10340.method_9564(), class_2246.field_10445.method_9564(), world.method_8409());
    }

    private class_2680 generateCustomShorelineBlock(class_1937 world, class_2338 pos, int distance) {
        List<class_2248> customBlocks = this.config.getCustomShorelineBlockList();
        if (customBlocks.isEmpty()) {
            return this.generateBeachBlock(world, pos, distance);
        }
        float keepOriginalProbability = ShorelineProcessHandler.calculateKeepOriginalProbability(distance);
        if (world.method_8409().method_43057() < keepOriginalProbability) {
            return null;
        }
        int blockIndex = Math.min(distance - 1, customBlocks.size() - 1);
        class_2248 primaryBlock = customBlocks.getFirst();
        if (customBlocks.size() > 1 && distance > 1) {
            class_2248 secondaryBlock = customBlocks.get(Math.min(1, customBlocks.size() - 1));
            return ShorelineProcessHandler.applyTransitionProbability(distance, primaryBlock.method_9564(), secondaryBlock.method_9564(), world.method_8409());
        }
        return ShorelineProcessHandler.applyTransitionProbability(distance, primaryBlock.method_9564(), class_2246.field_10566.method_9564(), world.method_8409());
    }

    private boolean isReplaceableLandBlock(class_1937 world, class_2338 pos, class_2680 state) {
        if (state.method_26227().method_15767(class_3486.field_15517) || state.method_26215()) {
            return false;
        }
        if (this.isPlantOrDecoration(state)) {
            return false;
        }
        if (!this.isSurfaceBlock(world, pos)) {
            return false;
        }
        List<class_2248> customBlocks = this.config.getCustomShorelineBlockList();
        if (!customBlocks.isEmpty() && customBlocks.contains(state.method_26204())) {
            return true;
        }
        return state.method_45474() || state.method_26164(class_3481.field_29822) || state.method_26164(class_3481.field_15466) || state.method_26164(class_3481.field_15475) || state.method_26204() == class_2246.field_10219 || state.method_26204() == class_2246.field_10340 || state.method_26204() == class_2246.field_10445 || state.method_26204() == class_2246.field_10255 || state.method_26204() == class_2246.field_9979 || state.method_26204() == class_2246.field_10467 || state.method_26204() == class_2246.field_10344 || state.method_26204() == class_2246.field_10194 || state.method_26204() == class_2246.field_10253 || state.method_26204() == class_2246.field_10520 || state.method_26204() == class_2246.field_10402 || state.method_26204() == class_2246.field_10491 || state.method_26204() == class_2246.field_10295 || state.method_26204() == class_2246.field_10225 || state.method_26204() == class_2246.field_10115 || state.method_26204() == class_2246.field_10508 || state.method_26204() == class_2246.field_10474 || state.method_26204() == class_2246.field_28888 || state.method_26204() == class_2246.field_27165 || state.method_26204() == class_2246.field_27114 || state.method_26204() == class_2246.field_29032 || state.method_26204() == class_2246.field_28685 || state.method_26204() == class_2246.field_28681 || state.method_26204() == class_2246.field_42728 || state.method_26204() == class_2246.field_43227 || state.method_26204() == class_2246.field_10460 || state.method_26204() == class_2246.field_28680 || state.method_26204() == class_2246.field_37576;
    }

    private List<VegetationPlacement> collectVegetationPositions(class_1937 world, List<class_2338> positions) {
        ArrayList<VegetationPlacement> placements = new ArrayList<VegetationPlacement>();
        PushdozerMod.LOGGER.debug("collectVegetationPositions: processing {} positions, plantVegetationEnabled = {}", (Object)positions.size(), (Object)this.config.isPlantVegetationEnabled());
        for (class_2338 pos : positions) {
            if (!this.config.isPlantVegetationEnabled()) {
                PushdozerMod.LOGGER.debug("Plant vegetation is disabled, skipping position {}", (Object)pos);
                continue;
            }
            class_2680 belowState = world.method_8320(pos);
            if (!this.isSolidBlock(world, pos, belowState)) {
                PushdozerMod.LOGGER.debug("Position {} has non-solid block below: {}, skipping", (Object)pos, (Object)belowState.method_26204().toString());
                continue;
            }
            class_2680 plant = this.getVegetationForBiome(world, pos, (class_1959)world.method_23753(pos).comp_349(), belowState);
            PushdozerMod.LOGGER.debug("getVegetationForBiome returned: {} for position {}", (Object)(plant != null ? plant.method_26204().toString() : "null"), (Object)pos);
            if (plant != null && this.canPlantGrowOnBlock(world, pos, plant.method_26204(), belowState)) {
                int requiredHeight = this.getPlantRequiredHeight(world, plant.method_26204());
                if (this.hasEnoughSpaceForPlant(world, pos, requiredHeight)) {
                    boolean isTallPlant = plant.method_26204() instanceof class_2320;
                    placements.add(new VegetationPlacement(pos, plant, isTallPlant, belowState));
                    PushdozerMod.LOGGER.debug("Successfully added plant {} for position {} on ground {}", new Object[]{plant.method_26204().toString(), pos, belowState.method_26204().toString()});
                    continue;
                }
                PushdozerMod.LOGGER.debug("Not enough space for plant {} at position {}", (Object)plant.method_26204().toString(), (Object)pos);
                continue;
            }
            if (plant == null) continue;
            PushdozerMod.LOGGER.debug("Plant {} cannot grow on block {} at position {}", new Object[]{plant.method_26204().toString(), belowState.method_26204().toString(), pos});
        }
        PushdozerMod.LOGGER.debug("collectVegetationPositions: collected {} placements", (Object)placements.size());
        return placements;
    }

    private boolean shouldPlantVegetation(class_1937 world, class_2338 pos, int distance, class_1657 player) {
        class_2338 neighborPos;
        if (!this.config.isPlantVegetationEnabled()) {
            return false;
        }
        if (distance < 1 || distance > 8) {
            return false;
        }
        if (!this.isValidHeightForShorelineProcess(pos, player)) {
            return false;
        }
        class_2338 above = pos.method_10084();
        if (!world.method_8320(above).method_26215()) {
            return false;
        }
        class_6880 biomeEntry = world.method_23753(pos);
        String biomeName = ((class_1959)biomeEntry.comp_349()).toString().toLowerCase();
        if (biomeName.contains("snowy") || biomeName.contains("ice")) {
            return false;
        }
        float density = this.config.getVegetationDensity();
        float distanceFactor = Math.max(0.3f, 1.0f - (float)(distance - 1) / (float)this.config.getShorelineWidth());
        float adjustedDensity = density * distanceFactor;
        if (biomeName.contains("desert")) {
            adjustedDensity *= 1.2f;
        } else if (biomeName.contains("swamp") || biomeName.contains("river")) {
            adjustedDensity *= 1.8f;
        } else if (biomeName.contains("forest") || biomeName.contains("jungle")) {
            adjustedDensity *= 1.3f;
        } else if (biomeName.contains("savanna") || biomeName.contains("plains")) {
            adjustedDensity *= 1.1f;
        } else if (biomeName.contains("mountain") || biomeName.contains("hill")) {
            adjustedDensity *= 1.4f;
        } else if (biomeName.contains("badlands")) {
            adjustedDensity *= 0.8f;
        }
        int neighborPlants = 0;
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            neighborPos = pos.method_10093(dir);
            if (!(world.method_8320(neighborPos.method_10084()).method_26204() instanceof class_2261) && !(world.method_8320(neighborPos.method_10084()).method_26204() instanceof class_2320)) continue;
            ++neighborPlants;
        }
        for (class_2350 dir : class_2350.class_2353.field_11064) {
            neighborPos = pos.method_10093(dir);
            if (!(world.method_8320(neighborPos.method_10084()).method_26204() instanceof class_2261) && !(world.method_8320(neighborPos.method_10084()).method_26204() instanceof class_2320)) continue;
            ++neighborPlants;
        }
        if (neighborPlants >= 2) {
            adjustedDensity *= 1.5f;
        } else if (neighborPlants == 1) {
            adjustedDensity *= 1.2f;
        }
        return world.method_8409().method_43057() < adjustedDensity;
    }

    private int plantVegetation(class_1937 world, List<VegetationPlacement> placements, List<class_2338> affectedPositions, List<class_2680> originalStates, List<class_2680> newStates, class_1657 player) {
        int plantedCount = 0;
        int attemptCount = 0;
        for (VegetationPlacement placement : placements) {
            int i;
            if (plantedCount >= 500 || attemptCount >= 1000) {
                PushdozerMod.LOGGER.debug("Planting stopped: reached limit (planted: {}, attempts: {})", (Object)plantedCount, (Object)attemptCount);
                break;
            }
            ++attemptCount;
            class_2338 pos = placement.pos;
            class_2338 plantPos = pos.method_10084();
            if (!this.isChunkLoaded(world, pos) || !this.isChunkLoaded(world, plantPos)) continue;
            if (!placement.plant.method_26184((class_4538)world, plantPos)) {
                PushdozerMod.LOGGER.debug("Plant cannot survive at {}: {}", (Object)plantPos, (Object)placement.plant.method_26204().toString());
                continue;
            }
            if (placement.plant.method_26204() == class_2246.field_10424) {
                boolean hasWater = false;
                for (class_2350 dir : class_2350.class_2353.field_11062) {
                    if (!world.method_8316(pos.method_10093(dir)).method_15767(class_3486.field_15517)) continue;
                    hasWater = true;
                    break;
                }
                if (!hasWater) continue;
            }
            if (placement.isTallPlant) {
                class_2338 upperPos = plantPos.method_10084();
                if (!this.isValidHeightForShorelineProcess(upperPos, player) || !world.method_8320(plantPos).method_26215() || !world.method_8320(upperPos).method_26215()) continue;
                class_2680 lowerPlant = (class_2680)placement.plant.method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12607);
                class_2680 upperPlant = (class_2680)placement.plant.method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12609);
                if (!lowerPlant.method_26184((class_4538)world, plantPos) || !upperPlant.method_26184((class_4538)world, upperPos)) continue;
                originalStates.add(world.method_8320(plantPos));
                originalStates.add(world.method_8320(upperPos));
                affectedPositions.add(plantPos);
                affectedPositions.add(upperPos);
                world.method_8501(plantPos, lowerPlant);
                world.method_8501(upperPos, upperPlant);
                newStates.add(lowerPlant);
                newStates.add(upperPlant);
                ++plantedCount;
                continue;
            }
            int requiredHeight = this.getPlantRequiredHeight(world, placement.plant.method_26204());
            if (!this.hasEnoughSpaceForPlant(world, plantPos, requiredHeight)) continue;
            boolean heightValid = true;
            for (i = 0; i < requiredHeight; ++i) {
                if (this.isValidHeightForShorelineProcess(plantPos.method_10086(i), player)) continue;
                heightValid = false;
                break;
            }
            if (!heightValid || !placement.plant.method_26184((class_4538)world, plantPos)) continue;
            for (i = 0; i < requiredHeight; ++i) {
                class_2338 checkPos = plantPos.method_10086(i);
                originalStates.add(world.method_8320(checkPos));
                affectedPositions.add(checkPos);
            }
            if (requiredHeight == 1) {
                class_2680 plantToPlace = placement.plant;
                if (this.isDeadCoral(placement.plant.method_26204()) && (plantToPlace = placement.plant.method_26204().method_9564()).method_28498((class_2769)class_2741.field_12508)) {
                    plantToPlace = (class_2680)plantToPlace.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
                }
                world.method_8501(plantPos, plantToPlace);
                newStates.add(plantToPlace);
            } else {
                class_2338 flowerPos;
                this.placeHighPlant(world, plantPos, placement.plant, requiredHeight, newStates);
                if (placement.plant.method_26204() == class_2246.field_10029 && this.config.getShorelineType() == PushdozerConfig.ShorelineType.BEACH && world.method_8409().method_43057() < 0.3f && world.method_8320(flowerPos = plantPos.method_10086(requiredHeight)).method_26215()) {
                    class_2680 flowerState = class_2246.field_56564.method_9564();
                    world.method_8501(flowerPos, flowerState);
                    newStates.add(flowerState);
                    originalStates.add(world.method_8320(flowerPos));
                    affectedPositions.add(flowerPos);
                }
            }
            ++plantedCount;
        }
        PushdozerMod.LOGGER.debug("Vegetation planting completed: {} planted, {} attempts, {} placements provided", new Object[]{plantedCount, attemptCount, placements.size()});
        if (plantedCount == 0 && !placements.isEmpty()) {
            PushdozerMod.LOGGER.warn("No plants were planted despite having {} placements. This might indicate planting condition issues.", (Object)placements.size());
        }
        return plantedCount;
    }

    private void placeHighPlant(class_1937 world, class_2338 pos, class_2680 plantState, int height, List<class_2680> newStates) {
        class_2248 plantBlock = plantState.method_26204();
        class_5819 random = world.method_8409();
        if (plantBlock == class_2246.field_10424) {
            for (int i = 0; i < height; ++i) {
                class_2338 plantPos = pos.method_10086(i);
                class_2680 caneState = class_2246.field_10424.method_9564();
                if (i == 0) {
                    caneState = (class_2680)caneState.method_11657((class_2769)class_2523.field_11610, (Comparable)Integer.valueOf(random.method_43048(15)));
                }
                world.method_8501(plantPos, caneState);
                newStates.add(caneState);
            }
        } else if (plantBlock == class_2246.field_10211) {
            for (int i = 0; i < height; ++i) {
                class_2338 plantPos = pos.method_10086(i);
                class_2680 bambooState = class_2246.field_10211.method_9564();
                if (i == 0) {
                    bambooState = (class_2680)bambooState.method_11657((class_2769)class_2211.field_9914, (Comparable)Integer.valueOf(random.method_43048(1)));
                }
                world.method_8501(plantPos, bambooState);
                newStates.add(bambooState);
            }
        } else if (plantBlock == class_2246.field_10029 || plantBlock == class_2246.field_56564) {
            for (int i = 0; i < height; ++i) {
                class_2338 plantPos = pos.method_10086(i);
                class_2680 cactusState = plantBlock == class_2246.field_56564 ? class_2246.field_56564.method_9564() : class_2246.field_10029.method_9564();
                if (i == 0) {
                    cactusState = (class_2680)cactusState.method_11657((class_2769)class_2266.field_10709, (Comparable)Integer.valueOf(random.method_43048(15)));
                }
                world.method_8501(plantPos, cactusState);
                newStates.add(cactusState);
            }
        } else if (plantBlock == class_2246.field_9993) {
            for (int i = 0; i < height; ++i) {
                class_2338 plantPos = pos.method_10086(i);
                class_2680 kelpState = (class_2680)class_2246.field_9993.method_9564().method_11657((class_2769)class_2393.field_22509, (Comparable)Integer.valueOf(random.method_43048(4)));
                world.method_8501(plantPos, kelpState);
                newStates.add(kelpState);
            }
        } else if (plantBlock == class_2246.field_10021) {
            for (int i = 0; i < height; ++i) {
                class_2338 plantPos = pos.method_10086(i);
                class_2680 chorusState = class_2246.field_10021.method_9564();
                world.method_8501(plantPos, chorusState);
                newStates.add(chorusState);
            }
        } else if (plantBlock == class_2246.field_10528) {
            for (int i = 0; i < height; ++i) {
                class_2338 plantPos = pos.method_10086(i);
                class_2680 flowerState = class_2246.field_10528.method_9564();
                world.method_8501(plantPos, flowerState);
                newStates.add(flowerState);
            }
        } else {
            world.method_8501(pos, plantState);
            newStates.add(plantState);
        }
    }

    private boolean canPlantGrowOnBlock(class_1937 world, class_2338 pos, class_2248 plantBlock, class_2680 groundBlock) {
        boolean validBase;
        boolean isCrop;
        class_2338 upperPos;
        class_2680 upperCurrent;
        PushdozerConfig.ShorelineType shorelineType = this.config.getShorelineType();
        if (shorelineType == PushdozerConfig.ShorelineType.CUSTOM) {
            List<class_2248> customPlants = this.config.getCustomShorelinePlantList();
            if (!customPlants.isEmpty()) {
                if (customPlants.contains(plantBlock)) {
                    return this.canPlantCustomBlockAt(world, pos.method_10084(), plantBlock);
                }
                PushdozerMod.LOGGER.debug("Plant {} is not in custom plants list, rejecting", (Object)plantBlock.toString());
                return false;
            }
            PushdozerMod.LOGGER.debug("No custom plants configured, rejecting plant {}", (Object)plantBlock.toString());
            return false;
        }
        class_2680 currentState = world.method_8320(pos);
        boolean inWater = currentState.method_26227().method_15767(class_3486.field_15517);
        if (plantBlock == class_2246.field_10588) {
            boolean airHere = currentState.method_26215();
            boolean waterBelow = groundBlock.method_26227().method_15767(class_3486.field_15517);
            return airHere && waterBelow;
        }
        if (plantBlock instanceof class_2320 && !(upperCurrent = world.method_8320(upperPos = pos.method_10084())).method_26215() && !upperCurrent.method_45474()) {
            return false;
        }
        if (this.isPotted(plantBlock)) {
            boolean spotFree = currentState.method_26215() || currentState.method_45474();
            boolean notInWater = !currentState.method_26227().method_15767(class_3486.field_15517);
            boolean solidBelow = groundBlock.method_26212((class_1922)world, pos.method_10074());
            boolean notPlantBelow = !this.isPlantBlock(groundBlock.method_26204()) && !this.isPotted(groundBlock.method_26204());
            return spotFree && notInWater && solidBelow && notPlantBelow;
        }
        boolean bl = isCrop = this.isCropBlock(plantBlock) || plantBlock.method_9564().method_28498((class_2769)class_2741.field_12550);
        if (isCrop) {
            return groundBlock.method_27852(class_2246.field_10362) && (currentState.method_26215() || currentState.method_45474());
        }
        boolean adjacentToWater = this.isAdjacentToWater(world, pos);
        if (this.isLiveCoral(plantBlock)) {
            boolean validBase2;
            class_2338 upperPos2 = pos.method_10084();
            class_2680 upperState = world.method_8320(upperPos2);
            boolean upperInWater = upperState.method_26227().method_15767(class_3486.field_15517);
            boolean bl2 = validBase2 = groundBlock.method_26164(class_3481.field_15466) || groundBlock.method_26164(class_3481.field_15461) || groundBlock.method_26164(class_3481.field_25806) || groundBlock.method_26164(class_3481.field_25807) || groundBlock.method_27852(class_2246.field_10471) || groundBlock.method_27852(class_2246.field_10255) || groundBlock.method_27852(class_2246.field_10460);
            if (plantBlock instanceof class_2299) {
                boolean hasSolidSide = false;
                for (class_2350 direction : class_2350.class_2353.field_11062) {
                    class_2338 sidePos = pos.method_10093(direction);
                    class_2680 sideState = world.method_8320(sidePos);
                    if (!sideState.method_26212((class_1922)world, sidePos)) continue;
                    hasSolidSide = true;
                    break;
                }
                return (inWater || adjacentToWater) && upperInWater && hasSolidSide;
            }
            return (inWater || adjacentToWater) && upperInWater && validBase2;
        }
        if (plantBlock == class_2246.field_28684) {
            boolean validBase3 = groundBlock.method_26164(class_3481.field_33641) || groundBlock.method_27852(class_2246.field_10460) || groundBlock.method_27852(class_2246.field_28681) || groundBlock.method_27852(class_2246.field_28685) || groundBlock.method_27852(class_2246.field_10402) || groundBlock.method_27852(class_2246.field_10520) || inWater && (groundBlock.method_27852(class_2246.field_10566) || groundBlock.method_27852(class_2246.field_10253) || groundBlock.method_27852(class_2246.field_10219) || groundBlock.method_27852(class_2246.field_10362));
            class_2338 upperPos3 = pos.method_10084();
            class_2680 upperState = world.method_8320(upperPos3);
            boolean upperReplaceable = upperState.method_26215() || upperState.method_45474();
            return validBase3 && upperReplaceable;
        }
        if (plantBlock == class_2246.field_28682) {
            boolean validBase4 = groundBlock.method_27852(class_2246.field_10460) || groundBlock.method_27852(class_2246.field_28681) || groundBlock.method_27852(class_2246.field_10219) || groundBlock.method_27852(class_2246.field_10402) || groundBlock.method_27852(class_2246.field_10520) || groundBlock.method_27852(class_2246.field_10566) || groundBlock.method_27852(class_2246.field_28685) || groundBlock.method_27852(class_2246.field_10253) || groundBlock.method_27852(class_2246.field_10362) || groundBlock.method_27852(class_2246.field_37576) || groundBlock.method_27852(class_2246.field_37547);
            class_2338 upperPos4 = pos.method_10084();
            class_2680 upperState = world.method_8320(upperPos4);
            boolean upperReplaceable = upperState.method_26215() || upperState.method_45474();
            return validBase4 && upperReplaceable;
        }
        if (this.isAquatic(plantBlock)) {
            return inWater;
        }
        if (this.isDeadCoral(plantBlock)) {
            boolean spotFree = currentState.method_26215() || currentState.method_45474();
            boolean solidBelow = groundBlock.method_26212((class_1922)world, pos.method_10074());
            return spotFree && solidBelow;
        }
        if (plantBlock.toString().toLowerCase().contains("leaf_litter")) {
            boolean spotFree = currentState.method_26215() || currentState.method_45474();
            boolean validBase5 = groundBlock.method_26212((class_1922)world, pos.method_10074());
            return spotFree && validBase5;
        }
        if (plantBlock == class_2246.field_10029 || plantBlock == class_2246.field_56564) {
            return groundBlock.method_26164(class_3481.field_15466);
        }
        if (plantBlock == class_2246.field_10424) {
            return groundBlock.method_26164(class_3481.field_15466) || groundBlock.method_26164(class_3481.field_29822) || groundBlock.method_26204() == class_2246.field_10219;
        }
        if (plantBlock == class_2246.field_10479 || plantBlock == class_2246.field_10214) {
            return groundBlock.method_26164(class_3481.field_29822) || groundBlock.method_26204() == class_2246.field_10219;
        }
        if (plantBlock == class_2246.field_10112 || plantBlock == class_2246.field_10313) {
            return groundBlock.method_26164(class_3481.field_29822) || groundBlock.method_26204() == class_2246.field_10219 || groundBlock.method_26204() == class_2246.field_10340 || groundBlock.method_26204() == class_2246.field_10115 || groundBlock.method_26204() == class_2246.field_10508 || groundBlock.method_26204() == class_2246.field_10474;
        }
        if (plantBlock == class_2246.field_10428) {
            return groundBlock.method_26164(class_3481.field_15466);
        }
        if (plantBlock == class_2246.field_10376) {
            return groundBlock.method_26164(class_3481.field_15466) || groundBlock.method_26164(class_3481.field_29822);
        }
        if (plantBlock == class_2246.field_9993) {
            return groundBlock.method_26164(class_3481.field_15466) || groundBlock.method_26164(class_3481.field_29822);
        }
        if (plantBlock == class_2246.field_10211) {
            return groundBlock.method_26164(class_3481.field_15466) || groundBlock.method_26164(class_3481.field_29822) || groundBlock.method_26204() == class_2246.field_10219;
        }
        if (plantBlock == class_2246.field_10021 || plantBlock == class_2246.field_10528) {
            return groundBlock.method_26204() == class_2246.field_10471;
        }
        if (plantBlock == class_2246.field_10182 || plantBlock == class_2246.field_10449 || plantBlock == class_2246.field_10086 || plantBlock == class_2246.field_10226 || plantBlock == class_2246.field_10573 || plantBlock == class_2246.field_10270 || plantBlock == class_2246.field_10048 || plantBlock == class_2246.field_10156 || plantBlock == class_2246.field_10315 || plantBlock == class_2246.field_10554 || plantBlock == class_2246.field_9995 || plantBlock == class_2246.field_10548) {
            return groundBlock.method_26164(class_3481.field_29822) || groundBlock.method_26204() == class_2246.field_10219 || groundBlock.method_26164(class_3481.field_15466);
        }
        boolean bl3 = validBase = groundBlock.method_26164(class_3481.field_29822) || groundBlock.method_27852(class_2246.field_10219) || groundBlock.method_26164(class_3481.field_15466) || groundBlock.method_26164(class_3481.field_29823) || groundBlock.method_27852(class_2246.field_10194) || groundBlock.method_27852(class_2246.field_28681) || groundBlock.method_27852(class_2246.field_10460);
        if (!validBase) {
            return false;
        }
        return currentState.method_26215() || currentState.method_45474();
    }

    private boolean isPlantOrDecoration(class_2680 state) {
        if (state.method_26204() instanceof class_2261 || state.method_26204() instanceof class_2320 || state.method_26204() instanceof class_2356 || state.method_26204() instanceof class_2473 || state.method_26204() instanceof class_2381) {
            return true;
        }
        return state.method_26204() == class_2246.field_10479 || state.method_26204() == class_2246.field_10214 || state.method_26204() == class_2246.field_10112 || state.method_26204() == class_2246.field_10313 || state.method_26204() == class_2246.field_10428 || state.method_26204() == class_2246.field_10424 || state.method_26204() == class_2246.field_10029 || state.method_26204() == class_2246.field_56564 || state.method_26204() == class_2246.field_10376 || state.method_26204() == class_2246.field_9993 || state.method_26204() == class_2246.field_10182 || state.method_26204() == class_2246.field_10449 || state.method_26204() == class_2246.field_10086 || state.method_26204() == class_2246.field_10226 || state.method_26204() == class_2246.field_10573 || state.method_26204() == class_2246.field_10270 || state.method_26204() == class_2246.field_10048 || state.method_26204() == class_2246.field_10156 || state.method_26204() == class_2246.field_10315 || state.method_26204() == class_2246.field_10554 || state.method_26204() == class_2246.field_9995 || state.method_26204() == class_2246.field_10548 || state.method_26204() == class_2246.field_10583 || state.method_26204() == class_2246.field_10378 || state.method_26204() == class_2246.field_10430 || state.method_26204() == class_2246.field_10003 || state.method_26204() == class_2246.field_10394 || state.method_26204() == class_2246.field_10217 || state.method_26204() == class_2246.field_10575 || state.method_26204() == class_2246.field_10276 || state.method_26204() == class_2246.field_10385 || state.method_26204() == class_2246.field_10160 || state.method_26204() == class_2246.field_10251 || state.method_26204() == class_2246.field_10559 || state.method_26204() == class_2246.field_22121 || state.method_26204() == class_2246.field_22114 || state.method_26204() == class_2246.field_22125 || state.method_26204() == class_2246.field_22116 || state.method_26204() == class_2246.field_22117 || state.method_26204() == class_2246.field_22123 || state.method_26204() == class_2246.field_23078 || state.method_26204() == class_2246.field_28411 || state.method_26204() == class_2246.field_28680 || state.method_26204() == class_2246.field_28684 || state.method_26204() == class_2246.field_28682 || state.method_26204() == class_2246.field_28677 || state.method_26204() == class_2246.field_28678 || state.method_26204() == class_2246.field_28679 || state.method_26204() == class_2246.field_42750 || state.method_26204() == class_2246.field_42734 || state.method_26204() == class_2246.field_43229 || state.method_26204() == class_2246.field_42727 || state.method_26204() == class_2246.field_10211 || state.method_26204() == class_2246.field_10108 || state.method_26204() == class_2246.field_10021 || state.method_26204() == class_2246.field_10528 || state.method_26204() == class_2246.field_9974 || state.method_26204() == class_2246.field_22122 || state.method_26204() == class_2246.field_22089 || state.method_26204() == class_2246.field_22092 || state.method_26204() == class_2246.field_22093 || state.method_26204() == class_2246.field_22110 || state.method_26204() == class_2246.field_23860 || state.method_26204() == class_2246.field_10336 || state.method_26204() == class_2246.field_10099 || state.method_26204() == class_2246.field_16541 || state.method_26204() == class_2246.field_17350 || state.method_26204() == class_2246.field_23860 || state.method_26204() == class_2246.field_10036 || state.method_26204() == class_2246.field_10164 || state.method_26204() == class_2246.field_10382 || state.method_26204() == class_2246.field_10422 || state.method_26204() == class_2246.field_10476 || state.method_26204() == class_2246.field_10125 || state.method_26204() == class_2246.field_10339 || state.method_26204() == class_2246.field_10134 || state.method_26204() == class_2246.field_10618 || state.method_26204() == class_2246.field_10169 || state.method_26204() == class_2246.field_10053 || state.method_26204() == class_2246.field_10079 || state.method_26204() == class_2246.field_10427 || state.method_26204() == class_2246.field_10551 || state.method_26204() == class_2246.field_10005 || state.method_26204() == class_2246.field_10584 || state.method_26204() == class_2246.field_10186 || state.method_26204() == class_2246.field_10447 || state.method_26204() == class_2246.field_10498 || state.method_26204() == class_2246.field_9976;
    }

    private boolean isSurfaceBlock(class_1937 world, class_2338 pos) {
        class_2338 above = pos.method_10084();
        class_2680 aboveState = world.method_8320(above);
        if (aboveState.method_26215() || aboveState.method_26227().method_15767(class_3486.field_15517) || this.isPlantOrDecoration(aboveState)) {
            return true;
        }
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            class_2338 neighborPos = pos.method_10093(dir);
            class_2680 neighborState = world.method_8320(neighborPos);
            if (!neighborState.method_26215() && !neighborState.method_26227().method_15767(class_3486.field_15517) && !this.isPlantOrDecoration(neighborState)) continue;
            return true;
        }
        class_2338 below = pos.method_10074();
        class_2680 belowState = world.method_8320(below);
        return belowState.method_26215() || belowState.method_26227().method_15767(class_3486.field_15517);
    }

    private int getPlantRequiredHeight(class_1937 world, class_2248 plantBlock) {
        class_5819 random = world.method_8409();
        if (plantBlock == class_2246.field_10424) {
            return 1 + random.method_43048(3);
        }
        if (plantBlock == class_2246.field_10211) {
            return 2 + random.method_43048(4);
        }
        if (plantBlock == class_2246.field_10029 || plantBlock == class_2246.field_56564) {
            return 1 + random.method_43048(3);
        }
        if (plantBlock == class_2246.field_9993) {
            return 3 + random.method_43048(5);
        }
        if (plantBlock == class_2246.field_10313) {
            return 2;
        }
        if (plantBlock == class_2246.field_10583) {
            return 2;
        }
        if (plantBlock == class_2246.field_10378) {
            return 2;
        }
        if (plantBlock == class_2246.field_10430) {
            return 2;
        }
        if (plantBlock == class_2246.field_10003) {
            return 2;
        }
        if (plantBlock == class_2246.field_10021) {
            return 2 + random.method_43048(4);
        }
        if (plantBlock == class_2246.field_10528) {
            return 2 + random.method_43048(4);
        }
        return 1;
    }

    private boolean hasEnoughSpaceForPlant(class_1937 world, class_2338 pos, int requiredHeight) {
        for (int i = 1; i < requiredHeight; ++i) {
            class_2338 checkPos = pos.method_10086(i);
            class_2680 checkState = world.method_8320(checkPos);
            if (checkState.method_26215() || checkState.method_26227().method_15767(class_3486.field_15517) || this.isPlantOrDecoration(checkState)) continue;
            return false;
        }
        return true;
    }

    private boolean isSolidBlock(class_1937 world, class_2338 pos, class_2680 state) {
        if (state.method_26227().method_15767(class_3486.field_15517)) {
            return false;
        }
        return !state.method_26220((class_1922)world, pos).method_1110();
    }

    private boolean canPlantCustomBlockAt(class_1937 world, class_2338 pos, class_2248 block) {
        boolean validBase;
        boolean isCrop;
        class_2680 targetState = world.method_8320(pos);
        class_2680 below = world.method_8320(pos.method_10074());
        class_2680 state = block.method_9564();
        if (block == class_2246.field_10588) {
            boolean airHere = targetState.method_26215();
            boolean waterBelow = below.method_26227().method_15767(class_3486.field_15517);
            return airHere && waterBelow && state.method_26184((class_4538)world, pos);
        }
        if (block instanceof class_2320) {
            if (!state.method_28498((class_2769)class_2741.field_12533)) {
                return false;
            }
            class_2338 upperPos = pos.method_10084();
            class_2680 upperCurrent = world.method_8320(upperPos);
            if (!upperCurrent.method_26215() && !upperCurrent.method_45474()) {
                return false;
            }
        }
        if (this.isPotted(block)) {
            boolean spotFree = targetState.method_26215() || targetState.method_45474();
            boolean notInWater = !targetState.method_26227().method_15767(class_3486.field_15517);
            boolean solidBelow = below.method_26212((class_1922)world, pos.method_10074());
            boolean notPlantBelow = !this.isPlantBlock(below.method_26204()) && !this.isPotted(below.method_26204());
            boolean potCanPlace = class_2246.field_10495.method_9564().method_26184((class_4538)world, pos);
            return spotFree && notInWater && solidBelow && notPlantBelow && potCanPlace && state.method_26184((class_4538)world, pos);
        }
        boolean bl = isCrop = this.isCropBlock(block) || state.method_28498((class_2769)class_2741.field_12550);
        if (isCrop) {
            return below.method_27852(class_2246.field_10362) && (targetState.method_26215() || targetState.method_45474());
        }
        boolean inWater = targetState.method_26227().method_15767(class_3486.field_15517);
        boolean adjacentToWater = this.isAdjacentToWater(world, pos);
        if (this.isLiveCoral(block)) {
            boolean validBase2;
            class_2338 upperPos = pos.method_10084();
            class_2680 upperState = world.method_8320(upperPos);
            boolean upperInWater = upperState.method_26227().method_15767(class_3486.field_15517);
            boolean bl2 = validBase2 = below.method_26164(class_3481.field_15466) || below.method_26164(class_3481.field_15461) || below.method_26164(class_3481.field_25806) || below.method_26164(class_3481.field_25807) || below.method_27852(class_2246.field_10471) || below.method_27852(class_2246.field_10255) || below.method_27852(class_2246.field_10460);
            if (block instanceof class_2299) {
                boolean hasSolidSide = false;
                for (class_2350 direction : class_2350.class_2353.field_11062) {
                    class_2338 sidePos = pos.method_10093(direction);
                    class_2680 sideState = world.method_8320(sidePos);
                    if (!sideState.method_26212((class_1922)world, sidePos)) continue;
                    hasSolidSide = true;
                    break;
                }
                return (inWater || adjacentToWater) && upperInWater && hasSolidSide;
            }
            return (inWater || adjacentToWater) && upperInWater && validBase2;
        }
        if (block == class_2246.field_28684) {
            boolean validBase3 = below.method_26164(class_3481.field_33641) || below.method_27852(class_2246.field_10460) || below.method_27852(class_2246.field_28681) || below.method_27852(class_2246.field_28685) || below.method_27852(class_2246.field_10402) || below.method_27852(class_2246.field_10520) || inWater && (below.method_27852(class_2246.field_10566) || below.method_27852(class_2246.field_10253) || below.method_27852(class_2246.field_10219) || below.method_27852(class_2246.field_10362));
            class_2338 upperPos = pos.method_10084();
            class_2680 upperState = world.method_8320(upperPos);
            boolean upperReplaceable = upperState.method_26215() || upperState.method_45474();
            return validBase3 && upperReplaceable;
        }
        if (block == class_2246.field_28682) {
            boolean validBase4 = below.method_27852(class_2246.field_10460) || below.method_27852(class_2246.field_28681) || below.method_27852(class_2246.field_10219) || below.method_27852(class_2246.field_10402) || below.method_27852(class_2246.field_10520) || below.method_27852(class_2246.field_10566) || below.method_27852(class_2246.field_28685) || below.method_27852(class_2246.field_10253) || below.method_27852(class_2246.field_10362) || below.method_27852(class_2246.field_37576) || below.method_27852(class_2246.field_37547);
            class_2338 upperPos = pos.method_10084();
            class_2680 upperState = world.method_8320(upperPos);
            boolean upperReplaceable = upperState.method_26215() || upperState.method_45474();
            return validBase4 && upperReplaceable;
        }
        if (this.isAquatic(block)) {
            return inWater && state.method_26184((class_4538)world, pos);
        }
        if (this.isDeadCoral(block)) {
            boolean spotFree = targetState.method_26215() || targetState.method_45474();
            boolean solidBelow = below.method_26212((class_1922)world, pos.method_10074());
            return spotFree && solidBelow;
        }
        if (block.toString().toLowerCase().contains("leaf_litter")) {
            boolean spotFree = targetState.method_26215() || targetState.method_45474();
            boolean validBase5 = below.method_26212((class_1922)world, pos.method_10074());
            return spotFree && validBase5;
        }
        boolean bl3 = validBase = below.method_26164(class_3481.field_29822) || below.method_27852(class_2246.field_10219) || below.method_26164(class_3481.field_15466) || below.method_26164(class_3481.field_29823) || below.method_27852(class_2246.field_10194) || below.method_27852(class_2246.field_28681) || below.method_27852(class_2246.field_10460);
        if (!validBase) {
            PushdozerMod.LOGGER.debug("Custom plant {} cannot grow on invalid base block {} at pos {}", new Object[]{block, below.method_26204().toString(), pos});
            return false;
        }
        boolean spotFree = targetState.method_26215() || targetState.method_45474();
        boolean canPlace = state.method_26184((class_4538)world, pos);
        if (!spotFree) {
            PushdozerMod.LOGGER.debug("Custom plant {} cannot grow at pos {}: spot not free (current state: {})", new Object[]{block, pos, targetState.method_26204().toString()});
            return false;
        }
        if (!canPlace) {
            PushdozerMod.LOGGER.debug("Custom plant {} cannot be placed at pos {}: canPlaceAt returned false", (Object)block, (Object)pos);
            return false;
        }
        PushdozerMod.LOGGER.debug("Custom plant {} can grow at pos {} on base block {}", new Object[]{block, pos, below.method_26204().toString()});
        return true;
    }

    private boolean isAdjacentToWater(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            class_2338 adjacentPos = pos.method_10093(direction);
            class_2680 adjacentState = world.method_8320(adjacentPos);
            if (!adjacentState.method_26227().method_15767(class_3486.field_15517)) continue;
            return true;
        }
        return false;
    }

    private boolean isPotted(class_2248 block) {
        return block instanceof class_2362 && block != class_2246.field_10495;
    }

    private boolean isPlantBlock(class_2248 block) {
        return block == class_2246.field_10182 || block == class_2246.field_10449 || block == class_2246.field_10086 || block == class_2246.field_10226 || block == class_2246.field_10573 || block == class_2246.field_10270 || block == class_2246.field_10048 || block == class_2246.field_10156 || block == class_2246.field_10315 || block == class_2246.field_10554 || block == class_2246.field_9995 || block == class_2246.field_10548 || block == class_2246.field_10583 || block == class_2246.field_10378 || block == class_2246.field_10430 || block == class_2246.field_10003 || block == class_2246.field_10479 || block == class_2246.field_10214 || block == class_2246.field_10112 || block == class_2246.field_10313 || block == class_2246.field_10428 || block == class_2246.field_10029 || block == class_2246.field_56564 || block == class_2246.field_10424 || block == class_2246.field_10211 || block == class_2246.field_10021 || block == class_2246.field_10528 || block == class_2246.field_22117 || block == class_2246.field_22116 || block == class_2246.field_22125 || block == class_2246.field_22114 || block == class_2246.field_22121 || block == class_2246.field_22123 || block == class_2246.field_23078 || block == class_2246.field_28411 || block == class_2246.field_28686 || block == class_2246.field_28677 || block == class_2246.field_28679 || block == class_2246.field_28678 || block == class_2246.field_28680 || block == class_2246.field_10376 || block == class_2246.field_10238 || block == class_2246.field_9993 || block == class_2246.field_10463 || block == class_2246.field_10476 || block == class_2246.field_10588 || block == class_2246.field_28684 || block == class_2246.field_28682 || this.isLiveCoral(block) || this.isDeadCoral(block) || this.isCropBlock(block) || block instanceof class_2320 || block.toString().toLowerCase().contains("leaf_litter");
    }

    private boolean isCropBlock(class_2248 block) {
        return block == class_2246.field_10293 || block == class_2246.field_10609 || block == class_2246.field_10247 || block == class_2246.field_10341 || block == class_2246.field_46286 || block == class_2246.field_46287;
    }

    private boolean isLiveCoral(class_2248 block) {
        String id = block.toString().toLowerCase();
        return id.contains("coral") && !id.contains("dead");
    }

    private boolean isDeadCoral(class_2248 block) {
        String id = block.toString().toLowerCase();
        return id.contains("coral") && id.contains("dead");
    }

    private boolean isAquatic(class_2248 block) {
        return block == class_2246.field_10376 || block == class_2246.field_10238 || block == class_2246.field_9993 || block == class_2246.field_10463 || block == class_2246.field_10476;
    }

    private class_2680 getVegetationForBiome(class_1937 world, class_2338 pos, class_1959 biome, class_2680 groundBlock) {
        PushdozerConfig.ShorelineType shorelineType = this.config.getShorelineType();
        PushdozerMod.LOGGER.debug("getVegetationForBiome: shorelineType = {}, pos = {}", (Object)shorelineType, (Object)pos);
        if (shorelineType == PushdozerConfig.ShorelineType.CUSTOM) {
            List<class_2248> customPlants = this.config.getCustomShorelinePlantList();
            PushdozerMod.LOGGER.debug("Custom shoreline type: customPlants size = {}", (Object)customPlants.size());
            if (!customPlants.isEmpty()) {
                class_2248 selectedPlant = this.getRandomSuitableCustomPlant(world, pos, customPlants, groundBlock);
                PushdozerMod.LOGGER.debug("Selected custom plant: {}", (Object)(selectedPlant != null ? selectedPlant.toString() : "null"));
                if (selectedPlant != null) {
                    class_2680 plantState = selectedPlant.method_9564();
                    if (this.isDeadCoral(selectedPlant) && plantState.method_28498((class_2769)class_2741.field_12508)) {
                        plantState = (class_2680)plantState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
                    }
                    return plantState;
                }
                PushdozerMod.LOGGER.debug("No suitable custom plants found for current conditions");
            } else {
                PushdozerMod.LOGGER.debug("Custom shoreline type but no custom plants configured!");
            }
            return null;
        }
        return switch (shorelineType) {
            case PushdozerConfig.ShorelineType.BEACH -> this.getBeachVegetation(world, pos, biome, groundBlock);
            case PushdozerConfig.ShorelineType.EMBANKMENT -> this.getEmbankmentVegetation(world, pos, biome, groundBlock);
            case PushdozerConfig.ShorelineType.MUDDY -> this.getMuddyVegetation(world, pos, biome, groundBlock);
            case PushdozerConfig.ShorelineType.ROCKY -> this.getRockyVegetation(world, pos, biome, groundBlock);
            case PushdozerConfig.ShorelineType.ADAPTIVE -> this.getAdaptiveVegetation(world, pos, biome, groundBlock);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)shorelineType));
        };
    }

    private class_2248 getRandomSuitableCustomPlant(class_1937 world, class_2338 pos, List<class_2248> customPlants, class_2680 groundBlock) {
        if (customPlants.isEmpty()) {
            return null;
        }
        PushdozerMod.LOGGER.debug("Checking {} custom plants for position {} with ground block {}", new Object[]{customPlants.size(), pos, groundBlock.method_26204().toString()});
        ArrayList<class_2248> suitablePlants = new ArrayList<class_2248>();
        for (class_2248 plant : customPlants) {
            if (plant == null) continue;
            boolean canGrow = this.canPlantGrowOnBlock(world, pos, plant, groundBlock);
            if (canGrow) {
                suitablePlants.add(plant);
                PushdozerMod.LOGGER.debug("Plant {} is suitable for position {}", (Object)plant, (Object)pos);
                continue;
            }
            PushdozerMod.LOGGER.debug("Plant {} is NOT suitable for position {}", (Object)plant, (Object)pos);
        }
        if (suitablePlants.isEmpty()) {
            PushdozerMod.LOGGER.debug("No suitable custom plants found for position {} with ground block {}", (Object)pos, (Object)groundBlock.method_26204().toString());
            return null;
        }
        class_2248 selectedPlant = (class_2248)suitablePlants.get(world.method_8409().method_43048(suitablePlants.size()));
        PushdozerMod.LOGGER.debug("Selected custom plant {} from {} suitable options for position {}", new Object[]{selectedPlant.toString(), suitablePlants.size(), pos});
        return selectedPlant;
    }

    private class_2680 getRandomFlower(class_1937 world) {
        class_2248[] flowers = new class_2248[]{class_2246.field_10182, class_2246.field_10449, class_2246.field_10086, class_2246.field_10226, class_2246.field_10573, class_2246.field_10270, class_2246.field_10048, class_2246.field_10156, class_2246.field_10315, class_2246.field_10554, class_2246.field_9995, class_2246.field_10548};
        return flowers[world.method_8409().method_43048(flowers.length)].method_9564();
    }

    private class_2680 getRandomAquaticPlant(class_1937 world) {
        class_2248[] aquaticPlants = new class_2248[]{class_2246.field_10376, class_2246.field_9993, class_2246.field_10476, class_2246.field_10125, class_2246.field_10339, class_2246.field_10134, class_2246.field_10618, class_2246.field_10169};
        class_2248 selectedPlant = aquaticPlants[world.method_8409().method_43048(aquaticPlants.length)];
        if (selectedPlant == class_2246.field_9993) {
            return (class_2680)selectedPlant.method_9564().method_11657((class_2769)class_2393.field_22509, (Comparable)Integer.valueOf(world.method_8409().method_43048(4)));
        }
        return selectedPlant.method_9564();
    }

    private class_2680 getRandomFern(class_1937 world) {
        class_2248[] ferns = new class_2248[]{class_2246.field_10112, class_2246.field_10313};
        class_2248 selectedFern = ferns[world.method_8409().method_43048(ferns.length)];
        if (selectedFern == class_2246.field_10313) {
            return (class_2680)selectedFern.method_9564().method_11657((class_2769)class_2320.field_10929, (Comparable)(world.method_8409().method_43056() ? class_2756.field_12607 : class_2756.field_12609));
        }
        return selectedFern.method_9564();
    }

    private class_2680 getRandomMoss(class_1937 world) {
        class_2248[] mossPlants = new class_2248[]{class_2246.field_28680, class_2246.field_28411, class_2246.field_28684, class_2246.field_28682};
        return mossPlants[world.method_8409().method_43048(mossPlants.length)].method_9564();
    }

    private class_2680 getCactusWithFlower(class_1937 world) {
        return class_2246.field_10029.method_9564();
    }

    private Set<class_2338> findShorelineEdges(class_1937 world, GeometryShape shape) {
        HashSet<class_2338> edges = new HashSet<class_2338>();
        HashSet<class_2338> waterBlocks = new HashSet<class_2338>();
        HashSet<class_2338> checkedPositions = new HashSet<class_2338>();
        for (class_2338 pos : shape.getBlockPositions()) {
            if (!world.method_8316(pos).method_15767(class_3486.field_15517)) continue;
            waterBlocks.add(pos);
        }
        for (class_2338 waterPos : waterBlocks) {
            class_2338 neighborPos;
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                neighborPos = waterPos.method_10093(dir);
                if (checkedPositions.contains(neighborPos)) continue;
                checkedPositions.add(neighborPos);
                if (waterBlocks.contains(neighborPos) || world.method_8316(neighborPos).method_15767(class_3486.field_15517) || !this.isReplaceableLandBlock(world, neighborPos, world.method_8320(neighborPos))) continue;
                edges.add(neighborPos);
            }
            for (class_2350 dir : class_2350.class_2353.field_11064) {
                neighborPos = waterPos.method_10093(dir);
                if (checkedPositions.contains(neighborPos)) continue;
                checkedPositions.add(neighborPos);
                if (waterBlocks.contains(neighborPos) || world.method_8316(neighborPos).method_15767(class_3486.field_15517) || !this.isReplaceableLandBlock(world, neighborPos, world.method_8320(neighborPos))) continue;
                edges.add(neighborPos);
            }
        }
        return edges;
    }

    private boolean isChunkLoaded(class_1937 world, class_2338 pos) {
        return world.method_8393(pos.method_10263() >> 4, pos.method_10260() >> 4);
    }

    private class_2680 getBeachVegetation(class_1937 world, class_2338 pos, class_1959 biome, class_2680 groundBlock) {
        String biomeName = biome.toString().toLowerCase();
        PushdozerMod.LOGGER.debug("Beach vegetation selection - Biome: {}, Ground: {}", (Object)biomeName, (Object)groundBlock.method_26204().toString());
        float heightAdjustment = 1.0f;
        if (groundBlock.method_26164(class_3481.field_15466)) {
            if (biomeName.contains("ocean") || biomeName.contains("beach")) {
                return this.getRandomAquaticPlant(world);
            }
            if (biomeName.contains("desert")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.7f) {
                    return class_2246.field_10029.method_9564();
                }
                if (randomValue < 0.8f) {
                    return class_2246.field_10428.method_9564();
                }
                return class_2246.field_10029.method_9564();
            }
            if (biomeName.contains("river") || biomeName.contains("swamp")) {
                return world.method_8409().method_43057() < 0.6f ? class_2246.field_10424.method_9564() : this.getRandomAquaticPlant(world);
            }
            if (biomeName.contains("jungle") || biomeName.contains("forest")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.4f) {
                    return class_2246.field_10211.method_9564();
                }
                if (randomValue < 0.6f) {
                    return class_2246.field_10029.method_9564();
                }
                if (randomValue < 0.7f) {
                    return class_2246.field_10029.method_9564();
                }
                return class_2246.field_10424.method_9564();
            }
            if (biomeName.contains("savanna") || biomeName.contains("plains")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.4f) {
                    return class_2246.field_10029.method_9564();
                }
                if (randomValue < 0.5f) {
                    return class_2246.field_10029.method_9564();
                }
                if (randomValue < 0.8f) {
                    return class_2246.field_10428.method_9564();
                }
                return class_2246.field_10424.method_9564();
            }
            if (biomeName.contains("badlands")) {
                return world.method_8409().method_43057() < 0.8f ? class_2246.field_10428.method_9564() : class_2246.field_10029.method_9564();
            }
            float randomValue = world.method_8409().method_43057();
            if (randomValue < 0.3f) {
                return class_2246.field_10029.method_9564();
            }
            if (randomValue < 0.4f) {
                return class_2246.field_10029.method_9564();
            }
            if (randomValue < 0.7f) {
                return class_2246.field_10424.method_9564();
            }
            return class_2246.field_10428.method_9564();
        }
        if (groundBlock.method_26164(class_3481.field_29822) || groundBlock.method_26204() == class_2246.field_10219) {
            if (biomeName.contains("snowy")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.1f) {
                    return class_2246.field_10479.method_9564();
                }
                return null;
            }
            if (biomeName.contains("desert")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.7f) {
                    return class_2246.field_10029.method_9564();
                }
                if (randomValue < 0.8f) {
                    return class_2246.field_10428.method_9564();
                }
                return class_2246.field_10029.method_9564();
            }
            if (biomeName.contains("river") || biomeName.contains("swamp")) {
                return world.method_8409().method_43057() < 0.7f ? class_2246.field_10424.method_9564() : this.getRandomFern(world);
            }
            if (biomeName.contains("jungle") || biomeName.contains("forest")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.2f) {
                    return class_2246.field_10029.method_9564();
                }
                if (randomValue < 0.3f) {
                    return class_2246.field_10029.method_9564();
                }
                if (randomValue < 0.5f) {
                    return class_2246.field_10479.method_9564();
                }
                if (randomValue < 0.7f) {
                    return this.getRandomFern(world);
                }
                if (randomValue < 0.9f) {
                    return class_2246.field_10214.method_9564();
                }
                return this.getRandomFlower(world);
            }
            if (biomeName.contains("savanna") || biomeName.contains("plains")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.3f) {
                    return class_2246.field_10029.method_9564();
                }
                if (randomValue < 0.4f) {
                    return class_2246.field_10029.method_9564();
                }
                if (randomValue < 0.7f) {
                    return class_2246.field_10479.method_9564();
                }
                if (randomValue < 0.9f) {
                    return class_2246.field_10214.method_9564();
                }
                return this.getRandomFlower(world);
            }
            if (biomeName.contains("badlands")) {
                return world.method_8409().method_43057() < 0.6f ? class_2246.field_10029.method_9564() : class_2246.field_10428.method_9564();
            }
            float randomValue = world.method_8409().method_43057();
            if (randomValue < 0.2f) {
                return class_2246.field_10029.method_9564();
            }
            if (randomValue < 0.3f) {
                return class_2246.field_10029.method_9564();
            }
            if (randomValue < 0.6f) {
                return class_2246.field_10479.method_9564();
            }
            if (randomValue < 0.8f) {
                return class_2246.field_10214.method_9564();
            }
            return this.getRandomFlower(world);
        }
        if (groundBlock.method_26204() == class_2246.field_9979 || groundBlock.method_26204() == class_2246.field_10344 || groundBlock.method_26204() == class_2246.field_10467) {
            if (biomeName.contains("desert") || biomeName.contains("badlands")) {
                return world.method_8409().method_43057() < 0.6f ? class_2246.field_10029.method_9564() : class_2246.field_10428.method_9564();
            }
            if (biomeName.contains("savanna") || biomeName.contains("plains")) {
                return world.method_8409().method_43057() < 0.5f ? class_2246.field_10029.method_9564() : class_2246.field_10428.method_9564();
            }
            return world.method_8409().method_43057() < 0.4f ? class_2246.field_10029.method_9564() : class_2246.field_10428.method_9564();
        }
        return null;
    }

    private class_2680 getEmbankmentVegetation(class_1937 world, class_2338 pos, class_1959 biome, class_2680 groundBlock) {
        String biomeName = biome.toString().toLowerCase();
        if (groundBlock.method_26164(class_3481.field_29822) || groundBlock.method_26204() == class_2246.field_10219) {
            if (biomeName.contains("snowy")) {
                return null;
            }
            if (biomeName.contains("desert")) {
                return world.method_8409().method_43057() < 0.7f ? class_2246.field_10029.method_9564() : class_2246.field_10428.method_9564();
            }
            if (biomeName.contains("river") || biomeName.contains("swamp")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.5f) {
                    return class_2246.field_10424.method_9564();
                }
                if (randomValue < 0.8f) {
                    return this.getRandomFern(world);
                }
                return class_2246.field_10086.method_9564();
            }
            if (biomeName.contains("forest") || biomeName.contains("jungle")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.4f) {
                    return this.getRandomFern(world);
                }
                if (randomValue < 0.6f) {
                    return class_2246.field_10479.method_9564();
                }
                if (randomValue < 0.8f) {
                    return class_2246.field_10214.method_9564();
                }
                return this.getRandomFlower(world);
            }
            if (biomeName.contains("mountain") || biomeName.contains("hill")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.3f) {
                    return class_2246.field_10479.method_9564();
                }
                if (randomValue < 0.5f) {
                    return class_2246.field_10214.method_9564();
                }
                if (randomValue < 0.7f) {
                    return this.getRandomFern(world);
                }
                if (randomValue < 0.9f) {
                    return this.getRandomFlower(world);
                }
                return class_2246.field_10554.method_9564();
            }
            if (biomeName.contains("nether")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.5f) {
                    return class_2246.field_22125.method_9564();
                }
                if (randomValue < 0.7f) {
                    return class_2246.field_22116.method_9564();
                }
                return null;
            }
            if (biomeName.contains("end")) {
                return world.method_8409().method_43057() < 0.3f ? class_2246.field_10021.method_9564() : null;
            }
            float randomValue = world.method_8409().method_43057();
            if (randomValue < 0.4f) {
                return class_2246.field_10479.method_9564();
            }
            if (randomValue < 0.6f) {
                return class_2246.field_10214.method_9564();
            }
            if (randomValue < 0.8f) {
                return this.getRandomFern(world);
            }
            return this.getRandomFlower(world);
        }
        if (groundBlock.method_26164(class_3481.field_15466)) {
            if (biomeName.contains("river") || biomeName.contains("swamp")) {
                return world.method_8409().method_43057() < 0.8f ? class_2246.field_10424.method_9564() : class_2246.field_9993.method_9564();
            }
            if (biomeName.contains("desert")) {
                return world.method_8409().method_43057() < 0.6f ? class_2246.field_10428.method_9564() : class_2246.field_10029.method_9564();
            }
            float randomValue = world.method_8409().method_43057();
            if (randomValue < 0.6f) {
                return class_2246.field_10479.method_9564();
            }
            if (randomValue < 0.8f) {
                return class_2246.field_10214.method_9564();
            }
            return this.getRandomFlower(world);
        }
        if (groundBlock.method_26204() == class_2246.field_10340 || groundBlock.method_26204() == class_2246.field_10445 || groundBlock.method_26204() == class_2246.field_10255 || groundBlock.method_26204() == class_2246.field_10115 || groundBlock.method_26204() == class_2246.field_10508 || groundBlock.method_26204() == class_2246.field_10474) {
            if (biomeName.contains("mountain") || biomeName.contains("hill")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.5f) {
                    return this.getRandomMoss(world);
                }
                if (randomValue < 0.8f) {
                    return class_2246.field_10554.method_9564();
                }
                return this.getRandomFlower(world);
            }
            if (biomeName.contains("forest")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.3f) {
                    return class_2246.field_28411.method_9564();
                }
                if (randomValue < 0.6f) {
                    return this.getRandomMoss(world);
                }
                return this.getRandomFern(world);
            }
            if (biomeName.contains("river") || biomeName.contains("swamp")) {
                return world.method_8409().method_43057() < 0.2f ? class_2246.field_10424.method_9564() : null;
            }
            float randomValue = world.method_8409().method_43057();
            if (randomValue < 0.4f) {
                return this.getRandomMoss(world);
            }
            if (randomValue < 0.7f) {
                return this.getRandomFern(world);
            }
            return this.getRandomFlower(world);
        }
        return null;
    }

    private class_2680 getMuddyVegetation(class_1937 world, class_2338 pos, class_1959 biome, class_2680 groundBlock) {
        String biomeName = biome.toString().toLowerCase();
        if (groundBlock.method_26164(class_3481.field_29822) || groundBlock.method_26204() == class_2246.field_10219 || groundBlock.method_26204() == class_2246.field_37576) {
            if (biomeName.contains("snowy")) {
                return null;
            }
            if (biomeName.contains("swamp") || biomeName.contains("river")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.3f) {
                    return class_2246.field_10424.method_9564();
                }
                if (randomValue < 0.5f) {
                    return this.getRandomFern(world);
                }
                if (randomValue < 0.7f) {
                    return class_2246.field_10479.method_9564();
                }
                if (randomValue < 0.85f) {
                    return class_2246.field_10214.method_9564();
                }
                if (randomValue < 0.95f) {
                    return class_2246.field_10086.method_9564();
                }
                return this.getRandomFlower(world);
            }
            if (biomeName.contains("jungle")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.4f) {
                    return this.getRandomFern(world);
                }
                if (randomValue < 0.6f) {
                    return class_2246.field_10424.method_9564();
                }
                if (randomValue < 0.75f) {
                    return class_2246.field_10479.method_9564();
                }
                if (randomValue < 0.9f) {
                    return class_2246.field_10214.method_9564();
                }
                return this.getRandomFlower(world);
            }
            if (biomeName.contains("forest") || biomeName.contains("plains")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.3f) {
                    return class_2246.field_10479.method_9564();
                }
                if (randomValue < 0.5f) {
                    return this.getRandomFern(world);
                }
                if (randomValue < 0.7f) {
                    return class_2246.field_10214.method_9564();
                }
                if (randomValue < 0.85f) {
                    return this.getRandomFlower(world);
                }
                return class_2246.field_10086.method_9564();
            }
            if (biomeName.contains("desert")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.4f) {
                    return class_2246.field_10428.method_9564();
                }
                if (randomValue < 0.7f) {
                    return class_2246.field_10479.method_9564();
                }
                if (randomValue < 0.9f) {
                    return class_2246.field_10214.method_9564();
                }
                return this.getRandomFlower(world);
            }
            if (biomeName.contains("nether")) {
                return world.method_8409().method_43057() < 0.4f ? class_2246.field_22125.method_9564() : null;
            }
            if (biomeName.contains("end")) {
                return world.method_8409().method_43057() < 0.2f ? class_2246.field_10021.method_9564() : null;
            }
            float randomValue = world.method_8409().method_43057();
            if (randomValue < 0.4f) {
                return this.getRandomFern(world);
            }
            if (randomValue < 0.6f) {
                return class_2246.field_10479.method_9564();
            }
            if (randomValue < 0.8f) {
                return class_2246.field_10214.method_9564();
            }
            return this.getRandomFlower(world);
        }
        if (groundBlock.method_26164(class_3481.field_15466)) {
            if (biomeName.contains("swamp") || biomeName.contains("river")) {
                return class_2246.field_10424.method_9564();
            }
            if (biomeName.contains("ocean")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.6f) {
                    return this.getRandomAquaticPlant(world);
                }
                return class_2246.field_10376.method_9564();
            }
        } else if (groundBlock.method_26204() == class_2246.field_10340 || groundBlock.method_26204() == class_2246.field_10445 || groundBlock.method_26204() == class_2246.field_10255 || groundBlock.method_26204() == class_2246.field_10115 || groundBlock.method_26204() == class_2246.field_10508 || groundBlock.method_26204() == class_2246.field_10474) {
            if (biomeName.contains("swamp") || biomeName.contains("river")) {
                return world.method_8409().method_43057() < 0.4f ? class_2246.field_28680.method_9564() : null;
            }
        } else if (groundBlock.method_26204() == class_2246.field_37576 && (biomeName.contains("swamp") || biomeName.contains("river"))) {
            return world.method_8409().method_43057() < 0.2f ? class_2246.field_28684.method_9564() : class_2246.field_10112.method_9564();
        }
        return null;
    }

    private class_2680 getRockyVegetation(class_1937 world, class_2338 pos, class_1959 biome, class_2680 groundBlock) {
        String biomeName = biome.toString().toLowerCase();
        if (groundBlock.method_26204() == class_2246.field_10340 || groundBlock.method_26204() == class_2246.field_10445 || groundBlock.method_26204() == class_2246.field_10255 || groundBlock.method_26204() == class_2246.field_10115 || groundBlock.method_26204() == class_2246.field_10508 || groundBlock.method_26204() == class_2246.field_10474 || groundBlock.method_26204() == class_2246.field_28888) {
            if (biomeName.contains("mountain") || biomeName.contains("hill")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.5f) {
                    return this.getRandomMoss(world);
                }
                if (randomValue < 0.8f) {
                    return class_2246.field_10554.method_9564();
                }
                return this.getRandomFlower(world);
            }
            if (biomeName.contains("desert")) {
                return world.method_8409().method_43057() < 0.5f ? class_2246.field_10029.method_9564() : class_2246.field_10428.method_9564();
            }
            if (biomeName.contains("ocean") || biomeName.contains("beach")) {
                return world.method_8409().method_43057() < 0.2f ? this.getRandomAquaticPlant(world) : null;
            }
            if (biomeName.contains("forest")) {
                return world.method_8409().method_43057() < 0.3f ? this.getRandomFern(world) : null;
            }
            if (biomeName.contains("river") || biomeName.contains("swamp")) {
                return world.method_8409().method_43057() < 0.2f ? class_2246.field_10424.method_9564() : null;
            }
            if (biomeName.contains("nether")) {
                return world.method_8409().method_43057() < 0.2f ? class_2246.field_22116.method_9564() : null;
            }
            if (biomeName.contains("end")) {
                return world.method_8409().method_43057() < 0.2f ? class_2246.field_10021.method_9564() : null;
            }
            return null;
        }
        if (groundBlock.method_26164(class_3481.field_29822) || groundBlock.method_26204() == class_2246.field_10219) {
            if (biomeName.contains("mountain") || biomeName.contains("hill")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.6f) {
                    return class_2246.field_10479.method_9564();
                }
                if (randomValue < 0.8f) {
                    return class_2246.field_10112.method_9564();
                }
                return this.getRandomFlower(world);
            }
            if (biomeName.contains("desert")) {
                return world.method_8409().method_43057() < 0.3f ? class_2246.field_10029.method_9564() : null;
            }
            float randomValue = world.method_8409().method_43057();
            if (randomValue < 0.4f) {
                return class_2246.field_10479.method_9564();
            }
            if (randomValue < 0.6f) {
                return class_2246.field_10214.method_9564();
            }
            if (randomValue < 0.8f) {
                return this.getRandomFern(world);
            }
            return this.getRandomFlower(world);
        }
        if (groundBlock.method_26164(class_3481.field_15466)) {
            if (biomeName.contains("desert")) {
                return class_2246.field_10428.method_9564();
            }
            if (biomeName.contains("ocean") || biomeName.contains("beach")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.5f) {
                    return this.getRandomAquaticPlant(world);
                }
                return class_2246.field_10428.method_9564();
            }
        }
        return null;
    }

    private class_2680 getAdaptiveVegetation(class_1937 world, class_2338 pos, class_1959 biome, class_2680 groundBlock) {
        String biomeName = biome.toString().toLowerCase();
        if (groundBlock.method_26164(class_3481.field_15466)) {
            if (biomeName.contains("desert")) {
                return class_2246.field_10029.method_9564();
            }
            if (biomeName.contains("river") || biomeName.contains("swamp")) {
                return class_2246.field_10424.method_9564();
            }
            if (biomeName.contains("ocean") || biomeName.contains("beach")) {
                return this.getRandomAquaticPlant(world);
            }
            if (biomeName.contains("badlands")) {
                return world.method_8409().method_43057() < 0.4f ? class_2246.field_10428.method_9564() : class_2246.field_10029.method_9564();
            }
            return class_2246.field_10424.method_9564();
        }
        if (groundBlock.method_26164(class_3481.field_29822) || groundBlock.method_26204() == class_2246.field_10219) {
            if (biomeName.contains("snowy")) {
                return null;
            }
            if (biomeName.contains("desert")) {
                return world.method_8409().method_43057() < 0.7f ? class_2246.field_10029.method_9564() : class_2246.field_10428.method_9564();
            }
            if (biomeName.contains("river") || biomeName.contains("swamp")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.4f) {
                    return class_2246.field_10424.method_9564();
                }
                if (randomValue < 0.7f) {
                    return this.getRandomFern(world);
                }
                if (randomValue < 0.9f) {
                    return class_2246.field_10086.method_9564();
                }
                return this.getRandomFlower(world);
            }
            if (biomeName.contains("forest") || biomeName.contains("jungle")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.4f) {
                    return class_2246.field_10479.method_9564();
                }
                if (randomValue < 0.6f) {
                    return class_2246.field_10214.method_9564();
                }
                if (randomValue < 0.8f) {
                    return this.getRandomFern(world);
                }
                return this.getRandomFlower(world);
            }
            if (biomeName.contains("savanna") || biomeName.contains("plains")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.7f) {
                    return class_2246.field_10479.method_9564();
                }
                return this.getRandomFlower(world);
            }
            if (biomeName.contains("taiga") || biomeName.contains("cold")) {
                return world.method_8409().method_43057() < 0.6f ? class_2246.field_10112.method_9564() : null;
            }
            if (biomeName.contains("ocean") || biomeName.contains("beach")) {
                return world.method_8409().method_43057() < 0.8f ? class_2246.field_10479.method_9564() : this.getRandomAquaticPlant(world);
            }
            if (biomeName.contains("end")) {
                return world.method_8409().method_43057() < 0.2f ? class_2246.field_10021.method_9564() : null;
            }
            float randomValue = world.method_8409().method_43057();
            if (randomValue < 0.5f) {
                return class_2246.field_10479.method_9564();
            }
            if (randomValue < 0.7f) {
                return class_2246.field_10214.method_9564();
            }
            if (randomValue < 0.85f) {
                return this.getRandomFern(world);
            }
            return this.getRandomFlower(world);
        }
        if (groundBlock.method_26204() == class_2246.field_10340 || groundBlock.method_26204() == class_2246.field_10445 || groundBlock.method_26204() == class_2246.field_10255 || groundBlock.method_26204() == class_2246.field_10115 || groundBlock.method_26204() == class_2246.field_10508 || groundBlock.method_26204() == class_2246.field_10474 || groundBlock.method_26204() == class_2246.field_28888) {
            if (biomeName.contains("mountain") || biomeName.contains("hill")) {
                float randomValue = world.method_8409().method_43057();
                if (randomValue < 0.5f) {
                    return this.getRandomMoss(world);
                }
                if (randomValue < 0.8f) {
                    return class_2246.field_10554.method_9564();
                }
                return this.getRandomFlower(world);
            }
            if (biomeName.contains("ocean") || biomeName.contains("beach")) {
                return world.method_8409().method_43057() < 0.2f ? this.getRandomAquaticPlant(world) : null;
            }
            if (biomeName.contains("river") || biomeName.contains("swamp")) {
                return world.method_8409().method_43057() < 0.3f ? class_2246.field_10424.method_9564() : null;
            }
            if (biomeName.contains("forest")) {
                return world.method_8409().method_43057() < 0.2f ? class_2246.field_10112.method_9564() : null;
            }
            return null;
        }
        return null;
    }

    static {
        BIOME_BLOCK_GENERATORS.put(PushdozerBiomeTags.HAS_SWAMP_SHORES, (distance, random) -> ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_37576.method_9564(), class_2246.field_10566.method_9564(), random));
        BIOME_BLOCK_GENERATORS.put(PushdozerBiomeTags.HAS_RIVER_SHORES, (distance, random) -> ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_10255.method_9564(), class_2246.field_10566.method_9564(), random));
        BIOME_BLOCK_GENERATORS.put(PushdozerBiomeTags.HAS_SNOWY_SHORES, (distance, random) -> ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_10491.method_9564(), class_2246.field_10295.method_9564(), random));
        BIOME_BLOCK_GENERATORS.put(PushdozerBiomeTags.HAS_DESERT_BEACHES, (distance, random) -> ShorelineProcessHandler.applyBeachTransitionProbability(distance, class_2246.field_10102.method_9564(), class_2246.field_10566.method_9564(), random, null));
        BIOME_BLOCK_GENERATORS.put(PushdozerBiomeTags.HAS_DESERT_SHORES, (distance, random) -> ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_10534.method_9564(), class_2246.field_10344.method_9564(), random));
        BIOME_BLOCK_GENERATORS.put(PushdozerBiomeTags.HAS_SANDY_BEACHES, (distance, random) -> ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_10102.method_9564(), class_2246.field_10566.method_9564(), random));
        BIOME_BLOCK_GENERATORS.put(PushdozerBiomeTags.HAS_ROCKY_SHORES, (distance, random) -> ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_10340.method_9564(), class_2246.field_10445.method_9564(), random));
        BIOME_BLOCK_GENERATORS.put(PushdozerBiomeTags.HAS_LUSH_SHORES, (distance, random) -> ShorelineProcessHandler.applyTransitionProbability(distance, class_2246.field_10219.method_9564(), class_2246.field_10566.method_9564(), random));
    }

    private static class ShorelineTransition {
        final class_2338 pos;
        final class_2680 newState;
        final int distance;
        final boolean isValid;

        ShorelineTransition(class_2338 pos, class_2680 newState, int distance, boolean isValid) {
            this.pos = pos;
            this.newState = newState;
            this.distance = distance;
            this.isValid = isValid;
        }

        static ShorelineTransition valid(class_2338 pos, class_2680 newState, int distance) {
            return new ShorelineTransition(pos, newState, distance, true);
        }

        boolean isValid() {
            return this.isValid;
        }
    }

    private static class ProcessingResult {
        final List<class_2338> affectedPositions;
        final List<class_2680> originalStates;
        final List<class_2680> newStates;
        final List<class_2338> vegetationPositions;
        final int processedCount;
        final int iterationCount;

        ProcessingResult(List<class_2338> affectedPositions, List<class_2680> originalStates, List<class_2680> newStates, List<class_2338> vegetationPositions, int processedCount, int iterationCount) {
            this.affectedPositions = affectedPositions;
            this.originalStates = originalStates;
            this.newStates = newStates;
            this.vegetationPositions = vegetationPositions;
            this.processedCount = processedCount;
            this.iterationCount = iterationCount;
        }
    }

    private static class VegetationPlacement {
        final class_2338 pos;
        final class_2680 plant;
        final boolean isTallPlant;
        final class_2680 groundBlock;

        VegetationPlacement(class_2338 pos, class_2680 plant, boolean isTallPlant, class_2680 groundBlock) {
            this.pos = pos;
            this.plant = plant;
            this.isTallPlant = isTallPlant;
            this.groundBlock = groundBlock;
        }
    }
}

