/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.network;

import com.pushdozer.network.BatchedNetworkManager;
import com.pushdozer.network.ConfigSyncPayload;
import com.pushdozer.network.PermissionCheckPayload;
import com.pushdozer.network.TerrainOperationPayload;
import com.pushdozer.network.UndoRedoPayload;
import com.pushdozer.services.UndoRedoService;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"pushdozer");

    public static void registerNetworking() {
        PayloadTypeRegistry.playC2S().register(UndoRedoPayload.ID, UndoRedoPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ConfigSyncPayload.ID, ConfigSyncPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(PermissionCheckPayload.ID, PermissionCheckPayload.CODEC);
        NetworkManager.registerServerHandlers();
        NetworkManager.registerConnectionEvents();
        LOGGER.info("Pushdozer\u670d\u52a1\u5668\u7aef\u7f51\u7edc\u5305\u6ce8\u518c\u5b8c\u6210");
    }

    private static void registerServerHandlers() {
        ServerPlayNetworking.registerGlobalReceiver(UndoRedoPayload.ID, (payload, context) -> context.server().execute(() -> {
            try {
                if (payload.isUndo()) {
                    LOGGER.info("\u670d\u52a1\u5668\u6536\u5230\u64a4\u9500\u8bf7\u6c42\uff0c\u73a9\u5bb6: {}", (Object)context.player().method_5477().getString());
                    UndoRedoService.getInstance().undoLastAction((class_1657)context.player(), (class_1937)context.player().method_51469());
                } else {
                    LOGGER.info("\u670d\u52a1\u5668\u6536\u5230\u91cd\u505a\u8bf7\u6c42\uff0c\u73a9\u5bb6: {}", (Object)context.player().method_5477().getString());
                    UndoRedoService.getInstance().redoLastAction((class_1657)context.player(), (class_1937)context.player().method_51469());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5904\u7406\u64a4\u9500/\u91cd\u505a\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(ConfigSyncPayload.ID, (payload, context) -> context.server().execute(() -> {
            try {
                if (NetworkManager.hasPermissionToChangeConfig(context.player())) {
                    LOGGER.info("\u73a9\u5bb6 {} \u66f4\u65b0\u4e86\u4e2a\u4eba\u914d\u7f6e", (Object)context.player().method_5477().getString());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5904\u7406\u914d\u7f6e\u540c\u6b65\u5931\u8d25", (Throwable)e);
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(PermissionCheckPayload.ID, (payload, context) -> context.server().execute(() -> {
            try {
                boolean hasPermission = NetworkManager.checkTerrainOperationPermission(context.player(), payload.operationType(), payload.centerPos(), payload.radius());
                if (!hasPermission) {
                    LOGGER.warn("\u73a9\u5bb6 {} \u5c1d\u8bd5\u6267\u884c\u672a\u6388\u6743\u7684\u5730\u5f62\u64cd\u4f5c: {}", (Object)context.player().method_5477().getString(), (Object)payload.operationType());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5904\u7406\u6743\u9650\u68c0\u67e5\u5931\u8d25", (Throwable)e);
            }
        }));
    }

    private static void registerConnectionEvents() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            try {
                LOGGER.info("\u73a9\u5bb6 {} \u52a0\u5165\u670d\u52a1\u5668\uff0cpushdozer\u5de5\u5177\u53ef\u7528", (Object)handler.field_14140.method_5477().getString());
            }
            catch (Exception e) {
                LOGGER.error("\u5904\u7406\u73a9\u5bb6\u52a0\u5165\u4e8b\u4ef6\u5931\u8d25", (Throwable)e);
            }
        });
    }

    public static void broadcastTerrainOperation(class_3218 world, String operationType, List<class_2338> positions, List<class_2680> states) {
        try {
            if (positions.size() <= 50) {
                TerrainOperationPayload payload = new TerrainOperationPayload(operationType, positions, states);
                for (class_3222 player : world.method_18456()) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
                }
                LOGGER.debug("\u76f4\u63a5\u5e7f\u64ad\u5730\u5f62\u64cd\u4f5c {} \u5230 {} \u4e2a\u73a9\u5bb6\uff0c\u65b9\u5757\u6570: {}", new Object[]{operationType, world.method_18456().size(), positions.size()});
            } else {
                BatchedNetworkManager.getInstance().addTerrainOperation(world, operationType, positions, states);
                LOGGER.debug("\u6dfb\u52a0\u5730\u5f62\u64cd\u4f5c\u5230\u6279\u5904\u7406\u961f\u5217: {} \u4e2a\u65b9\u5757", (Object)positions.size());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5e7f\u64ad\u5730\u5f62\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
    }

    public static void syncConfigToAllPlayers(MinecraftServer server, ConfigSyncPayload configPayload) {
        try {
            for (class_3222 player : server.method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)configPayload);
            }
            LOGGER.info("\u5411 {} \u4e2a\u73a9\u5bb6\u540c\u6b65\u914d\u7f6e", (Object)server.method_3760().method_14571().size());
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u914d\u7f6e\u5230\u6240\u6709\u73a9\u5bb6\u5931\u8d25", (Throwable)e);
        }
    }

    private static boolean hasPermissionToChangeConfig(class_3222 player) {
        return true;
    }

    private static boolean checkTerrainOperationPermission(class_3222 player, String operationType, class_2338 centerPos, int radius) {
        if (radius > 100) {
            LOGGER.warn("\u73a9\u5bb6 {} \u5c1d\u8bd5\u6267\u884c\u8fc7\u5927\u8303\u56f4\u7684\u64cd\u4f5c: \u534a\u5f84 {}", (Object)player.method_5477().getString(), (Object)radius);
            return false;
        }
        return true;
    }
}

