/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.shapes;

import com.pushdozer.shapes.GeometryShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;

public class TriangularPrismShape
implements GeometryShape {
    private final double sideLength;
    private final double height;
    private class_243 prismCenter;
    private class_2338 center;

    public TriangularPrismShape(double sideLength, double height, class_2338 center) {
        this.sideLength = sideLength;
        this.height = height;
        this.center = center;
        this.prismCenter = class_243.method_24953((class_2382)center);
    }

    public TriangularPrismShape(double sideLength, double height, class_243 center) {
        this.sideLength = sideLength;
        this.height = height;
        this.prismCenter = center;
        this.center = new class_2338((int)Math.floor(center.field_1352), (int)Math.floor(center.field_1351), (int)Math.floor(center.field_1350));
    }

    @Override
    public class_2338 getCenter() {
        return this.center;
    }

    @Override
    public void setCenter(class_2338 newCenter) {
        if (newCenter == null) {
            throw new IllegalArgumentException("The central location cannot be empty");
        }
        this.center = newCenter;
        this.prismCenter = class_243.method_24953((class_2382)newCenter);
    }

    @Override
    public void renderOutline(class_4587 matrices, class_4588 vertexConsumer, class_243 center, float red, float green, float blue, float alpha) {
        matrices.method_22903();
        matrices.method_22904(center.field_1352, center.field_1351, center.field_1350);
        class_243[] bottomVertices = this.getBottomVertices();
        class_243[] topVertices = this.getTopVertices();
        this.drawEdge(vertexConsumer, matrices, bottomVertices[0], bottomVertices[1], red, green, blue, alpha);
        this.drawEdge(vertexConsumer, matrices, bottomVertices[1], bottomVertices[2], red, green, blue, alpha);
        this.drawEdge(vertexConsumer, matrices, bottomVertices[2], bottomVertices[0], red, green, blue, alpha);
        this.drawEdge(vertexConsumer, matrices, topVertices[0], topVertices[1], red, green, blue, alpha);
        this.drawEdge(vertexConsumer, matrices, topVertices[1], topVertices[2], red, green, blue, alpha);
        this.drawEdge(vertexConsumer, matrices, topVertices[2], topVertices[0], red, green, blue, alpha);
        this.drawEdge(vertexConsumer, matrices, bottomVertices[0], topVertices[0], red, green, blue, alpha);
        this.drawEdge(vertexConsumer, matrices, bottomVertices[1], topVertices[1], red, green, blue, alpha);
        this.drawEdge(vertexConsumer, matrices, bottomVertices[2], topVertices[2], red, green, blue, alpha);
        matrices.method_22909();
    }

    @Override
    public void renderSolid(class_4587 matrices, class_4588 vertexConsumer, class_243 center, float red, float green, float blue, float alpha) {
        matrices.method_22903();
        matrices.method_22904(center.field_1352, center.field_1351, center.field_1350);
        class_243[] bottomVertices = this.getBottomVertices();
        class_243[] topVertices = this.getTopVertices();
        this.renderTriangleFace(vertexConsumer, matrices, bottomVertices[0], bottomVertices[1], bottomVertices[2], red, green, blue, alpha);
        this.renderTriangleFace(vertexConsumer, matrices, topVertices[0], topVertices[1], topVertices[2], red, green, blue, alpha);
        this.renderRectangleFace(vertexConsumer, matrices, bottomVertices[0], bottomVertices[1], topVertices[1], topVertices[0], red, green, blue, alpha);
        this.renderRectangleFace(vertexConsumer, matrices, bottomVertices[1], bottomVertices[2], topVertices[2], topVertices[1], red, green, blue, alpha);
        this.renderRectangleFace(vertexConsumer, matrices, bottomVertices[2], bottomVertices[0], topVertices[0], topVertices[2], red, green, blue, alpha);
        matrices.method_22909();
    }

    @Override
    public boolean isInside(class_243 pos) {
        class_243 relativePos = pos.method_1020(this.prismCenter);
        if (Math.abs(relativePos.field_1351) > this.height / 2.0) {
            return false;
        }
        return this.isPointInTriangle(relativePos.field_1352, relativePos.field_1350, this.sideLength);
    }

    private boolean isPointInTriangle(double x, double z, double sideLength) {
        double area3;
        double area2;
        double height = sideLength * Math.sqrt(3.0) / 2.0;
        double[] xCoords = new double[]{0.0, -sideLength / 2.0, sideLength / 2.0};
        double[] zCoords = new double[]{height / 2.0, -height / 2.0, -height / 2.0};
        double area = height * sideLength / 2.0;
        double area1 = Math.abs((xCoords[1] - x) * (zCoords[2] - z) - (xCoords[2] - x) * (zCoords[1] - z)) / 2.0;
        return Math.abs(area1 + (area2 = Math.abs((xCoords[2] - x) * (zCoords[0] - z) - (xCoords[0] - x) * (zCoords[2] - z)) / 2.0) + (area3 = Math.abs((xCoords[0] - x) * (zCoords[1] - z) - (xCoords[1] - x) * (zCoords[0] - z)) / 2.0) - area) < 0.001;
    }

    @Override
    public boolean isInside(class_2338 pos) {
        return this.isInside(class_243.method_24953((class_2382)pos));
    }

    @Override
    public class_238 getBoundingBox(class_2338 basePos) {
        return new class_238((double)basePos.method_10263() - this.sideLength, (double)basePos.method_10264() - this.height / 2.0, (double)basePos.method_10260() - this.sideLength, (double)basePos.method_10263() + this.sideLength, (double)basePos.method_10264() + this.height / 2.0, (double)basePos.method_10260() + this.sideLength);
    }

    @Override
    public int getMinY(class_2338 basePos) {
        return (int)((double)basePos.method_10264() - this.height / 2.0);
    }

    @Override
    public int getMaxY(class_2338 basePos) {
        return (int)((double)basePos.method_10264() + this.height / 2.0);
    }

    @Override
    public List<class_2338> getBlocksInLayer(class_2338 basePos, int y) {
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        class_238 boundingBox = this.getBoundingBox(basePos);
        int x = (int)boundingBox.field_1323;
        while ((double)x <= boundingBox.field_1320) {
            int z = (int)boundingBox.field_1321;
            while ((double)z <= boundingBox.field_1324) {
                class_2338 pos = new class_2338(x, y, z);
                if (this.isInside(pos)) {
                    blocks.add(pos);
                }
                ++z;
            }
            ++x;
        }
        return blocks;
    }

    @Override
    public List<class_2338> getBlocksInRadius(class_243 center, int maxDistance) {
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        class_2338 basePos = new class_2338((int)center.field_1352, (int)center.field_1351, (int)center.field_1350);
        for (int y = this.getMinY(basePos); y <= this.getMaxY(basePos); ++y) {
            blocks.addAll(this.getBlocksInLayer(basePos, y));
        }
        return blocks;
    }

    @Override
    public boolean isWithinBounds(class_2338 pos, class_2338 basePos) {
        return this.isInside(pos);
    }

    @Override
    public List<class_2338> getBlocks() {
        return this.getBlockPositions();
    }

    @Override
    public Iterator<class_2338> getBlocksIterator() {
        return this.getBlocks().iterator();
    }

    public double getSideLength() {
        return this.sideLength;
    }

    public double getHeight() {
        return this.height;
    }

    @Override
    public List<class_2338> getBlockPositions() {
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        class_238 boundingBox = this.getBoundingBox(this.center);
        int x = (int)boundingBox.field_1323;
        while ((double)x <= boundingBox.field_1320) {
            int y = (int)boundingBox.field_1322;
            while ((double)y <= boundingBox.field_1325) {
                int z = (int)boundingBox.field_1321;
                while ((double)z <= boundingBox.field_1324) {
                    class_2338 pos = new class_2338(x, y, z);
                    if (this.isInside(pos)) {
                        blocks.add(pos);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return blocks;
    }

    private class_243[] getBottomVertices() {
        double triangleHeight = this.sideLength * Math.sqrt(3.0) / 2.0;
        return new class_243[]{new class_243(0.0, -this.height / 2.0, triangleHeight / 2.0), new class_243(-this.sideLength / 2.0, -this.height / 2.0, -triangleHeight / 2.0), new class_243(this.sideLength / 2.0, -this.height / 2.0, -triangleHeight / 2.0)};
    }

    private class_243[] getTopVertices() {
        double triangleHeight = this.sideLength * Math.sqrt(3.0) / 2.0;
        return new class_243[]{new class_243(0.0, this.height / 2.0, triangleHeight / 2.0), new class_243(-this.sideLength / 2.0, this.height / 2.0, -triangleHeight / 2.0), new class_243(this.sideLength / 2.0, this.height / 2.0, -triangleHeight / 2.0)};
    }

    private void drawEdge(class_4588 vertexConsumer, class_4587 matrices, class_243 start, class_243 end, float red, float green, float blue, float alpha) {
        class_243 normal = end.method_1020(start).method_1029();
        vertexConsumer.method_22918(matrices.method_23760().method_23761(), (float)start.field_1352, (float)start.field_1351, (float)start.field_1350).method_22915(red, green, blue, alpha).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
        vertexConsumer.method_22918(matrices.method_23760().method_23761(), (float)end.field_1352, (float)end.field_1351, (float)end.field_1350).method_22915(red, green, blue, alpha).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
    }

    private void renderTriangleFace(class_4588 vertexConsumer, class_4587 matrices, class_243 v1, class_243 v2, class_243 v3, float red, float green, float blue, float alpha) {
        class_243 edge1 = v2.method_1020(v1);
        class_243 edge2 = v3.method_1020(v1);
        class_243 normal = edge1.method_1036(edge2).method_1029();
        this.addVertex(vertexConsumer, matrices, v1, normal, red, green, blue, alpha);
        this.addVertex(vertexConsumer, matrices, v2, normal, red, green, blue, alpha);
        this.addVertex(vertexConsumer, matrices, v3, normal, red, green, blue, alpha);
    }

    private void renderRectangleFace(class_4588 vertexConsumer, class_4587 matrices, class_243 v1, class_243 v2, class_243 v3, class_243 v4, float red, float green, float blue, float alpha) {
        class_243 edge1 = v2.method_1020(v1);
        class_243 edge2 = v3.method_1020(v1);
        class_243 normal = edge1.method_1036(edge2).method_1029();
        this.addVertex(vertexConsumer, matrices, v1, normal, red, green, blue, alpha);
        this.addVertex(vertexConsumer, matrices, v2, normal, red, green, blue, alpha);
        this.addVertex(vertexConsumer, matrices, v3, normal, red, green, blue, alpha);
        this.addVertex(vertexConsumer, matrices, v1, normal, red, green, blue, alpha);
        this.addVertex(vertexConsumer, matrices, v3, normal, red, green, blue, alpha);
        this.addVertex(vertexConsumer, matrices, v4, normal, red, green, blue, alpha);
    }

    private void addVertex(class_4588 vertexConsumer, class_4587 matrices, class_243 pos, class_243 normal, float red, float green, float blue, float alpha) {
        vertexConsumer.method_22918(matrices.method_23760().method_23761(), (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350).method_22915(red, green, blue, alpha).method_22913(0.5f, 0.5f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
    }
}

