/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.panels.workmode;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.ui.screens.PushdozerConfigScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_5348;

public class WorkModeSelectionPanel {
    private static final int COLOR_PANEL_BG = -1072689136;
    private static final int COLOR_PANEL_BORDER = -1;
    private static final int COLOR_TITLE_BG = -533712848;
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final int PANEL_WIDTH = 210;
    private static final int PANEL_HEIGHT = 125;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_MARGIN = 5;
    private static final int TITLE_HEIGHT = 20;
    private final PushdozerConfigScreen parent;
    private final PushdozerConfig config;
    private final Consumer<PushdozerConfig.WorkMode> onSelectionChanged;
    private final List<class_364> widgets = new ArrayList<class_364>();
    private List<PushdozerConfig.WorkMode> displayModes;
    private boolean visible = false;
    private int panelLeft;
    private int panelTop;
    private int titleX;
    private int titleY;
    private class_2561 titleText;

    public WorkModeSelectionPanel(PushdozerConfigScreen parent, PushdozerConfig config, Consumer<PushdozerConfig.WorkMode> onSelectionChanged) {
        this.parent = parent;
        this.config = config;
        this.onSelectionChanged = onSelectionChanged;
        this.panelLeft = (parent.getScreenWidth() - 210) / 2;
        this.panelTop = (parent.getScreenHeight() - 125) / 2;
        this.displayModes = this.getDisplayWorkModes();
        this.initializeWidgets();
        this.initializeTitlePosition();
    }

    private void initializeWidgets() {
        this.widgets.clear();
        int startY = this.panelTop + 20 + 5;
        List<PushdozerConfig.WorkMode> modes = this.displayModes;
        int buttonWidth = 97;
        for (int i = 0; i < modes.size(); ++i) {
            PushdozerConfig.WorkMode mode = modes.get(i);
            int row = i / 2;
            int col = i % 2;
            int buttonX = this.panelLeft + 5 + col * (buttonWidth + 5);
            int buttonY = startY + row * 25;
            class_4185 button = class_4185.method_46430((class_2561)this.getButtonText(mode), btn -> this.selectWorkMode(mode)).method_46434(buttonX, buttonY, buttonWidth, 20).method_46431();
            this.widgets.add((class_364)button);
        }
    }

    private class_2561 getButtonText(PushdozerConfig.WorkMode mode) {
        String prefix = this.config.getWorkMode() == mode ? "\u2611 " : "";
        return class_2561.method_43470((String)prefix).method_10852(mode.getDisplayText());
    }

    private void updateButtonStates() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            class_364 widget = this.widgets.get(i);
            if (!(widget instanceof class_4185)) continue;
            class_4185 button = (class_4185)widget;
            PushdozerConfig.WorkMode mode = this.displayModes.get(i);
            button.method_25355(this.getButtonText(mode));
        }
    }

    private void initializeTitlePosition() {
        this.titleText = class_2561.method_43471((String)"pushdozer.panel.work_mode_selection.title");
        if (this.parent.getClient() != null) {
            int titleWidth = this.parent.getClient().field_1772.method_27525((class_5348)this.titleText);
            this.titleX = this.panelLeft + (210 - titleWidth) / 2;
            Objects.requireNonNull(this.parent.getClient().field_1772);
            this.titleY = this.panelTop + (20 - 9) / 2;
        }
    }

    private void selectWorkMode(PushdozerConfig.WorkMode mode) {
        this.config.setWorkMode(mode);
        this.updateButtonStates();
        if (this.onSelectionChanged != null) {
            this.onSelectionChanged.accept(mode);
        }
        this.hide();
    }

    public void show() {
        this.visible = true;
        this.panelLeft = (this.parent.getScreenWidth() - 210) / 2;
        this.panelTop = (this.parent.getScreenHeight() - 125) / 2;
        this.initializeWidgets();
        this.initializeTitlePosition();
        this.updateButtonStates();
    }

    public void hide() {
        this.visible = false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        this.renderBackground(context);
        this.renderTitle(context);
        this.renderButtons(context, mouseX, mouseY, delta);
    }

    private void renderBackground(class_332 context) {
        context.method_25294(this.panelLeft, this.panelTop, this.panelLeft + 210, this.panelTop + 125, -1072689136);
        context.method_25294(this.panelLeft, this.panelTop, this.panelLeft + 210, this.panelTop + 20, -533712848);
        context.method_49601(this.panelLeft, this.panelTop, 210, 125, -1);
    }

    private void renderTitle(class_332 context) {
        if (this.parent.getClient() != null && this.titleText != null) {
            context.method_51439(this.parent.getClient().field_1772, this.titleText, this.titleX, this.titleY, 0xFFFFFF, false);
        }
    }

    private void renderButtons(class_332 context, int mouseX, int mouseY, float delta) {
        for (class_364 widget : this.widgets) {
            if (!(widget instanceof class_4185)) continue;
            class_4185 button = (class_4185)widget;
            button.method_25365(false);
        }
        PushdozerConfig.WorkMode currentMode = this.config.getWorkMode();
        for (int i = 0; i < this.widgets.size(); ++i) {
            boolean isSelected;
            class_364 widget = this.widgets.get(i);
            if (!(widget instanceof class_4185)) continue;
            class_4185 button = (class_4185)widget;
            boolean bl = isSelected = this.displayModes.get(i) == currentMode;
            if (!isSelected) continue;
            button.method_25365(true);
        }
        for (class_364 widget : this.widgets) {
            if (!(widget instanceof class_4068)) continue;
            ((class_4068)widget).method_25394(context, mouseX, mouseY, delta);
        }
    }

    private List<PushdozerConfig.WorkMode> getDisplayWorkModes() {
        ArrayList<PushdozerConfig.WorkMode> list = new ArrayList<PushdozerConfig.WorkMode>();
        block3: for (PushdozerConfig.WorkMode m : PushdozerConfig.WorkMode.values()) {
            switch (m) {
                case SMOOTH_RAISE: 
                case SMOOTH_LOWER: 
                case ADAPTIVE_SMOOTH: {
                    continue block3;
                }
                default: {
                    list.add(m);
                }
            }
        }
        if (!list.contains((Object)PushdozerConfig.WorkMode.SMOOTH)) {
            list.add(PushdozerConfig.WorkMode.SMOOTH);
        }
        return list;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        if (mouseX >= (double)this.panelLeft && mouseX <= (double)(this.panelLeft + 210) && mouseY >= (double)this.panelTop && mouseY <= (double)(this.panelTop + 125)) {
            return this.handleMouseEvent(widget -> widget.method_25402(mouseX, mouseY, button));
        }
        this.hide();
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.visible) {
            return false;
        }
        return this.handleMouseEvent(widget -> widget.method_25403(mouseX, mouseY, button, deltaX, deltaY));
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        return this.handleMouseEvent(widget -> widget.method_25406(mouseX, mouseY, button));
    }

    private boolean handleMouseEvent(Function<class_339, Boolean> eventHandler) {
        for (class_364 widget : this.widgets) {
            class_339 clickableWidget;
            if (!(widget instanceof class_339) || !eventHandler.apply(clickableWidget = (class_339)widget).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

