/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.screens;

import com.pushdozer.PushdozerMod;
import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.items.PushdozerItem;
import com.pushdozer.ui.panels.HeightConfigPanel;
import com.pushdozer.ui.panels.brushgeometry.BoxSubPanel;
import com.pushdozer.ui.panels.brushgeometry.ConeSubPanel;
import com.pushdozer.ui.panels.brushgeometry.CylinderSubPanel;
import com.pushdozer.ui.panels.brushgeometry.EllipsoidSubPanel;
import com.pushdozer.ui.panels.brushgeometry.GeometrySelectionPanel;
import com.pushdozer.ui.panels.brushgeometry.GeometrySubPanel;
import com.pushdozer.ui.panels.brushgeometry.OctahedronSubPanel;
import com.pushdozer.ui.panels.brushgeometry.SphereSubPanel;
import com.pushdozer.ui.panels.brushgeometry.TetrahedronSubPanel;
import com.pushdozer.ui.panels.brushgeometry.TriangularPrismSubPanel;
import com.pushdozer.ui.panels.workmode.BatchPlantConfigPanel;
import com.pushdozer.ui.panels.workmode.BoneMealConfigPanel;
import com.pushdozer.ui.panels.workmode.ExcavateConfigPanel;
import com.pushdozer.ui.panels.workmode.PlaceConfigPanel;
import com.pushdozer.ui.panels.workmode.ShorelineProcessConfigPanel;
import com.pushdozer.ui.panels.workmode.SmoothConfigPanel;
import com.pushdozer.ui.panels.workmode.SurfaceConvertConfigPanel;
import com.pushdozer.ui.panels.workmode.SurfaceRoughenConfigPanel;
import com.pushdozer.ui.panels.workmode.WorkModeConfigPanel;
import com.pushdozer.ui.panels.workmode.WorkModeSelectionPanel;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class PushdozerConfigScreen
extends class_437 {
    private final PushdozerConfig config;
    private class_4185 applyAndCloseButton;
    private class_4185 displayModeButton;
    private GeometrySubPanel currentSubPanel;
    private static final int PANEL_WIDTH = 280;
    private static final int TITLE_HEIGHT = 20;
    private static final int SCREEN_MARGIN = 10;
    public int panelLeft;
    public int panelTop;
    private long openTime;
    private static final long CLOSE_DELAY = 150L;
    private boolean mainPanelVisible = true;
    private CustomDistanceSlider distanceSlider;
    private class_4185 workModeButton;
    private class_4185 workModeConfigButton;
    private WorkModeSelectionPanel workModeSelectionPanel;
    private final List<class_4185> workModeOptions = new ArrayList<class_4185>();
    private boolean isWorkModeDropdownOpen = false;
    private WorkModeConfigPanel currentWorkModeConfigPanel;
    private class_4185 geometryButton;
    private class_4185 geometryConfigButton;
    private GeometrySelectionPanel geometrySelectionPanel;
    private class_4185 heightConfigButton;
    private HeightConfigPanel heightConfigPanel;

    public PushdozerConfigScreen(PushdozerConfig config) {
        super((class_2561)class_2561.method_43471((String)"pushdozer.config.title"));
        this.config = config;
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && !(client.field_1724.method_6047().method_7909() instanceof PushdozerItem)) {
            client.method_1507(null);
            return;
        }
        this.openTime = System.currentTimeMillis();
    }

    protected void method_25426() {
        super.method_25426();
        if (this.config == null) {
            PushdozerMod.LOGGER.error(class_2561.method_43471((String)"pushdozer.error.config_null").getString());
            return;
        }
        GeometrySubPanel previousSubPanel = this.currentSubPanel;
        boolean wasSubPanelVisible = previousSubPanel != null && previousSubPanel.isVisible();
        String previousPanelType = PushdozerConfigScreen.getString(wasSubPanelVisible, previousSubPanel);
        this.initializeComponents();
        if (wasSubPanelVisible && previousPanelType != null) {
            switch (previousPanelType) {
                case "Box": {
                    this.showBoxConfigPanel();
                    break;
                }
                case "Sphere": {
                    this.showSphereConfigPanel();
                    break;
                }
                case "Octahedron": {
                    this.showOctahedronConfigPanel();
                    break;
                }
                case "Cylinder": {
                    this.showCylinderConfigPanel();
                    break;
                }
                case "Cone": {
                    this.showConeConfigPanel();
                    break;
                }
                case "Ellipsoid": {
                    this.showEllipsoidConfigPanel();
                }
            }
        }
    }

    @Nullable
    private static String getString(boolean wasSubPanelVisible, GeometrySubPanel previousSubPanel) {
        String previousPanelType = null;
        if (wasSubPanelVisible) {
            GeometrySubPanel geometrySubPanel = previousSubPanel;
            Objects.requireNonNull(geometrySubPanel);
            GeometrySubPanel geometrySubPanel2 = geometrySubPanel;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoxSubPanel.class, SphereSubPanel.class, OctahedronSubPanel.class, CylinderSubPanel.class, ConeSubPanel.class, EllipsoidSubPanel.class}, (Object)geometrySubPanel2, n)) {
                case 0: {
                    BoxSubPanel boxSubPanel = (BoxSubPanel)geometrySubPanel2;
                    previousPanelType = "Box";
                    break;
                }
                case 1: {
                    SphereSubPanel sphereSubPanel = (SphereSubPanel)geometrySubPanel2;
                    previousPanelType = "Sphere";
                    break;
                }
                case 2: {
                    OctahedronSubPanel octahedronSubPanel = (OctahedronSubPanel)geometrySubPanel2;
                    previousPanelType = "Octahedron";
                    break;
                }
                case 3: {
                    CylinderSubPanel cylinderSubPanel = (CylinderSubPanel)geometrySubPanel2;
                    previousPanelType = "Cylinder";
                    break;
                }
                case 4: {
                    ConeSubPanel coneSubPanel = (ConeSubPanel)geometrySubPanel2;
                    previousPanelType = "Cone";
                    break;
                }
                case 5: {
                    EllipsoidSubPanel ellipsoidSubPanel = (EllipsoidSubPanel)geometrySubPanel2;
                    previousPanelType = "Ellipsoid";
                    break;
                }
            }
        }
        return previousPanelType;
    }

    private void initializeComponents() {
        if (this.config.getDisplayMode() == null) {
            PushdozerMod.LOGGER.error(class_2561.method_43471((String)"pushdozer.error.display_mode_null").getString());
            this.config.setDisplayMode(PushdozerConfig.DisplayMode.WIREFRAME);
        }
        if (this.config.getWorkMode() == null) {
            this.config.setWorkMode(PushdozerConfig.WorkMode.EXCAVATE);
        }
        this.panelLeft = (this.field_22789 - 280) / 2;
        this.panelTop = (this.field_22790 - this.computeMainPanelHeight()) / 2;
        int contentInset = 25;
        int contentLeft = this.panelLeft + contentInset;
        int contentTop = this.panelTop + 20 + 5;
        int rowHeight = 20;
        int verticalGap = 5;
        int finalButtonSpacing = 10;
        int buttonSpacing = 10;
        int availableWidth = 280 - contentInset * 2;
        int geomConfigButtonWidth = 60;
        int dropdownWidth = availableWidth - geomConfigButtonWidth - buttonSpacing;
        this.geometryButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)this.getGeometryButtonText(), button -> this.showGeometrySelectionPanel()).method_46434(contentLeft, contentTop, dropdownWidth, rowHeight).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.brush_shape_selection"))).method_46431());
        this.geometrySelectionPanel = new GeometrySelectionPanel(this, this.config, this::onGeometryTypeChanged);
        this.workModeSelectionPanel = new WorkModeSelectionPanel(this, this.config, this::onWorkModeChanged);
        this.geometryConfigButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.button.config"), button -> this.showGeometryConfigPanel()).method_46434(contentLeft + dropdownWidth + buttonSpacing, contentTop, geomConfigButtonWidth, rowHeight).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.geometry_config"))).method_46431());
        this.workModeButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)this.getWorkModeText(), button -> this.showWorkModeSelectionPanel()).method_46434(contentLeft, contentTop + rowHeight + verticalGap, dropdownWidth, rowHeight).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.work_mode"))).method_46431());
        this.workModeConfigButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.button.config"), button -> this.showWorkModeConfigPanel()).method_46434(contentLeft + dropdownWidth + buttonSpacing, contentTop + rowHeight + verticalGap, geomConfigButtonWidth, rowHeight).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.work_mode_config"))).method_46431());
        this.distanceSlider = new CustomDistanceSlider(contentLeft, contentTop + (rowHeight + verticalGap) * 3, availableWidth, rowHeight, (class_2561)class_2561.method_43469((String)"pushdozer.label.maximum_operation_distance", (Object[])new Object[]{this.config.getMaxOperationDistance()}), (float)this.config.getMaxOperationDistance() / 99.0f);
        this.distanceSlider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.distance_slider")));
        this.method_37063((class_364)this.distanceSlider);
        this.displayModeButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)this.getDisplayModeButtonText(), button -> this.toggleDisplayMode()).method_46434(contentLeft, contentTop + (rowHeight + verticalGap) * 2, availableWidth, rowHeight).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.display_mode"))).method_46431());
        int heightConfigButtonWidth = (availableWidth - finalButtonSpacing) / 2;
        int applyCloseButtonWidth = availableWidth - finalButtonSpacing - heightConfigButtonWidth;
        this.heightConfigButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.config.height_config"), button -> this.showHeightConfigPanel()).method_46434(contentLeft, contentTop + (rowHeight + verticalGap) * 4, heightConfigButtonWidth, rowHeight).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.height_config"))).method_46431());
        this.applyAndCloseButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.config.save_and_close"), button -> this.applyAndClose()).method_46434(contentLeft + heightConfigButtonWidth + finalButtonSpacing, contentTop + (rowHeight + verticalGap) * 4, applyCloseButtonWidth, rowHeight).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.save_close"))).method_46431());
    }

    private int computeMainPanelHeight() {
        int rowHeight = 20;
        int verticalGap = 5;
        int numRows = 5;
        int numGaps = numRows - 1;
        int topMarginBelowTitle = 5;
        int bottomMargin = 5;
        return 20 + topMarginBelowTitle + rowHeight * numRows + verticalGap * numGaps + bottomMargin;
    }

    private void showGeometrySelectionPanel() {
        if (this.geometrySelectionPanel != null) {
            this.geometrySelectionPanel.show();
        }
    }

    private void showWorkModeSelectionPanel() {
        if (this.workModeSelectionPanel != null) {
            this.workModeSelectionPanel.show();
        }
    }

    private void showWorkModeConfigPanel() {
        if (this.workModeSelectionPanel != null) {
            this.workModeSelectionPanel.hide();
        }
        PushdozerConfig.WorkMode currentMode = this.config.getWorkMode();
        switch (currentMode) {
            case EXCAVATE: {
                this.currentWorkModeConfigPanel = new ExcavateConfigPanel(this, this.config);
                break;
            }
            case PLACE: {
                this.currentWorkModeConfigPanel = new PlaceConfigPanel(this, this.config);
                break;
            }
            case SMOOTH: {
                this.currentWorkModeConfigPanel = new SmoothConfigPanel(this, this.config);
                break;
            }
            case SMOOTH_RAISE: 
            case ADAPTIVE_SMOOTH: 
            case SMOOTH_LOWER: {
                this.currentWorkModeConfigPanel = new SmoothConfigPanel(this, this.config);
                break;
            }
            case SURFACE_ROUGHEN: {
                this.currentWorkModeConfigPanel = new SurfaceRoughenConfigPanel(this, this.config);
                break;
            }
            case SURFACE_CONVERT: {
                this.currentWorkModeConfigPanel = new SurfaceConvertConfigPanel(this, this.config);
                break;
            }
            case BONE_MEAL: {
                this.currentWorkModeConfigPanel = new BoneMealConfigPanel(this, this.config);
                break;
            }
            case BATCH_PLANT: {
                this.currentWorkModeConfigPanel = new BatchPlantConfigPanel(this, this.config);
                break;
            }
            case SHORELINE_PROCESS: {
                this.currentWorkModeConfigPanel = new ShorelineProcessConfigPanel(this, this.config);
                break;
            }
            default: {
                this.showErrorMessage(class_2561.method_43469((String)"pushdozer.error.unknown_work_mode", (Object[])new Object[]{currentMode.getDisplayText().getString()}).getString());
                return;
            }
        }
        this.currentWorkModeConfigPanel.show();
        this.hideMainPanel();
    }

    private void onGeometryTypeChanged(PushdozerConfig.GeometryType geometryType) {
        this.config.setGeometryType(geometryType);
        PushdozerMod.saveConfig();
        if (this.geometryButton != null) {
            this.geometryButton.method_25355(this.getGeometryButtonText());
        }
        this.showErrorMessage(class_2561.method_43469((String)"pushdozer.message.shape_switch", (Object[])new Object[]{geometryType.getDisplayText().getString()}).getString());
        this.updatePreview();
    }

    private void onWorkModeChanged(PushdozerConfig.WorkMode workMode) {
        this.config.setWorkMode(workMode);
        PushdozerMod.saveConfig();
        if (this.workModeButton != null) {
            this.workModeButton.method_25355(this.getWorkModeText());
        }
        this.showErrorMessage(class_2561.method_43469((String)"pushdozer.message.working_mode_switch", (Object[])new Object[]{workMode.getDisplayText().getString()}).getString());
        this.updatePreview();
    }

    private void showGeometryConfigPanel() {
        PushdozerConfig.GeometryType currentType = this.config.getGeometryType();
        switch (currentType) {
            case BOX: {
                this.showBoxConfigPanel();
                break;
            }
            case SPHERE: {
                this.showSphereConfigPanel();
                break;
            }
            case OCTAHEDRON: {
                this.showOctahedronConfigPanel();
                break;
            }
            case CYLINDER: {
                this.showCylinderConfigPanel();
                break;
            }
            case CONE: {
                this.showConeConfigPanel();
                break;
            }
            case ELLIPSOID: {
                this.showEllipsoidConfigPanel();
                break;
            }
            case TETRAHEDRON: {
                this.showTetrahedronConfigPanel();
                break;
            }
            case TRIANGULAR_PRISM: {
                this.showTriangularPrismConfigPanel();
                break;
            }
            default: {
                this.showBoxConfigPanel();
            }
        }
    }

    private void showBoxConfigPanel() {
        this.currentSubPanel = new BoxSubPanel(this, this.config);
        this.showSubPanel();
    }

    private void showSphereConfigPanel() {
        this.currentSubPanel = new SphereSubPanel(this, this.config);
        this.showSubPanel();
    }

    private void showOctahedronConfigPanel() {
        this.currentSubPanel = new OctahedronSubPanel(this, this.config);
        this.showSubPanel();
    }

    private void showCylinderConfigPanel() {
        this.currentSubPanel = new CylinderSubPanel(this, this.config);
        this.showSubPanel();
    }

    private void showConeConfigPanel() {
        this.currentSubPanel = new ConeSubPanel(this, this.config);
        this.showSubPanel();
    }

    private void showEllipsoidConfigPanel() {
        this.currentSubPanel = new EllipsoidSubPanel(this, this.config);
        this.showSubPanel();
    }

    private void showTetrahedronConfigPanel() {
        this.currentSubPanel = new TetrahedronSubPanel(this, this.config);
        this.showSubPanel();
    }

    private void showTriangularPrismConfigPanel() {
        this.currentSubPanel = new TriangularPrismSubPanel(this, this.config);
        this.showSubPanel();
    }

    private void showSubPanel() {
        if (this.currentSubPanel != null) {
            this.currentSubPanel.init();
            this.currentSubPanel.show();
            this.hideMainPanel();
        }
    }

    private void hideMainPanel() {
        this.mainPanelVisible = false;
        if (this.geometryButton != null) {
            this.geometryButton.field_22764 = false;
        }
        if (this.geometryConfigButton != null) {
            this.geometryConfigButton.field_22764 = false;
        }
        if (this.workModeButton != null) {
            this.workModeButton.field_22764 = false;
        }
        if (this.workModeConfigButton != null) {
            this.workModeConfigButton.field_22764 = false;
        }
        if (this.displayModeButton != null) {
            this.displayModeButton.field_22764 = false;
        }
        if (this.distanceSlider != null) {
            this.distanceSlider.field_22764 = false;
        }
        if (this.applyAndCloseButton != null) {
            this.applyAndCloseButton.field_22764 = false;
        }
        if (this.heightConfigButton != null) {
            this.heightConfigButton.field_22764 = false;
        }
        if (this.geometrySelectionPanel != null) {
            this.geometrySelectionPanel.hide();
        }
        if (this.workModeSelectionPanel != null) {
            this.workModeSelectionPanel.hide();
        }
    }

    public void method_25393() {
        super.method_25393();
        if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)75) && System.currentTimeMillis() - this.openTime > 150L) {
            this.method_25419();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        int currentDistance;
        int newDistance;
        if (keyCode == 256) {
            if (this.heightConfigPanel != null && this.heightConfigPanel.isVisible()) {
                this.heightConfigPanel.hide();
                this.showMainPanel();
                return true;
            }
            if (this.geometrySelectionPanel != null && this.geometrySelectionPanel.isVisible()) {
                this.geometrySelectionPanel.hide();
                return true;
            }
            if (this.workModeSelectionPanel != null && this.workModeSelectionPanel.isVisible()) {
                this.workModeSelectionPanel.hide();
                return true;
            }
            if (this.currentWorkModeConfigPanel != null && this.currentWorkModeConfigPanel.isVisible()) {
                this.currentWorkModeConfigPanel.saveConfig();
                this.currentWorkModeConfigPanel.hide();
                this.showMainPanel();
                return true;
            }
            if (this.currentSubPanel != null && this.currentSubPanel.isVisible()) {
                this.currentSubPanel.saveConfig();
                this.hideSubPanel();
                this.showMainPanel();
                return true;
            }
        }
        if ((keyCode == 265 || keyCode == 264) && this.field_22787 != null && this.field_22787.field_1724 != null && (newDistance = keyCode == 265 ? Math.min(currentDistance + 1, 99) : Math.max(currentDistance - 1, 1)) != (currentDistance = this.config.getMaxOperationDistance())) {
            if (this.distanceSlider != null) {
                this.distanceSlider.setCustomValue((float)newDistance / 99.0f);
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        PushdozerMod.saveConfig();
        super.method_25419();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        boolean heightConfigPanelVisible;
        boolean geometryPanelVisible = this.geometrySelectionPanel != null && this.geometrySelectionPanel.isVisible();
        boolean workModePanelVisible = this.workModeSelectionPanel != null && this.workModeSelectionPanel.isVisible();
        boolean workModeConfigPanelVisible = this.currentWorkModeConfigPanel != null && this.currentWorkModeConfigPanel.isVisible();
        boolean configSubPanelVisible = this.currentSubPanel != null && this.currentSubPanel.isVisible();
        boolean bl = heightConfigPanelVisible = this.heightConfigPanel != null && this.heightConfigPanel.isVisible();
        if (!(geometryPanelVisible || workModePanelVisible || workModeConfigPanelVisible || configSubPanelVisible || heightConfigPanelVisible)) {
            int panelHeight = this.applyAndCloseButton.method_46427() + this.applyAndCloseButton.method_25364() + 5 - this.panelTop;
            context.method_25294(this.panelLeft + 20, this.panelTop, this.panelLeft + 280 - 20, this.panelTop + panelHeight, Integer.MIN_VALUE);
            context.method_25294(this.panelLeft + 20, this.panelTop, this.panelLeft + 280 - 20, this.panelTop + 20, -533712848);
            context.method_49601(this.panelLeft + 20, this.panelTop, 240, panelHeight, -1);
            if (this.field_22793 != null) {
                class_5250 title = class_2561.method_43471((String)"pushdozer.config.title").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054});
                int titleWidth = this.field_22793.method_27525((class_5348)title);
                int n = this.panelLeft + (280 - titleWidth) / 2;
                Objects.requireNonNull(this.field_22793);
                context.method_51439(this.field_22793, (class_2561)title, n, this.panelTop + (20 - 9) / 2, 0xFFFFFF, false);
            }
            for (class_364 child : this.method_25396()) {
                if (!(child instanceof class_4068)) continue;
                ((class_4068)child).method_25394(context, mouseX, mouseY, delta);
            }
            if (this.isWorkModeDropdownOpen) {
                this.renderWorkModeOptions(context, mouseX, mouseY, delta);
            }
        }
        if (this.currentSubPanel != null && this.currentSubPanel.isVisible()) {
            this.currentSubPanel.render(context, mouseX, mouseY, delta);
        }
        if (geometryPanelVisible) {
            this.geometrySelectionPanel.render(context, mouseX, mouseY, delta);
        }
        if (workModePanelVisible) {
            this.workModeSelectionPanel.render(context, mouseX, mouseY, delta);
        }
        if (workModeConfigPanelVisible) {
            this.currentWorkModeConfigPanel.render(context, mouseX, mouseY, delta);
        }
        if (heightConfigPanelVisible) {
            this.heightConfigPanel.render(context, mouseX, mouseY, delta);
        }
    }

    private String getDisplayModeText() {
        if (this.config.getDisplayMode() == null) {
            this.config.setDisplayMode(PushdozerConfig.DisplayMode.WIREFRAME);
        }
        return this.config.getDisplayMode().getDisplayText().getString();
    }

    private void toggleDisplayMode() {
        if (this.config.getDisplayMode() == null) {
            this.config.setDisplayMode(PushdozerConfig.DisplayMode.WIREFRAME);
        }
        PushdozerConfig.DisplayMode[] modes = PushdozerConfig.DisplayMode.values();
        int nextIndex = (this.config.getDisplayMode().ordinal() + 1) % modes.length;
        PushdozerConfig.DisplayMode newMode = modes[nextIndex];
        this.config.setDisplayMode(newMode);
        this.displayModeButton.method_25355(this.getDisplayModeButtonText());
        PushdozerMod.saveConfig();
        this.showErrorMessage(class_2561.method_43469((String)"pushdozer.message.display_mode_switch", (Object[])new Object[]{this.getDisplayModeText()}).getString());
    }

    private void toggleWorkModeDropdown() {
        this.isWorkModeDropdownOpen = false;
        this.workModeOptions.forEach(x$0 -> this.method_37066((class_364)x$0));
        this.workModeOptions.clear();
    }

    private void renderWorkModeOptions(class_332 context, int mouseX, int mouseY, float delta) {
        int dropdownHeight = this.workModeOptions.size() * 20;
        context.method_25294(this.workModeButton.method_46426(), this.workModeButton.method_46427() + 20, this.workModeButton.method_46426() + this.workModeButton.method_25368(), this.workModeButton.method_46427() + 20 + dropdownHeight, -533712848);
        for (class_4185 option : this.workModeOptions) {
            option.method_25394(context, mouseX, mouseY, delta);
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public void showErrorMessage(String message) {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)message), false);
        }
    }

    public int getScreenWidth() {
        return this.field_22789;
    }

    public int getScreenHeight() {
        return this.field_22790;
    }

    private void applyAndClose() {
        this.config.save();
        this.method_25419();
    }

    private class_2561 getGeometryButtonText() {
        return class_2561.method_43469((String)"pushdozer.button.geometry_format", (Object[])new Object[]{this.config.getGeometryType().getDisplayText()});
    }

    private class_2561 getWorkModeText() {
        return class_2561.method_43469((String)"pushdozer.button.work_mode_format", (Object[])new Object[]{this.config.getWorkMode().getDisplayText()});
    }

    private class_2561 getDisplayModeButtonText() {
        if (this.config.getDisplayMode() == null) {
            this.config.setDisplayMode(PushdozerConfig.DisplayMode.WIREFRAME);
        }
        return class_2561.method_43469((String)"pushdozer.button.display_mode_format", (Object[])new Object[]{this.config.getDisplayMode().getDisplayText()});
    }

    public void showMainPanel() {
        this.mainPanelVisible = true;
        if (this.geometryButton != null) {
            this.geometryButton.field_22764 = true;
        }
        if (this.geometryConfigButton != null) {
            this.geometryConfigButton.field_22764 = true;
        }
        if (this.workModeButton != null) {
            this.workModeButton.field_22764 = true;
        }
        if (this.workModeConfigButton != null) {
            this.workModeConfigButton.field_22764 = true;
        }
        if (this.displayModeButton != null) {
            this.displayModeButton.field_22764 = true;
        }
        if (this.distanceSlider != null) {
            this.distanceSlider.field_22764 = true;
        }
        if (this.applyAndCloseButton != null) {
            this.applyAndCloseButton.field_22764 = true;
        }
        if (this.heightConfigButton != null) {
            this.heightConfigButton.field_22764 = true;
        }
        this.hideSubPanel();
        if (this.geometrySelectionPanel != null) {
            this.geometrySelectionPanel.hide();
        }
        if (this.workModeSelectionPanel != null) {
            this.workModeSelectionPanel.hide();
        }
        if (this.currentWorkModeConfigPanel != null) {
            this.currentWorkModeConfigPanel.hide();
        }
        if (this.heightConfigPanel != null) {
            this.heightConfigPanel.hide();
        }
    }

    private void showHeightConfigPanel() {
        if (this.heightConfigPanel == null) {
            this.heightConfigPanel = new HeightConfigPanel(this, this.config);
        }
        this.heightConfigPanel.show();
        this.hideMainPanel();
    }

    public void updatePreview() {
    }

    public class_310 getClient() {
        return this.field_22787;
    }

    public void hideSubPanel() {
        if (this.currentSubPanel != null) {
            this.currentSubPanel.hide();
            this.currentSubPanel = null;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.heightConfigPanel != null && this.heightConfigPanel.isVisible() && this.heightConfigPanel.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.geometrySelectionPanel != null && this.geometrySelectionPanel.isVisible() && this.geometrySelectionPanel.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.currentWorkModeConfigPanel != null && this.currentWorkModeConfigPanel.isVisible() && this.currentWorkModeConfigPanel.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.workModeSelectionPanel != null && this.workModeSelectionPanel.isVisible() && this.workModeSelectionPanel.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isWorkModeDropdownOpen) {
            for (class_4185 option : this.workModeOptions) {
                if (!option.method_25405(mouseX, mouseY)) continue;
                option.method_25306();
                return true;
            }
            this.toggleWorkModeDropdown();
        }
        if (this.currentSubPanel != null && this.currentSubPanel.isVisible()) {
            for (class_364 widget : this.currentSubPanel.getWidgets()) {
                class_339 clickable;
                if (!(widget instanceof class_339) || !(clickable = (class_339)widget).method_25405(mouseX, mouseY)) continue;
                return clickable.method_25402(mouseX, mouseY, button);
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.heightConfigPanel != null && this.heightConfigPanel.isVisible() && this.heightConfigPanel.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.geometrySelectionPanel != null && this.geometrySelectionPanel.isVisible() && this.geometrySelectionPanel.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.currentWorkModeConfigPanel != null && this.currentWorkModeConfigPanel.isVisible() && this.currentWorkModeConfigPanel.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.workModeSelectionPanel != null && this.workModeSelectionPanel.isVisible() && this.workModeSelectionPanel.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.currentSubPanel != null && this.currentSubPanel.isVisible()) {
            for (class_364 widget : this.currentSubPanel.getWidgets()) {
                class_339 clickable;
                if (!(widget instanceof class_339) || !(clickable = (class_339)widget).method_25405(mouseX, mouseY)) continue;
                return clickable.method_25403(mouseX, mouseY, button, deltaX, deltaY);
            }
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.heightConfigPanel != null && this.heightConfigPanel.isVisible() && this.heightConfigPanel.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.geometrySelectionPanel != null && this.geometrySelectionPanel.isVisible() && this.geometrySelectionPanel.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.currentWorkModeConfigPanel != null && this.currentWorkModeConfigPanel.isVisible() && this.currentWorkModeConfigPanel.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.workModeSelectionPanel != null && this.workModeSelectionPanel.isVisible() && this.workModeSelectionPanel.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.currentSubPanel != null && this.currentSubPanel.isVisible()) {
            for (class_364 widget : this.currentSubPanel.getWidgets()) {
                class_339 clickable;
                if (!(widget instanceof class_339) || !(clickable = (class_339)widget).method_25405(mouseX, mouseY)) continue;
                return clickable.method_25406(mouseX, mouseY, button);
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private class CustomDistanceSlider
    extends class_357 {
        public CustomDistanceSlider(int x, int y, int width, int height, class_2561 text, double value) {
            super(x, y, width, height, text, value);
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43469((String)"pushdozer.label.maximum_operation_distance", (Object[])new Object[]{(int)(this.field_22753 * 99.0)}));
        }

        protected void method_25344() {
            int newDistance = (int)(this.field_22753 * 99.0);
            PushdozerConfigScreen.this.config.setMaxOperationDistance(newDistance);
        }

        public void setCustomValue(double value) {
            if (this.field_22753 != value) {
                this.field_22753 = value;
                this.method_25346();
                this.method_25344();
            }
        }
    }
}

