/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.util;

import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TerrainBlockSelector {
    private static final Logger LOGGER = LogManager.getLogger(TerrainBlockSelector.class);

    private TerrainBlockSelector() {
    }

    public static class_2248 getNaturalTerrainBlock(class_2338 pos, class_1937 world) {
        class_2338 groundPos = TerrainBlockSelector.findSolidGround(pos, world);
        if (groundPos == null) {
            LOGGER.debug("\u5728\u4f4d\u7f6e {} \u627e\u4e0d\u5230\u575a\u5b9e\u5730\u9762\uff0c\u4f7f\u7528\u9ed8\u8ba4\u65b9\u5757 STONE", (Object)pos);
            return class_2246.field_10340;
        }
        class_2680 groundState = world.method_8320(groundPos);
        class_2248 groundBlock = groundState.method_26204();
        if (groundState.method_26164(class_3481.field_29822)) {
            return world.method_8320(pos.method_10084()).method_26215() ? class_2246.field_10219 : class_2246.field_10566;
        }
        if (groundState.method_26164(class_3481.field_15466) || groundState.method_26164(class_3481.field_25806)) {
            return groundBlock;
        }
        if (groundState.method_26164(class_3481.field_21953) || groundBlock == class_2246.field_10515) {
            return class_2246.field_10515;
        }
        return TerrainBlockSelector.getBiomeTopBlock(pos, world);
    }

    private static class_2338 findSolidGround(class_2338 startPos, class_1937 world) {
        class_2338.class_2339 mutablePos = new class_2338.class_2339(startPos.method_10263(), startPos.method_10264(), startPos.method_10260());
        while (mutablePos.method_10264() > world.method_31607()) {
            mutablePos.method_10100(0, -1, 0);
            class_2680 state = world.method_8320((class_2338)mutablePos);
            if (state.method_26215() || !state.method_26227().method_15769()) continue;
            return mutablePos.method_10062();
        }
        return null;
    }

    private static class_2248 getBiomeTopBlock(class_2338 pos, class_1937 world) {
        try {
            class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
            class_2960 biomeId = world.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
            if (biomeId != null) {
                String biomeName = biomeId.toString();
                return TerrainBlockSelector.getBlockForBiome(biomeName);
            }
            return class_2246.field_10219;
        }
        catch (Exception e) {
            LOGGER.warn("\u65e0\u6cd5\u83b7\u53d6\u4f4d\u7f6e {} \u7684\u751f\u7269\u7fa4\u7cfb\u4fe1\u606f\uff0c\u4f7f\u7528\u9ed8\u8ba4\u65b9\u5757 GRASS_BLOCK", (Object)pos, (Object)e);
            return class_2246.field_10219;
        }
    }

    private static class_2248 getBlockForBiome(String biomeName) {
        return switch (biomeName) {
            case "minecraft:ocean", "minecraft:deep_ocean", "minecraft:frozen_ocean", "minecraft:deep_frozen_ocean" -> TerrainBlockSelector.getOceanFloorBlock(biomeName);
            case "minecraft:plains", "minecraft:sunflower_plains", "minecraft:savanna", "minecraft:savanna_plateau" -> class_2246.field_10219;
            case "minecraft:desert", "minecraft:desert_hills", "minecraft:beach" -> class_2246.field_10102;
            case "minecraft:mountains", "minecraft:mountain_edge", "minecraft:wooded_mountains", "minecraft:stone_shore" -> class_2246.field_10340;
            case "minecraft:forest", "minecraft:wooded_hills", "minecraft:birch_forest", "minecraft:birch_forest_hills" -> class_2246.field_10566;
            case "minecraft:taiga", "minecraft:taiga_hills", "minecraft:snowy_taiga", "minecraft:snowy_taiga_hills" -> class_2246.field_10520;
            case "minecraft:swamp", "minecraft:swamp_hills" -> class_2246.field_37576;
            case "minecraft:badlands", "minecraft:wooded_badlands_plateau", "minecraft:badlands_plateau" -> class_2246.field_10534;
            case "minecraft:snowy_tundra", "minecraft:snowy_mountains" -> class_2246.field_10491;
            case "minecraft:mushroom_fields", "minecraft:mushroom_field_shore" -> class_2246.field_10402;
            case "minecraft:nether_wastes" -> class_2246.field_10515;
            case "minecraft:the_end" -> class_2246.field_10471;
            default -> biomeName.contains("ocean") || biomeName.contains("sea") ? TerrainBlockSelector.getOceanFloorBlock(biomeName) : (biomeName.contains("snowy") || biomeName.contains("ice") ? class_2246.field_10491 : (biomeName.contains("desert") || biomeName.contains("badlands") ? class_2246.field_10102 : (biomeName.contains("mountains") || biomeName.contains("hills") ? class_2246.field_10340 : (biomeName.contains("forest") || biomeName.contains("taiga") ? class_2246.field_10566 : (biomeName.contains("swamp") ? class_2246.field_37576 : (biomeName.contains("nether") ? class_2246.field_10515 : (biomeName.contains("end") ? class_2246.field_10471 : class_2246.field_10219)))))));
        };
    }

    private static class_2248 getOceanFloorBlock(String biomeName) {
        return switch (biomeName) {
            case "minecraft:ocean" -> class_2246.field_10340;
            case "minecraft:deep_ocean" -> class_2246.field_10340;
            case "minecraft:frozen_ocean" -> class_2246.field_10340;
            case "minecraft:deep_frozen_ocean" -> class_2246.field_10340;
            case "minecraft:warm_ocean" -> class_2246.field_10102;
            case "minecraft:lukewarm_ocean" -> class_2246.field_10102;
            case "minecraft:cold_ocean" -> class_2246.field_10255;
            case "minecraft:deep_cold_ocean" -> class_2246.field_10255;
            case "minecraft:deep_lukewarm_ocean" -> class_2246.field_10102;
            case "minecraft:deep_warm_ocean" -> class_2246.field_10102;
            default -> biomeName.contains("warm") || biomeName.contains("lukewarm") ? class_2246.field_10102 : (biomeName.contains("cold") ? class_2246.field_10255 : (biomeName.contains("frozen") ? class_2246.field_10340 : class_2246.field_10340));
        };
    }
}

