/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.items.handlers;

import com.pushdozer.PushdozerMod;
import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.operations.UndoAction;
import com.pushdozer.shapes.GeometryShape;
import com.pushdozer.tags.PushdozerBiomeTags;
import com.pushdozer.util.ShapeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2299;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2362;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3541;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7924;

public class BatchPlantHandler {
    private static final double MIN_TREE_PROB = 0.02;
    private static final double MIN_PLANT_PROB = 0.06;
    private static final int CORE_SCAN_RADIUS = 4;
    private final PushdozerConfig config;
    private final class_5819 random;
    private final class_3541 noiseSampler;
    private static final int TREE_HEIGHT_LIMIT = 32;
    private static final double NOISE_SCALE = 0.05;

    public BatchPlantHandler(PushdozerConfig config) {
        this.config = config;
        this.random = class_5819.method_43047();
        this.noiseSampler = new class_3541(class_5819.method_43049((long)1234L));
    }

    public void handleBatchPlant(class_1657 player, class_1937 world) {
        if (world.field_9236 || !(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_2338 basePos = ShapeUtil.getTargetBlockPos(player, this.config);
        GeometryShape shape = ShapeUtil.createShape(player, this.config, basePos);
        if (shape == null) {
            return;
        }
        PushdozerMod.LOGGER.info("Batch planting started at position: {}, plant type: {}", (Object)basePos, (Object)this.config.getPlantType());
        List<PlantingPosition> plantingPositions = this.collectPlantingPositions(world, shape);
        if (plantingPositions.isEmpty()) {
            PushdozerMod.LOGGER.info("No planting positions found");
            return;
        }
        PushdozerMod.LOGGER.info("Found {} planting positions", (Object)plantingPositions.size());
        BatchPlantingResult result = this.executeBatchPlanting(serverWorld, plantingPositions);
        if (!result.isEmpty()) {
            UndoAction undoAction = new UndoAction(UndoAction.ActionType.BATCH_PLANT, result.getAllPositions(), result.getAllOriginalStates(), result.getAllNewStates());
            PushdozerMod.pushUndoAction(player, undoAction);
        }
        if (result.getTotalCount() > 0) {
            PushdozerMod.LOGGER.info("Batch planting completed: {} plants, {} trees, {} total blocks changed", new Object[]{result.getSimplePlantCount(), result.getTreeCount(), result.getTotalCount()});
        }
    }

    private List<PlantingPosition> collectPlantingPositions(class_1937 world, GeometryShape shape) {
        ArrayList<PlantingPosition> positions = new ArrayList<PlantingPosition>();
        PushdozerConfig.PlantType plantType = this.config.getPlantType();
        HashMap<class_2338, class_2680> blockStates = new HashMap<class_2338, class_2680>();
        HashMap<class_2338, class_2680> groundStates = new HashMap<class_2338, class_2680>();
        for (class_2338 pos : shape.getBlockPositions()) {
            blockStates.put(pos, world.method_8320(pos));
            groundStates.put(pos.method_10074(), world.method_8320(pos.method_10074()));
        }
        HashSet<Long> seenColumns = new HashSet<Long>();
        if (plantType == PushdozerConfig.PlantType.CUSTOM) {
            boolean preferWaterForCustom = this.containsLiveCoral(this.config.getCustomPlantBlocks());
            block1: for (class_2338 pos : shape.getBlockPositions()) {
                long key = class_2338.method_10064((int)pos.method_10263(), (int)0, (int)pos.method_10260());
                if (seenColumns.contains(key)) continue;
                seenColumns.add(key);
                int x = pos.method_10263();
                int z = pos.method_10260();
                int surfaceY = world.method_8624(class_2902.class_2903.field_13202, x, z);
                int oceanFloorY = world.method_8624(class_2902.class_2903.field_13200, x, z);
                class_2338 topPos = new class_2338(x, surfaceY, z);
                class_2680 topState = world.method_8320(topPos);
                class_2338 landCandidate = topState.method_45474() ? topPos : topPos.method_10084();
                class_2338 seabedWaterPos = new class_2338(x, oceanFloorY, z);
                List<class_2338> candidates = preferWaterForCustom ? Arrays.asList(seabedWaterPos, landCandidate) : Arrays.asList(landCandidate, seabedWaterPos);
                for (class_2338 candidate : candidates) {
                    class_2680 cs = world.method_8320(candidate);
                    boolean land = candidate.equals((Object)landCandidate);
                    if (preferWaterForCustom && !land) {
                        boolean validBase;
                        class_2338 upperPos;
                        class_2680 upperState;
                        boolean upperInWater;
                        boolean inWater = cs.method_26227().method_15767(class_3486.field_15517);
                        if (!inWater || !(upperInWater = (upperState = world.method_8320(upperPos = candidate.method_10084())).method_26227().method_15767(class_3486.field_15517))) continue;
                        class_2338 lowerPos = candidate.method_10074();
                        class_2680 lowerState = world.method_8320(lowerPos);
                        boolean bl = validBase = lowerState.method_26164(class_3481.field_15466) || lowerState.method_26164(class_3481.field_15461) || lowerState.method_26164(class_3481.field_25806) || lowerState.method_26164(class_3481.field_25807) || lowerState.method_27852(class_2246.field_10471) || lowerState.method_27852(class_2246.field_10255) || lowerState.method_27852(class_2246.field_10460);
                        if (!validBase) {
                            continue;
                        }
                    } else {
                        boolean bl = land ? cs.method_26215() || cs.method_45474() : cs.method_26227().method_15767(class_3486.field_15517);
                        boolean pass = bl;
                        if (!pass) continue;
                    }
                    if (!this.shouldPlantHere(candidate)) continue;
                    positions.add(new PlantingPosition(candidate, plantType));
                    continue block1;
                }
            }
        } else {
            HashSet<Long> blockedColumns = new HashSet<Long>();
            int spacingRadius = 0;
            if (plantType == PushdozerConfig.PlantType.FLOWERS || plantType == PushdozerConfig.PlantType.GRASS) {
                float d = Math.max(0.0f, Math.min(1.0f, this.config.getPlantDensity()));
                spacingRadius = Math.max(1, Math.round(1.0f + (1.0f - d) * 2.0f));
            }
            for (class_2338 pos : shape.getBlockPositions()) {
                long colKey = class_2338.method_10064((int)pos.method_10263(), (int)0, (int)pos.method_10260());
                if (seenColumns.contains(colKey) || blockedColumns.contains(colKey)) continue;
                seenColumns.add(colKey);
                int x = pos.method_10263();
                int z = pos.method_10260();
                int surfaceY = world.method_8624(class_2902.class_2903.field_13202, x, z);
                class_2338 topPos = new class_2338(x, surfaceY, z);
                class_2680 topState = world.method_8320(topPos);
                if (plantType == PushdozerConfig.PlantType.TREES) {
                    class_2338 placePos = new class_2338(x, surfaceY + 1, z);
                    class_2338 treeCenter = new class_2338(x, surfaceY, z);
                    class_2680 currentState = world.method_8320(placePos);
                    boolean passPrecheck = this.canPlantAtOptimized(currentState, world.method_8320(treeCenter));
                    if (!passPrecheck || !this.shouldPlantHere(placePos)) continue;
                    positions.add(new PlantingPosition(treeCenter, plantType));
                } else {
                    class_2338 candidate = topState.method_45474() ? topPos : topPos.method_10084();
                    class_2680 currentState = world.method_8320(candidate);
                    boolean passPrecheck = this.canPlantAtOptimized(currentState, world.method_8320(candidate.method_10074()));
                    if (!passPrecheck || !this.shouldPlantHere(candidate)) continue;
                    positions.add(new PlantingPosition(candidate, plantType));
                }
                if (spacingRadius <= 0) continue;
                for (int dx = -spacingRadius; dx <= spacingRadius; ++dx) {
                    for (int dz = -spacingRadius; dz <= spacingRadius; ++dz) {
                        long k = class_2338.method_10064((int)(x + dx), (int)0, (int)(z + dz));
                        blockedColumns.add(k);
                    }
                }
            }
        }
        return positions;
    }

    private boolean containsLiveCoral(List<class_2248> blocks) {
        if (blocks == null) {
            return false;
        }
        for (class_2248 b : blocks) {
            if (b == null || !this.isLiveCoral(b)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlantAtOptimized(class_2680 currentState, class_2680 groundState) {
        return currentState.method_26215() || currentState.method_45474();
    }

    private BatchPlantingResult executeBatchPlanting(class_3218 world, List<PlantingPosition> positions) {
        BatchPlantingResult result = new BatchPlantingResult();
        ArrayList<PlantingPosition> treePositions = new ArrayList<PlantingPosition>();
        ArrayList<PlantingPosition> simplePlantPositions = new ArrayList<PlantingPosition>();
        for (PlantingPosition pos : positions) {
            if (pos.plantType == PushdozerConfig.PlantType.TREES) {
                treePositions.add(pos);
                continue;
            }
            simplePlantPositions.add(pos);
        }
        this.processSimplePlants(world, simplePlantPositions, result);
        this.processTrees(world, treePositions, result);
        return result;
    }

    private void processSimplePlants(class_3218 world, List<PlantingPosition> positions, BatchPlantingResult result) {
        PushdozerMod.LOGGER.info("Processing {} simple plants", (Object)positions.size());
        for (PlantingPosition pos : positions) {
            boolean waterHere;
            class_2338 basePos = pos.position;
            class_2680 originalStateLower = world.method_8320(basePos);
            class_2680 newState = this.generateSimplePlant((class_1937)world, basePos, pos.plantType);
            if (newState == null) {
                PushdozerMod.LOGGER.debug("No plant generated for position: {}", (Object)basePos);
                continue;
            }
            PushdozerMod.LOGGER.debug("Generated plant: {} at position: {}", (Object)newState.method_26204(), (Object)basePos);
            if (this.hasExistingPlantOrDecoration(originalStateLower.method_26204())) {
                PushdozerMod.LOGGER.debug("Skipping plant placement at {}: existing plant/decoration detected", (Object)basePos);
                continue;
            }
            boolean bl = waterHere = originalStateLower.method_26227().method_15767(class_3486.field_15517) || world.method_8316(basePos).method_15767(class_3486.field_15517);
            if (waterHere) {
                boolean isDripleaf;
                class_2248 block = newState.method_26204();
                boolean allowedUnderwater = this.isLiveCoral(block) || this.isAquatic(block);
                boolean isLilyPad = block == class_2246.field_10588;
                boolean bl2 = isDripleaf = block == class_2246.field_28684 || block == class_2246.field_28682;
                if (!allowedUnderwater && !isLilyPad && !isDripleaf) continue;
            }
            if (pos.plantType == PushdozerConfig.PlantType.CUSTOM && (this.isLiveCoral(newState.method_26204()) || this.isDeadCoral(newState.method_26204())) && this.handleCoralPlacement(world, basePos, newState, originalStateLower, result)) continue;
            if (pos.plantType != PushdozerConfig.PlantType.CUSTOM || newState.method_26204() == class_2246.field_28684 || newState.method_26204() == class_2246.field_28682) {
                // empty if block
            }
            if (pos.plantType == PushdozerConfig.PlantType.CUSTOM && this.isPotted(newState.method_26204())) {
                if (originalStateLower.method_26227().method_15767(class_3486.field_15517) || !newState.method_26184((class_4538)world, basePos)) continue;
                world.method_8501(basePos, newState);
                result.addSimplePlant(basePos, originalStateLower, newState);
                continue;
            }
            if (newState.method_26204() instanceof class_2320) {
                class_2680 upper;
                class_2338 upperPos = basePos.method_10084();
                class_2680 originalStateUpper = world.method_8320(upperPos);
                if (!newState.method_28498((class_2769)class_2741.field_12533)) continue;
                if (newState.method_26204() == class_2246.field_10238) {
                    boolean lowerWater = world.method_8316(basePos).method_15767(class_3486.field_15517);
                    boolean upperWater = world.method_8316(upperPos).method_15767(class_3486.field_15517);
                    if (!lowerWater || !upperWater) continue;
                    class_2680 lower = (class_2680)newState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12607);
                    class_2680 upper2 = (class_2680)newState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609);
                    world.method_8501(basePos, lower);
                    world.method_8501(upperPos, upper2);
                    result.addSimplePlant(basePos, originalStateLower, lower);
                    result.addSimplePlant(upperPos, originalStateUpper, upper2);
                    continue;
                }
                if (newState.method_26204() == class_2246.field_28684) {
                    class_2680 lower;
                    class_2680 upperCurrent = world.method_8320(upperPos);
                    if (!upperCurrent.method_26215() && !upperCurrent.method_45474() || !(lower = (class_2680)newState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12607)).method_26184((class_4538)world, basePos)) continue;
                    boolean inWater = world.method_8316(basePos).method_15767(class_3486.field_15517);
                    boolean upperInWater = world.method_8316(upperPos).method_15767(class_3486.field_15517);
                    if (inWater) {
                        lower = (class_2680)lower.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
                    }
                    upper = upperInWater ? (class_2680)((class_2680)newState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)) : (class_2680)newState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609);
                    world.method_8501(upperPos, upper);
                    result.addSimplePlant(upperPos, originalStateUpper, upper);
                    world.method_8501(basePos, lower);
                    result.addSimplePlant(basePos, originalStateLower, lower);
                    PushdozerMod.LOGGER.debug("Placed Small Dripleaf at {}, height: 2, inWater: {}", (Object)basePos, (Object)inWater);
                    continue;
                }
                if (newState.method_26204() == class_2246.field_28682) {
                    class_2680 lower;
                    class_2680 upperCurrent = world.method_8320(upperPos);
                    if (!upperCurrent.method_26215() && !upperCurrent.method_45474() || !(lower = (class_2680)newState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12607)).method_26184((class_4538)world, basePos)) continue;
                    boolean inWater = world.method_8316(basePos).method_15767(class_3486.field_15517);
                    boolean upperInWater = world.method_8316(upperPos).method_15767(class_3486.field_15517);
                    if (inWater) {
                        lower = (class_2680)lower.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
                    }
                    upper = upperInWater ? (class_2680)((class_2680)newState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)) : (class_2680)newState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609);
                    world.method_8501(upperPos, upper);
                    result.addSimplePlant(upperPos, originalStateUpper, upper);
                    world.method_8501(basePos, lower);
                    result.addSimplePlant(basePos, originalStateLower, lower);
                    PushdozerMod.LOGGER.debug("Placed Big Dripleaf at {}, height: 2, inWater: {}", (Object)basePos, (Object)inWater);
                    continue;
                }
                if (!newState.method_26184((class_4538)world, basePos)) continue;
                class_2680 lower = (class_2680)newState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12607);
                class_2680 upper3 = (class_2680)newState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609);
                class_2680 upperCurrent = world.method_8320(upperPos);
                if (!upperCurrent.method_26215() && !upperCurrent.method_45474()) continue;
                world.method_8501(basePos, lower);
                world.method_8501(upperPos, upper3);
                result.addSimplePlant(basePos, originalStateLower, lower);
                result.addSimplePlant(upperPos, originalStateUpper, upper3);
                continue;
            }
            if (!this.isDeadCoral(newState.method_26204()) && !newState.method_26184((class_4538)world, basePos)) continue;
            world.method_8501(basePos, newState);
            class_2680 placedState = world.method_8320(basePos);
            if (!placedState.equals(newState)) {
                world.method_8501(basePos, originalStateLower);
                PushdozerMod.LOGGER.debug("Plant placement failed at {}: expected {}, got {}", new Object[]{basePos, newState.method_26204(), placedState.method_26204()});
                continue;
            }
            if (this.isLiveCoral(newState.method_26204()) && this.isDeadCoral(placedState.method_26204())) {
                world.method_8501(basePos, originalStateLower);
                PushdozerMod.LOGGER.debug("Live coral at {} turned into dead coral, reverting", (Object)basePos);
                continue;
            }
            result.addSimplePlant(basePos, originalStateLower, newState);
        }
    }

    private boolean handleCoralPlacement(class_3218 world, class_2338 basePos, class_2680 newState, class_2680 originalState, BatchPlantingResult result) {
        class_2248 block = newState.method_26204();
        boolean isLive = this.isLiveCoral(block);
        boolean isDead = this.isDeadCoral(block);
        if (!isLive && !isDead) {
            return false;
        }
        if (this.hasExistingPlantOrDecoration(originalState.method_26204())) {
            PushdozerMod.LOGGER.debug("Skipping coral placement at {}: existing plant/decoration detected", (Object)basePos);
            return false;
        }
        if (isLive) {
            class_2338 upperPos;
            class_2680 upperState;
            boolean upperInWater;
            boolean inWater = originalState.method_26227().method_15767(class_3486.field_15517) || world.method_8316(basePos).method_15767(class_3486.field_15517);
            boolean adjacentToWater = this.isAdjacentToWater((class_1937)world, basePos);
            if (!inWater && !adjacentToWater) {
                return false;
            }
            if (this.isLiveCoralFan(block) && !(upperInWater = (upperState = world.method_8320(upperPos = basePos.method_10084())).method_26227().method_15767(class_3486.field_15517))) {
                return false;
            }
            class_2680 toPlace = newState;
            if (block instanceof class_2299) {
                class_2350 facing = this.findValidWallDirection((class_1937)world, basePos);
                if (facing == null) {
                    PushdozerMod.LOGGER.debug("Skipping wall coral fan at {}: no valid solid side", (Object)basePos);
                    return false;
                }
                toPlace = (class_2680)newState.method_11657((class_2769)class_2741.field_12481, (Comparable)facing);
            }
            if (toPlace.method_28498((class_2769)class_2741.field_12508)) {
                toPlace = (class_2680)toPlace.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
            }
            if (!toPlace.method_26184((class_4538)world, basePos)) {
                PushdozerMod.LOGGER.debug("Skipping live coral at {}: canPlaceAt failed", (Object)basePos);
                return false;
            }
            world.method_8501(basePos, toPlace);
            result.addSimplePlant(basePos, originalState, toPlace);
            return true;
        }
        class_2680 below = world.method_8320(basePos.method_10074());
        boolean spotFree = originalState.method_26215() || originalState.method_45474();
        boolean solidBelow = below.method_26212((class_1922)world, basePos.method_10074());
        if (!spotFree || !solidBelow) {
            return false;
        }
        class_2680 toPlace = newState;
        if (toPlace.method_28498((class_2769)class_2741.field_12508)) {
            toPlace = (class_2680)toPlace.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
        }
        world.method_8501(basePos, toPlace);
        result.addSimplePlant(basePos, originalState, toPlace);
        return true;
    }

    private boolean isAdjacentToWater(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            class_2338 adjacentPos = pos.method_10093(direction);
            class_2680 adjacentState = world.method_8320(adjacentPos);
            if (!adjacentState.method_26227().method_15767(class_3486.field_15517)) continue;
            return true;
        }
        return false;
    }

    private class_2350 findValidWallDirection(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 sidePos = pos.method_10093(direction);
            class_2680 sideState = world.method_8320(sidePos);
            if (!sideState.method_26212((class_1922)world, sidePos)) continue;
            return direction.method_10153();
        }
        return null;
    }

    private void processTrees(class_3218 world, List<PlantingPosition> positions, BatchPlantingResult result) {
        HashSet<Long> blockedColumns = new HashSet<Long>();
        for (PlantingPosition pos : positions) {
            TreeGenerationResult treeResult;
            long colKey = class_2338.method_10064((int)pos.position.method_10263(), (int)0, (int)pos.position.method_10260());
            if (blockedColumns.contains(colKey) || !this.canPlantAt((class_1937)world, pos.position) || (treeResult = this.generateTreeWithSmartBoundary(world, pos.position)).isEmpty()) continue;
            result.incrementTreeCount();
            for (int dx = -4; dx <= 4; ++dx) {
                for (int dz = -4; dz <= 4; ++dz) {
                    long nearbyColKey = class_2338.method_10064((int)(pos.position.method_10263() + dx), (int)0, (int)(pos.position.method_10260() + dz));
                    blockedColumns.add(nearbyColKey);
                }
            }
            for (int i = 0; i < treeResult.affectedPositions.size(); ++i) {
                class_2338 affectedPos = treeResult.affectedPositions.get(i);
                result.addTreeBlock(affectedPos, treeResult.originalStates.get(i), treeResult.newStates.get(i));
            }
        }
    }

    private TreeGenerationResult generateTreeWithSmartBoundary(class_3218 world, class_2338 centerPos) {
        class_2975 feature;
        TreeGenerationResult result = new TreeGenerationResult();
        class_2338 coreMinPos = centerPos.method_10069(-4, -4, -4);
        class_2338 coreMaxPos = centerPos.method_10069(4, 32, 4);
        HashMap<class_2338, class_2680> originalStates = new HashMap<class_2338, class_2680>();
        for (class_2338 pos : class_2338.method_10097((class_2338)coreMinPos, (class_2338)coreMaxPos)) {
            originalStates.put(pos.method_10062(), world.method_8320(pos));
        }
        Optional<class_5321<class_2975<?, ?>>> treeFeature = this.getTreeFeatureForBiome((class_6880<class_1959>)world.method_23753(centerPos));
        if (treeFeature.isPresent()) {
            class_2378 registry = world.method_30349().method_30530(class_7924.field_41239);
            feature = (class_2975)registry.method_29107(treeFeature.get());
            if (feature == null || world.method_14178().method_12129() == null) {
                PushdozerMod.LOGGER.warn("Tree generation failed: feature={}, chunkGenerator={}", (Object)(feature != null ? 1 : 0), (Object)(world.method_14178().method_12129() != null ? 1 : 0));
                return result;
            }
        } else {
            PushdozerMod.LOGGER.warn("No tree feature found for biome at position: {}", (Object)centerPos);
            return result;
        }
        feature.method_12862((class_5281)world, world.method_14178().method_12129(), this.random, centerPos);
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.offer(centerPos);
        visited.add(centerPos);
        while (!queue.isEmpty()) {
            class_2338 pos = (class_2338)queue.poll();
            class_2680 originalState = (class_2680)originalStates.get(pos);
            class_2680 newState = world.method_8320(pos);
            if (originalState == null || originalState.equals(newState)) continue;
            result.addChange(pos, originalState, newState);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        class_2338 neighbor = pos.method_10069(dx, dy, dz);
                        if (visited.contains(neighbor) || neighbor.method_10264() < coreMinPos.method_10264() || neighbor.method_10264() > coreMaxPos.method_10264() || Math.abs(neighbor.method_10263() - centerPos.method_10263()) > 4 || Math.abs(neighbor.method_10260() - centerPos.method_10260()) > 4) continue;
                        visited.add(neighbor);
                        queue.offer(neighbor);
                    }
                }
            }
        }
        return result;
    }

    private boolean canPlantAt(class_1937 world, class_2338 pos) {
        class_2680 groundState = world.method_8320(pos.method_10074());
        boolean isSoil = groundState.method_26164(class_3481.field_29822) || groundState.method_26164(class_3481.field_15466) || groundState.method_26164(class_3481.field_29823) || groundState.method_27852(class_2246.field_10219) || groundState.method_27852(class_2246.field_10194) || groundState.method_27852(class_2246.field_10362) || groundState.method_27852(class_2246.field_10402) || groundState.method_27852(class_2246.field_28685) || groundState.method_27852(class_2246.field_28681) || groundState.method_27852(class_2246.field_10460);
        class_2680 currentState = world.method_8320(pos);
        return isSoil && (currentState.method_26215() || currentState.method_45474());
    }

    private boolean shouldPlantHere(class_2338 pos) {
        List<class_2248> customBlocks;
        boolean containsCrops;
        double density = Math.max(0.0, Math.min(1.0, (double)this.config.getPlantDensity()));
        if (this.config.getPlantType() == PushdozerConfig.PlantType.CUSTOM && (containsCrops = (customBlocks = this.config.getCustomPlantBlocks()).stream().anyMatch(this::isCropBlock))) {
            return (double)this.random.method_43057() < density;
        }
        float clusterScaleCfg = this.config.getClusterScale();
        double scale = this.config.getPlantType() == PushdozerConfig.PlantType.TREES ? (double)clusterScaleCfg * 0.05 : 0.05 / Math.max(0.1, (double)clusterScaleCfg);
        int x = pos.method_10263();
        int z = pos.method_10260();
        double n1 = this.noiseSampler.method_15433((double)x * scale, (double)z * scale);
        double n2 = this.noiseSampler.method_15433((double)x * scale * 2.0, (double)z * scale * 2.0);
        double n3 = this.noiseSampler.method_15433((double)x * scale * 4.0, (double)z * scale * 4.0);
        double n = 0.6 * n1 + 0.3 * n2 + 0.1 * n3;
        double finalProb = this.getFinalProb(n, x, z, density);
        return this.random.method_43057() < (float)finalProb;
    }

    private double getFinalProb(double n, int x, int z, double density) {
        double p = (n + 1.0) * 0.5;
        int h = x * 73856093 ^ z * 19349663;
        double jitter = (double)(h & 0x3FF) / 1023.0 * 0.1 - 0.05;
        p = Math.max(0.0, Math.min(1.0, p + jitter));
        double baseProb = Math.max(0.0, Math.min(1.0, p * density));
        double minProb = this.config.getPlantType() == PushdozerConfig.PlantType.TREES ? 0.02 : 0.06;
        return Math.max(minProb, baseProb);
    }

    private Optional<class_5321<class_2975<?, ?>>> getTreeFeatureForBiome(class_6880<class_1959> biomeEntry) {
        PushdozerConfig.TreeSpecies selectedTree = this.config.getSelectedTree();
        if (selectedTree == PushdozerConfig.TreeSpecies.BIOME_ADAPTIVE) {
            return BiomeVegetationRegistry.getTreeFeature(biomeEntry);
        }
        return Optional.of(this.getTreeFeatureForSpecies(selectedTree));
    }

    private class_5321<class_2975<?, ?>> getTreeFeatureForSpecies(PushdozerConfig.TreeSpecies species) {
        return switch (species) {
            default -> throw new MatchException(null, null);
            case PushdozerConfig.TreeSpecies.OAK -> class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)class_2960.method_60655((String)"minecraft", (String)"oak"));
            case PushdozerConfig.TreeSpecies.SPRUCE -> class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)class_2960.method_60655((String)"minecraft", (String)"spruce"));
            case PushdozerConfig.TreeSpecies.BIRCH -> class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)class_2960.method_60655((String)"minecraft", (String)"birch"));
            case PushdozerConfig.TreeSpecies.JUNGLE -> class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)class_2960.method_60655((String)"minecraft", (String)"jungle_tree"));
            case PushdozerConfig.TreeSpecies.ACACIA -> class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)class_2960.method_60655((String)"minecraft", (String)"acacia"));
            case PushdozerConfig.TreeSpecies.DARK_OAK -> class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)class_2960.method_60655((String)"minecraft", (String)"dark_oak"));
            case PushdozerConfig.TreeSpecies.BIOME_ADAPTIVE -> BiomeVegetationRegistry.DEFAULT_TREE;
        };
    }

    private class_2680 generateSimplePlant(class_1937 world, class_2338 pos, PushdozerConfig.PlantType type) {
        class_6880 biomeEntry = world.method_23753(pos);
        if (type == PushdozerConfig.PlantType.FLOWERS) {
            if (world.method_8316(pos).method_15767(class_3486.field_15517)) {
                return null;
            }
            return this.generateFlowerForBiome((class_6880<class_1959>)biomeEntry);
        }
        if (type == PushdozerConfig.PlantType.GRASS) {
            if (world.method_8316(pos).method_15767(class_3486.field_15517)) {
                return null;
            }
            return this.generateGrassForBiome((class_6880<class_1959>)biomeEntry);
        }
        if (type == PushdozerConfig.PlantType.CUSTOM) {
            return this.generateCustomPlant(world, pos);
        }
        return null;
    }

    private class_2680 generateCustomPlant(class_1937 world, class_2338 pos) {
        String blockName;
        List<class_2248> customBlocks = this.config.getCustomPlantBlocks();
        if (customBlocks.isEmpty()) {
            PushdozerMod.LOGGER.debug("No custom plants selected, skipping planting");
            return null;
        }
        List<class_2248> validBlocks = customBlocks.stream().filter(block -> block != null && block.method_9564() != null).toList();
        if (validBlocks.isEmpty()) {
            PushdozerMod.LOGGER.debug("All custom plants are invalid, skipping planting");
            return null;
        }
        List<class_2248> placeableBlocks = validBlocks.stream().filter(block -> this.canPlantCustomBlockAt(world, pos, (class_2248)block)).toList();
        if (placeableBlocks.isEmpty()) {
            PushdozerMod.LOGGER.debug("No placeable blocks found for position: {}. Valid blocks: {}, placeable: {}", new Object[]{pos, validBlocks.stream().map(class_2248::toString).toList(), placeableBlocks.stream().map(class_2248::toString).toList()});
            return null;
        }
        class_2248 chosen = placeableBlocks.get(this.random.method_43048(placeableBlocks.size()));
        PushdozerMod.LOGGER.debug("Chosen plant: {} from {} placeable options", (Object)chosen, (Object)placeableBlocks.size());
        class_2680 state = chosen.method_9564();
        if (state.method_28498((class_2769)class_2741.field_12550)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12550, (Comparable)Integer.valueOf(this.random.method_43048(8)));
        }
        if ((state = this.setCoverageBasedOnDensity(state, chosen)).method_28498((class_2769)class_2741.field_12481) && ((blockName = chosen.toString().toLowerCase()).contains("leaf_litter") || blockName.contains("pink_petals") || blockName.contains("wildflowers"))) {
            class_2350[] directions = (class_2350[])class_2350.class_2353.field_11062.method_29716().toArray(class_2350[]::new);
            class_2350 randomDirection = directions[this.random.method_43048(directions.length)];
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)randomDirection);
        }
        return state;
    }

    private boolean canPlantCustomBlockAt(class_1937 world, class_2338 pos, class_2248 block) {
        boolean validBase;
        boolean isCrop;
        class_2680 targetState = world.method_8320(pos);
        class_2680 below = world.method_8320(pos.method_10074());
        class_2680 state = block.method_9564();
        if (block == class_2246.field_10588) {
            boolean airHere = targetState.method_26215();
            boolean waterBelow = below.method_26227().method_15767(class_3486.field_15517);
            return airHere && waterBelow && state.method_26184((class_4538)world, pos);
        }
        if (block instanceof class_2320) {
            if (!state.method_28498((class_2769)class_2741.field_12533)) {
                return false;
            }
            class_2338 upperPos = pos.method_10084();
            class_2680 upperCurrent = world.method_8320(upperPos);
            if (!upperCurrent.method_26215() && !upperCurrent.method_45474()) {
                return false;
            }
        }
        if (this.isPotted(block)) {
            boolean spotFree = targetState.method_26215() || targetState.method_45474();
            boolean notInWater = !targetState.method_26227().method_15767(class_3486.field_15517);
            boolean solidBelow = below.method_26212((class_1922)world, pos.method_10074());
            boolean notPlantBelow = !this.isPlantBlock(below.method_26204()) && !this.isPotted(below.method_26204());
            boolean potCanPlace = class_2246.field_10495.method_9564().method_26184((class_4538)world, pos);
            return spotFree && notInWater && solidBelow && notPlantBelow && potCanPlace && state.method_26184((class_4538)world, pos);
        }
        boolean bl = isCrop = this.isCropBlock(block) || state.method_28498((class_2769)class_2741.field_12550);
        if (isCrop) {
            return below.method_27852(class_2246.field_10362) && (targetState.method_26215() || targetState.method_45474());
        }
        boolean inWater = targetState.method_26227().method_15767(class_3486.field_15517);
        boolean adjacentToWater = this.isAdjacentToWater(world, pos);
        if (this.isLiveCoral(block)) {
            boolean validBase2;
            class_2338 upperPos = pos.method_10084();
            class_2680 upperState = world.method_8320(upperPos);
            boolean upperInWater = upperState.method_26227().method_15767(class_3486.field_15517);
            boolean bl2 = validBase2 = below.method_26164(class_3481.field_15466) || below.method_26164(class_3481.field_15461) || below.method_26164(class_3481.field_25806) || below.method_26164(class_3481.field_25807) || below.method_27852(class_2246.field_10471) || below.method_27852(class_2246.field_10255) || below.method_27852(class_2246.field_10460);
            if (block instanceof class_2299) {
                boolean hasSolidSide = false;
                for (class_2350 direction : class_2350.class_2353.field_11062) {
                    class_2338 sidePos = pos.method_10093(direction);
                    class_2680 sideState = world.method_8320(sidePos);
                    if (!sideState.method_26212((class_1922)world, sidePos)) continue;
                    hasSolidSide = true;
                    break;
                }
                return (inWater || adjacentToWater) && upperInWater && hasSolidSide;
            }
            return (inWater || adjacentToWater) && upperInWater && validBase2;
        }
        if (block == class_2246.field_28684) {
            boolean validBase3 = below.method_26164(class_3481.field_33641) || below.method_27852(class_2246.field_10460) || below.method_27852(class_2246.field_28681) || below.method_27852(class_2246.field_28685) || below.method_27852(class_2246.field_10402) || below.method_27852(class_2246.field_10520) || inWater && (below.method_27852(class_2246.field_10566) || below.method_27852(class_2246.field_10253) || below.method_27852(class_2246.field_10219) || below.method_27852(class_2246.field_10362));
            class_2338 upperPos = pos.method_10084();
            class_2680 upperState = world.method_8320(upperPos);
            boolean upperReplaceable = upperState.method_26215() || upperState.method_45474();
            boolean result = validBase3 && upperReplaceable;
            PushdozerMod.LOGGER.debug("Small Dripleaf canPlant check at {}: validBase={}, upperReplaceable={}, result={}", new Object[]{pos, validBase3, upperReplaceable, result});
            return result;
        }
        if (block == class_2246.field_28682) {
            boolean validBase4 = below.method_27852(class_2246.field_10460) || below.method_27852(class_2246.field_28681) || below.method_27852(class_2246.field_10219) || below.method_27852(class_2246.field_10402) || below.method_27852(class_2246.field_10520) || below.method_27852(class_2246.field_10566) || below.method_27852(class_2246.field_28685) || below.method_27852(class_2246.field_10253) || below.method_27852(class_2246.field_10362) || below.method_27852(class_2246.field_37576) || below.method_27852(class_2246.field_37547);
            class_2338 upperPos = pos.method_10084();
            class_2680 upperState = world.method_8320(upperPos);
            boolean upperReplaceable = upperState.method_26215() || upperState.method_45474();
            boolean result = validBase4 && upperReplaceable;
            PushdozerMod.LOGGER.debug("Big Dripleaf canPlant check at {}: validBase={}, upperReplaceable={}, result={}", new Object[]{pos, validBase4, upperReplaceable, result});
            return result;
        }
        if (this.isAquatic(block)) {
            return inWater && state.method_26184((class_4538)world, pos);
        }
        if (this.isDeadCoral(block)) {
            boolean spotFree = targetState.method_26215() || targetState.method_45474();
            boolean solidBelow = below.method_26212((class_1922)world, pos.method_10074());
            return spotFree && solidBelow;
        }
        if (block.toString().toLowerCase().contains("leaf_litter")) {
            boolean canPlace;
            boolean spotFree = targetState.method_26215() || targetState.method_45474();
            boolean validBase5 = below.method_26212((class_1922)world, pos.method_10074());
            boolean bl3 = canPlace = spotFree && validBase5;
            if (!canPlace) {
                PushdozerMod.LOGGER.debug("Cannot place leaf_litter at {}: spotFree={}, validBase={}", new Object[]{pos, spotFree, validBase5});
            }
            return canPlace;
        }
        boolean bl4 = validBase = below.method_26164(class_3481.field_29822) || below.method_27852(class_2246.field_10219) || below.method_26164(class_3481.field_15466) || below.method_26164(class_3481.field_29823) || below.method_27852(class_2246.field_10194) || below.method_27852(class_2246.field_28681) || below.method_27852(class_2246.field_10460);
        if (!validBase) {
            return false;
        }
        return (targetState.method_26215() || targetState.method_45474()) && state.method_26184((class_4538)world, pos);
    }

    private boolean isAquatic(class_2248 block) {
        return block == class_2246.field_10376 || block == class_2246.field_10238 || block == class_2246.field_9993 || block == class_2246.field_10463 || block == class_2246.field_10476;
    }

    private boolean isLiveCoral(class_2248 block) {
        String id = block.toString().toLowerCase();
        return id.contains("coral") && !id.contains("dead");
    }

    private boolean isLiveCoralFan(class_2248 block) {
        String id = block.toString().toLowerCase();
        return id.contains("coral") && id.contains("fan") && !id.contains("dead");
    }

    private boolean isDeadCoral(class_2248 block) {
        String id = block.toString().toLowerCase();
        return id.contains("coral") && id.contains("dead");
    }

    private boolean hasExistingPlantOrDecoration(class_2248 block) {
        if (block == class_2246.field_10029) {
            return true;
        }
        if (this.isPlantBlock(block)) {
            return true;
        }
        if (this.isPotted(block)) {
            return true;
        }
        if (this.isLiveCoral(block) || this.isDeadCoral(block)) {
            return true;
        }
        return block == class_2246.field_10428 || block == class_2246.field_10424 || block == class_2246.field_10211 || block == class_2246.field_10021 || block == class_2246.field_10528 || block == class_2246.field_22117 || block == class_2246.field_22116 || block == class_2246.field_22125 || block == class_2246.field_22114 || block == class_2246.field_22121 || block == class_2246.field_22123 || block == class_2246.field_23078 || block == class_2246.field_28411 || block == class_2246.field_28686 || block == class_2246.field_28677 || block == class_2246.field_28679 || block == class_2246.field_28678 || block == class_2246.field_28680 || block == class_2246.field_10376 || block == class_2246.field_10238 || block == class_2246.field_9993 || block == class_2246.field_10463 || block == class_2246.field_10476 || block == class_2246.field_10588 || block == class_2246.field_28684 || block == class_2246.field_28682 || block.toString().toLowerCase().contains("leaf_litter");
    }

    private boolean isPlantBlock(class_2248 block) {
        return block == class_2246.field_10182 || block == class_2246.field_10449 || block == class_2246.field_10086 || block == class_2246.field_10226 || block == class_2246.field_10573 || block == class_2246.field_10270 || block == class_2246.field_10048 || block == class_2246.field_10156 || block == class_2246.field_10315 || block == class_2246.field_10554 || block == class_2246.field_9995 || block == class_2246.field_10548 || block == class_2246.field_10583 || block == class_2246.field_10378 || block == class_2246.field_10430 || block == class_2246.field_10003 || block == class_2246.field_10479 || block == class_2246.field_10214 || block == class_2246.field_10112 || block == class_2246.field_10313 || block == class_2246.field_10428 || block == class_2246.field_10029 || block == class_2246.field_10424 || block == class_2246.field_10211 || block == class_2246.field_10021 || block == class_2246.field_10528 || block == class_2246.field_22117 || block == class_2246.field_22116 || block == class_2246.field_22125 || block == class_2246.field_22114 || block == class_2246.field_22121 || block == class_2246.field_22123 || block == class_2246.field_23078 || block == class_2246.field_28411 || block == class_2246.field_28686 || block == class_2246.field_28677 || block == class_2246.field_28679 || block == class_2246.field_28678 || block == class_2246.field_28680 || block == class_2246.field_10376 || block == class_2246.field_10238 || block == class_2246.field_9993 || block == class_2246.field_10463 || block == class_2246.field_10476 || block == class_2246.field_10588 || block == class_2246.field_28684 || block == class_2246.field_28682 || this.isLiveCoral(block) || this.isDeadCoral(block) || this.isCropBlock(block) || block instanceof class_2320 || block.toString().toLowerCase().contains("leaf_litter");
    }

    private boolean isPotted(class_2248 block) {
        return block instanceof class_2362 && block != class_2246.field_10495;
    }

    private class_2680 generateFlowerForBiome(class_6880<class_1959> biomeEntry) {
        PushdozerConfig.FlowerGroup selectedFlowerGroup = this.config.getSelectedFlowerGroup();
        if (selectedFlowerGroup == PushdozerConfig.FlowerGroup.BIOME_ADAPTIVE) {
            List<class_2248> flowerBlocks = BiomeVegetationRegistry.getFlowerBlocks(biomeEntry);
            return this.getRandomBlock(flowerBlocks, this.random);
        }
        List<class_2248> flowerBlocks = this.getFlowerBlocksForGroup(selectedFlowerGroup);
        return this.getRandomBlock(flowerBlocks, this.random);
    }

    private List<class_2248> getFlowerBlocksForGroup(PushdozerConfig.FlowerGroup group) {
        return switch (group) {
            default -> throw new MatchException(null, null);
            case PushdozerConfig.FlowerGroup.PLAINS_FLOWERS -> Arrays.asList(class_2246.field_10182, class_2246.field_10449, class_2246.field_10554, class_2246.field_9995);
            case PushdozerConfig.FlowerGroup.FOREST_FLOWERS -> Arrays.asList(class_2246.field_10548, class_2246.field_10226, class_2246.field_10573, class_2246.field_10270, class_2246.field_10048, class_2246.field_10156, class_2246.field_10315);
            case PushdozerConfig.FlowerGroup.ALL_FLOWERS -> Arrays.asList(class_2246.field_10182, class_2246.field_10449, class_2246.field_10086, class_2246.field_10226, class_2246.field_10573, class_2246.field_10270, class_2246.field_10048, class_2246.field_10156, class_2246.field_10315, class_2246.field_10554, class_2246.field_9995, class_2246.field_10548, class_2246.field_10583, class_2246.field_10378, class_2246.field_10430, class_2246.field_10003);
            case PushdozerConfig.FlowerGroup.BIOME_ADAPTIVE -> BiomeVegetationRegistry.DEFAULT_FLOWERS;
        };
    }

    private class_2680 generateGrassForBiome(class_6880<class_1959> biomeEntry) {
        List<class_2248> grassBlocks = BiomeVegetationRegistry.getGrassBlocks(biomeEntry);
        return this.getRandomBlock(grassBlocks, this.random);
    }

    private boolean isCropBlock(class_2248 block) {
        return block == class_2246.field_10293 || block == class_2246.field_10609 || block == class_2246.field_10247 || block == class_2246.field_10341 || block == class_2246.field_46286 || block == class_2246.field_46287;
    }

    private class_2680 getRandomBlock(List<class_2248> blocks, class_5819 random) {
        if (blocks.isEmpty()) {
            return null;
        }
        class_2248 selectedBlock = blocks.get(random.method_43048(blocks.size()));
        return selectedBlock.method_9564();
    }

    private class_2680 setCoverageBasedOnDensity(class_2680 state, class_2248 block) {
        class_2350 randomDirection;
        class_2350[] directions;
        class_2680 newState;
        String propName;
        boolean isCoverageBlock;
        String blockId = block.toString().toLowerCase();
        PushdozerMod.LOGGER.debug("Checking coverage for block: {} (blockId: {})", (Object)block, (Object)blockId);
        boolean bl = isCoverageBlock = blockId.contains("pink_petals") || blockId.contains("wildflowers") || blockId.contains("leaf_litter");
        if (!isCoverageBlock) {
            return state;
        }
        double density = Math.max(0.0, Math.min(1.0, (double)this.config.getPlantDensity()));
        int coverageLevel = density <= 0.25 ? 1 : (density <= 0.5 ? 2 : (density <= 0.75 ? 3 : 4));
        if (this.random.method_43057() < 0.3f) {
            coverageLevel = Math.max(1, Math.min(4, coverageLevel + (this.random.method_43056() ? 1 : -1)));
        }
        PushdozerMod.LOGGER.debug("Block {} has properties: {}", (Object)block, (Object)state.method_28501());
        for (class_2769 property : state.method_28501()) {
            PushdozerMod.LOGGER.debug("Property: {} = {}", (Object)property.method_11899(), (Object)state.method_11654(property));
        }
        PushdozerMod.LOGGER.debug("Checking all possible properties for block: {}", (Object)block);
        if (state.method_28498((class_2769)class_2741.field_42835)) {
            PushdozerMod.LOGGER.debug("Found FLOWER_AMOUNT property");
        }
        for (class_2769 property : state.method_28501()) {
            propName = property.method_11899().toLowerCase();
            if (!propName.contains("leaves") && !propName.contains("amount") && !propName.contains("flower")) continue;
            PushdozerMod.LOGGER.debug("Found relevant property: {} = {}", (Object)property.method_11899(), (Object)state.method_11654(property));
        }
        if (blockId.contains("pink_petals") && state.method_28498((class_2769)class_2741.field_42835)) {
            newState = (class_2680)state.method_11657((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(coverageLevel));
            if (newState.method_28498((class_2769)class_2741.field_12481)) {
                directions = (class_2350[])class_2350.class_2353.field_11062.method_29716().toArray(class_2350[]::new);
                randomDirection = directions[this.random.method_43048(directions.length)];
                newState = (class_2680)newState.method_11657((class_2769)class_2741.field_12481, (Comparable)randomDirection);
            }
            PushdozerMod.LOGGER.debug("Set FLOWER_AMOUNT for pink_petals: density={}, coverageLevel={}", (Object)density, (Object)coverageLevel);
            return newState;
        }
        if (blockId.contains("wildflowers") && state.method_28498((class_2769)class_2741.field_42835)) {
            newState = (class_2680)state.method_11657((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(coverageLevel));
            if (newState.method_28498((class_2769)class_2741.field_12481)) {
                directions = (class_2350[])class_2350.class_2353.field_11062.method_29716().toArray(class_2350[]::new);
                randomDirection = directions[this.random.method_43048(directions.length)];
                newState = (class_2680)newState.method_11657((class_2769)class_2741.field_12481, (Comparable)randomDirection);
            }
            PushdozerMod.LOGGER.debug("Set FLOWER_AMOUNT for wildflowers: density={}, coverageLevel={}", (Object)density, (Object)coverageLevel);
            return newState;
        }
        if (blockId.contains("leaf_litter")) {
            for (class_2769 property : state.method_28501()) {
                propName = property.method_11899().toLowerCase();
                if (!propName.equals("segment_amount") && !propName.equals("segmentamount")) continue;
                try {
                    class_2769 intProperty = property;
                    Collection validValues = intProperty.method_11898();
                    int maxValue = validValues.stream().mapToInt(Integer::intValue).max().orElse(4);
                    int validCoverageLevel = Math.max(1, Math.min(maxValue, coverageLevel));
                    class_2680 newState2 = (class_2680)state.method_11657(intProperty, (Comparable)Integer.valueOf(validCoverageLevel));
                    if (newState2.method_28498((class_2769)class_2741.field_12481)) {
                        class_2350[] directions2 = (class_2350[])class_2350.class_2353.field_11062.method_29716().toArray(class_2350[]::new);
                        class_2350 randomDirection2 = directions2[this.random.method_43048(directions2.length)];
                        newState2 = (class_2680)newState2.method_11657((class_2769)class_2741.field_12481, (Comparable)randomDirection2);
                    }
                    PushdozerMod.LOGGER.debug("Set {} for leaf_litter: density={}, coverageLevel={}, validLevel={}, maxValue={}", new Object[]{property.method_11899(), density, coverageLevel, validCoverageLevel, maxValue});
                    return newState2;
                }
                catch (ClassCastException e) {
                    PushdozerMod.LOGGER.debug("Property {} is not an integer property for leaf_litter", (Object)property.method_11899());
                }
            }
            for (class_2769 property : state.method_28501()) {
                propName = property.method_11899().toLowerCase();
                if (!propName.contains("amount") && !propName.contains("growth")) continue;
                try {
                    class_2769 intProperty = property;
                    Collection validValues = intProperty.method_11898();
                    int maxValue = validValues.stream().mapToInt(Integer::intValue).max().orElse(4);
                    int validCoverageLevel = Math.max(1, Math.min(maxValue, coverageLevel));
                    class_2680 newState3 = (class_2680)state.method_11657(intProperty, (Comparable)Integer.valueOf(validCoverageLevel));
                    if (newState3.method_28498((class_2769)class_2741.field_12481)) {
                        class_2350[] directions3 = (class_2350[])class_2350.class_2353.field_11062.method_29716().toArray(class_2350[]::new);
                        class_2350 randomDirection3 = directions3[this.random.method_43048(directions3.length)];
                        newState3 = (class_2680)newState3.method_11657((class_2769)class_2741.field_12481, (Comparable)randomDirection3);
                    }
                    PushdozerMod.LOGGER.debug("Set {} for leaf_litter: density={}, coverageLevel={}, validLevel={}, maxValue={}", new Object[]{property.method_11899(), density, coverageLevel, validCoverageLevel, maxValue});
                    return newState3;
                }
                catch (ClassCastException e) {
                    PushdozerMod.LOGGER.debug("Property {} is not an integer property for leaf_litter", (Object)property.method_11899());
                }
            }
            PushdozerMod.LOGGER.warn("Leaf_litter at {} does not have segment_amount property. Available properties: {}", (Object)block, state.method_28501().stream().map(class_2769::method_11899).toList());
        }
        PushdozerMod.LOGGER.debug("Coverage block {} detected but no matching property found. Available properties: {}", (Object)block, (Object)state.method_28501());
        return state;
    }

    private static class BatchPlantingResult {
        private final List<class_2338> allPositions = new ArrayList<class_2338>();
        private final List<class_2680> allOriginalStates = new ArrayList<class_2680>();
        private final List<class_2680> allNewStates = new ArrayList<class_2680>();
        private int simplePlantCount = 0;
        private int treeCount = 0;

        private BatchPlantingResult() {
        }

        void addSimplePlant(class_2338 pos, class_2680 original, class_2680 newState) {
            this.allPositions.add(pos);
            this.allOriginalStates.add(original);
            this.allNewStates.add(newState);
            ++this.simplePlantCount;
        }

        void addTreeBlock(class_2338 pos, class_2680 original, class_2680 newState) {
            this.allPositions.add(pos);
            this.allOriginalStates.add(original);
            this.allNewStates.add(newState);
        }

        void incrementTreeCount() {
            ++this.treeCount;
        }

        List<class_2338> getAllPositions() {
            return this.allPositions;
        }

        List<class_2680> getAllOriginalStates() {
            return this.allOriginalStates;
        }

        List<class_2680> getAllNewStates() {
            return this.allNewStates;
        }

        boolean isEmpty() {
            return this.allPositions.isEmpty();
        }

        int getTotalCount() {
            return this.simplePlantCount + this.treeCount;
        }

        int getSimplePlantCount() {
            return this.simplePlantCount;
        }

        int getTreeCount() {
            return this.treeCount;
        }
    }

    private static class PlantingPosition {
        final class_2338 position;
        final PushdozerConfig.PlantType plantType;

        PlantingPosition(class_2338 position, PushdozerConfig.PlantType plantType) {
            this.position = position;
            this.plantType = plantType;
        }
    }

    private static class TreeGenerationResult {
        final List<class_2338> affectedPositions = new ArrayList<class_2338>();
        final List<class_2680> originalStates = new ArrayList<class_2680>();
        final List<class_2680> newStates = new ArrayList<class_2680>();

        private TreeGenerationResult() {
        }

        void addChange(class_2338 pos, class_2680 original, class_2680 newState) {
            this.affectedPositions.add(pos);
            this.originalStates.add(original);
            this.newStates.add(newState);
        }

        boolean isEmpty() {
            return this.affectedPositions.isEmpty();
        }
    }

    private static class BiomeVegetationRegistry {
        private static final Map<class_6862<class_1959>, class_5321<class_2975<?, ?>>> TREE_FEATURES = new HashMap();
        private static final Map<class_6862<class_1959>, List<class_2248>> FLOWER_BLOCKS = new HashMap<class_6862<class_1959>, List<class_2248>>();
        private static final Map<class_6862<class_1959>, List<class_2248>> GRASS_BLOCKS = new HashMap<class_6862<class_1959>, List<class_2248>>();
        private static final class_5321<class_2975<?, ?>> DEFAULT_TREE = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)class_2960.method_60655((String)"minecraft", (String)"oak"));
        private static final List<class_2248> DEFAULT_FLOWERS = Arrays.asList(class_2246.field_10182, class_2246.field_10449, class_2246.field_10554);
        private static final List<class_2248> DEFAULT_GRASS = Arrays.asList(class_2246.field_10479, class_2246.field_10214, class_2246.field_10112);

        private BiomeVegetationRegistry() {
        }

        private static void initializeTreeFeatures() {
            TREE_FEATURES.put(PushdozerBiomeTags.HAS_JUNGLE_TREES, class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)class_2960.method_60655((String)"minecraft", (String)"jungle_tree")));
            TREE_FEATURES.put(PushdozerBiomeTags.HAS_TAIGA_TREES, class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)class_2960.method_60655((String)"minecraft", (String)"spruce")));
            TREE_FEATURES.put(PushdozerBiomeTags.HAS_BIRCH_TREES, class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)class_2960.method_60655((String)"minecraft", (String)"birch")));
            TREE_FEATURES.put(PushdozerBiomeTags.HAS_OAK_TREES, class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)class_2960.method_60655((String)"minecraft", (String)"oak")));
        }

        private static void initializeFlowerBlocks() {
            FLOWER_BLOCKS.put(PushdozerBiomeTags.HAS_DESERT_FLOWERS, Arrays.asList(class_2246.field_10428, class_2246.field_10029));
            FLOWER_BLOCKS.put(PushdozerBiomeTags.HAS_PLAINS_FLOWERS, Arrays.asList(class_2246.field_10182, class_2246.field_10449, class_2246.field_10554, class_2246.field_9995));
            FLOWER_BLOCKS.put(PushdozerBiomeTags.HAS_FOREST_FLOWERS, Arrays.asList(class_2246.field_10548, class_2246.field_10226, class_2246.field_10573, class_2246.field_10270, class_2246.field_10048, class_2246.field_10156, class_2246.field_10315));
            FLOWER_BLOCKS.put((class_6862<class_1959>)class_6908.field_36509, Arrays.asList(class_2246.field_10376, class_2246.field_10238));
        }

        private static void initializeGrassBlocks() {
            GRASS_BLOCKS.put(PushdozerBiomeTags.HAS_DESERT_GRASS, Arrays.asList(class_2246.field_10428, class_2246.field_10029));
            GRASS_BLOCKS.put(PushdozerBiomeTags.HAS_PLAINS_GRASS, Arrays.asList(class_2246.field_10479, class_2246.field_10214, class_2246.field_10112));
            GRASS_BLOCKS.put((class_6862<class_1959>)class_6908.field_36509, Arrays.asList(class_2246.field_10376, class_2246.field_10238));
        }

        public static Optional<class_5321<class_2975<?, ?>>> getTreeFeature(class_6880<class_1959> biomeEntry) {
            for (Map.Entry<class_6862<class_1959>, class_5321<class_2975<?, ?>>> entry : TREE_FEATURES.entrySet()) {
                if (!biomeEntry.method_40220(entry.getKey())) continue;
                return Optional.of(entry.getValue());
            }
            PushdozerMod.LOGGER.debug("Biome not matched for tree feature, using default oak");
            return Optional.of(DEFAULT_TREE);
        }

        public static List<class_2248> getFlowerBlocks(class_6880<class_1959> biomeEntry) {
            for (Map.Entry<class_6862<class_1959>, List<class_2248>> entry : FLOWER_BLOCKS.entrySet()) {
                if (!biomeEntry.method_40220(entry.getKey())) continue;
                return entry.getValue() != null ? entry.getValue() : DEFAULT_FLOWERS;
            }
            return DEFAULT_FLOWERS;
        }

        public static List<class_2248> getGrassBlocks(class_6880<class_1959> biomeEntry) {
            for (Map.Entry<class_6862<class_1959>, List<class_2248>> entry : GRASS_BLOCKS.entrySet()) {
                if (!biomeEntry.method_40220(entry.getKey())) continue;
                return entry.getValue() != null ? entry.getValue() : DEFAULT_GRASS;
            }
            return DEFAULT_GRASS;
        }

        static {
            BiomeVegetationRegistry.initializeTreeFeatures();
            BiomeVegetationRegistry.initializeFlowerBlocks();
            BiomeVegetationRegistry.initializeGrassBlocks();
        }
    }
}

