/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.items.handlers;

import com.pushdozer.PushdozerMod;
import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.operations.BlockOperation;
import com.pushdozer.operations.UndoAction;
import com.pushdozer.shapes.GeometryShape;
import com.pushdozer.util.ShapeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_7923;

public class ExcavationHandler {
    private final PushdozerConfig config;

    public ExcavationHandler(PushdozerConfig config) {
        this.config = config;
    }

    public List<class_2338> handleExcavation(class_1657 player, class_1937 world) {
        if (world.field_9236) {
            return List.of();
        }
        class_2338 basePos = ShapeUtil.getTargetBlockPos(player, this.config);
        GeometryShape shape = ShapeUtil.createShape(player, this.config, basePos);
        if (shape == null) {
            return List.of();
        }
        List<class_2338> blocksToBreak = this.getBlocksToBreak(player, world, shape);
        if (!blocksToBreak.isEmpty()) {
            this.performExcavation(world, blocksToBreak, player);
        }
        return blocksToBreak;
    }

    private List<class_2338> getBlocksToBreak(class_1657 player, class_1937 world, GeometryShape shape) {
        return shape.getBlockPositions().stream().filter(pos -> this.isValidBreakTarget(world.method_8320(pos), world, (class_2338)pos)).filter(pos -> this.isValidHeightForExcavation((class_2338)pos, player)).collect(Collectors.toList());
    }

    private void performExcavation(class_1937 world, List<class_2338> positions, class_1657 player) {
        ArrayList<class_2680> originalStates = new ArrayList<class_2680>();
        ArrayList<class_2680> newStates = new ArrayList<class_2680>();
        for (class_2338 pos : positions) {
            class_2680 originalState = world.method_8320(pos);
            originalStates.add(originalState);
            newStates.add(class_2246.field_10124.method_9564());
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
        BlockOperation.BoundaryExtension boundaryExtension = BlockOperation.collectBoundaryExtension(positions, world);
        UndoAction undoAction = new UndoAction(UndoAction.ActionType.BREAK, positions, originalStates, newStates, boundaryExtension.getPositions(), boundaryExtension.getOriginalStates(), boundaryExtension.getNewStates());
        PushdozerMod.pushUndoAction(player, undoAction);
    }

    private boolean isValidBreakTarget(class_2680 state, class_1937 world, class_2338 pos) {
        if (world.method_22347(pos)) {
            return false;
        }
        class_2248 block = state.method_26204();
        if (!this.config.isBlockBreakable(block)) {
            return false;
        }
        String blockId = class_7923.field_41175.method_10221((Object)block).toString();
        if (this.config.getIgnoredBlockIds().contains(blockId)) {
            return false;
        }
        return !(block.method_36555() < 0.0f);
    }

    private boolean isValidHeightForExcavation(class_2338 pos, class_1657 player) {
        PushdozerConfig.HeightMode heightMode = this.config.getHeightMode();
        if (heightMode == PushdozerConfig.HeightMode.NO_LIMIT) {
            return true;
        }
        if (heightMode == PushdozerConfig.HeightMode.FOLLOW_PLAYER) {
            return pos.method_10264() >= player.method_31478();
        }
        if (heightMode == PushdozerConfig.HeightMode.LOCKED_ONCE || heightMode == PushdozerConfig.HeightMode.CUSTOM) {
            return pos.method_10264() >= this.config.getLockedHeight() + 1;
        }
        return true;
    }
}

