/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.operations;

import com.pushdozer.operations.BlockOperation;
import com.pushdozer.operations.UndoAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2672;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3568;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoRedoManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"pushdozer");
    private static final int MAX_UNDO_REDO_STEPS = 30;
    private static final int LARGE_OPERATION_THRESHOLD = 4096;
    private final Map<UUID, PlayerUndoRedoStacks> playerStacks = new HashMap<UUID, PlayerUndoRedoStacks>();
    private final Map<UUID, Long> lastActionTime = new HashMap<UUID, Long>();
    private static final long ACTION_COOLDOWN_MS = 300L;
    private final Set<UUID> executingPlayers = new HashSet<UUID>();

    public void pushUndoAction(class_1657 player, UndoAction action) {
        UUID playerId = player.method_5667();
        PlayerUndoRedoStacks stacks = this.playerStacks.computeIfAbsent(playerId, k -> new PlayerUndoRedoStacks());
        if (stacks.undoStack.size() >= 30) {
            stacks.undoStack.removeFirst();
        }
        stacks.undoStack.push(action);
        stacks.redoStack.clear();
        LOGGER.debug("\u73a9\u5bb6 {} \u6dfb\u52a0\u4e86\u65b0\u7684\u64a4\u9500\u64cd\u4f5c\uff0c\u7c7b\u578b\uff1a{}\uff0c\u6d89\u53ca {} \u4e2a\u65b9\u5757\uff0c\u5f53\u524d\u64a4\u9500\u6808\u5927\u5c0f: {}", new Object[]{player.method_5477().getString(), action.getType(), action.getPositions().size(), stacks.undoStack.size()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoLastAction(class_1657 player, class_1937 world) {
        UUID playerId = player.method_5667();
        LOGGER.debug("\u73a9\u5bb6 {} \u5c1d\u8bd5\u6267\u884c\u64a4\u9500\u64cd\u4f5c", (Object)player.method_5477().getString());
        if (this.isCoolingDownOrExecuting(playerId)) {
            return;
        }
        this.markExecuting(playerId);
        try {
            PlayerUndoRedoStacks stacks = this.playerStacks.get(playerId);
            LOGGER.debug("\u73a9\u5bb6 {} \u7684\u64a4\u9500\u6808\u72b6\u6001: undoStack={}, redoStack={}", new Object[]{player.method_5477().getString(), stacks != null ? Integer.valueOf(stacks.undoStack.size()) : "null", stacks != null ? Integer.valueOf(stacks.redoStack.size()) : "null"});
            if (stacks != null && !stacks.undoStack.isEmpty()) {
                UndoAction action = stacks.undoStack.pop();
                LOGGER.debug("\u5f00\u59cb\u6267\u884c\u64a4\u9500\u64cd\u4f5c\uff0c\u7c7b\u578b: {}, \u65b9\u5757\u6570: {}", (Object)action.getType(), (Object)action.getPositions().size());
                boolean success = this.executeUndoRedoAction(action, player, world, true);
                if (success) {
                    stacks.redoStack.push(action);
                    LOGGER.debug("\u73a9\u5bb6 {} \u64a4\u9500\u6210\u529f\uff0c\u7c7b\u578b\uff1a{}\uff0c\u6d89\u53ca {} \u4e2a\u65b9\u5757", new Object[]{player.method_5477().getString(), action.getType(), action.getPositions().size()});
                } else {
                    LOGGER.warn("\u73a9\u5bb6 {} \u64a4\u9500\u5931\u8d25\uff0c\u64cd\u4f5c\u88ab\u5ffd\u7565", (Object)player.method_5477().getString());
                }
            } else {
                LOGGER.debug("\u73a9\u5bb6 {} \u5c1d\u8bd5\u64a4\u9500\uff0c\u4f46\u6ca1\u6709\u53ef\u64a4\u9500\u7684\u64cd\u4f5c", (Object)player.method_5477().getString());
            }
        }
        finally {
            this.updateCooldown(playerId);
            this.unmarkExecuting(playerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redoLastAction(class_1657 player, class_1937 world) {
        UUID playerId = player.method_5667();
        if (this.isCoolingDownOrExecuting(playerId)) {
            return;
        }
        this.markExecuting(playerId);
        try {
            PlayerUndoRedoStacks stacks = this.playerStacks.get(playerId);
            if (stacks != null && !stacks.redoStack.isEmpty()) {
                UndoAction action = stacks.redoStack.pop();
                boolean success = this.executeUndoRedoAction(action, player, world, false);
                if (success) {
                    stacks.undoStack.push(action);
                    LOGGER.debug("\u73a9\u5bb6 {} \u91cd\u505a\u6210\u529f\uff0c\u7c7b\u578b\uff1a{}\uff0c\u6d89\u53ca {} \u4e2a\u65b9\u5757", new Object[]{player.method_5477().getString(), action.getType(), action.getPositions().size()});
                } else {
                    LOGGER.warn("\u73a9\u5bb6 {} \u91cd\u505a\u5931\u8d25\uff0c\u64cd\u4f5c\u88ab\u5ffd\u7565", (Object)player.method_5477().getString());
                }
            } else {
                LOGGER.debug("\u73a9\u5bb6 {} \u5c1d\u8bd5\u91cd\u505a\uff0c\u4f46\u6ca1\u6709\u53ef\u91cd\u505a\u7684\u64cd\u4f5c", (Object)player.method_5477().getString());
            }
        }
        finally {
            this.updateCooldown(playerId);
            this.unmarkExecuting(playerId);
        }
    }

    private boolean executeUndoRedoAction(UndoAction action, class_1657 player, class_1937 world, boolean isUndo) {
        if (!(world instanceof class_3218)) {
            LOGGER.error("Action must be performed on the server side.");
            return false;
        }
        class_3218 serverWorld = (class_3218)world;
        if (action == null || player == null) {
            LOGGER.error("Invalid action or player.");
            return false;
        }
        if (!action.isValid()) {
            LOGGER.error("Invalid action data.");
            return false;
        }
        List<class_2338> positions = action.getPositions();
        List<class_2680> originalStates = action.getOriginalStates();
        List<class_2680> newStates = action.getNewStates();
        LOGGER.debug("\u5f00\u59cb\u6267\u884c{}\u64cd\u4f5c\uff0c\u73a9\u5bb6: {}\uff0c\u6d89\u53ca {} \u4e2a\u65b9\u5757", new Object[]{isUndo ? "\u64a4\u9500" : "\u91cd\u505a", player.method_5477().getString(), positions.size()});
        int BATCH_FLAGS = 35;
        boolean isLarge = positions.size() >= 4096;
        ArrayList<class_2338> validPositions = new ArrayList<class_2338>(positions.size());
        ArrayList<class_2680> validNewStates = new ArrayList<class_2680>(positions.size());
        int skipped = 0;
        for (int i = 0; i < positions.size(); ++i) {
            class_2338 pos = positions.get(i);
            if (this.isValidPosition(pos, serverWorld)) {
                validPositions.add(pos);
                validNewStates.add(isUndo ? originalStates.get(i) : newStates.get(i));
                continue;
            }
            ++skipped;
        }
        if (skipped > 0) {
            LOGGER.debug("\u4f4d\u7f6e\u9a8c\u8bc1\u8df3\u8fc7 {} \u4e2a\u4e0d\u53ef\u7528\u4f4d\u7f6e", (Object)skipped);
        }
        BlockOperation.batchSetBlockStates(validPositions, validNewStates, (class_1937)serverWorld, 35);
        class_3568 lightProvider = serverWorld.method_22336();
        if (!isLarge) {
            for (class_2338 class_23382 : validPositions) {
                try {
                    lightProvider.method_15513(class_23382);
                    class_2680 class_26802 = serverWorld.method_8320(class_23382);
                    serverWorld.method_8408(class_23382, class_26802.method_26204());
                    serverWorld.method_8455(class_23382, class_26802.method_26204());
                }
                catch (Exception exception) {
                    LOGGER.warn("\u66f4\u65b0\u4f4d\u7f6e\u5931\u8d25: {}", (Object)class_23382, (Object)exception);
                }
            }
        } else {
            HashMap<Long, Integer> xzToTopY = new HashMap<Long, Integer>();
            for (class_2338 class_23383 : validPositions) {
                long key = (long)class_23383.method_10263() << 32 ^ (long)class_23383.method_10260() & 0xFFFFFFFFL;
                xzToTopY.merge(key, class_23383.method_10264(), Math::max);
            }
            for (Map.Entry entry : xzToTopY.entrySet()) {
                int x = (int)((Long)entry.getKey() >> 32);
                int z = (int)((Long)entry.getKey()).longValue();
                int topY = (Integer)entry.getValue();
                try {
                    lightProvider.method_15513(new class_2338(x, topY, z));
                    lightProvider.method_15513(new class_2338(x, topY + 1, z));
                }
                catch (Exception exception) {}
            }
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (!isLarge) {
                for (class_2338 class_23384 : validPositions) {
                    try {
                        class_2680 currentState = serverWorld.method_8320(class_23384);
                        serverPlayer.field_13987.method_14364((class_2596)new class_2626(class_23384, currentState));
                    }
                    catch (Exception e) {
                        LOGGER.warn("\u53d1\u9001\u65b9\u5757\u66f4\u65b0\u5931\u8d25: {}", (Object)class_23384, (Object)e);
                    }
                }
            } else {
                HashSet<class_1923> hashSet = new HashSet<class_1923>();
                for (class_2338 pos : validPositions) {
                    hashSet.add(new class_1923(pos));
                }
                this.sendChunks(serverWorld, serverPlayer, hashSet, lightProvider, "\u5927\u64cd\u4f5c\u5feb\u901f\u540c\u6b65");
                serverWorld.method_8503().execute(() -> this.sendChunks(serverWorld, serverPlayer, affectedChunks, lightProvider, "\u5ef6\u8fdf\u5149\u7167\u540c\u6b65"));
            }
        }
        LOGGER.debug("\u5b8c\u6210{}\u64cd\u4f5c\uff0c\u5df2\u66f4\u65b0\u6709\u6548\u4f4d\u7f6e: {} (\u5927\u64cd\u4f5c: {})", new Object[]{isUndo ? "\u64a4\u9500" : "\u91cd\u505a", validPositions.size(), isLarge});
        return true;
    }

    private void sendChunks(class_3218 serverWorld, class_3222 serverPlayer, Set<class_1923> chunks, class_3568 lightProvider, String reason) {
        int sent = 0;
        for (class_1923 chunkPos : chunks) {
            try {
                class_2818 chunk = serverWorld.method_8497(chunkPos.field_9181, chunkPos.field_9180);
                if (chunk == null) continue;
                serverPlayer.field_13987.method_14364((class_2596)new class_2672(chunk, lightProvider, null, null));
                ++sent;
            }
            catch (Exception e) {
                LOGGER.warn("\u53d1\u9001\u533a\u5757\u6570\u636e\u5931\u8d25: {}", (Object)chunkPos, (Object)e);
            }
        }
        LOGGER.debug("{}\uff1a\u53d1\u9001 {} \u4e2a\u533a\u5757\u5230\u73a9\u5bb6 {}", new Object[]{reason, sent, serverPlayer.method_5477().getString()});
    }

    private boolean isValidPosition(class_2338 pos, class_3218 world) {
        try {
            if (pos.method_10264() < world.method_31607() || pos.method_10264() > world.method_31605()) {
                return false;
            }
            return world.method_37116(new class_1923(pos).method_8324());
        }
        catch (Exception e) {
            LOGGER.warn("\u4f4d\u7f6e\u9a8c\u8bc1\u5931\u8d25: {}", (Object)pos, (Object)e);
            return false;
        }
    }

    private boolean isCoolingDownOrExecuting(UUID playerId) {
        long now = System.currentTimeMillis();
        Long last = this.lastActionTime.get(playerId);
        if (this.executingPlayers.contains(playerId)) {
            return true;
        }
        return last != null && now - last < 300L;
    }

    private void updateCooldown(UUID playerId) {
        this.lastActionTime.put(playerId, System.currentTimeMillis());
    }

    private void markExecuting(UUID playerId) {
        this.executingPlayers.add(playerId);
    }

    private void unmarkExecuting(UUID playerId) {
        this.executingPlayers.remove(playerId);
    }

    public void debugPlayerStacks(class_1657 player) {
        UUID playerId = player.method_5667();
        PlayerUndoRedoStacks stacks = this.playerStacks.get(playerId);
        if (stacks == null) {
            LOGGER.debug("\u73a9\u5bb6 {} \u6ca1\u6709\u64a4\u9500\u6808", (Object)player.method_5477().getString());
        } else {
            LOGGER.debug("\u73a9\u5bb6 {} \u7684\u64a4\u9500\u6808\u72b6\u6001: undoStack={}, redoStack={}", new Object[]{player.method_5477().getString(), stacks.undoStack.size(), stacks.redoStack.size()});
            if (!stacks.undoStack.isEmpty()) {
                UndoAction topAction = stacks.undoStack.peek();
                LOGGER.debug("\u6808\u9876\u64cd\u4f5c: \u7c7b\u578b={}, \u65b9\u5757\u6570={}", (Object)topAction.getType(), (Object)topAction.getPositions().size());
            }
        }
    }

    public int getUndoStackSize(class_1657 player) {
        UUID playerId = player.method_5667();
        PlayerUndoRedoStacks stacks = this.playerStacks.get(playerId);
        return stacks != null ? stacks.undoStack.size() : 0;
    }

    private static class PlayerUndoRedoStacks {
        final Deque<UndoAction> undoStack = new ArrayDeque<UndoAction>();
        final Deque<UndoAction> redoStack = new ArrayDeque<UndoAction>();

        private PlayerUndoRedoStacks() {
        }
    }
}

