/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.shapes;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.shapes.BoxShape;
import com.pushdozer.shapes.ConeShape;
import com.pushdozer.shapes.CylinderShape;
import com.pushdozer.shapes.EllipsoidShape;
import com.pushdozer.shapes.GeometryShape;
import com.pushdozer.shapes.OctahedronShape;
import com.pushdozer.shapes.SphereShape;
import com.pushdozer.shapes.TetrahedronShape;
import com.pushdozer.shapes.TriangularPrismShape;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public class GeometryShapeFactory {
    public static GeometryShape createShape(String shapeType, PushdozerConfig config, class_2338 center) {
        String lowerShapeType;
        return switch (lowerShapeType = shapeType.toLowerCase()) {
            case "sphere" -> new SphereShape(config.getSphereRadius(), class_243.method_24953((class_2382)center));
            case "octahedron" -> new OctahedronShape(config.getOctahedronRadius(), center);
            case "cylinder" -> new CylinderShape(config.getCylinderRadius(), config.getCylinderHeight(), center);
            case "cone" -> new ConeShape(config.getConeRadius(), config.getConeHeight(), center);
            case "ellipsoid" -> new EllipsoidShape(config.getLength(), config.getEllipsoidHeight(), config.getWidth(), center);
            case "tetrahedron" -> new TetrahedronShape((double)config.getTetrahedronEdgeLength(), center);
            case "triangular_prism" -> new TriangularPrismShape((double)config.getTriangularPrismSideLength(), (double)config.getTriangularPrismHeight(), center);
            default -> new BoxShape(config.getLength(), config.getWidth(), config.getBoxHeight(), center);
        };
    }

    public static GeometryShape createShape(PushdozerConfig.GeometryType geometryType, PushdozerConfig config, class_2338 center) {
        return GeometryShapeFactory.createShape(geometryType.getShapeString(), config, center);
    }
}

