/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.panels.brushgeometry;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.ui.screens.PushdozerConfigScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5348;

public abstract class GeometrySubPanel {
    protected PushdozerConfigScreen parent;
    protected PushdozerConfig config;
    protected List<class_364> widgets = new ArrayList<class_364>();
    protected class_4185 confirmButton;
    protected class_327 textRenderer;
    protected static final int PANEL_WIDTH = 210;
    protected static final int PANEL_HEIGHT = 125;
    protected static final int TITLE_HEIGHT = 20;
    protected static final int SLIDER_HEIGHT = 20;
    protected static final int WIDGET_MARGIN_VERTICAL = 5;
    protected static final int WIDGET_MARGIN_HORIZONTAL = 5;
    protected static final int CONFIRM_BUTTON_HEIGHT = 20;
    protected static final int CONFIRM_BUTTON_MARGIN = 5;
    protected static final int MAX_VALUE = 64;
    protected int panelLeft;
    protected int panelTop;
    private boolean visible = false;

    public GeometrySubPanel(PushdozerConfigScreen parent, PushdozerConfig config) {
        this.parent = parent;
        this.config = config;
        this.textRenderer = class_310.method_1551().field_1772;
    }

    public void init() {
        this.widgets.clear();
        this.initPanel();
        this.initConfirmButton();
        this.panelLeft = (this.parent.getScreenWidth() - 210) / 2;
        this.panelTop = (this.parent.getScreenHeight() - this.getPanelHeight()) / 2;
        this.updateWidgetPositions();
    }

    protected int getPanelHeight() {
        int contentHeight = this.calculateContentHeight();
        return 20 + contentHeight + 20 + 5;
    }

    protected int calculateContentHeight() {
        int widgetCount = this.widgets.size() - 1;
        if (widgetCount <= 0) {
            return 10;
        }
        return widgetCount * 20 + (widgetCount - 1) * 5 + 5 + 5;
    }

    protected void updateWidgetPositions() {
        if (this.confirmButton != null) {
            int confirmButtonY = this.panelTop + this.getPanelHeight() - 20 - 5;
            this.confirmButton.method_48229(this.panelLeft + 5, confirmButtonY);
            this.confirmButton.method_25358(200);
        }
    }

    public abstract void initPanel();

    public abstract void render(class_332 var1, int var2, int var3, float var4);

    public abstract void saveConfig();

    protected CustomSliderWidget addSlider(int index, class_2561 label, int value) {
        int y = this.panelTop + 20 + 5 + index * 25;
        CustomSliderWidget slider = new CustomSliderWidget(this.panelLeft + 5, y, 200, 20, label.getString(), 1, 64, value, newValue -> this.updatePreview());
        this.widgets.add((class_364)slider);
        return slider;
    }

    protected int getSliderValue(CustomSliderWidget slider) {
        return slider.getIntValue();
    }

    public void show() {
        this.visible = true;
        this.panelLeft = (this.parent.getScreenWidth() - 210) / 2;
        this.panelTop = (this.parent.getScreenHeight() - this.getPanelHeight()) / 2;
        this.init();
    }

    public void hide() {
        this.visible = false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void initConfirmButton() {
        int confirmButtonY = this.panelTop + this.getPanelHeight() - 20 - 5;
        this.confirmButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.button.done"), button -> {
            this.saveConfig();
            this.closeSubPanel();
        }).method_46434(this.panelLeft + 5, confirmButtonY, 200, 20).method_46431();
        this.widgets.add((class_364)this.confirmButton);
    }

    protected void closeSubPanel() {
        this.hide();
        this.parent.hideSubPanel();
        this.parent.showMainPanel();
    }

    public List<class_364> getWidgets() {
        return this.widgets;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (class_364 widget : this.widgets) {
            if (!widget.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (class_364 widget : this.widgets) {
            if (!widget.method_25403(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (class_364 widget : this.widgets) {
            if (!widget.method_25406(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    protected void renderPanelBackground(class_332 context) {
        context.method_25294(this.panelLeft, this.panelTop, this.panelLeft + 210, this.panelTop + this.getPanelHeight(), -1072689136);
        context.method_25294(this.panelLeft, this.panelTop, this.panelLeft + 210, this.panelTop + 20, -533712848);
        context.method_49601(this.panelLeft, this.panelTop, 210, this.getPanelHeight(), -1);
    }

    protected void renderTitle(class_332 context, class_2561 title) {
        if (this.textRenderer != null) {
            int titleWidth = this.textRenderer.method_27525((class_5348)title);
            context.method_51439(this.textRenderer, title, this.panelLeft + (210 - titleWidth) / 2, this.panelTop + 5, 0xFFFFFF, false);
        }
    }

    protected abstract void updatePreview();

    protected static class CustomSliderWidget
    extends class_357 {
        private final String label;
        private final int min;
        private final int max;
        private final Consumer<Integer> onValueChange;

        public CustomSliderWidget(int x, int y, int width, int height, String label, int min, int max, int initialValue, Consumer<Integer> onValueChange) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), (double)(initialValue - min) / (double)(max - min));
            this.label = label;
            this.min = min;
            this.max = max;
            this.onValueChange = onValueChange;
            this.method_25346();
        }

        protected void method_25346() {
            this.method_25355(class_2561.method_30163((String)(this.label + ": " + this.getIntValue())));
        }

        protected void method_25344() {
            if (this.onValueChange != null) {
                this.onValueChange.accept(this.getIntValue());
            }
        }

        public int getIntValue() {
            return (int)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.min, (double)this.max));
        }
    }
}

