/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.panels.workmode;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.ui.panels.workmode.WorkModeConfigPanel;
import com.pushdozer.ui.screens.NaturalBlockSelectionScreen;
import com.pushdozer.ui.screens.PushdozerConfigScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class SurfaceConvertConfigPanel
extends WorkModeConfigPanel {
    private List<BlockConfigRow> blockRows = new ArrayList<BlockConfigRow>();
    private int panelHeight;
    private static final int MAX_BLOCKS = 5;
    private static final int ROW_HEIGHT = 20;
    private static final int BLOCK_ICON_SIZE = 20;

    public SurfaceConvertConfigPanel(PushdozerConfigScreen parent, PushdozerConfig config) {
        super(parent, config);
    }

    @Override
    protected class_2561 getTitleText() {
        return class_2561.method_43471((String)"pushdozer.mode.surface_convert");
    }

    @Override
    protected int getPanelHeight() {
        return this.panelHeight;
    }

    @Override
    protected void initializeWidgets() {
        this.widgets.clear();
        if (this.blockRows == null) {
            this.blockRows = new ArrayList<BlockConfigRow>();
        } else {
            this.blockRows.clear();
        }
        int tempPanelTop = 0;
        int contentTop = tempPanelTop + 20 + 5;
        List<PushdozerConfig.SurfaceConvertBlock> surfaceBlocks = this.config.getSurfaceConvertBlocks();
        int currentY = contentTop;
        for (int i = 0; i < surfaceBlocks.size() && i < 5; ++i) {
            currentY += 25;
        }
        if (surfaceBlocks.size() == 1) {
            currentY += 25;
            currentY += 20;
            currentY += 5;
        } else if (surfaceBlocks.size() >= 2 && surfaceBlocks.size() < 5) {
            currentY += 25;
            currentY += 20;
            currentY += 5;
        } else if (surfaceBlocks.size() == 5) {
            currentY += 20;
            currentY += 5;
        }
        int calculatedPanelHeight = currentY - tempPanelTop;
        if (this.parent != null) {
            int screenWidth = this.parent.getScreenWidth();
            int screenHeight = this.parent.getScreenHeight();
            this.panelLeft = (screenWidth - 210) / 2;
            this.panelTop = (screenHeight - calculatedPanelHeight) / 2;
        }
        this.panelHeight = calculatedPanelHeight;
        if (this.parent != null) {
            this.initializeTitlePosition();
        }
        int contentLeft = this.panelLeft + 5;
        contentTop = this.panelTop + 20 + 5;
        int contentWidth = 200;
        currentY = contentTop;
        for (int i = 0; i < surfaceBlocks.size() && i < 5; ++i) {
            PushdozerConfig.SurfaceConvertBlock block = surfaceBlocks.get(i);
            BlockConfigRow row = new BlockConfigRow(contentLeft, currentY, contentWidth, block, i);
            this.blockRows.add(row);
            this.widgets.addAll(row.getWidgets());
            currentY += 25;
        }
        if (surfaceBlocks.size() == 1) {
            class_4185 addBlockButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.config.add_block"), button -> this.addNewBlock()).method_46434(contentLeft, currentY, contentWidth, 20).method_46431();
            this.widgets.add(addBlockButton);
            this.confirmButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.button.done"), button -> {
                this.saveConfig();
                this.closeSubPanel();
            }).method_46434(contentLeft, currentY += 25, contentWidth, 20).method_46431();
            this.widgets.add(this.confirmButton);
        } else if (surfaceBlocks.size() >= 2 && surfaceBlocks.size() < 5) {
            halfWidth = (contentWidth - 5) / 2;
            class_4185 addBlockButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.config.add_block"), button -> this.addNewBlock()).method_46434(contentLeft, currentY, halfWidth, 20).method_46431();
            this.widgets.add(addBlockButton);
            class_4185 normalizeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.config.normalize_percentages"), button -> this.normalizePercentages()).method_46434(contentLeft + halfWidth + 5, currentY, halfWidth, 20).method_46431();
            this.widgets.add(normalizeButton);
            this.confirmButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.button.done"), button -> {
                this.saveConfig();
                this.closeSubPanel();
            }).method_46434(contentLeft, currentY += 25, contentWidth, 20).method_46431();
            this.widgets.add(this.confirmButton);
        } else if (surfaceBlocks.size() == 5) {
            halfWidth = (contentWidth - 5) / 2;
            class_4185 normalizeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.config.normalize_percentages"), button -> this.normalizePercentages()).method_46434(contentLeft, currentY, halfWidth, 20).method_46431();
            this.widgets.add(normalizeButton);
            this.confirmButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.button.done"), button -> {
                this.saveConfig();
                this.closeSubPanel();
            }).method_46434(contentLeft + halfWidth + 5, currentY, halfWidth, 20).method_46431();
            this.widgets.add(this.confirmButton);
        }
    }

    private void addSelectedBlock(class_2248 block) {
        List<PushdozerConfig.SurfaceConvertBlock> surfaceBlocks = this.config.getSurfaceConvertBlocks();
        String blockId = class_7923.field_41175.method_10221((Object)block).toString();
        boolean exists = surfaceBlocks.stream().anyMatch(b -> b.getBlockId().equals(blockId));
        if (!exists && surfaceBlocks.size() < 5) {
            surfaceBlocks.add(new PushdozerConfig.SurfaceConvertBlock(blockId, 0.0f));
            this.normalizePercentages();
        }
    }

    private void addNewBlock() {
        if (this.parent.getClient() != null) {
            this.parent.getClient().method_1507((class_437)new NaturalBlockSelectionScreen(this.parent, this::addSelectedBlock));
        }
    }

    private void removeBlock(int index) {
        List<PushdozerConfig.SurfaceConvertBlock> surfaceBlocks = this.config.getSurfaceConvertBlocks();
        if (index >= 0 && index < surfaceBlocks.size() && surfaceBlocks.size() > 1) {
            surfaceBlocks.remove(index);
            this.initializeWidgets();
        }
    }

    private void normalizePercentages() {
        List<PushdozerConfig.SurfaceConvertBlock> surfaceBlocks = this.config.getSurfaceConvertBlocks();
        if (surfaceBlocks.size() == 1) {
            surfaceBlocks.getFirst().setPercentage(100.0f);
        } else if (surfaceBlocks.size() > 1) {
            float equalPercentage = 100.0f / (float)surfaceBlocks.size();
            for (PushdozerConfig.SurfaceConvertBlock block : surfaceBlocks) {
                block.setPercentage(equalPercentage);
            }
        }
        this.initializeWidgets();
    }

    @Override
    protected void renderBackground(class_332 context) {
        context.method_25294(this.panelLeft, this.panelTop, this.panelLeft + 210, this.panelTop + this.panelHeight, -1072689136);
        context.method_25294(this.panelLeft, this.panelTop, this.panelLeft + 210, this.panelTop + 20, -533712848);
        context.method_49601(this.panelLeft, this.panelTop, 210, this.panelHeight, -1);
    }

    @Override
    protected void renderWidgets(class_332 context, int mouseX, int mouseY, float delta) {
        super.renderWidgets(context, mouseX, mouseY, delta);
        if (this.blockRows != null) {
            for (BlockConfigRow row : this.blockRows) {
                row.renderBlockIcon(context, mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        for (class_364 widget : this.widgets) {
            if (!widget.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        if (mouseX >= (double)this.panelLeft && mouseX <= (double)(this.panelLeft + 210) && mouseY >= (double)this.panelTop && mouseY <= (double)(this.panelTop + this.panelHeight)) {
            return true;
        }
        this.hide();
        this.parent.showMainPanel();
        return true;
    }

    @Override
    public void saveConfig() {
        try {
            this.config.save();
            this.parent.showErrorMessage(class_2561.method_43471((String)"pushdozer.config.saved").getString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void show() {
        this.visible = true;
        this.panelLeft = (this.parent.getScreenWidth() - 210) / 2;
        this.widgets.clear();
        this.confirmButton = null;
        this.initializeWidgets();
        this.panelTop = (this.parent.getScreenHeight() - this.getPanelHeight()) / 2;
        this.recalculateAllWidgetPositions();
    }

    @Override
    protected void recalculateAllWidgetPositions() {
        this.initializeTitlePosition();
        this.recalculateContentWidgetPositions();
    }

    @Override
    protected void recalculateContentWidgetPositions() {
        int contentLeft = this.panelLeft + 5;
        int contentTop = this.panelTop + 20 + 5;
        int contentWidth = 200;
        int currentY = contentTop;
        for (BlockConfigRow row : this.blockRows) {
            row.recalculatePosition(contentLeft, currentY, contentWidth);
            currentY += 25;
        }
        List<PushdozerConfig.SurfaceConvertBlock> surfaceBlocks = this.config.getSurfaceConvertBlocks();
        if (surfaceBlocks.size() == 1) {
            if (this.widgets.size() >= 2) {
                class_339 clickableWidget;
                Object e = this.widgets.get(this.widgets.size() - 2);
                if (e instanceof class_339) {
                    clickableWidget = (class_339)e;
                    clickableWidget.method_48229(contentLeft, currentY);
                }
                currentY += 25;
                e = this.widgets.getLast();
                if (e instanceof class_339) {
                    clickableWidget = (class_339)e;
                    clickableWidget.method_48229(contentLeft, currentY);
                }
            }
        } else if (surfaceBlocks.size() >= 2 && surfaceBlocks.size() < 5) {
            int halfWidth = (contentWidth - 5) / 2;
            if (this.widgets.size() >= 3) {
                class_339 clickableWidget;
                Object e = this.widgets.get(this.widgets.size() - 3);
                if (e instanceof class_339) {
                    clickableWidget = (class_339)e;
                    clickableWidget.method_48229(contentLeft, currentY);
                }
                if ((e = this.widgets.get(this.widgets.size() - 2)) instanceof class_339) {
                    clickableWidget = (class_339)e;
                    clickableWidget.method_48229(contentLeft + halfWidth + 5, currentY);
                }
                currentY += 25;
                e = this.widgets.getLast();
                if (e instanceof class_339) {
                    clickableWidget = (class_339)e;
                    clickableWidget.method_48229(contentLeft, currentY);
                }
            }
        } else if (surfaceBlocks.size() == 5) {
            int halfWidth = (contentWidth - 5) / 2;
            if (this.widgets.size() >= 2) {
                class_339 clickableWidget;
                Object e = this.widgets.get(this.widgets.size() - 2);
                if (e instanceof class_339) {
                    clickableWidget = (class_339)e;
                    clickableWidget.method_48229(contentLeft, currentY);
                }
                if ((e = this.widgets.getLast()) instanceof class_339) {
                    clickableWidget = (class_339)e;
                    clickableWidget.method_48229(contentLeft + halfWidth + 5, currentY);
                }
            }
        }
    }

    private class BlockConfigRow {
        private final PushdozerConfig.SurfaceConvertBlock block;
        private final int index;
        private final int x;
        private final int y;
        private final int width;
        private class_4185 removeButton;
        private PercentageSlider percentageSlider;
        private List<class_364> rowWidgets = new ArrayList<class_364>();

        public BlockConfigRow(int x, int y, int width, PushdozerConfig.SurfaceConvertBlock block, int index) {
            this.block = block;
            this.index = index;
            this.x = x;
            this.y = y;
            this.width = width;
            this.initializeRowWidgets();
        }

        private void initializeRowWidgets() {
            List<PushdozerConfig.SurfaceConvertBlock> surfaceBlocks = SurfaceConvertConfigPanel.this.config.getSurfaceConvertBlocks();
            int sliderX = this.x + 20 + 5;
            int sliderWidth = this.width - 20 - 5;
            if (surfaceBlocks.size() > 1) {
                this.removeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00d7"), button -> SurfaceConvertConfigPanel.this.removeBlock(this.index)).method_46434(this.x + 20 + 5, this.y, 20, 20).method_46431();
                this.rowWidgets.add((class_364)this.removeButton);
                sliderX = this.x + 20 + 30;
                sliderWidth = this.width - 20 - 30;
            }
            this.percentageSlider = new PercentageSlider(sliderX, this.y, sliderWidth, 20, this.block.getPercentage(), this.block);
            this.percentageSlider.updateValueFromConfig();
            this.rowWidgets.add((class_364)this.percentageSlider);
        }

        public List<class_364> getWidgets() {
            return this.rowWidgets;
        }

        public void renderBlockIcon(class_332 context, int mouseX, int mouseY) {
            try {
                class_2248 blockType = (class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)this.block.getBlockId()));
                class_1799 itemStack = this.getDisplayStack(blockType);
                context.method_25294(this.x, this.y, this.x + 20, this.y + 20, -13158601);
                context.method_49601(this.x, this.y, 20, 20, -7631989);
                if (!itemStack.method_7960()) {
                    context.method_51427(itemStack, this.x + 2, this.y + 2);
                }
                if (mouseX >= this.x && mouseX < this.x + 20 && mouseY >= this.y && mouseY < this.y + 20) {
                    class_5250 tooltipText = blockType.method_9518();
                    context.method_51438(SurfaceConvertConfigPanel.this.parent.getTextRenderer(), (class_2561)tooltipText, mouseX, mouseY);
                }
            }
            catch (Exception e) {
                context.method_25294(this.x, this.y, this.x + 20, this.y + 20, -65536);
            }
        }

        private class_1799 getDisplayStack(class_2248 block) {
            if (block == class_2246.field_10382) {
                return class_1802.field_8705.method_7854();
            }
            if (block == class_2246.field_10164) {
                return class_1802.field_8187.method_7854();
            }
            if (block == class_2246.field_10110) {
                return new class_1799((class_1935)class_2246.field_10295);
            }
            if (block == class_2246.field_10238) {
                return class_1802.field_8158.method_7854();
            }
            if (block == class_2246.field_10463) {
                return class_1802.field_17532.method_7854();
            }
            if (block == class_2246.field_22124) {
                return class_1802.field_21992.method_7854();
            }
            if (block == class_2246.field_23079) {
                return class_1802.field_23070.method_7854();
            }
            String translationKey = block.method_9539();
            if (translationKey.contains("wall_sign")) {
                String baseSignKey = translationKey.replace("wall_sign", "sign");
                try {
                    class_2248 baseSign = (class_2248)class_7923.field_41175.method_10223(class_7923.field_41175.method_10221((Object)block).method_45136(baseSignKey));
                    if (baseSign != class_2246.field_10124) {
                        return baseSign.method_8389().method_7854();
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to find base sign for wall sign: " + block.method_9539() + ", using original block");
                }
            }
            if (block == class_2246.field_10293) {
                return class_1802.field_8317.method_7854();
            }
            if (block == class_2246.field_10609) {
                return class_1802.field_8179.method_7854();
            }
            if (block == class_2246.field_10247) {
                return class_1802.field_8567.method_7854();
            }
            if (block == class_2246.field_10341) {
                return class_1802.field_8186.method_7854();
            }
            if (block == class_2246.field_10036) {
                return class_1802.field_8884.method_7854();
            }
            String blockId = class_7923.field_41175.method_10221((Object)block).method_12832();
            if (blockId.contains("wall_head") || blockId.contains("wall_skull")) {
                String baseHeadId = blockId.replace("wall_", "");
                try {
                    class_2248 baseHead = (class_2248)class_7923.field_41175.method_10223(class_7923.field_41175.method_10221((Object)block).method_45136(baseHeadId));
                    if (baseHead != class_2246.field_10124) {
                        return baseHead.method_8389().method_7854();
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to find base head for wall head: " + block.method_9539() + ", using original block");
                }
            }
            if (block == class_2246.field_9987) {
                return class_1802.field_8542.method_7854();
            }
            if (block == class_2246.field_10525) {
                return class_1802.field_8866.method_7854();
            }
            if (block == class_2246.field_10465) {
                return class_1802.field_8238.method_7854();
            }
            if (block == class_2246.field_16540) {
                return class_1802.field_16538.method_7854();
            }
            if (block == class_2246.field_10499) {
                return class_1802.field_8077.method_7854();
            }
            if (block == class_2246.field_31037) {
                return class_1802.field_30904.method_7854();
            }
            if (block == class_2246.field_10260) {
                return class_1802.field_8849.method_7854();
            }
            if (block == class_2246.field_47336) {
                return class_1802.field_47314.method_7854();
            }
            if (block == class_2246.field_10081) {
                return class_1802.field_8840.method_7854();
            }
            if (block == class_2246.field_10027) {
                return class_1802.field_8827.method_7854();
            }
            if (block == class_2246.field_10613) {
                return class_1802.field_8827.method_7854();
            }
            if (block == class_2246.field_10316) {
                return class_1802.field_8281.method_7854();
            }
            if (block == class_2246.field_10398) {
                return class_1802.field_8827.method_7854();
            }
            if (block == class_2246.field_9974) {
                return class_1802.field_8790.method_7854();
            }
            if (block == class_2246.field_22121) {
                return class_1802.field_21987.method_7854();
            }
            if (block == class_2246.field_22114) {
                return class_1802.field_21988.method_7854();
            }
            if (block == class_2246.field_22125) {
                return class_1802.field_21989.method_7854();
            }
            if (block == class_2246.field_22116) {
                return class_1802.field_21990.method_7854();
            }
            if (block == class_2246.field_22117) {
                return class_1802.field_21991.method_7854();
            }
            if (block == class_2246.field_22123) {
                return class_1802.field_21992.method_7854();
            }
            if (block == class_2246.field_23078) {
                return class_1802.field_23070.method_7854();
            }
            if (block == class_2246.field_22122) {
                return class_1802.field_22017.method_7854();
            }
            if (block == class_2246.field_28411) {
                return class_1802.field_28409.method_7854();
            }
            if (block == class_2246.field_37569) {
                return class_1802.field_37524.method_7854();
            }
            if (block == class_2246.field_37570) {
                return class_1802.field_37525.method_7854();
            }
            if (block == class_2246.field_37571) {
                return class_1802.field_37538.method_7854();
            }
            if (block == class_2246.field_28108) {
                return class_1802.field_28101.method_7854();
            }
            if (block == class_2246.field_43231) {
                return class_1802.field_43194.method_7854();
            }
            if (block == class_2246.field_37568) {
                return class_1802.field_37523.method_7854();
            }
            class_1799 itemStack = block.method_8389().method_7854();
            if (itemStack.method_7960()) {
                if (block == class_2246.field_10124) {
                    return class_1799.field_8037;
                }
                if (block == class_2246.field_10543) {
                    return class_1799.field_8037;
                }
                if (block == class_2246.field_10243) {
                    return class_1799.field_8037;
                }
                if (block == class_2246.field_10369) {
                    return class_1799.field_8037;
                }
                if (block == class_2246.field_10027) {
                    return class_1799.field_8037;
                }
                if (block == class_2246.field_10613) {
                    return class_1799.field_8037;
                }
                if (block == class_2246.field_10316) {
                    return class_1799.field_8037;
                }
                if (block == class_2246.field_31037) {
                    return class_1799.field_8037;
                }
                String blockIdPath = class_7923.field_41175.method_10221((Object)block).method_12832().toLowerCase();
                if (blockIdPath.contains("portal")) {
                    return class_1802.field_8281.method_7854();
                }
                if (blockIdPath.contains("light")) {
                    return class_1802.field_8801.method_7854();
                }
                if (blockIdPath.contains("air")) {
                    return class_1799.field_8037;
                }
                if (blockIdPath.contains("void")) {
                    return class_1799.field_8037;
                }
                return class_1802.field_20391.method_7854();
            }
            return itemStack;
        }

        public void recalculatePosition(int newX, int newY, int newWidth) {
            List<PushdozerConfig.SurfaceConvertBlock> surfaceBlocks = SurfaceConvertConfigPanel.this.config.getSurfaceConvertBlocks();
            int sliderX = newX + 20 + 5;
            if (surfaceBlocks.size() > 1) {
                if (this.removeButton != null) {
                    this.removeButton.method_48229(newX + 20 + 5, newY);
                }
                sliderX = newX + 20 + 30;
            }
            if (this.percentageSlider != null) {
                this.percentageSlider.method_48229(sliderX, newY);
            }
        }
    }

    private class PercentageSlider
    extends class_357 {
        private final PushdozerConfig.SurfaceConvertBlock block;

        public PercentageSlider(int x, int y, int width, int height, float percentage, PushdozerConfig.SurfaceConvertBlock block) {
            super(x, y, width, height, (class_2561)class_2561.method_43469((String)"pushdozer.config.percentage", (Object[])new Object[]{String.format("%.1f", Float.valueOf(percentage))}), PercentageSlider.getInitialValue(percentage));
            this.block = block;
        }

        private static double getInitialValue(float percentage) {
            return (double)percentage / 100.0;
        }

        protected void method_25346() {
            float percentage = (float)(this.field_22753 * 100.0);
            this.method_25355((class_2561)class_2561.method_43469((String)"pushdozer.config.percentage", (Object[])new Object[]{String.format("%.1f", Float.valueOf(percentage))}));
        }

        protected void method_25344() {
            List<PushdozerConfig.SurfaceConvertBlock> surfaceBlocks = SurfaceConvertConfigPanel.this.config.getSurfaceConvertBlocks();
            if (surfaceBlocks.size() == 1) {
                this.block.setPercentage(100.0f);
                this.field_22753 = 1.0;
                this.method_25346();
                return;
            }
            float percentage = (float)(this.field_22753 * 100.0);
            this.block.setPercentage(percentage);
            this.adjustOtherPercentages(this.block, percentage);
            this.updateOtherSliders();
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            List<PushdozerConfig.SurfaceConvertBlock> surfaceBlocks = SurfaceConvertConfigPanel.this.config.getSurfaceConvertBlocks();
            if (surfaceBlocks.size() == 1) {
                return false;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            List<PushdozerConfig.SurfaceConvertBlock> surfaceBlocks = SurfaceConvertConfigPanel.this.config.getSurfaceConvertBlocks();
            if (surfaceBlocks.size() == 1) {
                return false;
            }
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            List<PushdozerConfig.SurfaceConvertBlock> surfaceBlocks = SurfaceConvertConfigPanel.this.config.getSurfaceConvertBlocks();
            if (surfaceBlocks.size() == 1) {
                return false;
            }
            return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }

        private void updateOtherSliders() {
            for (BlockConfigRow row : SurfaceConvertConfigPanel.this.blockRows) {
                if (row.percentageSlider == this) continue;
                row.percentageSlider.updateValueFromConfig();
            }
        }

        public void updateValueFromConfig() {
            List<PushdozerConfig.SurfaceConvertBlock> surfaceBlocks = SurfaceConvertConfigPanel.this.config.getSurfaceConvertBlocks();
            if (surfaceBlocks.size() == 1) {
                this.field_22753 = 1.0;
                this.block.setPercentage(100.0f);
            } else {
                this.field_22753 = (double)this.block.getPercentage() / 100.0;
            }
            this.method_25346();
        }

        private void adjustOtherPercentages(PushdozerConfig.SurfaceConvertBlock currentBlock, float currentPercentage) {
            List<PushdozerConfig.SurfaceConvertBlock> surfaceBlocks = SurfaceConvertConfigPanel.this.config.getSurfaceConvertBlocks();
            float otherTotal = 0.0f;
            int otherCount = 0;
            for (PushdozerConfig.SurfaceConvertBlock surfaceConvertBlock : surfaceBlocks) {
                if (surfaceConvertBlock == currentBlock) continue;
                otherTotal += surfaceConvertBlock.getPercentage();
                ++otherCount;
            }
            float remainingPercentage = 100.0f - currentPercentage;
            if (otherCount > 0 && remainingPercentage >= 0.0f) {
                for (PushdozerConfig.SurfaceConvertBlock block : surfaceBlocks) {
                    if (block == currentBlock) continue;
                    if (otherTotal > 0.0f) {
                        float ratio = block.getPercentage() / otherTotal;
                        block.setPercentage(remainingPercentage * ratio);
                        continue;
                    }
                    block.setPercentage(remainingPercentage / (float)otherCount);
                }
            }
            float f = 0.0f;
            PushdozerConfig.SurfaceConvertBlock largestBlock = null;
            float maxPercentage = -1.0f;
            for (PushdozerConfig.SurfaceConvertBlock b2 : surfaceBlocks) {
                f += b2.getPercentage();
                if (b2 == currentBlock || !(b2.getPercentage() > maxPercentage)) continue;
                maxPercentage = b2.getPercentage();
                largestBlock = b2;
            }
            if (largestBlock == null && !surfaceBlocks.isEmpty()) {
                largestBlock = surfaceBlocks.stream().filter(b -> b != currentBlock).findFirst().orElse(null);
            }
            if (largestBlock != null) {
                float difference = 100.0f - f;
                largestBlock.setPercentage(largestBlock.getPercentage() + difference);
            }
        }
    }
}

