/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.screens;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2320;
import net.minecraft.class_2473;
import net.minecraft.class_2541;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3481;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class MultiSelectPlantSelectionScreen
extends class_437 {
    private final class_437 parent;
    private final Consumer<List<class_2248>> onBlocksSelected;
    private final List<class_2248> plantBlocks;
    private List<class_2248> filteredBlocksCache;
    private String currentSearchText = "";
    private ScrollableBlockPanel scrollPanel;
    private final Set<class_2248> selectedBlocks = new HashSet<class_2248>();
    private final Map<String, List<class_2248>> categorizedBlocks = new HashMap<String, List<class_2248>>();
    private String currentCategory = "all";
    private final List<class_4185> categoryButtons = new ArrayList<class_4185>();
    private static List<class_2248> cachedPlantBlocks = null;
    private static Map<String, List<class_2248>> cachedCategorizedBlocks = null;
    private static long lastCacheTime = 0L;
    private static final long CACHE_DURATION = 30000L;
    private long lastSearchTime = 0L;
    private static final long SEARCH_DEBOUNCE_DELAY = 300L;
    private final List<class_2248> reusableFilteredList = new ArrayList<class_2248>();
    private static final int BLOCKS_PER_ROW = 8;
    private static final int BLOCK_SIZE = 20;
    private static final int BLOCK_SPACING = 4;
    private static final int BUTTON_HEIGHT = 20;
    private static final int SCROLL_BAR_WIDTH = 4;
    private static final int PANEL_PADDING = 5;
    private static final int ELEMENT_SPACING = 5;
    private static final int PANEL_BACKGROUND_COLOR = 0x40000000;
    private static final int BLOCK_BORDER_COLOR = -7631989;
    private static final int BLOCK_BACKGROUND_COLOR = -13158601;
    private static final int BLOCK_HOVER_COLOR = -11184811;
    private static final int SCROLL_BAR_BACKGROUND_COLOR = 0x33FFFFFF;
    private static final int SCROLL_BAR_COLOR = -5592406;
    private static final int SCROLL_BAR_HIGHLIGHT_COLOR = -1;
    private static final int SCROLL_BAR_SHADOW_COLOR = -11184811;
    private static final int SELECTED_BLOCK_BORDER_COLOR = -1;

    public MultiSelectPlantSelectionScreen(class_437 parent, Consumer<List<class_2248>> onBlocksSelected, List<class_2248> initialSelectedBlocks) {
        super((class_2561)class_2561.method_43471((String)"pushdozer.screen.plant_selection.title"));
        this.parent = parent;
        this.onBlocksSelected = onBlocksSelected;
        this.plantBlocks = new ArrayList<class_2248>();
        this.filteredBlocksCache = this.plantBlocks;
        if (initialSelectedBlocks != null) {
            this.selectedBlocks.addAll(initialSelectedBlocks);
        }
    }

    protected void method_25426() {
        super.method_25426();
        if (this.plantBlocks.isEmpty()) {
            if (this.field_22787 == null) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (cachedPlantBlocks == null || cachedCategorizedBlocks == null || currentTime - lastCacheTime > 30000L) {
                cachedPlantBlocks = this.getPlantBlocks();
                cachedCategorizedBlocks = MultiSelectPlantSelectionScreen.categorizeBlocksStatic(cachedPlantBlocks);
                lastCacheTime = currentTime;
            }
            cachedPlantBlocks = null;
            cachedCategorizedBlocks = null;
            cachedPlantBlocks = this.getPlantBlocks();
            cachedCategorizedBlocks = MultiSelectPlantSelectionScreen.categorizeBlocksStatic(cachedPlantBlocks);
            lastCacheTime = currentTime;
            this.plantBlocks.addAll(cachedPlantBlocks);
            this.categorizedBlocks.putAll(cachedCategorizedBlocks);
            this.filteredBlocksCache = this.plantBlocks;
        }
        int buttonWidth = 60;
        int buttonSpacing = 10;
        int totalButtonWidth = buttonWidth * 3 + buttonSpacing * 2;
        int buttonStartX = (this.field_22789 - totalButtonWidth) / 2;
        int searchBoxWidth = Math.min(Math.max((int)((double)this.field_22789 * 0.4), 200), 400);
        int searchBoxX = (this.field_22789 - searchBoxWidth) / 2;
        int buttonsY = this.field_22790 - 20 - 20;
        int searchBoxY = buttonsY - 5 - 20;
        int topMargin = 70;
        int bottomMargin = this.field_22790 - searchBoxY + 5;
        int panelContentWidth = 188;
        int panelWidth = panelContentWidth + 4 + 10;
        int panelX = (this.field_22789 - panelWidth) / 2;
        int panelHeight = Math.max(100, this.field_22790 - topMargin - bottomMargin);
        this.addCategoryButtons();
        this.updateCategoryButtonStates();
        this.scrollPanel = new ScrollableBlockPanel(panelX, topMargin, panelWidth, panelHeight, this.filteredBlocksCache);
        this.method_37063((class_364)this.scrollPanel);
        class_342 searchBox = new class_342(this.field_22793, searchBoxX, searchBoxY, searchBoxWidth, 20, (class_2561)class_2561.method_43473());
        searchBox.method_1880(50);
        searchBox.method_1858(true);
        searchBox.method_1862(true);
        searchBox.method_1888(true);
        searchBox.method_1852("");
        searchBox.method_1863(this::onSearchTextChanged);
        searchBox.method_47404((class_2561)class_2561.method_43471((String)"pushdozer.screen.plant_selection.search_hint"));
        this.method_37063((class_364)searchBox);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.button.select_all"), button -> this.selectAll()).method_46434(buttonStartX, buttonsY, buttonWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.button.clear_all"), button -> this.clearAll()).method_46434(buttonStartX + buttonWidth + buttonSpacing, buttonsY, buttonWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.ok"), button -> this.onConfirm()).method_46434(buttonStartX + 2 * (buttonWidth + buttonSpacing), buttonsY, buttonWidth, 20).method_46431());
    }

    private void addCategoryButtons() {
        this.categoryButtons.clear();
        String[] categories = new String[]{"all", "saplings", "small_flowers", "large_flowers", "grass_ferns", "mushrooms", "crops", "aquatic_plants", "coral", "nether_plants", "potted", "other"};
        int buttonWidth = 60;
        int buttonSpacing = 3;
        int buttonsPerRow = 7;
        for (int i = 0; i < categories.length; ++i) {
            String category = categories[i];
            int row = i / buttonsPerRow;
            int col = i % buttonsPerRow;
            int totalRowWidth = buttonsPerRow * buttonWidth + (buttonsPerRow - 1) * buttonSpacing;
            int startX = (this.field_22789 - totalRowWidth) / 2;
            int x = startX + col * (buttonWidth + buttonSpacing);
            int buttonY = 25 + row * 22;
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43471((String)("pushdozer.category.plant." + category)), buttonWidget -> this.selectCategory(category)).method_46434(x, buttonY, buttonWidth, 20).method_46431();
            this.categoryButtons.add(button);
            this.method_37063((class_364)button);
        }
    }

    private void selectCategory(String category) {
        this.currentCategory = category;
        this.updateFilteredBlocks();
        if (this.scrollPanel != null) {
            this.scrollPanel.updateBlocks(this.filteredBlocksCache);
        }
        this.updateCategoryButtonStates();
    }

    private void updateCategoryButtonStates() {
        String[] categories = new String[]{"all", "saplings", "small_flowers", "large_flowers", "grass_ferns", "mushrooms", "crops", "aquatic_plants", "coral", "nether_plants", "potted", "other"};
        for (int i = 0; i < this.categoryButtons.size() && i < categories.length; ++i) {
            class_4185 button = this.categoryButtons.get(i);
            String category = categories[i];
            boolean isSelected = this.currentCategory.equals(category);
            if (isSelected) {
                button.method_25355((class_2561)class_2561.method_43471((String)("pushdozer.category.plant." + category)).method_27661().method_27692(class_124.field_1054));
                continue;
            }
            button.method_25355((class_2561)class_2561.method_43471((String)("pushdozer.category.plant." + category)));
        }
    }

    public void method_25393() {
        super.method_25393();
    }

    private void selectAll() {
        this.selectedBlocks.clear();
        this.selectedBlocks.addAll(this.filteredBlocksCache);
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u5df2\u5168\u9009\u5f53\u524d\u89c6\u56fe\u4e2d\u7684 " + this.filteredBlocksCache.size() + " \u79cd\u690d\u7269")), false);
        }
    }

    private void clearAll() {
        this.selectedBlocks.clear();
    }

    private void onConfirm() {
        this.onBlocksSelected.accept(new ArrayList<class_2248>(this.selectedBlocks));
        this.method_25419();
    }

    private void onSearchTextChanged(String text) {
        if (!text.equals(this.currentSearchText)) {
            this.currentSearchText = text.toLowerCase();
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastSearchTime < 300L) {
                return;
            }
            this.lastSearchTime = currentTime;
            this.updateFilteredBlocks();
            if (this.scrollPanel != null) {
                this.scrollPanel.updateBlocks(this.filteredBlocksCache);
            }
        }
    }

    private void updateFilteredBlocks() {
        List baseBlocks = "all".equals(this.currentCategory) ? this.plantBlocks : (List)this.categorizedBlocks.getOrDefault(this.currentCategory, new ArrayList());
        this.reusableFilteredList.clear();
        if (this.currentSearchText.isEmpty()) {
            this.reusableFilteredList.addAll(baseBlocks);
        } else {
            for (class_2248 block : baseBlocks) {
                String translation = class_2561.method_43471((String)block.method_9539()).getString().toLowerCase();
                String key = block.method_9539().toLowerCase();
                if (!translation.contains(this.currentSearchText) && !key.contains(this.currentSearchText)) continue;
                this.reusableFilteredList.add(block);
            }
        }
        this.filteredBlocksCache = new ArrayList<class_2248>(this.reusableFilteredList);
        if (this.scrollPanel != null) {
            this.scrollPanel.updateBlocks(this.filteredBlocksCache);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        int leftMargin = 20;
        int infoY = this.field_22790 / 2 - 30;
        String selectedCountText = "\u5df2\u9009\u62e9: " + this.selectedBlocks.size() + " \u79cd\u690d\u7269";
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)selectedCountText), leftMargin, infoY, 0xFFFFFF);
        String categoryText = "\u5f53\u524d\u5206\u7c7b: " + class_2561.method_43471((String)("pushdozer.category.plant." + this.currentCategory)).getString();
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)categoryText), leftMargin, infoY + 15, 0xCCCCCC);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private List<class_2248> getPlantBlocks() {
        if (this.field_22787 == null || this.field_22787.field_1687 == null) {
            return new ArrayList<class_2248>();
        }
        ArrayList<class_2248> list = new ArrayList<class_2248>();
        for (class_2248 block : class_7923.field_41175) {
            if (block == class_2246.field_10124 || !this.isPlantCandidate(block)) continue;
            list.add(block);
        }
        return list;
    }

    private boolean isPlantCandidate(class_2248 block) {
        String id = class_7923.field_41175.method_10221((Object)block).method_12832().toLowerCase();
        String key = block.method_9539().toLowerCase();
        class_2680 state = block.method_9564();
        switch (id) {
            case "attached_melon_stem": 
            case "attached_pumpkin_stem": 
            case "brown_mushroom_block": 
            case "red_mushroom_block": 
            case "mushroom_stem": 
            case "cherry_leaves": 
            case "flowering_azalea_leaves": {
                return false;
            }
        }
        if (id.endsWith("_coral_block") || id.equals("dried_kelp_block")) {
            return false;
        }
        if (state.method_26164(class_3481.field_20339)) {
            return true;
        }
        if (state.method_26164(class_3481.field_15462)) {
            return true;
        }
        if (state.method_26164(class_3481.field_20341)) {
            return true;
        }
        if (block instanceof class_2261 || block instanceof class_2320 || block instanceof class_2302 || block instanceof class_2473 || block instanceof class_2541) {
            return true;
        }
        if (id.contains("dripleaf") && !id.contains("big_dripleaf_stem")) {
            return true;
        }
        if (id.equals("weeping_vines") || id.equals("weeping_vines_plant") || id.equals("twisting_vines") || id.equals("twisting_vines_plant")) {
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u8bc6\u522b\u5230\u4e0b\u754c\u85e4\u8513: " + id)), false);
            }
            return true;
        }
        if (id.startsWith("potted_")) {
            return true;
        }
        if (id.contains("chorus_")) {
            return true;
        }
        if (key.contains("seagrass") || key.contains("kelp") || id.equals("sea_pickle") || id.equals("lily_pad")) {
            return true;
        }
        if (key.contains("mushroom") || key.contains("fungus")) {
            return true;
        }
        if (id.contains("coral")) {
            return true;
        }
        if (id.equals("moss_block") || id.equals("moss_carpet") || id.equals("moss")) {
            return true;
        }
        if (key.contains("grass") && !id.equals("grass_block") || key.contains("fern")) {
            return true;
        }
        switch (id) {
            case "wheat": 
            case "carrots": 
            case "potatoes": 
            case "beetroots": 
            case "sweet_berry_bush": 
            case "cocoa": 
            case "sugar_cane": 
            case "bamboo": 
            case "cactus": {
                return true;
            }
            case "melon_stem": 
            case "pumpkin_stem": {
                return true;
            }
        }
        return !(!key.contains("leaves") && !id.endsWith("_leaves") || !key.contains("dead") && !key.contains("withered") && !key.contains("dry"));
    }

    private static Map<String, List<class_2248>> categorizeBlocksStatic(List<class_2248> plantBlocks) {
        HashMap<String, List<class_2248>> categorizedBlocks = new HashMap<String, List<class_2248>>();
        ArrayList<class_2248> saplings = new ArrayList<class_2248>();
        ArrayList<class_2248> smallFlowers = new ArrayList<class_2248>();
        ArrayList<class_2248> largeFlowers = new ArrayList<class_2248>();
        ArrayList<class_2248> grassFerns = new ArrayList<class_2248>();
        ArrayList<class_2248> mushrooms = new ArrayList<class_2248>();
        ArrayList<class_2248> crops = new ArrayList<class_2248>();
        ArrayList<class_2248> aquatic = new ArrayList<class_2248>();
        ArrayList<class_2248> coral = new ArrayList<class_2248>();
        ArrayList<class_2248> nether = new ArrayList<class_2248>();
        ArrayList<class_2248> potted = new ArrayList<class_2248>();
        ArrayList<class_2248> other = new ArrayList<class_2248>();
        for (class_2248 b : plantBlocks) {
            String id = class_7923.field_41175.method_10221((Object)b).method_12832().toLowerCase();
            String key = b.method_9539().toLowerCase();
            if (id.equals("sunflower") || id.equals("lilac") || id.equals("rose_bush") || id.equals("peony")) {
                largeFlowers.add(b);
                continue;
            }
            if (id.startsWith("potted_") || key.contains("potted")) {
                potted.add(b);
                continue;
            }
            if (id.endsWith("_sapling") || id.equals("mangrove_propagule")) {
                saplings.add(b);
                continue;
            }
            if (key.contains("coral") || id.contains("coral")) {
                coral.add(b);
                continue;
            }
            if (key.contains("seagrass") || key.contains("kelp") || id.equals("sea_pickle") || id.equals("lily_pad")) {
                aquatic.add(b);
                continue;
            }
            if (key.contains("mushroom") || key.contains("fungus")) {
                mushrooms.add(b);
                continue;
            }
            if (id.contains("_flower_cluster") || key.contains("cluster") || id.contains("cluster")) {
                smallFlowers.add(b);
                continue;
            }
            if (key.contains("flower") || id.contains("flowers") || id.contains("flower") || id.contains("petal") || key.contains("blossom") || id.contains("blossom") || key.contains("bloom") || id.contains("bloom")) {
                if (key.contains("sunflower") || key.contains("lilac") || key.contains("rose_bush") || key.contains("peony") || key.contains("tall") || id.contains("big_dripleaf")) {
                    largeFlowers.add(b);
                    continue;
                }
                smallFlowers.add(b);
                continue;
            }
            if (id.equals("azalea") || id.equals("flowering_azalea")) {
                smallFlowers.add(b);
                continue;
            }
            if (id.contains("big_dripleaf") || id.contains("small_dripleaf") || id.contains("pitcher_plant")) {
                largeFlowers.add(b);
                continue;
            }
            if (id.equals("dandelion") || id.equals("poppy") || id.contains("orchid") || id.equals("allium") || id.contains("azure_bluet") || id.contains("tulip") || id.contains("oxeye_daisy") || id.contains("cornflower") || id.contains("lily_of_the_valley") || id.equals("torchflower") || id.equals("wither_rose")) {
                smallFlowers.add(b);
                continue;
            }
            if (key.contains("grass") && !id.equals("grass_block") || key.contains("fern")) {
                grassFerns.add(b);
                continue;
            }
            if (key.contains("crop") || id.endsWith("_crop") || id.equals("wheat") || id.equals("carrots") || id.equals("potatoes") || id.equals("beetroots") || id.equals("melon_stem") || id.equals("pumpkin_stem") || id.equals("sweet_berry_bush") || id.equals("cocoa") || id.equals("sugar_cane")) {
                crops.add(b);
                continue;
            }
            if (id.equals("cactus") || id.equals("bamboo") || id.equals("bamboo_sapling")) {
                other.add(b);
                continue;
            }
            if (id.equals("weeping_vines") || id.equals("weeping_vines_plant") || id.equals("twisting_vines") || id.equals("twisting_vines_plant")) {
                nether.add(b);
                continue;
            }
            if (key.contains("vine") || key.contains("vines") || id.equals("glow_lichen")) {
                grassFerns.add(b);
                continue;
            }
            if (key.contains("nether") || key.contains("crimson") || key.contains("warped")) {
                nether.add(b);
                continue;
            }
            if (id.equals("chorus_plant")) {
                other.add(b);
                continue;
            }
            if (id.equals("chorus_flower")) {
                smallFlowers.add(b);
                continue;
            }
            other.add(b);
        }
        categorizedBlocks.put("saplings", saplings);
        categorizedBlocks.put("small_flowers", smallFlowers);
        categorizedBlocks.put("large_flowers", largeFlowers);
        categorizedBlocks.put("grass_ferns", grassFerns);
        categorizedBlocks.put("mushrooms", mushrooms);
        categorizedBlocks.put("crops", crops);
        categorizedBlocks.put("aquatic_plants", aquatic);
        categorizedBlocks.put("coral", coral);
        categorizedBlocks.put("nether_plants", nether);
        categorizedBlocks.put("potted", potted);
        categorizedBlocks.put("other", other);
        return categorizedBlocks;
    }

    private class ScrollableBlockPanel
    extends class_339 {
        private List<class_2248> blocks;
        private int scrollOffset;
        private boolean isDraggingScrollBar;
        private int dragStartY;
        private int dragStartScrollOffset;

        public ScrollableBlockPanel(int x, int y, int width, int height, List<class_2248> blocks) {
            super(x, y, width, height, (class_2561)class_2561.method_43473());
            this.scrollOffset = 0;
            this.isDraggingScrollBar = false;
            this.dragStartY = 0;
            this.dragStartScrollOffset = 0;
            this.blocks = blocks;
        }

        public void updateBlocks(List<class_2248> newBlocks) {
            this.blocks = newBlocks;
            this.scrollOffset = 0;
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            class_2248 hoveredBlock = null;
            int hoveredX = 0;
            int hoveredY = 0;
            int contentX = this.method_46426() + 5;
            int contentY = this.method_46427() + 5;
            int contentWidth = this.field_22758 - 4 - 10;
            int contentHeight = this.field_22759 - 10;
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758 - 4, this.method_46427() + this.field_22759, 0x40000000);
            context.method_44379(contentX - 1, contentY - 1, contentX + contentWidth + 1, contentY + contentHeight + 1);
            int gridWidth = 188;
            int offsetX = (contentWidth - gridWidth) / 2;
            int startRow = Math.max(0, this.scrollOffset / 24);
            int endRow = Math.min((this.blocks.size() + 8 - 1) / 8, startRow + contentHeight / 24 + 1);
            for (int row = startRow; row <= endRow; ++row) {
                int i;
                for (int col = 0; col < 8 && (i = row * 8 + col) < this.blocks.size(); ++col) {
                    class_1799 itemStack;
                    int blockX = contentX + offsetX + col * 24;
                    int blockY = contentY + row * 24 - this.scrollOffset;
                    if (blockY + 20 < contentY || blockY >= contentY + contentHeight) continue;
                    boolean isSelected = MultiSelectPlantSelectionScreen.this.selectedBlocks.contains(this.blocks.get(i));
                    int borderColor = isSelected ? -1 : -7631989;
                    context.method_25294(blockX, blockY, blockX + 20, blockY + 20, borderColor);
                    context.method_25294(blockX + 1, blockY + 1, blockX + 20 - 1, blockY + 20 - 1, -13158601);
                    if (this.method_25405(mouseX, mouseY) && mouseX >= blockX && mouseX < blockX + 20 && mouseY >= blockY && mouseY < blockY + 20) {
                        context.method_25294(blockX + 1, blockY + 1, blockX + 20 - 1, blockY + 20 - 1, -11184811);
                        hoveredBlock = this.blocks.get(i);
                        hoveredX = mouseX;
                        hoveredY = mouseY;
                    }
                    if (!(itemStack = this.getItemStack(i)).method_7960()) {
                        context.method_51427(itemStack, blockX + 2, blockY + 2);
                    }
                    if (this.isPottedBlock(this.blocks.get(i))) {
                        int cx = blockX + 10;
                        int cy = blockY + 10;
                        int outerR = Math.max(7, 8);
                        int thickness = 3;
                        int ringColor = -1996488705;
                        this.drawRing(context, blockX, blockY, cx, cy, outerR, thickness, ringColor);
                    }
                    if (!isSelected) continue;
                    context.method_25294(blockX + 1, blockY + 1, blockX + 20 - 1, blockY + 20 - 1, -2130706433);
                    context.method_51439(MultiSelectPlantSelectionScreen.this.field_22793, (class_2561)class_2561.method_43470((String)"\u2611"), blockX + 20 - 8, blockY + 20 - 9, -16777216, false);
                }
            }
            context.method_44380();
            this.drawScrollBar(context);
            if (hoveredBlock != null) {
                context.method_51438(MultiSelectPlantSelectionScreen.this.field_22793, (class_2561)class_2561.method_43471((String)hoveredBlock.method_9539()), hoveredX, hoveredY);
            }
        }

        private boolean isPottedBlock(class_2248 b) {
            String id = class_7923.field_41175.method_10221((Object)b).method_12832().toLowerCase();
            String key = b.method_9539().toLowerCase();
            return id.startsWith("potted_") || key.contains("potted");
        }

        private void drawRing(class_332 ctx, int clipX, int clipY, int cx, int cy, int outerR, int thickness, int color) {
            int innerR = Math.max(0, outerR - thickness);
            int minY = Math.max(clipY, cy - outerR);
            int maxY = Math.min(clipY + 20 - 1, cy + outerR);
            for (int y = minY; y <= maxY; ++y) {
                int rx2;
                int rx1;
                int lx2;
                int dy = y - cy;
                int y2 = dy * dy;
                int xOuter = (int)Math.floor(Math.sqrt(Math.max(0, outerR * outerR - y2)));
                int xInner = innerR > 0 ? (int)Math.floor(Math.sqrt(Math.max(0, innerR * innerR - y2))) : -1;
                int leftOuter = cx - xOuter;
                int rightOuter = cx + xOuter;
                int leftInner = cx - xInner;
                int rightInner = cx + xInner;
                int lx1 = Math.max(clipX, leftOuter);
                if (lx1 <= (lx2 = Math.min(clipX + 20 - 1, leftInner - 1))) {
                    ctx.method_25294(lx1, y, lx2 + 1, y + 1, color);
                }
                if ((rx1 = Math.max(clipX, rightInner + 1)) > (rx2 = Math.min(clipX + 20 - 1, rightOuter))) continue;
                ctx.method_25294(rx1, y, rx2 + 1, y + 1, color);
            }
        }

        @NotNull
        private class_1799 getItemStack(int i) {
            class_2248 b = this.blocks.get(i);
            class_1799 itemStack = new class_1799((class_1935)b);
            String idPath = class_7923.field_41175.method_10221((Object)b).method_12832().toLowerCase();
            if (b == class_2246.field_10293) {
                itemStack = new class_1799((class_1935)class_1802.field_8317);
            } else if (b == class_2246.field_10609) {
                itemStack = new class_1799((class_1935)class_1802.field_8179);
            } else if (b == class_2246.field_10247) {
                itemStack = new class_1799((class_1935)class_1802.field_8567);
            } else if (b == class_2246.field_10341) {
                itemStack = new class_1799((class_1935)class_1802.field_8309);
            } else if (b == class_2246.field_46287) {
                itemStack = new class_1799((class_1935)class_1802.field_46250);
            } else if (b == class_2246.field_46286) {
                itemStack = new class_1799((class_1935)class_1802.field_46249);
            } else if (b == class_2246.field_16999) {
                itemStack = new class_1799((class_1935)class_1802.field_16998);
            } else if (b == class_2246.field_10302) {
                itemStack = new class_1799((class_1935)class_1802.field_8116);
            } else if (b == class_2246.field_10463) {
                itemStack = new class_1799((class_1935)class_1802.field_17532);
            } else if (b == class_2246.field_10376) {
                itemStack = new class_1799((class_1935)class_1802.field_8158);
            } else if (b == class_2246.field_10238) {
                itemStack = new class_1799((class_1935)class_1802.field_8158);
            } else if (b == class_2246.field_28675 || b == class_2246.field_28676) {
                itemStack = new class_1799((class_1935)class_1802.field_28659);
            } else if (b == class_2246.field_22123 || b == class_2246.field_22124) {
                itemStack = new class_1799((class_1935)class_1802.field_21992);
            } else if (b == class_2246.field_23078 || b == class_2246.field_23079) {
                itemStack = new class_1799((class_1935)class_1802.field_23070);
            } else if (b == class_2246.field_10021) {
                itemStack = new class_1799((class_1935)class_1802.field_8233);
            } else if (b == class_2246.field_10479) {
                itemStack = new class_1799((class_1935)class_2246.field_10479);
            } else if (b == class_2246.field_10214) {
                itemStack = new class_1799((class_1935)class_2246.field_10214);
            } else if (b == class_2246.field_9974) {
                itemStack = new class_1799((class_1935)class_1802.field_8790);
            } else if (b == class_2246.field_42749) {
                itemStack = new class_1799((class_1935)class_1802.field_42711);
            } else if (b == class_2246.field_43228) {
                itemStack = new class_1799((class_1935)class_1802.field_43195);
            } else if (b == class_2246.field_10108) {
                itemStack = new class_1799((class_1935)class_1802.field_8648);
            } else if (idPath.startsWith("potted_")) {
                String base = idPath.substring("potted_".length());
                try {
                    class_2960 baseId = class_2960.method_60655((String)"minecraft", (String)base);
                    class_2248 baseBlock = (class_2248)class_7923.field_41175.method_10223(baseId);
                    itemStack = baseBlock != class_2246.field_10124 ? (base.equals("azalea") ? new class_1799((class_1935)class_2246.field_28678) : (base.equals("flowering_azalea") ? new class_1799((class_1935)class_2246.field_28679) : new class_1799((class_1935)baseBlock))) : new class_1799((class_1935)class_1802.field_8074);
                }
                catch (Exception ignored) {
                    itemStack = new class_1799((class_1935)class_1802.field_8074);
                }
            }
            return itemStack;
        }

        private void drawScrollBar(class_332 context) {
            int scrollBarX = this.method_46426() + this.field_22758 - 4;
            int contentHeight = this.field_22759 - 10;
            context.method_25294(scrollBarX, this.method_46427(), scrollBarX + 4, this.method_46427() + this.field_22759, 0x33FFFFFF);
            int visibleRows = contentHeight / 24;
            int totalRows = (this.blocks.size() + 8 - 1) / 8;
            if (totalRows > visibleRows) {
                int scrollBarHeight = Math.max(20, contentHeight * visibleRows / totalRows);
                int scrollBarY = this.method_46427() + (int)((float)(contentHeight - scrollBarHeight) * (float)this.scrollOffset / (float)((totalRows - visibleRows) * 24));
                context.method_25294(scrollBarX, scrollBarY, scrollBarX + 4, scrollBarY + scrollBarHeight, -5592406);
                context.method_25294(scrollBarX, scrollBarY, scrollBarX + 4 - 1, scrollBarY + 1, -1);
                context.method_25294(scrollBarX, scrollBarY, scrollBarX + 1, scrollBarY + scrollBarHeight - 1, -1);
                context.method_25294(scrollBarX + 4 - 1, scrollBarY, scrollBarX + 4, scrollBarY + scrollBarHeight, -11184811);
                context.method_25294(scrollBarX, scrollBarY + scrollBarHeight - 1, scrollBarX + 4, scrollBarY + scrollBarHeight, -11184811);
            }
        }

        public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            if (this.method_25405(mouseX, mouseY)) {
                int contentHeight = this.field_22759 - 10;
                int visibleRows = contentHeight / 24;
                int totalRows = (this.blocks.size() + 8 - 1) / 8;
                long maxScrollLong = Math.max(0L, (long)(totalRows - visibleRows) * 24L);
                int maxScroll = maxScrollLong > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxScrollLong;
                this.scrollOffset = Math.max(0, Math.min(this.scrollOffset - (int)(verticalAmount * 10.0), maxScroll));
                return true;
            }
            return false;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25405(mouseX, mouseY) && button == 0) {
                int scrollBarX = this.method_46426() + this.field_22758 - 4;
                if (mouseX >= (double)scrollBarX && mouseX < (double)(scrollBarX + 4)) {
                    this.isDraggingScrollBar = true;
                    this.dragStartY = (int)mouseY;
                    this.dragStartScrollOffset = this.scrollOffset;
                    return true;
                }
                int contentX = this.method_46426() + 5;
                int contentY = this.method_46427() + 5;
                int contentWidth = this.field_22758 - 4 - 10;
                int contentHeight = this.field_22759 - 10;
                int gridWidth = 188;
                int offsetX = (contentWidth - gridWidth) / 2;
                for (int i = 0; i < this.blocks.size(); ++i) {
                    int row = i / 8;
                    int col = i % 8;
                    int blockX = contentX + offsetX + col * 24;
                    int blockY = contentY + row * 24 - this.scrollOffset;
                    if (blockY + 20 < contentY || blockY >= contentY + contentHeight || !(mouseX >= (double)blockX) || !(mouseX < (double)(blockX + 20)) || !(mouseY >= (double)blockY) || !(mouseY < (double)(blockY + 20))) continue;
                    class_2248 clickedBlock = this.blocks.get(i);
                    if (MultiSelectPlantSelectionScreen.this.selectedBlocks.contains(clickedBlock)) {
                        MultiSelectPlantSelectionScreen.this.selectedBlocks.remove(clickedBlock);
                    } else {
                        MultiSelectPlantSelectionScreen.this.selectedBlocks.add(clickedBlock);
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.isDraggingScrollBar && button == 0) {
                int maxScroll;
                int contentHeight = this.field_22759 - 10;
                int visibleRows = contentHeight / 24;
                int totalRows = (this.blocks.size() + 8 - 1) / 8;
                long maxScrollLong = Math.max(0L, (long)(totalRows - visibleRows) * 24L);
                int n = maxScroll = maxScrollLong > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxScrollLong;
                if (maxScroll > 0) {
                    int dragDistance = (int)mouseY - this.dragStartY;
                    int scrollBarHeight = Math.max(20, contentHeight * visibleRows / totalRows);
                    int scrollableHeight = contentHeight - scrollBarHeight;
                    float scrollRatio = (float)dragDistance / (float)scrollableHeight;
                    int newScrollOffset = this.dragStartScrollOffset + (int)(scrollRatio * (float)maxScroll);
                    this.scrollOffset = Math.max(0, Math.min(newScrollOffset, maxScroll));
                }
                return true;
            }
            return false;
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.isDraggingScrollBar = false;
            }
            return false;
        }

        protected void method_47399(class_6382 builder) {
            builder.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43471((String)"pushdozer.narrator.plant_panel"));
        }
    }
}

