/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.items.ModItems;
import com.pushdozer.items.handlers.AdaptiveSmoothHandler;
import com.pushdozer.items.handlers.BatchPlantHandler;
import com.pushdozer.items.handlers.BoneMealHandler;
import com.pushdozer.items.handlers.ExcavationHandler;
import com.pushdozer.items.handlers.PlacementHandler;
import com.pushdozer.items.handlers.ShorelineProcessHandler;
import com.pushdozer.items.handlers.SmoothLowerHandler;
import com.pushdozer.items.handlers.SmoothRaiseHandler;
import com.pushdozer.items.handlers.SmoothingHandler;
import com.pushdozer.items.handlers.SurfaceConvertHandler;
import com.pushdozer.items.handlers.SurfaceRoughenHandler;
import com.pushdozer.network.NetworkManager;
import com.pushdozer.operations.UndoAction;
import com.pushdozer.services.UndoRedoService;
import com.pushdozer.ui.PushdozerConfigScreenHandler;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_7701;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushdozerMod
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"pushdozer");
    public static final String MOD_ID = "pushdozer";
    public static class_3917<PushdozerConfigScreenHandler> CONFIG_SCREEN_HANDLER;
    private static PushdozerConfig config;
    public static PlacementHandler placementHandler;
    public static SmoothingHandler smoothingHandler;
    public static ExcavationHandler excavationHandler;
    public static SmoothRaiseHandler smoothRaiseHandler;
    public static SmoothLowerHandler smoothLowerHandler;
    public static SurfaceRoughenHandler surfaceRoughenHandler;
    public static SurfaceConvertHandler surfaceConvertHandler;
    public static BoneMealHandler boneMealHandler;
    public static BatchPlantHandler batchPlantHandler;
    public static ShorelineProcessHandler shorelineProcessHandler;
    public static AdaptiveSmoothHandler adaptiveSmoothHandler;

    public void onInitialize() {
        LOGGER.info("Initializing Pushdozer mod...");
        try {
            ModItems.registerItems();
            LOGGER.info("Successfully registered item: {}", (Object)class_7923.field_41178.method_10221((Object)ModItems.PUSHDOZER_ITEM));
            config = PushdozerConfig.getInstance();
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(content -> {
                content.method_45421((class_1935)ModItems.PUSHDOZER_ITEM);
                LOGGER.info("Added Pushdozer item to tools item group");
            });
            CONFIG_SCREEN_HANDLER = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"config_screen"), (Object)new class_3917((syncId, inventory) -> new PushdozerConfigScreenHandler(syncId, inventory, null), class_7701.field_40182));
            placementHandler = new PlacementHandler(config);
            smoothingHandler = new SmoothingHandler(config);
            excavationHandler = new ExcavationHandler(config);
            smoothRaiseHandler = new SmoothRaiseHandler(config);
            smoothLowerHandler = new SmoothLowerHandler(config);
            surfaceRoughenHandler = new SurfaceRoughenHandler(config);
            surfaceConvertHandler = new SurfaceConvertHandler(config);
            boneMealHandler = new BoneMealHandler(config);
            batchPlantHandler = new BatchPlantHandler(config);
            shorelineProcessHandler = new ShorelineProcessHandler(config);
            adaptiveSmoothHandler = new AdaptiveSmoothHandler(config);
            NetworkManager.registerNetworking();
            LOGGER.info("Pushdozer mod has been initialized\uff01");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize Pushdozer mod", (Throwable)e);
            throw new RuntimeException("Failed to initialize Pushdozer mod", e);
        }
    }

    public static PushdozerConfig getConfig() {
        return PushdozerConfig.getInstance();
    }

    public static void pushUndoAction(class_1657 player, UndoAction action) {
        UndoRedoService.getInstance().pushUndoAction(player, action);
    }

    public static void debugUndoStacks(class_1657 player) {
        UndoRedoService.getInstance().debugPlayerStacks(player);
    }

    public static int getUndoStackSize(class_1657 player) {
        return UndoRedoService.getInstance().getUndoStackSize(player);
    }

    public static void saveConfig() {
        if (config != null) {
            config.save();
        }
    }
}

