/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.items.handlers;

import com.pushdozer.PushdozerMod;
import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.network.NetworkManager;
import com.pushdozer.operations.UndoAction;
import com.pushdozer.shapes.GeometryShape;
import com.pushdozer.util.ShapeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2211;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTerrainToolHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"pushdozer");
    protected final PushdozerConfig config;
    protected static final Set<class_2248> IGNORED_BLOCKS = Set.of(class_2246.field_10597, class_2246.field_10477, class_2246.field_10251, class_2246.field_10559);
    private static final float GAUSSIAN_KERNEL_RADIUS_FACTOR = 2.5f;
    private static final float MIN_SIGMA = 1.0f;

    public AbstractTerrainToolHandler(PushdozerConfig config) {
        this.config = config;
    }

    public void handleOperation(class_1657 player, class_1937 world, UndoAction.ActionType actionType) {
        if (world.field_9236) {
            return;
        }
        if (!this.hasOperationPermission(player, world, actionType)) {
            return;
        }
        class_2338 basePos = ShapeUtil.getTargetBlockPos(player, this.config);
        GeometryShape shape = ShapeUtil.createShape(player, this.config, basePos);
        if (shape == null) {
            return;
        }
        ArrayList<class_2338> affectedPositions = new ArrayList<class_2338>();
        ArrayList<class_2680> originalStates = new ArrayList<class_2680>();
        ArrayList<class_2680> newStates = new ArrayList<class_2680>();
        this.processTerrain(world, shape, basePos, affectedPositions, originalStates, newStates);
        if (!affectedPositions.isEmpty()) {
            class_3218 serverWorld;
            UndoAction undoAction = new UndoAction(actionType, affectedPositions, originalStates, newStates);
            PushdozerMod.pushUndoAction(player, undoAction);
            if (world instanceof class_3218 && !(serverWorld = (class_3218)world).method_8503().method_3724()) {
                NetworkManager.broadcastTerrainOperation(serverWorld, actionType.name(), affectedPositions, newStates);
            }
        }
    }

    private boolean hasOperationPermission(class_1657 player, class_1937 world, UndoAction.ActionType actionType) {
        if (world.method_8503() != null && world.method_8503().method_3724()) {
            return true;
        }
        if (player instanceof class_3222 && this.config.getRadius() > 100) {
            LOGGER.warn("\u73a9\u5bb6 {} \u5c1d\u8bd5\u6267\u884c\u8fc7\u5927\u8303\u56f4\u64cd\u4f5c: \u534a\u5f84 {}", (Object)player.method_5477().getString(), (Object)this.config.getRadius());
            return false;
        }
        return true;
    }

    protected void processTerrain(class_1937 world, GeometryShape shape, class_2338 brushCenter, List<class_2338> affectedPositions, List<class_2680> originalStates, List<class_2680> newStates) {
        class_2338 columnXZ;
        Map<class_2338, TerrainColumn> columns = this.collectTerrainColumns(world, shape, brushCenter);
        if (columns.isEmpty()) {
            return;
        }
        HashMap<class_2338, Integer> targetHeights = new HashMap<class_2338, Integer>();
        for (Map.Entry<class_2338, TerrainColumn> entry : columns.entrySet()) {
            columnXZ = entry.getKey();
            TerrainColumn column = entry.getValue();
            int targetHeight = this.calculateTargetHeight(columns, column, columnXZ, brushCenter);
            targetHeights.put(columnXZ, targetHeight);
        }
        for (Map.Entry<Object, TerrainColumn> entry : targetHeights.entrySet()) {
            columnXZ = (class_2338)entry.getKey();
            int targetHeight = (Integer)((Object)entry.getValue());
            TerrainColumn column = columns.get(columnXZ);
            this.applyHeightChange(world, columnXZ, column, targetHeight, affectedPositions, originalStates, newStates);
        }
        this.postProcess(world, shape, affectedPositions, originalStates, newStates);
    }

    protected Map<class_2338, TerrainColumn> collectTerrainColumns(class_1937 world, GeometryShape shape, class_2338 brushCenter) {
        HashMap<class_2338, TerrainColumn> columns = new HashMap<class_2338, TerrainColumn>();
        Set uniqueXZPositions = shape.getBlockPositions().stream().map(pos -> new class_2338(pos.method_10263(), 0, pos.method_10260())).collect(Collectors.toSet());
        for (class_2338 columnXZ : uniqueXZPositions) {
            class_2338 groundPos = this.findGroundBlock(world, columnXZ.method_33096(brushCenter.method_10264() + this.config.getRadius()));
            if (groundPos == null) continue;
            class_2680 groundState = world.method_8320(groundPos);
            if (this.isIgnoredBlock(groundState) || groundState.method_26215()) {
                if ((groundPos = this.findGroundBlock(world, groundPos.method_10074())) == null) continue;
                groundState = world.method_8320(groundPos);
            }
            if (this.isIgnoredBlock(groundState) || groundState.method_26215()) continue;
            TerrainColumn column = new TerrainColumn(groundState, groundPos.method_10264());
            columns.put(columnXZ, column);
        }
        return columns;
    }

    protected class_2338 findGroundBlock(class_1937 world, class_2338 initialPos) {
        class_2338.class_2339 currentPos = new class_2338.class_2339(initialPos.method_10263(), initialPos.method_10264(), initialPos.method_10260());
        if (!(world.method_22347((class_2338)currentPos) || this.isWater(world, (class_2338)currentPos) || this.isIgnoredBlock(world.method_8320((class_2338)currentPos)))) {
            while (!(currentPos.method_10264() >= world.method_31605() || world.method_22347((class_2338)currentPos) || this.isWater(world, (class_2338)currentPos) || this.isIgnoredBlock(world.method_8320((class_2338)currentPos)))) {
                currentPos.method_10100(0, 1, 0);
            }
        }
        while (currentPos.method_10264() >= world.method_31607() && (world.method_22347((class_2338)currentPos) || this.isWater(world, (class_2338)currentPos) || this.isIgnoredBlock(world.method_8320((class_2338)currentPos)))) {
            currentPos.method_10100(0, -1, 0);
        }
        if (currentPos.method_10264() < world.method_31607()) {
            return null;
        }
        return currentPos.method_10062();
    }

    protected void applyHeightChange(class_1937 world, class_2338 columnXZ, TerrainColumn column, int targetHeight, List<class_2338> affectedPositions, List<class_2680> originalStates, List<class_2680> newStates) {
        block7: {
            int clampedTargetHeight;
            int currentHeight;
            block6: {
                class_2338 pos;
                class_2680 originalState;
                currentHeight = column.getOriginalHeight();
                class_2680 fillState = column.getMainBlockState();
                clampedTargetHeight = Math.max(world.method_31607(), Math.min(world.method_31605() - 1, targetHeight));
                if (clampedTargetHeight <= currentHeight) break block6;
                class_2680 topState = fillState;
                class_2680 fillerState = fillState;
                if (fillState.method_27852(class_2246.field_10219)) {
                    fillerState = class_2246.field_10566.method_9564();
                    topState = class_2246.field_10219.method_9564();
                    if (Math.random() < 0.1) {
                        fillerState = class_2246.field_10253.method_9564();
                    }
                } else if (fillState.method_27852(class_2246.field_10520) || fillState.method_27852(class_2246.field_10402)) {
                    fillerState = class_2246.field_10566.method_9564();
                    topState = fillState;
                }
                for (int y = currentHeight + 1; y <= clampedTargetHeight && ((originalState = world.method_8320(pos = new class_2338(columnXZ.method_10263(), y, columnXZ.method_10260()))).method_45474() || this.isWater(world, pos)); ++y) {
                    boolean isTopLayer = y == clampedTargetHeight;
                    class_2680 placeState = isTopLayer ? topState : fillerState;
                    affectedPositions.add(pos);
                    originalStates.add(originalState);
                    newStates.add(placeState);
                    world.method_8652(pos, placeState, 3);
                }
                break block7;
            }
            if (clampedTargetHeight >= currentHeight) break block7;
            for (int y = currentHeight; y > clampedTargetHeight; --y) {
                class_2338 pos = new class_2338(columnXZ.method_10263(), y, columnXZ.method_10260());
                class_2680 originalState = world.method_8320(pos);
                if (world.method_22347(pos)) continue;
                affectedPositions.add(pos);
                originalStates.add(originalState);
                newStates.add(class_2246.field_10124.method_9564());
                world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
            }
        }
    }

    protected void postProcess(class_1937 world, GeometryShape shape, List<class_2338> affectedPositions, List<class_2680> originalStates, List<class_2680> newStates) {
        this.removeFloatingVegetation(world, shape, affectedPositions, originalStates, newStates);
    }

    protected void removeFloatingVegetation(class_1937 world, GeometryShape shape, List<class_2338> affectedPositions, List<class_2680> originalStates, List<class_2680> newStates) {
        Set uniqueXZPositions = shape.getBlockPositions().stream().map(pos -> new class_2338(pos.method_10263(), 0, pos.method_10260())).collect(Collectors.toSet());
        for (class_2338 columnXZ : uniqueXZPositions) {
            class_2338 groundPos = this.findGroundBlock(world, columnXZ.method_33096(world.method_31605()));
            if (groundPos == null) continue;
            int groundHeight = groundPos.method_10264();
            for (int y = groundHeight + 1; y <= groundHeight + 10; ++y) {
                class_2338 below;
                class_2338 pos2 = new class_2338(columnXZ.method_10263(), y, columnXZ.method_10260());
                class_2680 state = world.method_8320(pos2);
                if (!this.isIgnoredBlock(state) || !world.method_22347(below = pos2.method_10074()) && !this.isWater(world, below)) continue;
                affectedPositions.add(pos2);
                originalStates.add(state);
                newStates.add(class_2246.field_10124.method_9564());
                world.method_8652(pos2, class_2246.field_10124.method_9564(), 3);
            }
        }
    }

    protected boolean isWater(class_1937 world, class_2338 pos) {
        class_3610 fluidState = world.method_8316(pos);
        return !fluidState.method_15769() && fluidState.method_15771();
    }

    protected boolean isIgnoredBlock(class_2680 state) {
        if (state.method_26164(class_3481.field_15475) || state.method_26164(class_3481.field_15503) || state.method_26164(class_3481.field_20339) || state.method_26164(class_3481.field_15462) || state.method_26164(class_3481.field_20341) || state.method_26164(class_3481.field_15480)) {
            return true;
        }
        if (state.method_26204() instanceof class_2211) {
            return true;
        }
        return IGNORED_BLOCKS.contains(state.method_26204());
    }

    protected abstract int calculateTargetHeight(Map<class_2338, TerrainColumn> var1, TerrainColumn var2, class_2338 var3, class_2338 var4);

    protected float calculateSmoothedHeight(Map<class_2338, TerrainColumn> columns, class_2338 columnXZ, class_2338 brushCenter, int brushRadius) {
        float totalWeight = 0.0f;
        float weightedHeightSum = 0.0f;
        float sigmaFactor = this.getSigmaFactor(brushRadius);
        float sigma = (float)brushRadius * sigmaFactor;
        if (sigma < 1.0f) {
            sigma = 1.0f;
        }
        double twoSigmaSquared = 2.0 * (double)sigma * (double)sigma;
        float kernelRadius = sigma * 2.5f;
        float maxDistanceSq = kernelRadius * kernelRadius;
        class_2338 currentCenterXZ = new class_2338(columnXZ.method_10263(), 0, columnXZ.method_10260());
        for (Map.Entry<class_2338, TerrainColumn> entry : columns.entrySet()) {
            class_2338 neighborColumnXZ = entry.getKey();
            TerrainColumn neighborColumn = entry.getValue();
            double distanceSq = neighborColumnXZ.method_10262((class_2382)currentCenterXZ);
            if (distanceSq > (double)maxDistanceSq) continue;
            float weight = (float)Math.exp(-distanceSq / twoSigmaSquared);
            weightedHeightSum += (float)neighborColumn.getOriginalHeight() * weight;
            totalWeight += weight;
        }
        if (totalWeight <= 0.0f) {
            return 0.0f;
        }
        return weightedHeightSum / totalWeight;
    }

    protected float getSigmaFactor(int brushRadius) {
        if (brushRadius <= 5) {
            return 0.5f;
        }
        if (brushRadius <= 10) {
            return 0.4f;
        }
        return 0.35f;
    }

    protected static class TerrainColumn {
        private final int originalHeight;
        private final class_2680 mainBlockState;

        public TerrainColumn(class_2680 mainBlockState, int initialHeight) {
            this.mainBlockState = mainBlockState;
            this.originalHeight = initialHeight;
        }

        public int getOriginalHeight() {
            return this.originalHeight;
        }

        public class_2680 getMainBlockState() {
            return this.mainBlockState;
        }
    }
}

