/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.items.handlers;

import com.pushdozer.PushdozerMod;
import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.operations.UndoAction;
import com.pushdozer.shapes.GeometryShape;
import com.pushdozer.util.ShapeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1752;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class BoneMealHandler {
    private final PushdozerConfig config;
    private static final Set<class_2248> GROWABLE_BLOCKS = Set.of(class_2246.field_10219, class_2246.field_10566, class_2246.field_10362, class_2246.field_10102);

    public BoneMealHandler(PushdozerConfig config) {
        this.config = config;
    }

    public void handleBoneMeal(class_1657 player, class_1937 world) {
        if (world.field_9236) {
            return;
        }
        class_2338 basePos = ShapeUtil.getTargetBlockPos(player, this.config);
        GeometryShape shape = ShapeUtil.createShape(player, this.config, basePos);
        if (shape == null) {
            return;
        }
        ArrayList<class_2338> affectedPositions = new ArrayList<class_2338>();
        ArrayList<class_2680> originalStates = new ArrayList<class_2680>();
        ArrayList<class_2680> newStates = new ArrayList<class_2680>();
        this.applyBoneMeal(world, shape, affectedPositions, originalStates, newStates);
        if (!affectedPositions.isEmpty()) {
            UndoAction undoAction = new UndoAction(UndoAction.ActionType.BONE_MEAL, affectedPositions, originalStates, newStates);
            PushdozerMod.pushUndoAction(player, undoAction);
        }
    }

    private void applyBoneMeal(class_1937 world, GeometryShape shape, List<class_2338> affectedPositions, List<class_2680> originalStates, List<class_2680> newStates) {
        int totalBoneMealUsed = 0;
        int totalChangesDetected = 0;
        for (class_2338 pos : shape.getBlockPositions()) {
            class_2680 state = world.method_8320(pos);
            if (!this.isGrowableBlock(state)) continue;
            Set<class_2338> positionsToCheck = this.getPositionsToCheck(pos);
            HashMap<class_2338, class_2680> statesBefore = new HashMap<class_2338, class_2680>();
            for (class_2338 checkPos : positionsToCheck) {
                statesBefore.put(checkPos, world.method_8320(checkPos));
            }
            class_1799 boneMealStack = new class_1799((class_1935)class_1802.field_8324);
            boolean boneMealUsed = false;
            int maxAttempts = 3;
            for (int attempt = 0; attempt < maxAttempts; ++attempt) {
                if (!class_1752.method_7720((class_1799)boneMealStack, (class_1937)world, (class_2338)pos)) continue;
                boneMealUsed = true;
                ++totalBoneMealUsed;
                this.checkForChanges(positionsToCheck, statesBefore, world, affectedPositions, originalStates, newStates, attempt + 1);
            }
            if (boneMealUsed) continue;
            this.checkForChanges(positionsToCheck, statesBefore, world, affectedPositions, originalStates, newStates, 0);
        }
        if (totalBoneMealUsed > 0) {
            PushdozerMod.LOGGER.info("\u9aa8\u7c89\u64cd\u4f5c\u5b8c\u6210: \u4f7f\u7528\u4e86 {} \u6b21\u9aa8\u7c89\uff0c\u68c0\u6d4b\u5230 {} \u4e2a\u65b9\u5757\u53d8\u5316", (Object)totalBoneMealUsed, (Object)totalChangesDetected);
        }
    }

    private Set<class_2338> getPositionsToCheck(class_2338 groundPos) {
        HashSet<class_2338> positions = new HashSet<class_2338>();
        positions.add(groundPos);
        for (int y = 1; y <= 8; ++y) {
            positions.add(groundPos.method_10086(y));
        }
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (x == 0 && z == 0) continue;
                class_2338 adjacentPos = groundPos.method_10069(x, 0, z);
                positions.add(adjacentPos);
                for (int y = 1; y <= 4; ++y) {
                    positions.add(adjacentPos.method_10086(y));
                }
            }
        }
        return positions;
    }

    private void checkForChanges(Set<class_2338> positionsToCheck, Map<class_2338, class_2680> statesBefore, class_1937 world, List<class_2338> affectedPositions, List<class_2680> originalStates, List<class_2680> newStates, int attempt) {
        int changesFound = 0;
        for (class_2338 checkPos : positionsToCheck) {
            class_2680 stateAfter = world.method_8320(checkPos);
            class_2680 stateBefore = statesBefore.get(checkPos);
            if (stateBefore.equals((Object)stateAfter) || affectedPositions.contains(checkPos)) continue;
            affectedPositions.add(checkPos);
            originalStates.add(stateBefore);
            newStates.add(stateAfter);
            ++changesFound;
            PushdozerMod.LOGGER.debug("\u9aa8\u7c89\u53d8\u5316\u68c0\u6d4b: \u4f4d\u7f6e {} \u4ece {} \u53d8\u4e3a {} (\u5c1d\u8bd5 {})", new Object[]{checkPos, stateBefore.method_26204(), stateAfter.method_26204(), attempt > 0 ? Integer.valueOf(attempt) : "\u6700\u7ec8\u68c0\u67e5"});
        }
        if (changesFound > 0) {
            PushdozerMod.LOGGER.debug("\u672c\u6b21\u68c0\u67e5\u53d1\u73b0 {} \u4e2a\u65b0\u53d8\u5316", (Object)changesFound);
        }
    }

    private boolean isGrowableBlock(class_2680 state) {
        class_2248 block = state.method_26204();
        if (GROWABLE_BLOCKS.contains(block)) {
            return true;
        }
        return block == class_2246.field_10402 || block == class_2246.field_10520 || block == class_2246.field_10253 || block == class_2246.field_28685 || block == class_2246.field_28681 || block == class_2246.field_37576 || block == class_2246.field_37547;
    }
}

