/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.shapes;

import com.pushdozer.shapes.GeometryShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

public class SphereShape
implements GeometryShape {
    private final double radius;
    private class_243 sphereCenter;
    private class_2338 center;

    public SphereShape(double radius, class_243 center) {
        this.radius = radius;
        this.sphereCenter = center;
        this.center = new class_2338((int)Math.floor(center.field_1352), (int)Math.floor(center.field_1351), (int)Math.floor(center.field_1350));
    }

    @Override
    public class_2338 getCenter() {
        return this.center;
    }

    @Override
    public void setCenter(class_2338 newCenter) {
        if (newCenter == null) {
            throw new IllegalArgumentException("The central location cannot be empty");
        }
        this.center = newCenter;
        this.sphereCenter = class_243.method_24953((class_2382)newCenter);
    }

    @Override
    public void renderOutline(class_4587 matrices, class_4588 vertexConsumer, class_243 center, float red, float green, float blue, float alpha) {
        matrices.method_22903();
        matrices.method_22904(center.field_1352, center.field_1351, center.field_1350);
        int segments = 64;
        float r = (float)this.radius;
        this.drawCircle(matrices, vertexConsumer, segments, r, 0.0f, red, green, blue, alpha);
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
        this.drawCircle(matrices, vertexConsumer, segments, r, 0.0f, red, green, blue, alpha);
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
        this.drawCircle(matrices, vertexConsumer, segments, r, 0.0f, red, green, blue, alpha);
        matrices.method_22909();
    }

    @Override
    public void renderSolid(class_4587 matrices, class_4588 vertexConsumer, class_243 center, float red, float green, float blue, float alpha) {
        matrices.method_22903();
        matrices.method_22904(center.field_1352, center.field_1351, center.field_1350);
        int segments = 32;
        for (int i = 0; i < segments; ++i) {
            float theta1 = (float)((double)i * Math.PI * 2.0 / (double)segments);
            float theta2 = (float)((double)(i + 1) * Math.PI * 2.0 / (double)segments);
            for (int j = 0; j < segments / 2; ++j) {
                float phi1 = (float)((double)j * Math.PI / (double)(segments / 2));
                float phi2 = (float)((double)(j + 1) * Math.PI / (double)(segments / 2));
                this.renderSphereFace(matrices, vertexConsumer, theta1, theta2, phi1, phi2, red, green, blue, alpha);
            }
        }
        matrices.method_22909();
    }

    @Override
    public boolean isInside(class_243 pos) {
        return pos.method_1025(this.sphereCenter) <= this.radius * this.radius;
    }

    @Override
    public boolean isInside(class_2338 pos) {
        return new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5).method_1025(this.sphereCenter) <= this.radius * this.radius;
    }

    @Override
    public int getMinY(class_2338 basePos) {
        return (int)((double)basePos.method_10264() - this.radius);
    }

    @Override
    public int getMaxY(class_2338 basePos) {
        return (int)((double)basePos.method_10264() + this.radius);
    }

    @Override
    public List<class_2338> getBlocksInLayer(class_2338 basePos, int y) {
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        int layerY = y - basePos.method_10264();
        if ((double)Math.abs(layerY) > this.radius) {
            return blocks;
        }
        int layerRadius = (int)Math.sqrt(this.radius * this.radius - (double)(layerY * layerY));
        for (int x = -layerRadius; x <= layerRadius; ++x) {
            int zLimit = (int)Math.sqrt(layerRadius * layerRadius - x * x);
            for (int z = -zLimit; z <= zLimit; ++z) {
                blocks.add(new class_2338(basePos.method_10263() + x, y, basePos.method_10260() + z));
            }
        }
        return blocks;
    }

    @Override
    public List<class_2338> getBlocksInRadius(class_243 center, int maxDistance) {
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        int minX = (int)Math.floor(this.sphereCenter.field_1352 - this.radius);
        int maxX = (int)Math.ceil(this.sphereCenter.field_1352 + this.radius);
        int minY = (int)Math.floor(this.sphereCenter.field_1351 - this.radius);
        int maxY = (int)Math.ceil(this.sphereCenter.field_1351 + this.radius);
        int minZ = (int)Math.floor(this.sphereCenter.field_1350 - this.radius);
        int maxZ = (int)Math.ceil(this.sphereCenter.field_1350 + this.radius);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    if (!(this.sphereCenter.method_1025(class_243.method_24953((class_2382)pos)) <= this.radius * this.radius)) continue;
                    blocks.add(pos);
                }
            }
        }
        return blocks;
    }

    @Override
    public class_238 getBoundingBox(class_2338 basePos) {
        class_243 worldCenter = this.sphereCenter.method_1019(class_243.method_24953((class_2382)basePos));
        return new class_238(worldCenter.field_1352 - this.radius, worldCenter.field_1351 - this.radius, worldCenter.field_1350 - this.radius, worldCenter.field_1352 + this.radius, worldCenter.field_1351 + this.radius, worldCenter.field_1350 + this.radius);
    }

    @Override
    public boolean isWithinBounds(class_2338 pos, class_2338 centerPos) {
        return pos.method_10262((class_2382)centerPos) <= this.radius * this.radius;
    }

    @Override
    public List<class_2338> getBlocks() {
        return this.getBlocksInRadius(this.sphereCenter, (int)Math.ceil(this.radius));
    }

    @Override
    public Iterator<class_2338> getBlocksIterator() {
        return this.getBlocks().iterator();
    }

    @Override
    public List<class_2338> getBlockPositions() {
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        int minX = (int)Math.floor(this.sphereCenter.field_1352 - this.radius);
        int maxX = (int)Math.ceil(this.sphereCenter.field_1352 + this.radius);
        int minY = (int)Math.floor(this.sphereCenter.field_1351 - this.radius);
        int maxY = (int)Math.ceil(this.sphereCenter.field_1351 + this.radius);
        int minZ = (int)Math.floor(this.sphereCenter.field_1350 - this.radius);
        int maxZ = (int)Math.ceil(this.sphereCenter.field_1350 + this.radius);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    if (!this.isInside(pos)) continue;
                    blocks.add(pos);
                }
            }
        }
        return blocks;
    }

    public class_243 getCenterVec3d() {
        return this.sphereCenter;
    }

    public double getRadius() {
        return this.radius;
    }

    private void drawCircle(class_4587 matrices, class_4588 vertexConsumer, int segments, float radius, float y, float red, float green, float blue, float alpha) {
        float theta = 0.0f;
        float step = (float)(Math.PI * 2 / (double)segments);
        for (int i = 0; i <= segments; ++i) {
            float x1 = radius * (float)Math.cos(theta);
            float z1 = radius * (float)Math.sin(theta);
            float x2 = radius * (float)Math.cos(theta + step);
            float z2 = radius * (float)Math.sin(theta + step);
            class_243 normal1 = new class_243((double)x1, (double)y, (double)z1).method_1029();
            class_243 normal2 = new class_243((double)x2, (double)y, (double)z2).method_1029();
            vertexConsumer.method_22918(matrices.method_23760().method_23761(), x1, y, z1).method_22915(red, green, blue, alpha).method_22914((float)normal1.field_1352, (float)normal1.field_1351, (float)normal1.field_1350);
            vertexConsumer.method_22918(matrices.method_23760().method_23761(), x2, y, z2).method_22915(red, green, blue, alpha).method_22914((float)normal2.field_1352, (float)normal2.field_1351, (float)normal2.field_1350);
            theta += step;
        }
    }

    private void renderSphereFace(class_4587 matrices, class_4588 vertexConsumer, float theta1, float theta2, float phi1, float phi2, float red, float green, float blue, float alpha) {
        class_243 v1 = this.getSpherePoint(theta1, phi1);
        class_243 v2 = this.getSpherePoint(theta1, phi2);
        class_243 v3 = this.getSpherePoint(theta2, phi2);
        class_243 v4 = this.getSpherePoint(theta2, phi1);
        class_243 normal1 = v1.method_1029();
        class_243 normal2 = v2.method_1029();
        class_243 normal3 = v3.method_1029();
        class_243 normal4 = v4.method_1029();
        this.addVertex(matrices, vertexConsumer, v1, normal1, red, green, blue, alpha, theta1, phi1);
        this.addVertex(matrices, vertexConsumer, v2, normal2, red, green, blue, alpha, theta1, phi2);
        this.addVertex(matrices, vertexConsumer, v3, normal3, red, green, blue, alpha, theta2, phi2);
        this.addVertex(matrices, vertexConsumer, v1, normal1, red, green, blue, alpha, theta1, phi1);
        this.addVertex(matrices, vertexConsumer, v3, normal3, red, green, blue, alpha, theta2, phi2);
        this.addVertex(matrices, vertexConsumer, v4, normal4, red, green, blue, alpha, theta2, phi1);
    }

    private void addVertex(class_4587 matrices, class_4588 vertexConsumer, class_243 pos, class_243 normal, float red, float green, float blue, float alpha, float u, float v) {
        vertexConsumer.method_22918(matrices.method_23760().method_23761(), (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350).method_22915(red, green, blue, alpha).method_22913(u / ((float)Math.PI * 2), v / (float)Math.PI).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
    }

    private class_243 getSpherePoint(float theta, float phi) {
        float x = (float)(this.radius * Math.sin(phi) * Math.cos(theta));
        float y = (float)(this.radius * Math.cos(phi));
        float z = (float)(this.radius * Math.sin(phi) * Math.sin(theta));
        return new class_243((double)x, (double)y, (double)z);
    }
}

