/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.items.handlers;

import com.pushdozer.PushdozerMod;
import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.operations.UndoAction;
import com.pushdozer.shapes.GeometryShape;
import com.pushdozer.util.ShapeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2362;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;

public class SurfaceConvertHandler {
    private final PushdozerConfig config;
    private static final Random RANDOM = new Random();
    private static final Set<class_2248> IGNORED_BLOCKS = Set.of(class_2246.field_10431, class_2246.field_10037, class_2246.field_10511, class_2246.field_10306, class_2246.field_10533, class_2246.field_10010, class_2246.field_37545, class_2246.field_42729, class_2246.field_10479, class_2246.field_10214, class_2246.field_10112, class_2246.field_10313, class_2246.field_56562, class_2246.field_56563, class_2246.field_10182, class_2246.field_10449, class_2246.field_10086, class_2246.field_10226, class_2246.field_10573, class_2246.field_10270, class_2246.field_10048, class_2246.field_10156, class_2246.field_10315, class_2246.field_10554, class_2246.field_9995, class_2246.field_10548, class_2246.field_10583, class_2246.field_10378, class_2246.field_10430, class_2246.field_10003, class_2246.field_10606, class_2246.field_42734, class_2246.field_10428, class_2246.field_10029, class_2246.field_56564, class_2246.field_10424, class_2246.field_10211, class_2246.field_10021, class_2246.field_10528, class_2246.field_22117, class_2246.field_22116, class_2246.field_22125, class_2246.field_22114, class_2246.field_22121, class_2246.field_22123, class_2246.field_23078, class_2246.field_28411, class_2246.field_28686, class_2246.field_28677, class_2246.field_28679, class_2246.field_28678, class_2246.field_28680, class_2246.field_10376, class_2246.field_10238, class_2246.field_9993, class_2246.field_10463, class_2246.field_10476, class_2246.field_10588, class_2246.field_28684, class_2246.field_28682, class_2246.field_43229, class_2246.field_10394, class_2246.field_10217, class_2246.field_10575, class_2246.field_10276, class_2246.field_10385, class_2246.field_10160, class_2246.field_37544, class_2246.field_42727, class_2246.field_10293, class_2246.field_10609, class_2246.field_10247, class_2246.field_10341, class_2246.field_16999, class_2246.field_10302, class_2246.field_46287, class_2246.field_46286, class_2246.field_10251, class_2246.field_10559, class_2246.field_10597, class_2246.field_28675, class_2246.field_28676);

    public SurfaceConvertHandler(PushdozerConfig config) {
        this.config = config;
    }

    public void handleSurfaceConvert(class_1657 player, class_1937 world) {
        if (world.field_9236) {
            return;
        }
        class_2338 basePos = ShapeUtil.getTargetBlockPos(player, this.config);
        GeometryShape shape = ShapeUtil.createShape(player, this.config, basePos);
        if (shape == null) {
            return;
        }
        ArrayList<class_2338> affectedPositions = new ArrayList<class_2338>();
        ArrayList<class_2680> originalStates = new ArrayList<class_2680>();
        ArrayList<class_2680> newStates = new ArrayList<class_2680>();
        this.convertSurface(world, shape, affectedPositions, originalStates, newStates);
        if (!affectedPositions.isEmpty()) {
            UndoAction undoAction = new UndoAction(UndoAction.ActionType.SURFACE_CONVERT, affectedPositions, originalStates, newStates);
            PushdozerMod.pushUndoAction(player, undoAction);
        }
    }

    private void convertSurface(class_1937 world, GeometryShape shape, List<class_2338> affectedPositions, List<class_2680> originalStates, List<class_2680> newStates) {
        HashMap<class_2338, List> columnYMap = new HashMap<class_2338, List>();
        for (class_2338 pos : shape.getBlockPositions()) {
            class_2338 columnPos = new class_2338(pos.method_10263(), 0, pos.method_10260());
            columnYMap.computeIfAbsent(columnPos, k -> new ArrayList()).add(pos.method_10264());
        }
        ArrayList<class_2338> newlyPlacedSurfacePositions = new ArrayList<class_2338>();
        block1: for (Map.Entry entry : columnYMap.entrySet()) {
            class_2338 columnPos = (class_2338)entry.getKey();
            List yList = (List)entry.getValue();
            yList.sort(Collections.reverseOrder());
            Iterator iterator = yList.iterator();
            while (iterator.hasNext()) {
                int y = (Integer)iterator.next();
                class_2338 surfacePos = new class_2338(columnPos.method_10263(), y, columnPos.method_10260());
                class_2680 state = world.method_8320(surfacePos);
                if (world.method_22347(surfacePos) || this.isWater(world, surfacePos) || this.isIgnoredBlock(state)) continue;
                class_2248 targetBlock = this.selectTargetBlock();
                class_2680 targetState = targetBlock.method_9564();
                if (state.method_26204() == targetBlock) continue block1;
                affectedPositions.add(surfacePos);
                originalStates.add(state);
                newStates.add(targetState);
                world.method_8652(surfacePos, targetState, 3);
                newlyPlacedSurfacePositions.add(surfacePos);
                continue block1;
            }
        }
        this.removeFloatingVegetation(world, newlyPlacedSurfacePositions, affectedPositions, originalStates, newStates);
    }

    private class_2248 selectTargetBlock() {
        List<PushdozerConfig.SurfaceConvertBlock> surfaceBlocks = this.config.getSurfaceConvertBlocks();
        if (surfaceBlocks.isEmpty()) {
            return class_2246.field_10219;
        }
        float totalPercentage = 0.0f;
        for (PushdozerConfig.SurfaceConvertBlock block : surfaceBlocks) {
            totalPercentage += block.getPercentage();
        }
        if (totalPercentage <= 0.0f) {
            return class_2246.field_10219;
        }
        float random = RANDOM.nextFloat() * totalPercentage;
        float currentSum = 0.0f;
        for (PushdozerConfig.SurfaceConvertBlock surfaceBlock : surfaceBlocks) {
            if (!(random <= (currentSum += surfaceBlock.getPercentage()))) continue;
            try {
                String blockId = surfaceBlock.getBlockId();
                class_2248 block = (class_2248)class_7923.field_41175.method_63535(class_2960.method_60654((String)blockId));
                if (block == class_2246.field_10124) continue;
                return block;
            }
            catch (Exception exception) {
            }
        }
        return class_2246.field_10219;
    }

    private boolean isWater(class_1937 world, class_2338 pos) {
        return !world.method_8316(pos).method_15769() && world.method_8316(pos).method_15772().method_15780((class_3611)class_3612.field_15910);
    }

    private boolean isIgnoredBlock(class_2680 state) {
        class_2248 block = state.method_26204();
        return IGNORED_BLOCKS.contains(block) || this.isPotted(block) || this.isLiveCoral(block) || this.isDeadCoral(block);
    }

    private boolean isPotted(class_2248 block) {
        return block instanceof class_2362 && block != class_2246.field_10495;
    }

    private boolean isLiveCoral(class_2248 block) {
        String id = block.toString().toLowerCase();
        return id.contains("coral") && !id.contains("dead");
    }

    private boolean isDeadCoral(class_2248 block) {
        String id = block.toString().toLowerCase();
        return id.contains("coral") && id.contains("dead");
    }

    private boolean isLeafBlock(class_2680 state) {
        return state.method_26204() instanceof class_2397;
    }

    private void removeFloatingVegetation(class_1937 world, List<class_2338> surfacePositions, List<class_2338> affectedPositions, List<class_2680> originalStates, List<class_2680> newStates) {
        Set<class_2248> floatingPlants = Set.of(class_2246.field_10214, class_2246.field_10112, class_2246.field_10313, class_2246.field_10182, class_2246.field_10449, class_2246.field_10086, class_2246.field_10226, class_2246.field_10573, class_2246.field_10270, class_2246.field_10048, class_2246.field_10156, class_2246.field_10315, class_2246.field_10554, class_2246.field_9995, class_2246.field_10548, class_2246.field_10583, class_2246.field_10378, class_2246.field_10430, class_2246.field_10003, class_2246.field_56562, class_2246.field_56563);
        for (class_2338 surfacePos : surfacePositions) {
            class_2338 pos = surfacePos.method_10084();
            class_2680 state = world.method_8320(pos);
            class_2248 block = state.method_26204();
            if (!floatingPlants.contains(block)) continue;
            affectedPositions.add(pos);
            originalStates.add(state);
            newStates.add(class_2246.field_10124.method_9564());
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
    }
}

