/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.items.handlers;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.items.handlers.AbstractTerrainToolHandler;
import com.pushdozer.operations.UndoAction;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;

public class SurfaceRoughenHandler
extends AbstractTerrainToolHandler {
    private static final int[] PERMUTATION = new int[]{151, 160, 137, 91, 90, 15, 131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240, 21, 10, 23, 190, 6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54, 65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187, 208, 89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86, 164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147, 118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70, 221, 153, 101, 155, 167, 43, 172, 9, 129, 22, 39, 253, 19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104, 218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176, 115, 121, 50, 45, 127, 4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66, 215, 61, 156, 180};
    private static final float DEFAULT_NOISE_FREQUENCY = 0.02f;
    private static final float DEFAULT_NOISE_PERSISTENCE = 0.5f;
    private static final float MAX_ROUGHNESS_AMPLITUDE = 5.0f;
    private final long noiseSeed;
    private final Map<Long, Float> noiseCache = new HashMap<Long, Float>();

    public SurfaceRoughenHandler(PushdozerConfig config) {
        super(config);
        this.noiseSeed = config.getNoiseSeed();
    }

    public void handleSurfaceRoughen(class_1657 player, class_1937 world) {
        this.noiseCache.clear();
        this.handleOperation(player, world, UndoAction.ActionType.SURFACE_ROUGHEN);
    }

    @Override
    protected int calculateTargetHeight(Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> columns, AbstractTerrainToolHandler.TerrainColumn currentColumn, class_2338 columnXZ, class_2338 brushCenter) {
        int brushRadius = this.config.getRadius();
        float originalHeight = currentColumn.getOriginalHeight();
        float smoothedHeight = this.calculateSmoothedHeight(columns, columnXZ, brushCenter, brushRadius);
        if (smoothedHeight <= 0.0f) {
            smoothedHeight = originalHeight;
        }
        float smoothingIntensity = this.config.getSmoothingIntensity();
        float baseHeight = originalHeight * (1.0f - smoothingIntensity) + smoothedHeight * smoothingIntensity;
        float noiseValue = this.generateSeededPerlinNoise(columnXZ.method_10263(), columnXZ.method_10260());
        float roughnessStrength = this.config.getRoughnessStrength();
        float roughnessAmount = Math.min(roughnessStrength * 3.0f, 5.0f);
        class_2680 mainBlock = currentColumn.getMainBlockState();
        if (mainBlock.method_27852(class_2246.field_10102)) {
            roughnessAmount *= 0.7f;
        } else if (mainBlock.method_27852(class_2246.field_10340) || mainBlock.method_27852(class_2246.field_28888)) {
            roughnessAmount *= 1.2f;
        } else if (mainBlock.method_27852(class_2246.field_10219)) {
            roughnessAmount *= 0.9f;
        }
        float heightOffset = noiseValue * roughnessAmount;
        float falloff = this.calculateEdgeFalloff(columnXZ, brushCenter, brushRadius);
        float targetHeight = baseHeight + heightOffset * falloff;
        return Math.round(targetHeight);
    }

    private float generateSeededPerlinNoise(int x, int z) {
        long key = (long)x << 32 | (long)z & 0xFFFFFFFFL;
        Float cached = this.noiseCache.get(key);
        if (cached != null) {
            return cached.floatValue();
        }
        float noise = 0.0f;
        float amplitude = 1.0f;
        float frequency = this.getNoiseFrequency();
        float persistence = this.getNoisePersistence();
        int octaves = this.getNoiseOctaves();
        float maxAmplitude = 0.0f;
        for (int i = 0; i < octaves; ++i) {
            int seededX = x + (int)(this.noiseSeed & 0xFFFFL);
            int seededZ = z + (int)(this.noiseSeed >> 16 & 0xFFFFL);
            noise += amplitude * this.perlinNoise((float)seededX * frequency, (float)seededZ * frequency);
            maxAmplitude += amplitude;
            amplitude *= persistence;
            frequency *= 2.0f;
        }
        float result = maxAmplitude > 0.0f ? noise / maxAmplitude : 0.0f;
        this.noiseCache.put(key, Float.valueOf(result));
        return result;
    }

    private float getNoiseFrequency() {
        if (!this.config.isNoiseAutoScale()) {
            return this.config.getNoiseFrequency();
        }
        int r = Math.max(1, this.config.getRadius());
        float scale = (float)Math.max(0.5, Math.min(4.0, 12.0 / (double)r));
        float freq = 0.02f * scale;
        return Math.max(0.01f, Math.min(0.15f, freq));
    }

    private float getNoisePersistence() {
        if (!this.config.isNoiseAutoScale()) {
            return this.config.getNoisePersistence();
        }
        return 0.5f;
    }

    private int getNoiseOctaves() {
        if (!this.config.isNoiseAutoScale()) {
            return this.config.getNoiseOctaves();
        }
        int r = Math.max(1, this.config.getRadius());
        return 3 + Math.min(2, Math.max(0, (r - 6) / 8));
    }

    private float perlinNoise(float x, float z) {
        int xi = (int)Math.floor(x) & 0xFF;
        int zi = (int)Math.floor(z) & 0xFF;
        float xf = x - (float)Math.floor(x);
        float zf = z - (float)Math.floor(z);
        float u = this.fade(xf);
        float w = this.fade(zf);
        int A = PERMUTATION[xi] + zi;
        int AA = PERMUTATION[A & 0xFF];
        int AB = PERMUTATION[A + 1 & 0xFF];
        int B = PERMUTATION[xi + 1 & 0xFF] + zi;
        int BA = PERMUTATION[B & 0xFF];
        int BB = PERMUTATION[B + 1 & 0xFF];
        float g00 = this.grad(AA, xf, zf);
        float g10 = this.grad(BA, xf - 1.0f, zf);
        float g01 = this.grad(AB, xf, zf - 1.0f);
        float g11 = this.grad(BB, xf - 1.0f, zf - 1.0f);
        float x1 = this.lerp(g00, g10, u);
        float x2 = this.lerp(g01, g11, u);
        return this.lerp(x1, x2, w);
    }

    private float lerp(float a, float b, float t) {
        return a + t * (b - a);
    }

    private float fade(float t) {
        return t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
    }

    private float grad(int hash, float x, float z) {
        float u;
        int h = hash & 0xF;
        float f = u = h < 8 ? x : z;
        float v = h < 4 ? z : (h == 12 || h == 14 ? x : z);
        return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
    }

    private float calculateEdgeFalloff(class_2338 columnXZ, class_2338 brushCenter, int brushRadius) {
        class_2338 brushCenterXZ = new class_2338(brushCenter.method_10263(), 0, brushCenter.method_10260());
        double distanceSq = columnXZ.method_10262((class_2382)brushCenterXZ);
        float sigma = (float)brushRadius * 0.4f;
        return (float)Math.exp(-distanceSq / (2.0 * (double)sigma * (double)sigma));
    }
}

