/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.network;

import com.pushdozer.network.TerrainOperationPayload;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedNetworkManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"pushdozer");
    private static final int MAX_BATCH_SIZE = 500;
    private static final int BATCH_DELAY_MS = 100;
    private static BatchedNetworkManager instance;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "Pushdozer-Network-Batch");
        t.setDaemon(true);
        return t;
    });
    private final Map<class_3218, BatchedOperation> pendingOperations = new ConcurrentHashMap<class_3218, BatchedOperation>();

    private BatchedNetworkManager() {
    }

    public static BatchedNetworkManager getInstance() {
        if (instance == null) {
            instance = new BatchedNetworkManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTerrainOperation(class_3218 world, String operationType, List<class_2338> positions, List<class_2680> states) {
        BatchedOperation operation;
        if (positions.isEmpty() || states.isEmpty()) {
            return;
        }
        BatchedOperation batchedOperation = operation = this.pendingOperations.computeIfAbsent(world, k -> new BatchedOperation(world));
        synchronized (batchedOperation) {
            operation.addOperation(operationType, positions, states);
            if (operation.getTotalSize() >= 500) {
                this.sendBatch(operation);
                this.pendingOperations.remove(world);
            } else if (!operation.isScheduled) {
                operation.isScheduled = true;
                this.scheduler.schedule(() -> {
                    BatchedOperation batchedOperation = operation;
                    synchronized (batchedOperation) {
                        if (this.pendingOperations.remove(world) != null) {
                            this.sendBatch(operation);
                        }
                    }
                }, 100L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushWorld(class_3218 world) {
        BatchedOperation operation = this.pendingOperations.remove(world);
        if (operation != null) {
            BatchedOperation batchedOperation = operation;
            synchronized (batchedOperation) {
                this.sendBatch(operation);
            }
        }
    }

    private void sendBatch(BatchedOperation operation) {
        try {
            List players = operation.world.method_18456();
            if (players.isEmpty()) {
                return;
            }
            List<class_2338> allPositions = operation.getAllPositions();
            List<class_2680> allStates = operation.getAllStates();
            String operationType = operation.getOperationType();
            int chunks = (int)Math.ceil((double)allPositions.size() / 500.0);
            for (int i = 0; i < chunks; ++i) {
                int start = i * 500;
                int end = Math.min(start + 500, allPositions.size());
                List<class_2338> chunkPositions = allPositions.subList(start, end);
                List<class_2680> chunkStates = allStates.subList(start, end);
                TerrainOperationPayload payload = new TerrainOperationPayload(operationType, chunkPositions, chunkStates);
                for (class_3222 player : players) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
                }
                LOGGER.debug("\u53d1\u9001\u5730\u5f62\u64cd\u4f5c\u6279\u6b21 {}/{} \u5230 {} \u4e2a\u73a9\u5bb6\uff0c\u65b9\u5757\u6570: {}", new Object[]{i + 1, chunks, players.size(), chunkPositions.size()});
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001\u6279\u5904\u7406\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Iterator<BatchedOperation> iterator = this.pendingOperations.values().iterator();
        while (iterator.hasNext()) {
            BatchedOperation operation;
            BatchedOperation batchedOperation = operation = iterator.next();
            synchronized (batchedOperation) {
                this.sendBatch(operation);
            }
        }
        this.pendingOperations.clear();
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static class BatchedOperation {
        final class_3218 world;
        final List<class_2338> positions = new ArrayList<class_2338>();
        final List<class_2680> states = new ArrayList<class_2680>();
        String operationType = "";
        boolean isScheduled = false;

        BatchedOperation(class_3218 world) {
            this.world = world;
        }

        void addOperation(String opType, List<class_2338> newPositions, List<class_2680> newStates) {
            if (this.operationType.isEmpty()) {
                this.operationType = opType;
            }
            this.positions.addAll(newPositions);
            this.states.addAll(newStates);
        }

        int getTotalSize() {
            return this.positions.size();
        }

        List<class_2338> getAllPositions() {
            return new ArrayList<class_2338>(this.positions);
        }

        List<class_2680> getAllStates() {
            return new ArrayList<class_2680>(this.states);
        }

        String getOperationType() {
            return this.operationType;
        }
    }
}

