/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.render;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.items.PushdozerItem;
import com.pushdozer.render.PointCloudRenderer;
import com.pushdozer.render.WireframeRenderer;
import com.pushdozer.shapes.GeometryShape;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;

public class ShapeRenderer {
    public static boolean shouldRenderShape() {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        return player != null && ShapeRenderer.isHoldingPushdozer((class_1657)player) && ShapeRenderer.getCurrentDisplayMode((class_1657)player) != PushdozerItem.DisplayMode.NONE;
    }

    public static void renderShape(GeometryShape shape, PushdozerConfig config) {
        if (ShapeRenderer.shouldRenderShape()) {
            PushdozerItem.DisplayMode displayMode = null;
            if (class_310.method_1551().field_1724 != null) {
                displayMode = ShapeRenderer.getCurrentDisplayMode((class_1657)class_310.method_1551().field_1724);
            }
            if (displayMode != null) {
                ShapeRenderer.renderShapeAccordingToMode(shape, displayMode, config);
            }
        }
    }

    private static boolean isHoldingPushdozer(class_1657 player) {
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = player.method_6079();
        return mainHand.method_7909() instanceof PushdozerItem || offHand.method_7909() instanceof PushdozerItem;
    }

    private static PushdozerItem.DisplayMode getCurrentDisplayMode(class_1657 player) {
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = player.method_6079();
        if (mainHand.method_7909() instanceof PushdozerItem) {
            return ((PushdozerItem)mainHand.method_7909()).getDisplayMode(mainHand);
        }
        if (offHand.method_7909() instanceof PushdozerItem) {
            return ((PushdozerItem)offHand.method_7909()).getDisplayMode(offHand);
        }
        return PushdozerItem.DisplayMode.NONE;
    }

    private static void renderShapeAccordingToMode(GeometryShape shape, PushdozerItem.DisplayMode mode, PushdozerConfig config) {
        switch (mode) {
            case WIREFRAME: {
                ShapeRenderer.renderWireframe(shape, config);
                break;
            }
            case POINT_CLOUD: {
                ShapeRenderer.renderPointCloud(shape, config);
                break;
            }
        }
    }

    private static void renderWireframe(GeometryShape shape, PushdozerConfig config) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            class_4587 matrices = new class_4587();
            class_4597.class_4598 vertexConsumers = client.method_22940().method_23000();
            class_2338 basePos = client.field_1724.method_24515();
            WireframeRenderer.render(matrices, (class_4597)vertexConsumers, shape, basePos);
        }
    }

    private static void renderPointCloud(GeometryShape shape, PushdozerConfig config) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            class_4587 matrices = new class_4587();
            class_4597.class_4598 vertexConsumers = client.method_22940().method_23000();
            class_2338 basePos = client.field_1724.method_24515();
            PointCloudRenderer.render(matrices, (class_4597)vertexConsumers, shape, basePos);
        }
    }
}

