/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.panels.workmode;

import com.pushdozer.PushdozerMod;
import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.ui.panels.workmode.WorkModeConfigPanel;
import com.pushdozer.ui.screens.PushdozerConfigScreen;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_7919;

public class SmoothConfigPanel
extends WorkModeConfigPanel {
    private class_4185 adaptiveButton;
    private class_4185 raiseButton;
    private class_4185 lowerButton;
    private class_357 strengthSlider;

    public SmoothConfigPanel(PushdozerConfigScreen parent, PushdozerConfig config) {
        super(parent, config);
    }

    @Override
    protected class_2561 getTitleText() {
        return class_2561.method_43471((String)"pushdozer.panel.smooth.title");
    }

    @Override
    protected void initializeWidgets() {
        this.widgets.clear();
        int contentLeft = this.panelLeft + 5;
        int contentTop = this.panelTop + 20 + 5;
        int contentWidth = 200;
        this.adaptiveButton = class_4185.method_46430((class_2561)this.getVariantButtonText(PushdozerConfig.SmoothVariant.ADAPTIVE), btn -> this.selectVariant(PushdozerConfig.SmoothVariant.ADAPTIVE)).method_46434(contentLeft, contentTop, contentWidth, 20).method_46431();
        this.widgets.add(this.adaptiveButton);
        this.raiseButton = class_4185.method_46430((class_2561)this.getVariantButtonText(PushdozerConfig.SmoothVariant.RAISE), btn -> this.selectVariant(PushdozerConfig.SmoothVariant.RAISE)).method_46434(contentLeft, contentTop + 25, contentWidth, 20).method_46431();
        this.widgets.add(this.raiseButton);
        this.lowerButton = class_4185.method_46430((class_2561)this.getVariantButtonText(PushdozerConfig.SmoothVariant.LOWER), btn -> this.selectVariant(PushdozerConfig.SmoothVariant.LOWER)).method_46434(contentLeft, contentTop + 50, contentWidth, 20).method_46431();
        this.widgets.add(this.lowerButton);
        float currentStrength = this.config.getSmoothStrength();
        this.strengthSlider = new class_357(contentLeft, contentTop + 75, contentWidth, 20, this.getStrengthText(currentStrength), (currentStrength - 0.1f) / 0.9f){

            protected void method_25346() {
                float strength = (float)(this.field_22753 * (double)0.9f + (double)0.1f);
                this.method_25355(SmoothConfigPanel.this.getStrengthText(strength));
            }

            protected void method_25344() {
                float strength = (float)(this.field_22753 * (double)0.9f + (double)0.1f);
                try {
                    SmoothConfigPanel.this.config.setSmoothStrength(strength);
                }
                catch (Exception e) {
                    PushdozerMod.LOGGER.error("Failed to update smooth strength", (Throwable)e);
                }
            }
        };
        this.strengthSlider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.tooltip.smooth_strength")));
        this.widgets.add(this.strengthSlider);
    }

    @Override
    protected void renderWidgets(class_332 context, int mouseX, int mouseY, float delta) {
        for (class_364 widget : this.widgets) {
            if (!(widget instanceof class_4185)) continue;
            class_4185 button = (class_4185)widget;
            button.method_25365(false);
        }
        PushdozerConfig.SmoothVariant currentVariant = this.config.getSmoothVariant();
        for (class_364 widget : this.widgets) {
            boolean isSelected;
            class_4185 button;
            if (!(widget instanceof class_4185) || (button = (class_4185)widget) != this.adaptiveButton && button != this.raiseButton && button != this.lowerButton) continue;
            if (button == this.adaptiveButton) {
                isSelected = currentVariant == PushdozerConfig.SmoothVariant.ADAPTIVE;
            } else if (button == this.raiseButton) {
                isSelected = currentVariant == PushdozerConfig.SmoothVariant.RAISE;
            } else {
                boolean bl = isSelected = currentVariant == PushdozerConfig.SmoothVariant.LOWER;
            }
            if (!isSelected) continue;
            button.method_25365(true);
        }
        for (class_364 widget : this.widgets) {
            if (!(widget instanceof class_4068)) continue;
            ((class_4068)widget).method_25394(context, mouseX, mouseY, delta);
        }
    }

    private void selectVariant(PushdozerConfig.SmoothVariant variant) {
        try {
            this.config.setSmoothVariant(variant);
            this.updateVariantButtons();
        }
        catch (Exception e) {
            PushdozerMod.LOGGER.error("Failed to set smooth variant", (Throwable)e);
        }
    }

    private void updateVariantButtons() {
        if (this.adaptiveButton != null) {
            this.adaptiveButton.method_25355(this.getVariantButtonText(PushdozerConfig.SmoothVariant.ADAPTIVE));
        }
        if (this.raiseButton != null) {
            this.raiseButton.method_25355(this.getVariantButtonText(PushdozerConfig.SmoothVariant.RAISE));
        }
        if (this.lowerButton != null) {
            this.lowerButton.method_25355(this.getVariantButtonText(PushdozerConfig.SmoothVariant.LOWER));
        }
    }

    private class_2561 getVariantButtonText(PushdozerConfig.SmoothVariant variant) {
        boolean selected = this.config.getSmoothVariant() == variant;
        String prefix = selected ? "\u2611 " : "";
        return class_2561.method_43470((String)prefix).method_10852(variant.getDisplayText());
    }

    private class_2561 getStrengthText(float strength) {
        return class_2561.method_43469((String)"pushdozer.config.smooth_strength", (Object[])new Object[]{String.format("%.2f", Float.valueOf(strength))});
    }

    @Override
    public void saveConfig() {
        try {
            this.config.save();
            this.parent.showErrorMessage(class_2561.method_43471((String)"pushdozer.config.saved").getString());
        }
        catch (Exception e) {
            PushdozerMod.LOGGER.error("Failed to save smooth config", (Throwable)e);
        }
    }
}

