/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.client;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.items.PushdozerItem;
import com.pushdozer.network.ClientNetworkHandler;
import com.pushdozer.ui.screens.PushdozerConfigScreen;
import java.util.ArrayList;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class KeyBindings {
    public static final String KEY_CATEGORY_PUSHDOZER = "key.category.pushdozer";
    public static final String KEY_TOGGLE_MODE = "key.pushdozer.toggle_mode";
    public static final String KEY_OPEN_CONFIG = "key.pushdozer.open_config";
    public static final String KEY_TOGGLE_DISPLAY_MODE = "key.pushdozer.toggle_display_mode";
    public static final String KEY_UNDO = "key.pushdozer.undo";
    public static final String KEY_REDO = "key.pushdozer.redo";
    public static final String KEY_INCREASE_DISTANCE = "key.pushdozer.increase_distance";
    public static final String KEY_DECREASE_DISTANCE = "key.pushdozer.decrease_distance";
    public static final String KEY_TOGGLE_SHAPE = "key.pushdozer.toggle_shape";
    public static class_304 toggleModeKey;
    public static class_304 openConfigKey;
    public static class_304 toggleDisplayModeKey;
    public static class_304 undoKey;
    public static class_304 redoKey;
    public static class_304 increaseDistanceKey;
    public static class_304 decreaseDistanceKey;
    public static class_304 toggleShapeKey;

    public static void register() {
        toggleModeKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304(KEY_TOGGLE_MODE, class_3675.class_307.field_1668, 71, KEY_CATEGORY_PUSHDOZER));
        openConfigKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304(KEY_OPEN_CONFIG, class_3675.class_307.field_1668, 75, KEY_CATEGORY_PUSHDOZER));
        toggleDisplayModeKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304(KEY_TOGGLE_DISPLAY_MODE, class_3675.class_307.field_1668, 86, KEY_CATEGORY_PUSHDOZER));
        increaseDistanceKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304(KEY_INCREASE_DISTANCE, class_3675.class_307.field_1668, 265, KEY_CATEGORY_PUSHDOZER));
        decreaseDistanceKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304(KEY_DECREASE_DISTANCE, class_3675.class_307.field_1668, 264, KEY_CATEGORY_PUSHDOZER));
        toggleShapeKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304(KEY_TOGGLE_SHAPE, class_3675.class_307.field_1668, 85, KEY_CATEGORY_PUSHDOZER));
        undoKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304(KEY_UNDO, class_3675.class_307.field_1668, 90, KEY_CATEGORY_PUSHDOZER){

            public boolean method_1417(int keyCode, int scanCode) {
                return super.method_1417(keyCode, scanCode) && class_437.method_25441();
            }
        });
        redoKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304(KEY_REDO, class_3675.class_307.field_1668, 89, KEY_CATEGORY_PUSHDOZER){

            public boolean method_1417(int keyCode, int scanCode) {
                return super.method_1417(keyCode, scanCode) && class_437.method_25441();
            }
        });
        KeyBindings.registerKeyInputs();
    }

    private static void registerKeyInputs() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null && client.field_1724 != null) {
                if (toggleModeKey.method_1436() && KeyBindings.isHoldingPushdozer(client)) {
                    KeyBindings.toggleWorkMode(client);
                }
                if (openConfigKey.method_1436() && KeyBindings.isHoldingPushdozer(client)) {
                    KeyBindings.toggleConfigScreen(client);
                }
                if (toggleDisplayModeKey.method_1436() && KeyBindings.isHoldingPushdozer(client)) {
                    KeyBindings.toggleDisplayMode(client);
                }
                if (toggleShapeKey.method_1436() && KeyBindings.isHoldingPushdozer(client)) {
                    KeyBindings.toggleShape(client);
                }
                if (increaseDistanceKey.method_1436() && KeyBindings.isHoldingPushdozer(client)) {
                    KeyBindings.adjustOperationDistance(client, true);
                }
                if (decreaseDistanceKey.method_1436() && KeyBindings.isHoldingPushdozer(client)) {
                    KeyBindings.adjustOperationDistance(client, false);
                }
                if (undoKey.method_1436() && class_437.method_25441() && KeyBindings.isHoldingPushdozer(client)) {
                    ClientNetworkHandler.sendUndoRedoRequest(true);
                }
                if (redoKey.method_1436() && class_437.method_25441() && KeyBindings.isHoldingPushdozer(client)) {
                    ClientNetworkHandler.sendUndoRedoRequest(false);
                }
            }
        });
    }

    private static boolean isHoldingPushdozer(class_310 client) {
        if (client.field_1724 == null) {
            return false;
        }
        class_1799 mainHand = client.field_1724.method_6047();
        class_1799 offHand = client.field_1724.method_6079();
        return mainHand.method_7909() instanceof PushdozerItem || offHand.method_7909() instanceof PushdozerItem;
    }

    private static void toggleConfigScreen(class_310 client) {
        if (client.field_1755 instanceof PushdozerConfigScreen) {
            client.method_1507(null);
        } else {
            client.method_1507((class_437)new PushdozerConfigScreen(PushdozerConfig.getInstance()));
        }
    }

    private static void toggleDisplayMode(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        PushdozerConfig config = PushdozerConfig.getInstance();
        if (config.getDisplayMode() == null) {
            config.setDisplayMode(PushdozerConfig.DisplayMode.WIREFRAME);
        }
        PushdozerConfig.DisplayMode[] modes = PushdozerConfig.DisplayMode.values();
        int nextIndex = (config.getDisplayMode().ordinal() + 1) % modes.length;
        PushdozerConfig.DisplayMode newConfigMode = modes[nextIndex];
        config.setDisplayMode(newConfigMode);
        config.save();
        class_1799 mainHand = client.field_1724.method_6047();
        class_1799 offHand = client.field_1724.method_6079();
        PushdozerItem pushdozerItem = null;
        class_1799 targetStack = null;
        if (mainHand.method_7909() instanceof PushdozerItem) {
            pushdozerItem = (PushdozerItem)mainHand.method_7909();
            targetStack = mainHand;
        } else if (offHand.method_7909() instanceof PushdozerItem) {
            pushdozerItem = (PushdozerItem)offHand.method_7909();
            targetStack = offHand;
        }
        if (pushdozerItem != null) {
            PushdozerItem.DisplayMode newItemMode = PushdozerItem.DisplayMode.values()[newConfigMode.ordinal()];
            pushdozerItem.setDisplayMode(targetStack, newItemMode);
            client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"pushdozer.message.display_mode_switch", (Object[])new Object[]{newConfigMode.getDisplayText().getString()}), true);
        } else {
            client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"pushdozer.message.display_mode_switch", (Object[])new Object[]{newConfigMode.getDisplayText().getString()}), true);
        }
    }

    private static void toggleWorkMode(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        if (!KeyBindings.isHoldingPushdozer(client)) {
            client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"pushdozer.message.hold_tool"), true);
            return;
        }
        PushdozerConfig config = PushdozerConfig.getInstance();
        ArrayList<PushdozerConfig.WorkMode> visibleModes = new ArrayList<PushdozerConfig.WorkMode>();
        block3: for (PushdozerConfig.WorkMode m : PushdozerConfig.WorkMode.values()) {
            switch (m) {
                case SMOOTH_RAISE: 
                case SMOOTH_LOWER: 
                case ADAPTIVE_SMOOTH: {
                    continue block3;
                }
                default: {
                    visibleModes.add(m);
                }
            }
        }
        if (!visibleModes.contains((Object)PushdozerConfig.WorkMode.SMOOTH)) {
            visibleModes.add(PushdozerConfig.WorkMode.SMOOTH);
        }
        int currentIdx = visibleModes.indexOf((Object)config.getWorkMode());
        int nextIndex = (currentIdx + 1 + visibleModes.size()) % visibleModes.size();
        PushdozerConfig.WorkMode newMode = (PushdozerConfig.WorkMode)((Object)visibleModes.get(nextIndex));
        config.setWorkMode(newMode);
        PushdozerConfig.getInstance().save();
        class_5250 modeText = class_2561.method_43471((String)("pushdozer.mode." + newMode.name().toLowerCase()));
        client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"pushdozer.message.working_mode_switch", (Object[])new Object[]{modeText}), true);
    }

    private static void toggleShape(class_310 client) {
        PushdozerConfig config = PushdozerConfig.getInstance();
        PushdozerConfig.GeometryType[] geometryTypes = PushdozerConfig.GeometryType.values();
        int currentIndex = config.getGeometryType().ordinal();
        int nextIndex = (currentIndex + 1) % geometryTypes.length;
        PushdozerConfig.GeometryType newGeometryType = geometryTypes[nextIndex];
        config.setGeometryType(newGeometryType);
        config.save();
        class_2561 shapeText = newGeometryType.getDisplayText();
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"pushdozer.message.shape_switch", (Object[])new Object[]{shapeText}), true);
        }
    }

    private static void adjustOperationDistance(class_310 client, boolean increase) {
        PushdozerConfig config;
        int currentDistance;
        int newDistance = increase ? Math.min(currentDistance + 1, 99) : Math.max(currentDistance - 1, 1);
        if (newDistance != (currentDistance = (config = PushdozerConfig.getInstance()).getMaxOperationDistance())) {
            config.setMaxOperationDistance(newDistance);
            config.save();
            if (client.field_1724 != null) {
                client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"pushdozer.message.maximum_distance", (Object[])new Object[]{newDistance}), true);
            }
        }
    }
}

