/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.items.handlers;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.items.handlers.AbstractTerrainToolHandler;
import com.pushdozer.operations.UndoAction;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class ImprovedSmoothingHandler
extends AbstractTerrainToolHandler {
    private static final float[] SCALE_FACTORS = new float[]{0.5f, 1.0f, 2.0f};
    private static final float[] SCALE_WEIGHTS = new float[]{0.3f, 0.5f, 0.2f};
    private static final float RIDGE_THRESHOLD = 2.0f;
    private static final float VALLEY_THRESHOLD = -2.0f;
    private static final float FEATURE_PROTECTION_FACTOR = 0.3f;
    private static final float MIN_COMPLEXITY_THRESHOLD = 0.5f;
    private static final float MAX_COMPLEXITY_THRESHOLD = 3.0f;

    public ImprovedSmoothingHandler(PushdozerConfig config) {
        super(config);
    }

    public void handleSmoothing(class_1657 player, class_1937 world) {
        this.handleOperation(player, world, UndoAction.ActionType.SMOOTH);
    }

    @Override
    protected int calculateTargetHeight(Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> columns, AbstractTerrainToolHandler.TerrainColumn currentColumn, class_2338 columnXZ, class_2338 brushCenter) {
        float complexity = this.analyzeTerrainComplexity(columns, currentColumn, columnXZ);
        float adaptiveSmoothStrength = this.calculateAdaptiveSmoothStrength(complexity);
        TerrainFeature feature = this.detectTerrainFeature(columns, currentColumn, columnXZ);
        float multiScaleHeight = this.calculateMultiScaleSmoothedHeight(columns, currentColumn, columnXZ, brushCenter);
        float protectedHeight = this.applyFeatureProtection(currentColumn.getOriginalHeight(), multiScaleHeight, feature);
        float targetHeight = this.calculateAdaptiveInterpolation(currentColumn.getOriginalHeight(), protectedHeight, adaptiveSmoothStrength);
        return Math.round(targetHeight);
    }

    private float analyzeTerrainComplexity(Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> columns, AbstractTerrainToolHandler.TerrainColumn currentColumn, class_2338 columnXZ) {
        ArrayList<Float> heights = new ArrayList<Float>();
        int radius = 3;
        for (Map.Entry<class_2338, AbstractTerrainToolHandler.TerrainColumn> entry : columns.entrySet()) {
            class_2338 pos = entry.getKey();
            if (!(pos.method_10262((class_2382)columnXZ) <= (double)(radius * radius))) continue;
            heights.add(Float.valueOf(entry.getValue().getOriginalHeight()));
        }
        if (heights.size() < 2) {
            return 0.5f;
        }
        float mean = (float)heights.stream().mapToDouble(Float::doubleValue).average().orElse(0.0);
        float variance = (float)heights.stream().mapToDouble(h -> Math.pow(h.floatValue() - mean, 2.0)).average().orElse(0.0);
        return (float)Math.sqrt(variance);
    }

    private float calculateAdaptiveSmoothStrength(float complexity) {
        float baseSmoothStrength = this.config.getSmoothStrength();
        float normalizedComplexity = Math.max(0.0f, Math.min(1.0f, (complexity - 0.5f) / 2.5f));
        float adjustmentFactor = 1.0f - 0.7f * normalizedComplexity;
        return baseSmoothStrength * adjustmentFactor;
    }

    private TerrainFeature detectTerrainFeature(Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> columns, AbstractTerrainToolHandler.TerrainColumn currentColumn, class_2338 columnXZ) {
        float centerHeight = currentColumn.getOriginalHeight();
        ArrayList<Float> neighborHeights = new ArrayList<Float>();
        for (Map.Entry<class_2338, AbstractTerrainToolHandler.TerrainColumn> entry : columns.entrySet()) {
            class_2338 pos = entry.getKey();
            if (pos.equals((Object)columnXZ) || !(pos.method_10262((class_2382)columnXZ) <= 4.0)) continue;
            neighborHeights.add(Float.valueOf(entry.getValue().getOriginalHeight()));
        }
        if (neighborHeights.isEmpty()) {
            return TerrainFeature.FLAT;
        }
        float avgNeighborHeight = (float)neighborHeights.stream().mapToDouble(Float::doubleValue).average().orElse(centerHeight);
        float heightDiff = centerHeight - avgNeighborHeight;
        if (heightDiff > 2.0f) {
            return TerrainFeature.RIDGE;
        }
        if (heightDiff < -2.0f) {
            return TerrainFeature.VALLEY;
        }
        return TerrainFeature.FLAT;
    }

    private float calculateMultiScaleSmoothedHeight(Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> columns, AbstractTerrainToolHandler.TerrainColumn currentColumn, class_2338 columnXZ, class_2338 brushCenter) {
        float totalWeight = 0.0f;
        float weightedSum = 0.0f;
        for (int i = 0; i < SCALE_FACTORS.length; ++i) {
            float scale = SCALE_FACTORS[i];
            float weight = SCALE_WEIGHTS[i];
            float scaleRadius = (float)this.config.getRadius() * scale;
            float smoothedHeight = this.calculateScaleSpecificSmoothing(columns, currentColumn, columnXZ, brushCenter, scaleRadius);
            weightedSum += smoothedHeight * weight;
            totalWeight += weight;
        }
        return weightedSum / totalWeight;
    }

    private float calculateScaleSpecificSmoothing(Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> columns, AbstractTerrainToolHandler.TerrainColumn currentColumn, class_2338 columnXZ, class_2338 brushCenter, float radius) {
        float totalWeight = 0.0f;
        float weightedHeightSum = 0.0f;
        float spatialSigma = radius / 2.0f;
        float twoSpatialSigmaSquared = 2.0f * spatialSigma * spatialSigma;
        float heightSigma = this.getAdaptiveHeightSigma(radius);
        float twoHeightSigmaSquared = 2.0f * heightSigma * heightSigma;
        for (Map.Entry<class_2338, AbstractTerrainToolHandler.TerrainColumn> entry : columns.entrySet()) {
            class_2338 neighborColumnXZ = entry.getKey();
            AbstractTerrainToolHandler.TerrainColumn neighborColumn = entry.getValue();
            double spatialDistanceSq = neighborColumnXZ.method_10262((class_2382)columnXZ);
            if (spatialDistanceSq > (double)(radius * radius)) continue;
            float heightDiff = Math.abs(neighborColumn.getOriginalHeight() - currentColumn.getOriginalHeight());
            float spatialWeight = (float)Math.exp(-spatialDistanceSq / (double)twoSpatialSigmaSquared);
            float heightWeight = (float)Math.exp(-heightDiff * heightDiff / twoHeightSigmaSquared);
            float weight = spatialWeight * heightWeight;
            weightedHeightSum += (float)neighborColumn.getOriginalHeight() * weight;
            totalWeight += weight;
        }
        return totalWeight > 0.0f ? weightedHeightSum / totalWeight : (float)currentColumn.getOriginalHeight();
    }

    private float getAdaptiveHeightSigma(float radius) {
        float baseSigma = radius / 3.0f;
        return Math.max(1.0f, Math.min(6.0f, baseSigma));
    }

    private float applyFeatureProtection(float originalHeight, float smoothedHeight, TerrainFeature feature) {
        if (feature == TerrainFeature.FLAT) {
            return smoothedHeight;
        }
        float protectionStrength = 0.3f;
        return originalHeight * protectionStrength + smoothedHeight * (1.0f - protectionStrength);
    }

    private float calculateAdaptiveInterpolation(float originalHeight, float smoothedHeight, float strength) {
        float t = Math.max(0.0f, Math.min(1.0f, strength));
        float smoothT = t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
        return originalHeight * (1.0f - smoothT) + smoothedHeight * smoothT;
    }

    private static enum TerrainFeature {
        RIDGE,
        VALLEY,
        FLAT;

    }
}

