/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.items.handlers;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.items.handlers.AbstractTerrainToolHandler;
import com.pushdozer.operations.UndoAction;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class SmoothingHandler
extends AbstractTerrainToolHandler {
    private static final float DEFAULT_HEIGHT_SIGMA = 3.0f;
    private static final float MIN_HEIGHT_SIGMA = 1.0f;
    private static final float MAX_HEIGHT_SIGMA = 10.0f;
    private static final float BILATERAL_KERNEL_RADIUS_FACTOR = 2.0f;

    public SmoothingHandler(PushdozerConfig config) {
        super(config);
    }

    public void handleSmoothing(class_1657 player, class_1937 world) {
        this.handleOperation(player, world, UndoAction.ActionType.SMOOTH);
    }

    @Override
    protected int calculateTargetHeight(Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> columns, AbstractTerrainToolHandler.TerrainColumn currentColumn, class_2338 columnXZ, class_2338 brushCenter) {
        float smoothStrength = this.config.getSmoothStrength();
        int brushRadius = this.config.getRadius();
        float smoothedHeight = this.calculateOptimizedBilateralSmoothedHeight(columns, currentColumn, columnXZ, brushCenter, brushRadius);
        float targetHeight = this.calculateNonLinearInterpolation(currentColumn.getOriginalHeight(), smoothedHeight, smoothStrength);
        return Math.round(targetHeight);
    }

    private float calculateNonLinearInterpolation(float originalHeight, float smoothedHeight, float smoothStrength) {
        float smoothT = smoothStrength * smoothStrength * (3.0f - 2.0f * smoothStrength);
        return originalHeight * (1.0f - smoothT) + smoothedHeight * smoothT;
    }

    private float calculateOptimizedBilateralSmoothedHeight(Map<class_2338, AbstractTerrainToolHandler.TerrainColumn> columns, AbstractTerrainToolHandler.TerrainColumn currentColumn, class_2338 columnXZ, class_2338 brushCenter, int brushRadius) {
        float totalWeight = 0.0f;
        float weightedHeightSum = 0.0f;
        float spatialSigma = (float)brushRadius / 2.0f;
        float twoSpatialSigmaSquared = 2.0f * spatialSigma * spatialSigma;
        float heightSigma = this.getHeightSigma(brushRadius);
        float twoHeightSigmaSquared = 2.0f * heightSigma * heightSigma;
        float kernelRadius = spatialSigma * 2.0f;
        float maxDistanceSq = kernelRadius * kernelRadius;
        class_2338 brushCenterXZ = new class_2338(brushCenter.method_10263(), 0, brushCenter.method_10260());
        float falloff = SmoothingHandler.getFalloff(columnXZ, brushRadius, brushCenterXZ);
        for (Map.Entry<class_2338, AbstractTerrainToolHandler.TerrainColumn> entry : columns.entrySet()) {
            class_2338 neighborColumnXZ = entry.getKey();
            AbstractTerrainToolHandler.TerrainColumn neighborColumn = entry.getValue();
            double spatialDistanceSq = neighborColumnXZ.method_10262((class_2382)columnXZ);
            if (spatialDistanceSq > (double)maxDistanceSq) continue;
            float heightDiff = Math.abs(neighborColumn.getOriginalHeight() - currentColumn.getOriginalHeight());
            float spatialWeight = (float)Math.exp(-spatialDistanceSq / (double)twoSpatialSigmaSquared);
            float heightWeight = (float)Math.exp(-heightDiff * heightDiff / twoHeightSigmaSquared);
            float bilateralWeight = spatialWeight * heightWeight;
            weightedHeightSum += (float)neighborColumn.getOriginalHeight() * (bilateralWeight *= falloff);
            totalWeight += bilateralWeight;
        }
        if (totalWeight <= 0.0f) {
            return currentColumn.getOriginalHeight();
        }
        return weightedHeightSum / totalWeight;
    }

    private float getHeightSigma(int brushRadius) {
        if (brushRadius <= 5) {
            return 2.0f;
        }
        if (brushRadius <= 10) {
            return 3.0f;
        }
        return 4.0f;
    }

    private static float getFalloff(class_2338 columnXZ, int brushRadius, class_2338 brushCenterXZ) {
        double distanceToCenter = Math.sqrt(Math.pow(columnXZ.method_10263() - brushCenterXZ.method_10263(), 2.0) + Math.pow(columnXZ.method_10260() - brushCenterXZ.method_10260(), 2.0));
        float falloff = 1.0f;
        if (distanceToCenter > (double)((float)brushRadius * 0.8f)) {
            float t = (float)((distanceToCenter - (double)((float)brushRadius * 0.8f)) / (double)((float)brushRadius * 0.2f));
            t = Math.min(1.0f, Math.max(0.0f, t));
            falloff = (float)(Math.cos((double)t * Math.PI) * 0.5 + 0.5);
        }
        return falloff;
    }
}

