/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.operations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class UndoAction {
    private final ActionType type;
    private final List<class_2338> positions;
    private final List<class_2680> originalStates;
    private final List<class_2680> newStates;
    private final Set<class_2338> boundaryPositions;
    private final List<class_2680> boundaryOriginalStates;
    private final List<class_2680> boundaryNewStates;

    public UndoAction(ActionType type, List<class_2338> positions, List<class_2680> originalStates, List<class_2680> newStates) {
        this.type = type;
        this.positions = positions;
        this.originalStates = originalStates;
        this.newStates = newStates;
        this.boundaryPositions = new HashSet<class_2338>();
        this.boundaryOriginalStates = new ArrayList<class_2680>();
        this.boundaryNewStates = new ArrayList<class_2680>();
    }

    public UndoAction(ActionType type, List<class_2338> positions, List<class_2680> originalStates, List<class_2680> newStates, Set<class_2338> boundaryPositions, List<class_2680> boundaryOriginalStates, List<class_2680> boundaryNewStates) {
        this.type = type;
        this.positions = positions;
        this.originalStates = originalStates;
        this.newStates = newStates;
        this.boundaryPositions = boundaryPositions != null ? boundaryPositions : new HashSet();
        this.boundaryOriginalStates = boundaryOriginalStates != null ? boundaryOriginalStates : new ArrayList();
        this.boundaryNewStates = boundaryNewStates != null ? boundaryNewStates : new ArrayList();
    }

    public List<class_2338> getPositions() {
        return this.positions;
    }

    public List<class_2680> getOriginalStates() {
        return this.originalStates;
    }

    public List<class_2680> getNewStates() {
        return this.newStates;
    }

    public ActionType getType() {
        return this.type;
    }

    public List<class_2338> getAllPositions() {
        ArrayList<class_2338> allPositions = new ArrayList<class_2338>(this.positions);
        allPositions.addAll(this.boundaryPositions);
        return allPositions;
    }

    public List<class_2680> getAllOriginalStates() {
        ArrayList<class_2680> allOriginalStates = new ArrayList<class_2680>(this.originalStates);
        allOriginalStates.addAll(this.boundaryOriginalStates);
        return allOriginalStates;
    }

    public List<class_2680> getAllNewStates() {
        ArrayList<class_2680> allNewStates = new ArrayList<class_2680>(this.newStates);
        allNewStates.addAll(this.boundaryNewStates);
        return allNewStates;
    }

    public Set<class_2338> getBoundaryPositions() {
        return this.boundaryPositions;
    }

    public List<class_2680> getBoundaryOriginalStates() {
        return this.boundaryOriginalStates;
    }

    public List<class_2680> getBoundaryNewStates() {
        return this.boundaryNewStates;
    }

    public boolean isValid() {
        if (this.positions == null || this.originalStates == null || this.newStates == null) {
            return false;
        }
        return this.positions.size() == this.originalStates.size() && this.positions.size() == this.newStates.size();
    }

    public int getTotalBlockCount() {
        return this.positions.size() + this.boundaryPositions.size();
    }

    public static enum ActionType {
        PLACE,
        BREAK,
        SMOOTH,
        SMOOTH_RAISE,
        SMOOTH_LOWER,
        SURFACE_ROUGHEN,
        SURFACE_CONVERT,
        BONE_MEAL,
        BATCH_PLANT,
        SHORELINE_PROCESS;

    }
}

