/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.services;

import com.pushdozer.operations.UndoAction;
import com.pushdozer.operations.UndoRedoManager;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoRedoService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"pushdozer");
    private static UndoRedoService instance;
    private final UndoRedoManager undoRedoManager = new UndoRedoManager();

    private UndoRedoService() {
    }

    public static UndoRedoService getInstance() {
        if (instance == null) {
            instance = new UndoRedoService();
        }
        return instance;
    }

    public void pushUndoAction(class_1657 player, UndoAction action) {
        this.undoRedoManager.pushUndoAction(player, action);
    }

    public void undoLastAction(class_1657 player, class_1937 world) {
        try {
            this.undoRedoManager.undoLastAction(player, world);
            this.updatePlayerPosition(player);
        }
        catch (Exception e) {
            LOGGER.error("UndoRedoService: \u64a4\u9500\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
    }

    public void redoLastAction(class_1657 player, class_1937 world) {
        try {
            this.undoRedoManager.redoLastAction(player, world);
            this.updatePlayerPosition(player);
        }
        catch (Exception e) {
            LOGGER.error("UndoRedoService: \u91cd\u505a\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
    }

    public void debugPlayerStacks(class_1657 player) {
        this.undoRedoManager.debugPlayerStacks(player);
    }

    public int getUndoStackSize(class_1657 player) {
        return this.undoRedoManager.getUndoStackSize(player);
    }

    private void updatePlayerPosition(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_3218 serverWorld = serverPlayer.method_51469();
            serverWorld.method_14178().method_14096(serverPlayer);
        }
    }
}

