/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.shapes;

import com.pushdozer.shapes.GeometryShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class EllipsoidShape
implements GeometryShape {
    private final int radiusX;
    private final int radiusY;
    private final int radiusZ;
    private class_2338 center;

    public EllipsoidShape(int radiusX, int radiusY, int radiusZ, class_2338 center) {
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
        this.center = center;
    }

    @Override
    public class_238 getBoundingBox(class_2338 basePos) {
        return new class_238((double)(basePos.method_10263() - this.radiusX), (double)(basePos.method_10264() - this.radiusY), (double)(basePos.method_10260() - this.radiusZ), (double)(basePos.method_10263() + this.radiusX + 1), (double)(basePos.method_10264() + this.radiusY + 1), (double)(basePos.method_10260() + this.radiusZ + 1));
    }

    @Override
    public void renderOutline(class_4587 matrices, class_4588 vertexConsumer, class_243 center, float red, float green, float blue, float alpha) {
    }

    @Override
    public void renderSolid(class_4587 matrices, class_4588 vertexConsumer, class_243 center, float red, float green, float blue, float alpha) {
    }

    @Override
    public boolean isInside(class_243 pos) {
        double dz;
        double dy;
        double dx = pos.field_1352 - (double)this.center.method_10263();
        double equation = dx * dx / (double)(this.radiusX * this.radiusX) + (dy = pos.field_1351 - (double)this.center.method_10264()) * dy / (double)(this.radiusY * this.radiusY) + (dz = pos.field_1350 - (double)this.center.method_10260()) * dz / (double)(this.radiusZ * this.radiusZ);
        return equation <= 1.0;
    }

    @Override
    public boolean isInside(class_2338 pos) {
        double dz;
        double dy;
        double dx = pos.method_10263() - this.center.method_10263();
        double equation = dx * dx / (double)(this.radiusX * this.radiusX) + (dy = (double)(pos.method_10264() - this.center.method_10264())) * dy / (double)(this.radiusY * this.radiusY) + (dz = (double)(pos.method_10260() - this.center.method_10260())) * dz / (double)(this.radiusZ * this.radiusZ);
        return equation <= 1.0;
    }

    @Override
    public int getMinY(class_2338 basePos) {
        return basePos.method_10264() - this.radiusY;
    }

    @Override
    public int getMaxY(class_2338 basePos) {
        return basePos.method_10264() + this.radiusY;
    }

    @Override
    public List<class_2338> getBlocksInLayer(class_2338 basePos, int y) {
        double yFactor;
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        double dy = y - basePos.method_10264();
        if (Math.abs(dy) <= (double)this.radiusY && (yFactor = 1.0 - dy * dy / (double)(this.radiusY * this.radiusY)) > 0.0) {
            int maxX = (int)Math.ceil((double)this.radiusX * Math.sqrt(yFactor));
            int maxZ = (int)Math.ceil((double)this.radiusZ * Math.sqrt(yFactor));
            for (int x = basePos.method_10263() - maxX; x <= basePos.method_10263() + maxX; ++x) {
                for (int z = basePos.method_10260() - maxZ; z <= basePos.method_10260() + maxZ; ++z) {
                    if (!this.isInside(new class_2338(x, y, z))) continue;
                    positions.add(new class_2338(x, y, z));
                }
            }
        }
        return positions;
    }

    @Override
    public List<class_2338> getBlocksInRadius(class_243 center, int maxDistance) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        class_2338 centerPos = class_2338.method_49638((class_2374)center);
        int minX = Math.max(centerPos.method_10263() - maxDistance, this.center.method_10263() - this.radiusX);
        int maxX = Math.min(centerPos.method_10263() + maxDistance, this.center.method_10263() + this.radiusX);
        int minY = Math.max(centerPos.method_10264() - maxDistance, this.center.method_10264() - this.radiusY);
        int maxY = Math.min(centerPos.method_10264() + maxDistance, this.center.method_10264() + this.radiusY);
        int minZ = Math.max(centerPos.method_10260() - maxDistance, this.center.method_10260() - this.radiusZ);
        int maxZ = Math.min(centerPos.method_10260() + maxDistance, this.center.method_10260() + this.radiusZ);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    double distance;
                    class_2338 pos = new class_2338(x, y, z);
                    if (!this.isInside(pos) || !((distance = Math.sqrt(Math.pow(x - centerPos.method_10263(), 2.0) + Math.pow(y - centerPos.method_10264(), 2.0) + Math.pow(z - centerPos.method_10260(), 2.0))) <= (double)maxDistance)) continue;
                    positions.add(pos);
                }
            }
        }
        return positions;
    }

    @Override
    public boolean isWithinBounds(class_2338 pos, class_2338 basePos) {
        return this.isInside(pos);
    }

    @Override
    public void setCenter(class_2338 center) {
        this.center = center;
    }

    @Override
    public List<class_2338> getBlocks() {
        return this.getBlockPositions();
    }

    @Override
    public Iterator<class_2338> getBlocksIterator() {
        return this.getBlockPositions().iterator();
    }

    @Override
    public class_2338 getCenter() {
        return this.center;
    }

    @Override
    public List<class_2338> getBlockPositions() {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        int centerX = this.center.method_10263();
        int centerY = this.center.method_10264();
        int centerZ = this.center.method_10260();
        for (int x = centerX - this.radiusX; x <= centerX + this.radiusX; ++x) {
            for (int y = centerY - this.radiusY; y <= centerY + this.radiusY; ++y) {
                for (int z = centerZ - this.radiusZ; z <= centerZ + this.radiusZ; ++z) {
                    double dx = x - centerX;
                    double dy = y - centerY;
                    double dz = z - centerZ;
                    double equation = dx * dx / (double)(this.radiusX * this.radiusX) + dy * dy / (double)(this.radiusY * this.radiusY) + dz * dz / (double)(this.radiusZ * this.radiusZ);
                    if (!(equation <= 1.0)) continue;
                    positions.add(new class_2338(x, y, z));
                }
            }
        }
        return positions;
    }

    public int getRadiusX() {
        return this.radiusX;
    }

    public int getRadiusY() {
        return this.radiusY;
    }

    public int getRadiusZ() {
        return this.radiusZ;
    }
}

