/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.panels.brushgeometry;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.ui.panels.brushgeometry.GeometrySubPanel;
import com.pushdozer.ui.screens.PushdozerConfigScreen;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class BoxSubPanel
extends GeometrySubPanel {
    private GeometrySubPanel.CustomSliderWidget lengthSlider;
    private GeometrySubPanel.CustomSliderWidget widthSlider;
    private GeometrySubPanel.CustomSliderWidget heightSlider;

    public BoxSubPanel(PushdozerConfigScreen parent, PushdozerConfig config) {
        super(parent, config);
    }

    @Override
    public void initPanel() {
        this.lengthSlider = this.addSlider(0, (class_2561)class_2561.method_43471((String)"pushdozer.config.length"), this.config.getLength());
        this.widthSlider = this.addSlider(1, (class_2561)class_2561.method_43471((String)"pushdozer.config.width"), this.config.getWidth());
        this.heightSlider = this.addSlider(2, (class_2561)class_2561.method_43471((String)"pushdozer.config.height"), this.config.getBoxHeight());
        System.out.println("BoxSubPanel initialized");
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        this.renderPanelBackground(context);
        this.renderTitle(context, (class_2561)class_2561.method_43471((String)"pushdozer.panel.box.title"));
        this.lengthSlider.method_25394(context, mouseX, mouseY, delta);
        this.widthSlider.method_25394(context, mouseX, mouseY, delta);
        this.heightSlider.method_25394(context, mouseX, mouseY, delta);
        this.confirmButton.method_25394(context, mouseX, mouseY, delta);
    }

    @Override
    public void saveConfig() {
        System.out.println("Saving config in BoxSubPanel");
        try {
            int length = this.getSliderValue(this.lengthSlider);
            int width = this.getSliderValue(this.widthSlider);
            int height = this.getSliderValue(this.heightSlider);
            System.out.println("Slider values: length=" + length + ", width=" + width + ", height=" + height);
            this.config.setLength(length);
            this.config.setWidth(width);
            this.config.setBoxHeight(height);
            System.out.println("Values set in config");
            this.config.save();
            System.out.println("Config saved");
            this.parent.showErrorMessage(class_2561.method_43471((String)"pushdozer.config.saved").getString());
            System.out.println("Error message shown");
        }
        catch (Exception e) {
            System.out.println("Unexpected error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    protected void updatePreview() {
        int length = this.getSliderValue(this.lengthSlider);
        int width = this.getSliderValue(this.widthSlider);
        int height = this.getSliderValue(this.heightSlider);
        this.config.setLength(length);
        this.config.setWidth(width);
        this.config.setBoxHeight(height);
        this.parent.updatePreview();
    }
}

