/*
 * Decompiled with CFR 0.152.
 */
package com.pushdozer.ui.panels.workmode;

import com.pushdozer.config.PushdozerConfig;
import com.pushdozer.ui.panels.workmode.WorkModeConfigPanel;
import com.pushdozer.ui.screens.EntityBlockSelectionScreen;
import com.pushdozer.ui.screens.MultiSelectPlantSelectionScreen;
import com.pushdozer.ui.screens.PushdozerConfigScreen;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import net.minecraft.class_7923;

public class ShorelineProcessConfigPanel
extends WorkModeConfigPanel {
    private class_4286 heightAboveCheckbox;
    private class_4286 heightBelowCheckbox;

    public ShorelineProcessConfigPanel(PushdozerConfigScreen parent, PushdozerConfig config) {
        super(parent, config);
    }

    @Override
    protected void initializeWidgets() {
        this.widgets.clear();
        int contentLeft = 5;
        int contentTop = 25;
        int contentWidth = 200;
        class_5676 shorelineTypeButton = class_5676.method_32606(PushdozerConfig.ShorelineType::getDisplayText).method_32624((Object[])PushdozerConfig.ShorelineType.values()).method_32619((Object)this.config.getShorelineType()).method_32617(contentLeft, contentTop, contentWidth, 20, (class_2561)class_2561.method_43471((String)"pushdozer.config.shoreline_type"), (button, shorelineType) -> {
            this.config.setShorelineType((PushdozerConfig.ShorelineType)((Object)shorelineType));
            this.show();
        });
        shorelineTypeButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.config.shoreline_type.tooltip")));
        this.widgets.add(shorelineTypeButton);
        CustomWidthSlider widthSlider = new CustomWidthSlider(contentLeft, contentTop += 25, contentWidth, 20, this.config.getShorelineWidth(), this.config::setShorelineWidth);
        widthSlider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.config.shoreline_width.tooltip")));
        this.widgets.add(widthSlider);
        contentTop += 25;
        if (this.config.getShorelineType() == PushdozerConfig.ShorelineType.CUSTOM) {
            int halfWidth = (contentWidth - 5) / 2;
            class_4185 selectBlocksButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.config.custom_shoreline.select_blocks"), button -> this.openBlockSelectionScreen()).method_46434(contentLeft, contentTop, halfWidth, 20).method_46431();
            selectBlocksButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.config.custom_shoreline.select_blocks.tooltip")));
            this.widgets.add(selectBlocksButton);
            class_4185 selectPlantsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"pushdozer.config.custom_shoreline.select_plants"), button -> this.openPlantSelectionScreen()).method_46434(contentLeft + halfWidth + 5, contentTop, halfWidth, 20).method_46431();
            selectPlantsButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.config.custom_shoreline.select_plants.tooltip")));
            this.widgets.add(selectPlantsButton);
            contentTop += 25;
        } else {
            class_5676 plantVegetationButton = class_5676.method_32614().method_32619((Object)this.config.isPlantVegetationEnabled()).method_32617(contentLeft, contentTop, contentWidth, 20, (class_2561)class_2561.method_43471((String)"pushdozer.config.plant_vegetation"), (button, enabled) -> {
                this.config.setPlantVegetationEnabled((boolean)enabled);
                this.show();
            });
            plantVegetationButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.config.plant_vegetation.tooltip")));
            this.widgets.add(plantVegetationButton);
            contentTop += 25;
        }
        if (this.config.getShorelineType() == PushdozerConfig.ShorelineType.CUSTOM || this.config.isPlantVegetationEnabled()) {
            CustomVegetationDensitySlider densitySlider = new CustomVegetationDensitySlider(contentLeft, contentTop, contentWidth, 20, this.config.getVegetationDensity(), this.config::setVegetationDensity);
            densitySlider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.config.vegetation_density.tooltip")));
            this.widgets.add(densitySlider);
            contentTop += 25;
        }
        int halfWidthForChecks = (contentWidth - 5) / 2;
        this.heightAboveCheckbox = class_4286.method_54787((class_2561)class_2561.method_43471((String)"pushdozer.config.shoreline_height_above"), (class_327)this.parent.method_64506()).method_54789(contentLeft, contentTop).method_54794(this.config.isShorelineHeightAboveEnabled()).method_54791((widget, checked) -> {
            if (checked) {
                this.config.setShorelineHeightBelowEnabled(false);
            }
            this.config.setShorelineHeightAboveEnabled(checked);
            this.show();
        }).method_54788();
        this.heightAboveCheckbox.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.config.shoreline_height_above.tooltip")));
        this.widgets.add(this.heightAboveCheckbox);
        this.heightBelowCheckbox = class_4286.method_54787((class_2561)class_2561.method_43471((String)"pushdozer.config.shoreline_height_below"), (class_327)this.parent.method_64506()).method_54789(contentLeft + halfWidthForChecks + 5, contentTop).method_54794(this.config.isShorelineHeightBelowEnabled()).method_54791((widget, checked) -> {
            if (checked) {
                this.config.setShorelineHeightAboveEnabled(false);
            }
            this.config.setShorelineHeightBelowEnabled(checked);
            this.show();
        }).method_54788();
        this.heightBelowCheckbox.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pushdozer.config.shoreline_height_below.tooltip")));
        this.widgets.add(this.heightBelowCheckbox);
    }

    @Override
    protected void recalculateContentWidgetPositions() {
        int contentLeft = this.panelLeft + 5;
        int contentTop = this.panelTop + 20 + 5;
        int contentWidth = 200;
        boolean foundFirstButton = false;
        for (class_364 widget : this.widgets) {
            if (widget == this.confirmButton || !(widget instanceof class_339)) continue;
            class_339 clickableWidget = (class_339)widget;
            if (widget instanceof class_5676) {
                clickableWidget.method_48229(contentLeft, contentTop);
                contentTop += 25;
                continue;
            }
            if (widget instanceof CustomWidthSlider || widget instanceof CustomVegetationDensitySlider) {
                clickableWidget.method_48229(contentLeft, contentTop);
                contentTop += 25;
                continue;
            }
            if (widget instanceof class_4185) {
                int halfWidth = (contentWidth - 5) / 2;
                if (this.config.getShorelineType() == PushdozerConfig.ShorelineType.CUSTOM) {
                    if (!foundFirstButton) {
                        clickableWidget.method_48229(contentLeft, contentTop);
                        foundFirstButton = true;
                        continue;
                    }
                    clickableWidget.method_48229(contentLeft + halfWidth + 5, contentTop);
                    contentTop += 25;
                    foundFirstButton = false;
                    continue;
                }
                clickableWidget.method_48229(contentLeft, contentTop);
                contentTop += 25;
                continue;
            }
            if (widget instanceof class_4286) {
                int halfWidthForChecks = (contentWidth - 5) / 2;
                if (widget == this.heightAboveCheckbox) {
                    clickableWidget.method_48229(contentLeft, contentTop);
                    continue;
                }
                clickableWidget.method_48229(contentLeft + halfWidthForChecks + 5, contentTop);
                contentTop += 25;
                continue;
            }
            clickableWidget.method_48229(contentLeft, contentTop);
            contentTop += 25;
        }
    }

    @Override
    protected int calculateConfirmButtonY() {
        int contentTop = this.panelTop + 20 + 5;
        contentTop += 25;
        contentTop += 25;
        contentTop = this.config.getShorelineType() == PushdozerConfig.ShorelineType.CUSTOM ? (contentTop += 25) : (contentTop += 25);
        if (this.config.getShorelineType() == PushdozerConfig.ShorelineType.CUSTOM || this.config.isPlantVegetationEnabled()) {
            contentTop += 25;
        }
        return contentTop += 25;
    }

    @Override
    protected class_2561 getTitleText() {
        return class_2561.method_43471((String)"pushdozer.panel.shoreline_process.title");
    }

    @Override
    public void saveConfig() {
        this.config.save();
    }

    private void openBlockSelectionScreen() {
        List<class_2248> initial = this.config.getCustomShorelineBlockList();
        EntityBlockSelectionScreen screen = new EntityBlockSelectionScreen(this.parent, this.config, initial, selectedSet -> {
            Set<String> ids = selectedSet.stream().map(b -> class_7923.field_41175.method_10221(b).toString()).collect(Collectors.toSet());
            this.config.setCustomShorelineBlocks(ids);
            this.config.save();
        });
        if (this.parent.getClient() != null) {
            this.parent.getClient().method_1507((class_437)screen);
        }
    }

    private void openPlantSelectionScreen() {
        List<class_2248> currentSelectedPlants = this.config.getCustomShorelinePlantList();
        MultiSelectPlantSelectionScreen plantSelectionScreen = new MultiSelectPlantSelectionScreen(this.parent, selectedPlants -> {
            Set<String> plantIds = selectedPlants.stream().map(plant -> class_7923.field_41175.method_10221(plant).toString()).collect(Collectors.toSet());
            this.config.setCustomShorelinePlants(plantIds);
            this.config.save();
        }, currentSelectedPlants);
        if (this.parent.getClient() != null) {
            this.parent.getClient().method_1507((class_437)plantSelectionScreen);
        }
    }

    private static class CustomWidthSlider
    extends class_357 {
        private final Consumer<Integer> onValueChanged;

        public CustomWidthSlider(int x, int y, int width, int height, int value, Consumer<Integer> onValueChanged) {
            super(x, y, width, height, (class_2561)class_2561.method_43471((String)"pushdozer.config.shoreline_width"), (double)value / 10.0);
            this.onValueChanged = onValueChanged;
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43469((String)"pushdozer.config.shoreline_width.value", (Object[])new Object[]{String.format("%.1f", this.field_22753 * 10.0)}));
        }

        protected void method_25344() {
            this.onValueChanged.accept((int)(this.field_22753 * 10.0));
        }
    }

    private static class CustomVegetationDensitySlider
    extends class_357 {
        private final Consumer<Float> onValueChanged;

        public CustomVegetationDensitySlider(int x, int y, int width, int height, float value, Consumer<Float> onValueChanged) {
            super(x, y, width, height, (class_2561)class_2561.method_43471((String)"pushdozer.config.vegetation_density"), (double)value);
            this.onValueChanged = onValueChanged;
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43469((String)"pushdozer.config.vegetation_density.value", (Object[])new Object[]{String.format("%.1f", this.field_22753 * 100.0)}));
        }

        protected void method_25344() {
            this.onValueChanged.accept(Float.valueOf((float)this.field_22753));
        }
    }
}

