/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.mixin;

import com.devnemo.nemos.inventory.sorting.NemosInventorySortingClientCommon;
import com.devnemo.nemos.inventory.sorting.client.InventorySortingKeyMappings;
import com.devnemo.nemos.inventory.sorting.config.DefaultConfigValues;
import com.devnemo.nemos.inventory.sorting.config.model.ComponentConfig;
import com.devnemo.nemos.inventory.sorting.config.model.FilterConfig;
import com.devnemo.nemos.inventory.sorting.config.service.ConfigService;
import com.devnemo.nemos.inventory.sorting.factory.ButtonCreator;
import com.devnemo.nemos.inventory.sorting.factory.DropAllButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.FilterButtonCreator;
import com.devnemo.nemos.inventory.sorting.factory.MoveAllButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.MoveSameButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.SortButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.ToggleFilterPersistenceButtonFactory;
import com.devnemo.nemos.inventory.sorting.gui.components.FilterBox;
import com.devnemo.nemos.inventory.sorting.gui.components.buttons.AbstractFilterToggleButton;
import com.devnemo.nemos.inventory.sorting.gui.components.buttons.AbstractInventoryButton;
import com.devnemo.nemos.inventory.sorting.helper.ButtonTypeMapping;
import com.devnemo.nemos.inventory.sorting.model.FilterResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1708;
import net.minecraft.class_1714;
import net.minecraft.class_1718;
import net.minecraft.class_1723;
import net.minecraft.class_1733;
import net.minecraft.class_1735;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3705;
import net.minecraft.class_3706;
import net.minecraft.class_3803;
import net.minecraft.class_3858;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_8881;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_465.class})
public abstract class AbstractContainerScreenMixin
extends class_437 {
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Shadow
    protected int field_25270;
    @Shadow
    protected int field_2792;
    @Unique
    private FilterBox nemosInventorySorting$filterBox;
    @Unique
    private FilterConfig nemosInventorySorting$filterConfig;
    @Unique
    private static final class_2960 HIGHLIGHTED_SLOT = class_2960.method_60655((String)"nemos_inventory_sorting", (String)"container/highlighted_slot");
    @Unique
    private static final class_2960 HIGHLIGHTED_SLOT_INCLUDED_ITEM = class_2960.method_60655((String)"nemos_inventory_sorting", (String)"container/highlighted_slot_included_item");
    @Unique
    private static final class_2960 DIMMED_SLOT = class_2960.method_60655((String)"nemos_inventory_sorting", (String)"container/dimmed_slot");
    @Unique
    private int nemosInventorySorting$inventoryEndIndex;
    @Unique
    private int nemosInventorySorting$containerSize;
    @Unique
    private int nemosInventorySorting$filterBoxWidth = 0;
    @Unique
    private final ConfigService nemosInventorySorting$configService = ConfigService.getInstance();
    @Unique
    private final List<class_339> nemosInventorySorting$widgets = new ArrayList<class_339>();

    @Shadow
    public abstract class_1703 method_17577();

    protected AbstractContainerScreenMixin(class_2561 component) {
        super(component);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        this.nemosInventorySorting$inventoryEndIndex = this.method_17577().field_7761.size() - 9;
        if (this.method_17577() instanceof class_1723) {
            --this.nemosInventorySorting$inventoryEndIndex;
        }
        this.nemosInventorySorting$containerSize = this.nemosInventorySorting$inventoryEndIndex - 27;
        List<ComponentConfig> componentConfigs = this.nemosInventorySorting$configService.readOrGetDefaultComponentConfigs();
        if (this.nemosInventorySorting$shouldHaveFilter()) {
            this.nemosInventorySorting$filterConfig = this.nemosInventorySorting$configService.readOrGetDefaultFilterConfig();
            this.nemosInventorySorting$initFilter(componentConfigs);
        }
        if (this.nemosInventorySorting$shouldHaveStorageContainerButtons()) {
            this.nemosInventorySorting$initStorageContainerButtons(componentConfigs);
        }
        if (this.nemosInventorySorting$shouldHaveInventoryButtons()) {
            this.nemosInventorySorting$initInventoryButtons(componentConfigs);
        }
        if (this.nemosInventorySorting$shouldHaveContainerInventorySortingButtons()) {
            this.nemosInventorySorting$initContainerInventoryButtons(componentConfigs);
        }
        for (class_339 widget : this.nemosInventorySorting$widgets) {
            this.method_37063((class_364)widget);
        }
    }

    protected void method_37067() {
        this.nemosInventorySorting$widgets.clear();
        super.method_37067();
    }

    @Unique
    private void nemosInventorySorting$initFilter(List<ComponentConfig> configs) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, DefaultConfigValues.ITEM_FILTER);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        this.nemosInventorySorting$filterBoxWidth = config.width();
        int xOffset = config.xOffset() != null ? config.xOffset() : 1;
        int yOffset = config.yOffset() != null ? config.yOffset() : DefaultConfigValues.Y_OFFSET_ITEM_FILTER;
        this.nemosInventorySorting$createSearchBox(xOffset, yOffset, this.nemosInventorySorting$filterBoxWidth, config.height(), this.nemosInventorySorting$filterConfig.getFilter());
        this.nemosInventorySorting$createButton(configs, DefaultConfigValues.FILTER_PERSISTENCE_TOGGLE, ToggleFilterPersistenceButtonFactory.getInstance());
    }

    @Inject(method={"onClose"}, at={@At(value="TAIL")})
    private void onClose(CallbackInfo ci) {
        if (this.nemosInventorySorting$filterBox == null) {
            return;
        }
        this.nemosInventorySorting$filterBox.updateAndSaveFilter(this.nemosInventorySorting$filterConfig);
    }

    @Unique
    private void nemosInventorySorting$createSearchBox(int xOffset, int yOffset, int width, int height, String filter) {
        this.nemosInventorySorting$filterBox = new FilterBox(this.field_22793, this.field_2776, this.field_2800, xOffset, yOffset, width, height, (class_2561)class_2561.method_43471((String)"nemos_inventory_sorting.itemFilter"));
        this.method_37063((class_364)this.nemosInventorySorting$filterBox);
        this.nemosInventorySorting$filterBox.method_1852(filter);
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(class_11908 keyEvent, CallbackInfoReturnable<Boolean> cir) {
        if (this.nemosInventorySorting$filterBox != null) {
            if (this.nemosInventorySorting$filterBox.method_25370() && keyEvent.comp_4795() != 256) {
                cir.setReturnValue((Object)this.nemosInventorySorting$filterBox.method_25404(keyEvent));
                return;
            }
            if (!this.nemosInventorySorting$filterBox.method_25370() && keyEvent.method_74240() && InventorySortingKeyMappings.QUICK_SEARCH.get().method_1417(keyEvent)) {
                this.nemosInventorySorting$handleQuickSearch(cir);
                return;
            }
        }
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.method_25404(keyEvent))) {
            cir.setReturnValue((Object)true);
        }
    }

    public boolean method_16803(@NotNull class_11908 keyEvent) {
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.method_16803(keyEvent))) {
            return true;
        }
        return super.method_16803(keyEvent);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void mouseClicked(class_11909 mouseButtonEvent, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        Optional optional = this.method_19355(mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799());
        if (optional.isEmpty()) {
            for (class_364 guiEventListener : this.method_25396()) {
                guiEventListener.method_25365(false);
            }
        }
        if (this.nemosInventorySorting$filterBox != null && !this.nemosInventorySorting$filterBox.method_25370() && mouseButtonEvent.method_74240() && InventorySortingKeyMappings.QUICK_SEARCH.get().method_1433(mouseButtonEvent)) {
            this.nemosInventorySorting$handleQuickSearch(cir);
            return;
        }
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.method_25402(mouseButtonEvent, bl))) {
            cir.setReturnValue((Object)true);
        }
        if (this.nemosInventorySorting$filterBox != null && !this.nemosInventorySorting$filterBox.method_25402(mouseButtonEvent, bl) && this.method_25399() == this.nemosInventorySorting$filterBox) {
            this.method_25395(null);
        }
    }

    @Unique
    private void nemosInventorySorting$handleQuickSearch(CallbackInfoReturnable<Boolean> cir) {
        int filterBoxY;
        int filterBoxX = this.nemosInventorySorting$filterBox.method_46426();
        Optional optionalGuiEventListener = this.method_19355(filterBoxX, filterBoxY = this.nemosInventorySorting$filterBox.method_46427());
        if (optionalGuiEventListener.isEmpty()) {
            return;
        }
        this.method_25395((class_364)optionalGuiEventListener.get());
        this.nemosInventorySorting$filterBox.method_25365(true);
        this.nemosInventorySorting$filterBox.method_25348(new class_11909((double)filterBoxX, (double)filterBoxY, new class_11910(0, 0)), false);
        cir.setReturnValue((Object)true);
    }

    @Unique
    private boolean nemosInventorySorting$triggerActionOnWidget(Function<class_339, Boolean> function) {
        for (class_339 widget : this.nemosInventorySorting$widgets) {
            if (!function.apply(widget).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"renderContents"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderSlots(Lnet/minecraft/client/gui/GuiGraphics;)V")})
    void renderHighlightedSlot(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveFilter() || this.nemosInventorySorting$filterBox == null) {
            return;
        }
        String filter = this.nemosInventorySorting$filterBox.method_1882();
        if (!filter.isEmpty()) {
            Map<FilterResult, List<class_1735>> filteredSlotMap = this.nemosInventorySorting$filterBox.filterSlots((class_2371<class_1735>)this.method_17577().field_7761, filter);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.INCLUDED), guiGraphics, HIGHLIGHTED_SLOT);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.HAS_INCLUDED_ITEM), guiGraphics, HIGHLIGHTED_SLOT_INCLUDED_ITEM);
        }
    }

    @Inject(method={"renderContents"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderSlotHighlightFront(Lnet/minecraft/client/gui/GuiGraphics;)V", shift=At.Shift.AFTER)})
    void renderDimmedSlot(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveFilter() || this.nemosInventorySorting$filterBox == null) {
            return;
        }
        String filter = this.nemosInventorySorting$filterBox.method_1882();
        if (!filter.isEmpty()) {
            Map<FilterResult, List<class_1735>> filteredSlotMap = this.nemosInventorySorting$filterBox.filterSlots((class_2371<class_1735>)this.method_17577().field_7761, filter);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.EXCLUDED), guiGraphics, DIMMED_SLOT);
        }
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveFilter() {
        return !(this.method_17577() instanceof class_481.class_483);
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveStorageContainerButtons() {
        class_1703 menu = this.method_17577();
        if (NemosInventorySortingClientCommon.MOD_LOADER_HELPER.isModLoaded("nemos_backpacks")) {
            try {
                Class<?> clazz = Class.forName("com.devnemo.nemos.backpacks.world.inventory.BackpackMenu");
                if (clazz.isInstance(menu)) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return menu instanceof class_1707 || menu instanceof class_1733 || this.nemosInventorySorting$isModdedContainerMenu(menu, "nemos_backpacks", "com.devnemo.nemos.backpacks.world.inventory.BackpackMenu") || this.nemosInventorySorting$isModdedContainerMenu(menu, "reinfchest", "atonkish.reinfcore.screen.ReinforcedStorageScreenHandler") || this.nemosInventorySorting$isModdedContainerMenu(menu, "reinfbarrel", "atonkish.reinfcore.screen.ReinforcedStorageScreenHandler") || this.nemosInventorySorting$isModdedContainerMenu(menu, "reinfshulker", "atonkish.reinfcore.screen.ReinforcedStorageScreenHandler");
    }

    @Unique
    private boolean nemosInventorySorting$isModdedContainerMenu(class_1703 menu, String modId, String className) {
        if (NemosInventorySortingClientCommon.MOD_LOADER_HELPER.isModLoaded(modId)) {
            try {
                Class<?> clazz = Class.forName(className);
                if (clazz.isInstance(menu)) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveInventoryButtons() {
        return this.method_17577() instanceof class_1723;
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveContainerInventorySortingButtons() {
        class_1703 menu = this.method_17577();
        return menu instanceof class_1718 || menu instanceof class_3858 || menu instanceof class_3706 || menu instanceof class_3705 || menu instanceof class_1714 || menu instanceof class_8881 || menu instanceof class_3803 || menu instanceof class_1708;
    }

    @Unique
    private void nemosInventorySorting$markSlots(List<class_1735> slots, class_332 guiGraphics, class_2960 texture) {
        if (slots == null) {
            return;
        }
        for (class_1735 slot : slots) {
            guiGraphics.method_52706(class_10799.field_56883, texture, slot.field_7873, slot.field_7872, 16, 16);
        }
    }

    @Unique
    private void nemosInventorySorting$initStorageContainerButtons(List<ComponentConfig> componentConfigs) {
        int defaultInventoryYOffset = this.method_17577() instanceof class_1733 ? this.field_25270 - 1 : this.field_25270 - 2;
        this.nemosInventorySorting$createButtons(componentConfigs, new ButtonTypeMapping(DefaultConfigValues.SORT_STORAGE_CONTAINER, SortButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.MOVE_SAME_STORAGE_CONTAINER, MoveSameButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.MOVE_ALL_STORAGE_CONTAINER, MoveAllButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_STORAGE_CONTAINER, DropAllButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.SORT_STORAGE_CONTAINER_INVENTORY, SortButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.MOVE_SAME_STORAGE_CONTAINER_INVENTORY, MoveSameButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.MOVE_ALL_STORAGE_CONTAINER_INVENTORY, MoveAllButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_STORAGE_CONTAINER_INVENTORY, DropAllButtonFactory.getInstance(), defaultInventoryYOffset, true));
    }

    @Unique
    private void nemosInventorySorting$initInventoryButtons(List<ComponentConfig> componentConfigs) {
        this.nemosInventorySorting$createButtons(componentConfigs, new ButtonTypeMapping(DefaultConfigValues.SORT_INVENTORY, SortButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_INVENTORY, true), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_INVENTORY, DropAllButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_INVENTORY, true));
    }

    @Unique
    private void nemosInventorySorting$initContainerInventoryButtons(List<ComponentConfig> componentConfigs) {
        int defaultInventoryYOffset = this.field_25270 - 1;
        this.nemosInventorySorting$createButtons(componentConfigs, new ButtonTypeMapping(DefaultConfigValues.SORT_CONTAINER_INVENTORY, SortButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_CONTAINER_INVENTORY, DropAllButtonFactory.getInstance(), defaultInventoryYOffset, true));
    }

    @Unique
    private void nemosInventorySorting$createButton(List<ComponentConfig> configs, String componentName, FilterButtonCreator filterButtonCreator) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, componentName);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int width = config.width();
        int xOffset = config.xOffset() != null ? config.xOffset() : this.nemosInventorySorting$filterBoxWidth + 3;
        int yOffset = config.yOffset() != null ? config.yOffset() : DefaultConfigValues.Y_OFFSET_ITEM_FILTER;
        AbstractFilterToggleButton button = filterButtonCreator.createButton(this.field_2776, this.field_2800, xOffset, yOffset, width, config.height(), this.nemosInventorySorting$filterConfig);
        this.nemosInventorySorting$widgets.add(button);
    }

    @Unique
    private void nemosInventorySorting$createButtons(List<ComponentConfig> configs, ButtonTypeMapping ... mappings) {
        for (ButtonTypeMapping mapping : mappings) {
            ComponentConfig config;
            Optional<ComponentConfig> optionalConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, mapping.componentName());
            if (optionalConfig.isEmpty() || !(config = optionalConfig.get()).isEnabled()) continue;
            int yOffset = config.yOffset() != null ? config.yOffset().intValue() : mapping.defaultYOffset();
            int xOffset = config.xOffset() != null ? config.xOffset() : this.field_2792 + config.rightXOffset();
            this.nemosInventorySorting$createButton(mapping.factory(), mapping.isInventoryButton(), xOffset, yOffset, config.width(), config.height());
        }
    }

    @Unique
    private void nemosInventorySorting$createButton(ButtonCreator buttonCreator, boolean isInventoryButton, int xOffset, int yOffset, int width, int height) {
        int startIndex = isInventoryButton ? this.nemosInventorySorting$containerSize : 0;
        int endIndex = isInventoryButton ? this.nemosInventorySorting$inventoryEndIndex : this.nemosInventorySorting$containerSize;
        this.nemosInventorySorting$createButton(buttonCreator, startIndex, endIndex, xOffset, yOffset, width, height, isInventoryButton);
    }

    @Unique
    private void nemosInventorySorting$createButton(ButtonCreator buttonCreator, int startIndex, int endIndex, int xOffset, int yOffset, int width, int height, boolean isInventoryButton) {
        AbstractInventoryButton sortButton = buttonCreator.createButton(startIndex, endIndex, this.field_2776, this.field_2800, xOffset, yOffset, width, height, this.method_17577(), isInventoryButton);
        this.nemosInventorySorting$widgets.add(sortButton);
    }
}

