/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.gui.components.buttons;

import com.devnemo.nemos.inventory.sorting.ModKeyMappings;
import com.devnemo.nemos.inventory.sorting.gui.components.buttons.AbstractInventoryButton;
import com.devnemo.nemos.inventory.sorting.service.InventoryService;
import com.devnemo.nemos.inventory.sorting.service.SortingService;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;

public class SortButton
extends AbstractInventoryButton {
    private final ResourceLocation buttonTexture = ResourceLocation.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"sort_button");
    private final ResourceLocation buttonHoverTexture = ResourceLocation.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"sort_button_highlighted");

    public SortButton(AbstractInventoryButton.Builder<SortButton> builder) {
        super(builder);
    }

    @Override
    protected ResourceLocation getButtonHoverTexture() {
        return this.buttonHoverTexture;
    }

    @Override
    protected ResourceLocation getButtonTexture() {
        return this.buttonTexture;
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        InventoryService inventoryService = InventoryService.getInstance();
        SortingService sortingService = SortingService.getInstance();
        int endIndex = inventoryService.calculateEndIndex(this.isButtonShiftable(), this.endIndex);
        inventoryService.handleSorting(sortingService, this.menu, this.startIndex, endIndex);
    }

    @Override
    protected KeyMapping getKeyMapping() {
        if (this.isInventoryButton) {
            return ModKeyMappings.SORT_INVENTORY.get();
        }
        return ModKeyMappings.SORT.get();
    }
}

