/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.mixin;

import com.devnemo.nemos.inventory.sorting.ModKeyMappings;
import com.devnemo.nemos.inventory.sorting.NemosInventorySortingClientCommon;
import com.devnemo.nemos.inventory.sorting.config.DefaultConfigValues;
import com.devnemo.nemos.inventory.sorting.config.model.ComponentConfig;
import com.devnemo.nemos.inventory.sorting.config.model.FilterConfig;
import com.devnemo.nemos.inventory.sorting.config.service.ConfigService;
import com.devnemo.nemos.inventory.sorting.factory.ButtonCreator;
import com.devnemo.nemos.inventory.sorting.factory.DropAllButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.FilterButtonCreator;
import com.devnemo.nemos.inventory.sorting.factory.MoveAllButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.MoveSameButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.SortButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.ToggleFilterPersistenceButtonFactory;
import com.devnemo.nemos.inventory.sorting.gui.components.FilterBox;
import com.devnemo.nemos.inventory.sorting.gui.components.buttons.AbstractFilterToggleButton;
import com.devnemo.nemos.inventory.sorting.gui.components.buttons.AbstractInventoryButton;
import com.devnemo.nemos.inventory.sorting.helper.ButtonTypeMapping;
import com.devnemo.nemos.inventory.sorting.model.FilterResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BlastFurnaceMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.FurnaceMenu;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SmokerMenu;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin
extends Screen {
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;
    @Shadow
    protected int inventoryLabelY;
    @Shadow
    protected int imageWidth;
    @Unique
    private FilterBox nemosInventorySorting$filterBox;
    @Unique
    private FilterConfig nemosInventorySorting$filterConfig;
    @Unique
    private static final ResourceLocation HIGHLIGHTED_SLOT = ResourceLocation.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"container/highlighted_slot");
    @Unique
    private static final ResourceLocation HIGHLIGHTED_SLOT_INCLUDED_ITEM = ResourceLocation.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"container/highlighted_slot_included_item");
    @Unique
    private static final ResourceLocation DIMMED_SLOT = ResourceLocation.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"container/dimmed_slot");
    @Unique
    private int nemosInventorySorting$inventoryEndIndex;
    @Unique
    private int nemosInventorySorting$containerSize;
    @Unique
    private int nemosInventorySorting$filterBoxWidth = 0;
    @Unique
    private final ConfigService nemosInventorySorting$configService = ConfigService.getInstance();
    @Unique
    private final List<AbstractWidget> nemosInventorySorting$widgets = new ArrayList<AbstractWidget>();

    @Shadow
    public abstract AbstractContainerMenu getMenu();

    protected AbstractContainerScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        this.nemosInventorySorting$inventoryEndIndex = this.getMenu().slots.size() - 9;
        if (this.getMenu() instanceof InventoryMenu) {
            --this.nemosInventorySorting$inventoryEndIndex;
        }
        this.nemosInventorySorting$containerSize = this.nemosInventorySorting$inventoryEndIndex - 27;
        List<ComponentConfig> componentConfigs = this.nemosInventorySorting$configService.readOrGetDefaultComponentConfigs();
        if (this.nemosInventorySorting$shouldHaveFilter()) {
            this.nemosInventorySorting$filterConfig = this.nemosInventorySorting$configService.readOrGetDefaultFilterConfig();
            this.nemosInventorySorting$initFilter(componentConfigs);
        }
        if (this.nemosInventorySorting$shouldHaveStorageContainerButtons()) {
            this.nemosInventorySorting$initStorageContainerButtons(componentConfigs);
        }
        if (this.nemosInventorySorting$shouldHaveInventoryButtons()) {
            this.nemosInventorySorting$initInventoryButtons(componentConfigs);
        }
        if (this.nemosInventorySorting$shouldHaveContainerInventorySortingButtons()) {
            this.nemosInventorySorting$initContainerInventoryButtons(componentConfigs);
        }
        for (AbstractWidget widget : this.nemosInventorySorting$widgets) {
            this.addRenderableWidget((GuiEventListener)widget);
        }
    }

    protected void clearWidgets() {
        this.nemosInventorySorting$widgets.clear();
        super.clearWidgets();
    }

    @Unique
    private void nemosInventorySorting$initFilter(List<ComponentConfig> configs) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, DefaultConfigValues.ITEM_FILTER);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        this.nemosInventorySorting$filterBoxWidth = config.width();
        int xOffset = config.xOffset() != null ? config.xOffset() : 1;
        int yOffset = config.yOffset() != null ? config.yOffset() : DefaultConfigValues.Y_OFFSET_ITEM_FILTER;
        this.nemosInventorySorting$createSearchBox(xOffset, yOffset, this.nemosInventorySorting$filterBoxWidth, config.height(), this.nemosInventorySorting$filterConfig.getFilter());
        this.nemosInventorySorting$createButton(configs, DefaultConfigValues.FILTER_PERSISTENCE_TOGGLE, ToggleFilterPersistenceButtonFactory.getInstance());
    }

    @Inject(method={"onClose"}, at={@At(value="TAIL")})
    private void onClose(CallbackInfo ci) {
        if (this.nemosInventorySorting$filterBox == null) {
            return;
        }
        this.nemosInventorySorting$filterBox.updateAndSaveFilter(this.nemosInventorySorting$filterConfig);
    }

    @Unique
    private void nemosInventorySorting$createSearchBox(int xOffset, int yOffset, int width, int height, String filter) {
        this.nemosInventorySorting$filterBox = new FilterBox(this.font, this.leftPos, this.topPos, xOffset, yOffset, width, height, (Component)Component.translatable((String)"nemos_inventory_sorting.itemFilter"));
        this.addRenderableWidget((GuiEventListener)this.nemosInventorySorting$filterBox);
        this.nemosInventorySorting$filterBox.setValue(filter);
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.nemosInventorySorting$filterBox != null) {
            if (this.nemosInventorySorting$filterBox.isFocused() && keyCode != 256) {
                cir.setReturnValue((Object)this.nemosInventorySorting$filterBox.keyPressed(keyCode, scanCode, modifiers));
                return;
            }
            if (!this.nemosInventorySorting$filterBox.isFocused() && AbstractContainerScreenMixin.hasControlDown() && ModKeyMappings.QUICK_SEARCH.get().matches(keyCode, scanCode)) {
                this.nemosInventorySorting$handleQuickSearch(cir);
                return;
            }
        }
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.keyPressed(keyCode, scanCode, modifiers))) {
            cir.setReturnValue((Object)true);
        }
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.keyReleased(keyCode, scanCode, modifiers))) {
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        Optional optional = this.getChildAt(mouseX, mouseY);
        if (optional.isEmpty()) {
            for (GuiEventListener guiEventListener : this.children()) {
                guiEventListener.setFocused(false);
            }
        }
        if (this.nemosInventorySorting$filterBox != null && !this.nemosInventorySorting$filterBox.isFocused() && AbstractContainerScreenMixin.hasControlDown() && ModKeyMappings.QUICK_SEARCH.get().matchesMouse(button)) {
            this.nemosInventorySorting$handleQuickSearch(cir);
            return;
        }
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.mouseClicked(mouseX, mouseY, button))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private void nemosInventorySorting$handleQuickSearch(CallbackInfoReturnable<Boolean> cir) {
        int filterBoxY;
        int filterBoxX = this.nemosInventorySorting$filterBox.getX();
        Optional optionalGuiEventListener = this.getChildAt(filterBoxX, filterBoxY = this.nemosInventorySorting$filterBox.getY());
        if (optionalGuiEventListener.isEmpty()) {
            return;
        }
        this.setFocused((GuiEventListener)optionalGuiEventListener.get());
        this.nemosInventorySorting$filterBox.setFocused(true);
        this.nemosInventorySorting$filterBox.onClick(filterBoxX + this.nemosInventorySorting$filterBoxWidth, this.nemosInventorySorting$filterBox.getY());
        cir.setReturnValue((Object)true);
    }

    @Unique
    private boolean nemosInventorySorting$triggerActionOnWidget(Function<AbstractWidget, Boolean> function) {
        for (AbstractWidget widget : this.nemosInventorySorting$widgets) {
            if (!function.apply(widget).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"renderContents"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderSlots(Lnet/minecraft/client/gui/GuiGraphics;)V")})
    void renderHighlightedSlot(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveFilter() || this.nemosInventorySorting$filterBox == null) {
            return;
        }
        String filter = this.nemosInventorySorting$filterBox.getValue();
        if (!filter.isEmpty()) {
            Map<FilterResult, List<Slot>> filteredSlotMap = this.nemosInventorySorting$filterBox.filterSlots((NonNullList<Slot>)this.getMenu().slots, filter);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.INCLUDED), guiGraphics, HIGHLIGHTED_SLOT);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.HAS_INCLUDED_ITEM), guiGraphics, HIGHLIGHTED_SLOT_INCLUDED_ITEM);
        }
    }

    @Inject(method={"renderContents"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderSlotHighlightFront(Lnet/minecraft/client/gui/GuiGraphics;)V", shift=At.Shift.AFTER)})
    void renderDimmedSlot(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveFilter() || this.nemosInventorySorting$filterBox == null) {
            return;
        }
        String filter = this.nemosInventorySorting$filterBox.getValue();
        if (!filter.isEmpty()) {
            Map<FilterResult, List<Slot>> filteredSlotMap = this.nemosInventorySorting$filterBox.filterSlots((NonNullList<Slot>)this.getMenu().slots, filter);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.EXCLUDED), guiGraphics, DIMMED_SLOT);
        }
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveFilter() {
        return !(this.getMenu() instanceof CreativeModeInventoryScreen.ItemPickerMenu);
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveStorageContainerButtons() {
        AbstractContainerMenu menu = this.getMenu();
        if (NemosInventorySortingClientCommon.MOD_LOADER_HELPER.isModLoaded("nemos_backpacks")) {
            try {
                Class<?> clazz = Class.forName("com.devnemo.nemos.backpacks.world.inventory.BackpackMenu");
                if (clazz.isInstance(menu)) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return menu instanceof ChestMenu || menu instanceof ShulkerBoxMenu || this.nemosInventorySorting$isModdedContainerMenu(menu, "nemos_backpacks", "com.devnemo.nemos.backpacks.world.inventory.BackpackMenu") || this.nemosInventorySorting$isModdedContainerMenu(menu, "reinfchest", "atonkish.reinfcore.screen.ReinforcedStorageScreenHandler") || this.nemosInventorySorting$isModdedContainerMenu(menu, "reinfbarrel", "atonkish.reinfcore.screen.ReinforcedStorageScreenHandler") || this.nemosInventorySorting$isModdedContainerMenu(menu, "reinfshulker", "atonkish.reinfcore.screen.ReinforcedStorageScreenHandler");
    }

    @Unique
    private boolean nemosInventorySorting$isModdedContainerMenu(AbstractContainerMenu menu, String modId, String className) {
        if (NemosInventorySortingClientCommon.MOD_LOADER_HELPER.isModLoaded(modId)) {
            try {
                Class<?> clazz = Class.forName(className);
                if (clazz.isInstance(menu)) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveInventoryButtons() {
        return this.getMenu() instanceof InventoryMenu;
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveContainerInventorySortingButtons() {
        AbstractContainerMenu menu = this.getMenu();
        return menu instanceof EnchantmentMenu || menu instanceof FurnaceMenu || menu instanceof SmokerMenu || menu instanceof BlastFurnaceMenu || menu instanceof CraftingMenu || menu instanceof CrafterMenu || menu instanceof GrindstoneMenu || menu instanceof BrewingStandMenu;
    }

    @Unique
    private void nemosInventorySorting$markSlots(List<Slot> slots, GuiGraphics guiGraphics, ResourceLocation texture) {
        if (slots == null) {
            return;
        }
        for (Slot slot : slots) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, texture, slot.x, slot.y, 16, 16);
        }
    }

    @Unique
    private void nemosInventorySorting$initStorageContainerButtons(List<ComponentConfig> componentConfigs) {
        int defaultInventoryYOffset = this.getMenu() instanceof ShulkerBoxMenu ? this.inventoryLabelY - 1 : this.inventoryLabelY - 2;
        this.nemosInventorySorting$createButtons(componentConfigs, new ButtonTypeMapping(DefaultConfigValues.SORT_STORAGE_CONTAINER, SortButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.MOVE_SAME_STORAGE_CONTAINER, MoveSameButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.MOVE_ALL_STORAGE_CONTAINER, MoveAllButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_STORAGE_CONTAINER, DropAllButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.SORT_STORAGE_CONTAINER_INVENTORY, SortButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.MOVE_SAME_STORAGE_CONTAINER_INVENTORY, MoveSameButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.MOVE_ALL_STORAGE_CONTAINER_INVENTORY, MoveAllButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_STORAGE_CONTAINER_INVENTORY, DropAllButtonFactory.getInstance(), defaultInventoryYOffset, true));
    }

    @Unique
    private void nemosInventorySorting$initInventoryButtons(List<ComponentConfig> componentConfigs) {
        this.nemosInventorySorting$createButtons(componentConfigs, new ButtonTypeMapping(DefaultConfigValues.SORT_INVENTORY, SortButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_INVENTORY, true), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_INVENTORY, DropAllButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_INVENTORY, true));
    }

    @Unique
    private void nemosInventorySorting$initContainerInventoryButtons(List<ComponentConfig> componentConfigs) {
        int defaultInventoryYOffset = this.inventoryLabelY - 1;
        this.nemosInventorySorting$createButtons(componentConfigs, new ButtonTypeMapping(DefaultConfigValues.SORT_CONTAINER_INVENTORY, SortButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_CONTAINER_INVENTORY, DropAllButtonFactory.getInstance(), defaultInventoryYOffset, true));
    }

    @Unique
    private void nemosInventorySorting$createButton(List<ComponentConfig> configs, String componentName, FilterButtonCreator filterButtonCreator) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, componentName);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int width = config.width();
        int xOffset = config.xOffset() != null ? config.xOffset() : this.nemosInventorySorting$filterBoxWidth + 3;
        int yOffset = config.yOffset() != null ? config.yOffset() : DefaultConfigValues.Y_OFFSET_ITEM_FILTER;
        AbstractFilterToggleButton button = filterButtonCreator.createButton(this.leftPos, this.topPos, xOffset, yOffset, width, config.height(), this.nemosInventorySorting$filterConfig);
        this.nemosInventorySorting$widgets.add(button);
    }

    @Unique
    private void nemosInventorySorting$createButtons(List<ComponentConfig> configs, ButtonTypeMapping ... mappings) {
        for (ButtonTypeMapping mapping : mappings) {
            ComponentConfig config;
            Optional<ComponentConfig> optionalConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, mapping.componentName());
            if (optionalConfig.isEmpty() || !(config = optionalConfig.get()).isEnabled()) continue;
            int yOffset = config.yOffset() != null ? config.yOffset().intValue() : mapping.defaultYOffset();
            int xOffset = config.xOffset() != null ? config.xOffset() : this.imageWidth + config.rightXOffset();
            this.nemosInventorySorting$createButton(mapping.factory(), mapping.isInventoryButton(), xOffset, yOffset, config.width(), config.height());
        }
    }

    @Unique
    private void nemosInventorySorting$createButton(ButtonCreator buttonCreator, boolean isInventoryButton, int xOffset, int yOffset, int width, int height) {
        int startIndex = isInventoryButton ? this.nemosInventorySorting$containerSize : 0;
        int endIndex = isInventoryButton ? this.nemosInventorySorting$inventoryEndIndex : this.nemosInventorySorting$containerSize;
        this.nemosInventorySorting$createButton(buttonCreator, startIndex, endIndex, xOffset, yOffset, width, height, isInventoryButton);
    }

    @Unique
    private void nemosInventorySorting$createButton(ButtonCreator buttonCreator, int startIndex, int endIndex, int xOffset, int yOffset, int width, int height, boolean isInventoryButton) {
        AbstractInventoryButton sortButton = buttonCreator.createButton(startIndex, endIndex, this.leftPos, this.topPos, xOffset, yOffset, width, height, this.getMenu(), isInventoryButton);
        this.nemosInventorySorting$widgets.add(sortButton);
    }
}

