/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.gui.components.buttons;

import com.devnemo.nemos.inventory.sorting.gui.components.buttons.AbstractInventoryButton;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSingleClickButton<T extends AbstractInventoryButton>
extends AbstractInventoryButton {
    public AbstractSingleClickButton(AbstractInventoryButton.Builder<T> builder) {
        super(builder);
    }

    protected void interactWithAllItems(ClickType clickType, int button) {
        Minecraft minecraft = Minecraft.m_91087_();
        MultiPlayerGameMode gameMode = minecraft.f_91072_;
        LocalPlayer player = minecraft.f_91074_;
        int containerId = this.menu.f_38840_;
        boolean isCreativeModeMenu = this.menu instanceof CreativeModeInventoryScreen.ItemPickerMenu;
        if (player == null) {
            return;
        }
        List<Integer> slotItems = this.getItemSlotsToInteractWith(this.menu);
        if (gameMode != null) {
            Consumer<Integer> function = isCreativeModeMenu ? slotIndex -> this.menu.m_150399_(slotIndex.intValue(), button, clickType, (Player)player) : slotIndex -> gameMode.m_171799_(containerId, slotIndex.intValue(), button, clickType, (Player)player);
            this.triggerClickForAllItems(slotItems, function);
        }
    }

    private void triggerClickForAllItems(List<Integer> slotItems, Consumer<Integer> function) {
        for (Integer slotIndex : slotItems) {
            function.accept(slotIndex);
        }
    }

    @NotNull
    protected List<Integer> getItemSlotsToInteractWith(AbstractContainerMenu menu) {
        NonNullList slots = menu.f_38839_;
        return IntStream.range(this.startIndex, this.calculateEndIndex()).mapToObj(slotIndex -> Map.entry(slotIndex, ((Slot)slots.get(slotIndex)).m_7993_())).filter(itemStackEntry -> !((ItemStack)itemStackEntry.getValue()).m_150930_(Items.f_41852_)).map(Map.Entry::getKey).toList();
    }
}

