/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.service;

import com.devnemo.nemos.inventory.sorting.model.FilterResult;
import com.devnemo.nemos.inventory.sorting.service.TooltipService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class FilterService {
    private static FilterService INSTANCE;
    private final TooltipService tooltipService;

    public static FilterService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FilterService(TooltipService.getInstance());
        }
        return INSTANCE;
    }

    public FilterService(TooltipService tooltipService) {
        this.tooltipService = tooltipService;
    }

    public Map<FilterResult, List<Slot>> filterSlots(NonNullList<Slot> slots, String filter) {
        return slots.stream().collect(Collectors.groupingBy(slot -> this.filterSlot((Slot)slot, filter)));
    }

    private FilterResult filterSlot(Slot slot, String filter) {
        ItemStack slotItem = slot.m_7993_();
        if (slotItem.m_150930_(Items.f_41852_)) {
            return FilterResult.EXCLUDED;
        }
        if (this.itemContainerContentsMatchFilter(slotItem, filter)) {
            return FilterResult.HAS_INCLUDED_ITEM;
        }
        return this.matchesFilter(slotItem, filter) ? FilterResult.INCLUDED : FilterResult.EXCLUDED;
    }

    private boolean itemContainerContentsMatchFilter(ItemStack itemStack, String filter) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag == null || !compoundTag.m_128441_("BlockEntityTag")) {
            return false;
        }
        String containerItems = compoundTag.m_128423_("BlockEntityTag").m_7916_();
        return containerItems.contains(filter);
    }

    private boolean contentsMatchFilter(Stream<ItemStack> stream, String filter) {
        return stream.anyMatch(itemStack -> this.matchesFilter((ItemStack)itemStack, filter));
    }

    private boolean matchesFilter(ItemStack itemStack, String filter) {
        boolean itemNameMatchesFilter = this.componentMatchesFilter(itemStack.m_41720_().m_7626_(itemStack), filter);
        boolean itemDisplayNameMatchesFilter = this.componentMatchesFilter(itemStack.m_41611_(), filter);
        boolean tooltipMatchesFilter = this.tooltipMatchesFilter(itemStack, filter);
        return itemNameMatchesFilter || itemDisplayNameMatchesFilter || tooltipMatchesFilter;
    }

    private boolean tooltipMatchesFilter(ItemStack itemStack, String filter) {
        List<Component> tooltipComponents = this.tooltipService.retrieveTooltipLines(itemStack);
        boolean itemEnchantsMatchesFilter = this.tooltipService.retrieveEnchantmentNames(tooltipComponents).toLowerCase().contains(filter.toLowerCase());
        boolean jukeboxSongMatchesFilter = this.tooltipService.retrieveJukeboxSongName(tooltipComponents).toLowerCase().contains(filter.toLowerCase());
        boolean potionMatchesFilter = this.tooltipService.retrievePotionName(tooltipComponents).toLowerCase().contains(filter.toLowerCase());
        return itemEnchantsMatchesFilter || jukeboxSongMatchesFilter || potionMatchesFilter;
    }

    private boolean componentMatchesFilter(Component component, String filter) {
        return component.getString().toLowerCase().contains(filter.toLowerCase());
    }
}

