/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.gui.components;

import com.devnemo.nemos.inventory.sorting.config.model.FilterConfig;
import com.devnemo.nemos.inventory.sorting.config.service.ConfigService;
import com.devnemo.nemos.inventory.sorting.gui.components.RecipeBookUpdatable;
import com.devnemo.nemos.inventory.sorting.model.FilterResult;
import com.devnemo.nemos.inventory.sorting.service.FilterService;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;

public class FilterBox
extends EditBox
implements RecipeBookUpdatable {
    private static final Component FILTER_HINT = Component.m_237115_((String)"nemos_inventory_sorting.gui.inventory.itemFilter").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
    private final FilterService filterService = FilterService.getInstance();
    private final ConfigService configService = ConfigService.getInstance();
    private final int xOffset;

    public FilterBox(Font font, int x, int y, int xOffset, int yOffset, int width, int height, Component message) {
        super(font, x + xOffset, y + yOffset, width, height, message);
        this.xOffset = xOffset;
        this.m_94202_(-1);
        this.m_94194_(true);
        this.m_94199_(50);
        this.m_94182_(true);
        this.m_94190_(true);
        this.m_93692_(false);
        this.m_257771_(FILTER_HINT);
    }

    @Override
    public void updateXPosition(int leftPos) {
        this.m_252865_(leftPos + this.xOffset);
    }

    public Map<FilterResult, List<Slot>> filterSlots(NonNullList<Slot> slots, String filter) {
        return this.filterService.filterSlots(slots, filter);
    }

    public void updateAndSaveFilter(FilterConfig filterConfig) {
        String filter = filterConfig.isFilterPersistent() ? this.m_94155_() : "";
        filterConfig.setFilter(filter);
        this.configService.writeConfig(true, "config/nemos-inventory-sorting/filter-config.json", filterConfig);
    }
}

