/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.gui.components.buttons;

import com.devnemo.nemos.inventory.sorting.config.model.FilterConfig;
import com.devnemo.nemos.inventory.sorting.gui.components.RecipeBookUpdatable;
import java.util.Arrays;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFilterToggleButton
extends AbstractWidget
implements RecipeBookUpdatable {
    private final int xOffset;
    protected final FilterConfig filterConfig;

    public AbstractFilterToggleButton(Builder<? extends AbstractFilterToggleButton> builder) {
        super(builder.x.intValue(), builder.y.intValue(), builder.width.intValue(), builder.height.intValue(), builder.buttonName);
        this.xOffset = builder.xOffset;
        this.filterConfig = builder.filterConfig;
    }

    protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation texture = this.filterConfig.isFilterPersistent() ? (this.m_274382_() ? this.getToggleOnHoverTexture() : this.getToggleOnTexture()) : (this.m_274382_() ? this.getToggleOffHoverTexture() : this.getToggleOffTexture());
        this.m_280322_(guiGraphics, texture, this.m_252754_(), this.m_252907_(), 0, 0, 0, this.m_5711_(), this.m_93694_(), this.m_5711_(), this.m_93694_());
    }

    @Override
    public void updateXPosition(int leftPos) {
        this.m_252865_(leftPos + this.xOffset);
    }

    protected abstract ResourceLocation getToggleOffTexture();

    protected abstract ResourceLocation getToggleOnTexture();

    protected abstract ResourceLocation getToggleOffHoverTexture();

    protected abstract ResourceLocation getToggleOnHoverTexture();

    protected abstract void setTooltip();

    public abstract void m_5716_(double var1, double var3);

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Minecraft minecraft = Minecraft.m_91087_();
        boolean isKeyPressed = Arrays.stream(minecraft.f_91066_.f_92059_).filter(keyMapping -> keyMapping.m_90850_(this.getKeyMapping())).anyMatch(keyMapping -> keyMapping.m_90832_(keyCode, scanCode));
        if (!isKeyPressed) {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        this.m_7435_(minecraft.m_91106_());
        this.m_5716_(0.0, 0.0);
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Minecraft minecraft = Minecraft.m_91087_();
        boolean isKeyPressed = Arrays.stream(minecraft.f_91066_.f_92059_).filter(keyMapping -> keyMapping.m_90850_(this.getKeyMapping())).anyMatch(keyMapping -> keyMapping.m_90830_(button));
        if (!isKeyPressed) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        this.m_7435_(minecraft.m_91106_());
        this.m_5716_(0.0, 0.0);
        return true;
    }

    protected abstract KeyMapping getKeyMapping();

    protected void m_168797_(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    public static class Builder<T extends AbstractFilterToggleButton> {
        private Integer x;
        private Integer y;
        private Integer xOffset;
        private Integer width;
        private Integer height;
        private Component buttonName;
        private FilterConfig filterConfig;
        private final Class<T> clazz;

        public Builder(Class<T> clazz) {
            this.clazz = clazz;
        }

        public Builder<T> x(int x) {
            this.x = x;
            return this;
        }

        public Builder<T> y(int y) {
            this.y = y;
            return this;
        }

        public Builder<T> xOffset(int xOffset) {
            this.xOffset = xOffset;
            return this;
        }

        public Builder<T> width(int width) {
            this.width = width;
            return this;
        }

        public Builder<T> height(int height) {
            this.height = height;
            return this;
        }

        public Builder<T> buttonName(Component buttonName) {
            this.buttonName = buttonName;
            return this;
        }

        public Builder<T> filterConfig(FilterConfig filterConfig) {
            this.filterConfig = filterConfig;
            return this;
        }

        public T build() {
            this.checkRequiredFields();
            try {
                return (T)((AbstractFilterToggleButton)this.clazz.getDeclaredConstructor(Builder.class).newInstance(this));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create instance of " + this.clazz.getName(), e);
            }
        }

        private void checkRequiredFields() {
            if (this.x == null || this.y == null || this.xOffset == null || this.width == null || this.height == null || this.buttonName == null || this.filterConfig == null) {
                throw new IllegalArgumentException("Not all fields were set!");
            }
        }
    }
}

