/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.gui.components.buttons;

import com.devnemo.nemos.inventory.sorting.gui.components.RecipeBookUpdatable;
import java.util.Arrays;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInventoryButton
extends AbstractWidget
implements RecipeBookUpdatable {
    protected final AbstractContainerMenu menu;
    protected final Integer startIndex;
    protected final Integer endIndex;
    private final int xOffset;
    private final Component buttonName;
    private final Component shiftButtonName;
    protected final boolean isInventoryButton;
    protected boolean isShiftKeyDown = false;

    public AbstractInventoryButton(Builder<? extends AbstractInventoryButton> builder) {
        super(builder.x.intValue(), builder.y.intValue(), builder.width.intValue(), builder.height.intValue(), builder.buttonName);
        this.m_257544_(Tooltip.m_257550_((Component)builder.buttonName));
        this.buttonName = builder.buttonName;
        this.shiftButtonName = builder.shiftButtonName;
        this.menu = builder.menu;
        this.startIndex = builder.startIndex;
        this.endIndex = builder.endIndex;
        this.xOffset = builder.xOffset;
        this.isInventoryButton = builder.isInventoryButton;
    }

    public abstract void m_5716_(double var1, double var3);

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.setIsShiftKeyDown(true);
            this.setTooltip();
        }
        Minecraft minecraft = Minecraft.m_91087_();
        boolean isKeyPressed = Arrays.stream(minecraft.f_91066_.f_92059_).filter(keyMapping -> keyMapping.m_90850_(this.getKeyMapping())).anyMatch(keyMapping -> keyMapping.m_90832_(keyCode, scanCode));
        if (!isKeyPressed) {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        this.m_7435_(minecraft.m_91106_());
        this.m_5716_(0.0, 0.0);
        return true;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.setIsShiftKeyDown(false);
            this.setTooltip();
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Minecraft minecraft = Minecraft.m_91087_();
        boolean isKeyPressed = Arrays.stream(minecraft.f_91066_.f_92059_).filter(keyMapping -> keyMapping.m_90850_(this.getKeyMapping())).anyMatch(keyMapping -> keyMapping.m_90830_(button));
        if (!isKeyPressed) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        this.m_7435_(minecraft.m_91106_());
        this.m_5716_(0.0, 0.0);
        return true;
    }

    protected abstract KeyMapping getKeyMapping();

    protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.m_274382_()) {
            this.m_280322_(guiGraphics, this.getButtonHoverTexture(), this.m_252754_(), this.m_252907_(), 0, 0, 0, this.m_5711_(), this.m_93694_(), this.m_5711_(), this.m_93694_());
        } else {
            this.m_280322_(guiGraphics, this.getButtonTexture(), this.m_252754_(), this.m_252907_(), 0, 0, 0, this.m_5711_(), this.m_93694_(), this.m_5711_(), this.m_93694_());
        }
    }

    @Override
    public void updateXPosition(int leftPos) {
        this.m_252865_(leftPos + this.xOffset);
    }

    protected abstract ResourceLocation getButtonHoverTexture();

    protected abstract ResourceLocation getButtonTexture();

    public void setIsShiftKeyDown(boolean shiftKeyDown) {
        this.isShiftKeyDown = shiftKeyDown;
    }

    public void setTooltip() {
        if (this.isButtonShiftable()) {
            this.m_257544_(Tooltip.m_257550_((Component)this.shiftButtonName));
        } else {
            this.m_257544_(Tooltip.m_257550_((Component)this.buttonName));
        }
    }

    protected int calculateEndIndex() {
        if (this.isButtonShiftable()) {
            return this.endIndex + 9;
        }
        return this.endIndex;
    }

    protected boolean isButtonShiftable() {
        return this.isShiftKeyDown && this.isInventoryButton;
    }

    protected void m_168797_(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    public static class Builder<T extends AbstractInventoryButton> {
        private Integer startIndex;
        private Integer endIndex;
        private Integer x;
        private Integer y;
        private Integer xOffset;
        private Integer width;
        private Integer height;
        private Component buttonName;
        private Component shiftButtonName;
        private AbstractContainerMenu menu;
        private boolean isInventoryButton = false;
        private final Class<T> clazz;

        public Builder(Class<T> clazz) {
            this.clazz = clazz;
        }

        public Builder<T> startIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public Builder<T> endIndex(int endIndex) {
            this.endIndex = endIndex;
            return this;
        }

        public Builder<T> x(int x) {
            this.x = x;
            return this;
        }

        public Builder<T> y(int y) {
            this.y = y;
            return this;
        }

        public Builder<T> xOffset(int xOffset) {
            this.xOffset = xOffset;
            return this;
        }

        public Builder<T> width(int width) {
            this.width = width;
            return this;
        }

        public Builder<T> height(int height) {
            this.height = height;
            return this;
        }

        public Builder<T> buttonName(Component buttonName) {
            this.buttonName = buttonName;
            return this;
        }

        public Builder<T> shiftButtonName(Component shiftButtonName) {
            this.shiftButtonName = shiftButtonName;
            return this;
        }

        public Builder<T> menu(AbstractContainerMenu menu) {
            this.menu = menu;
            return this;
        }

        public Builder<T> isInventoryButton(boolean isInventoryButton) {
            this.isInventoryButton = isInventoryButton;
            return this;
        }

        public T build() {
            this.checkRequiredFields();
            try {
                return (T)((AbstractInventoryButton)this.clazz.getDeclaredConstructor(Builder.class).newInstance(this));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create instance of " + this.clazz.getName(), e);
            }
        }

        private void checkRequiredFields() {
            if (this.startIndex == null || this.endIndex == null || this.x == null || this.y == null || this.xOffset == null || this.width == null || this.height == null || this.buttonName == null || this.menu == null) {
                throw new IllegalArgumentException("Not all fields were set!");
            }
        }
    }
}

