/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.service;

import com.devnemo.nemos.inventory.sorting.Constants;
import com.devnemo.nemos.inventory.sorting.model.SlotItem;
import com.devnemo.nemos.inventory.sorting.service.SlotSwappingService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MergingService {
    private static MergingService INSTANCE;
    private final SlotSwappingService inventorySwapService;
    private final Minecraft minecraft;

    private MergingService(SlotSwappingService inventorySwapService, Minecraft minecraft) {
        this.inventorySwapService = inventorySwapService;
        this.minecraft = minecraft;
    }

    public static MergingService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MergingService(SlotSwappingService.getInstance(), Minecraft.m_91087_());
        }
        return INSTANCE;
    }

    public void mergeAllItems(AbstractContainerMenu menu, List<SlotItem> sortedSlotItems, int containerId) {
        Map<CompoundTag, List<SlotItem>> groupedItemByCompoundTagMap = sortedSlotItems.stream().filter(slotItem -> slotItem.itemStack().m_41783_() != null).collect(Collectors.groupingBy(slotItem -> slotItem.itemStack().m_41783_()));
        Map<String, List<SlotItem>> groupedItemByItemNameMap = sortedSlotItems.stream().filter(slotItem -> slotItem.itemStack().m_41783_() == null).collect(Collectors.groupingBy(slotItem -> {
            ItemStack itemStack = slotItem.itemStack();
            return itemStack.m_41720_().m_7626_(itemStack).getString();
        }));
        groupedItemByItemNameMap.forEach((key, slotItems) -> this.mergeItems(menu, (List<SlotItem>)slotItems, containerId));
        groupedItemByCompoundTagMap.forEach((key, slotItems) -> this.mergeItems(menu, (List<SlotItem>)slotItems, containerId));
    }

    private void mergeItems(AbstractContainerMenu menu, List<SlotItem> slotItems, int containerId) {
        if (slotItems.size() <= 1) {
            return;
        }
        int leftSlotIndex = 0;
        int rightSlotIndex = slotItems.size() - 1;
        int remainingCycles = 1000;
        while (leftSlotIndex < rightSlotIndex && remainingCycles-- > 0) {
            SlotItem leftSlotItem = slotItems.get(leftSlotIndex);
            SlotItem rightSlotItem = slotItems.get(rightSlotIndex);
            Slot leftSlot = (Slot)menu.f_38839_.get(leftSlotItem.slotIndex());
            Slot rightSlot = (Slot)menu.f_38839_.get(rightSlotItem.slotIndex());
            ItemStack leftItem = leftSlot.m_7993_();
            if (!this.isFullStack(leftItem)) {
                this.inventorySwapService.performSlotSwap(menu, this.minecraft.f_91072_, containerId, rightSlotItem.slotIndex(), leftSlotItem.slotIndex(), this.minecraft.f_91074_);
            } else {
                ++leftSlotIndex;
            }
            if (!rightSlot.m_7993_().m_41619_()) continue;
            --rightSlotIndex;
        }
        if (remainingCycles <= 0) {
            Constants.LOG.warn("Merging items exceeded cycle limit. Please report this.");
        }
    }

    private boolean isFullStack(ItemStack itemStack) {
        return itemStack.m_41613_() >= itemStack.m_41741_();
    }
}

