/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.gui.components.buttons;

import com.devnemo.nemos.inventory.sorting.ModKeyMappings;
import com.devnemo.nemos.inventory.sorting.gui.components.buttons.AbstractInventoryButton;
import com.devnemo.nemos.inventory.sorting.gui.components.buttons.AbstractSingleClickButton;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class MoveSameButton
extends AbstractSingleClickButton<MoveSameButton> {
    private final ResourceLocation buttonTexture = new ResourceLocation("nemos_inventory_sorting", "textures/gui/sprites/move_same_button.png");
    private final ResourceLocation buttonHoverTexture = new ResourceLocation("nemos_inventory_sorting", "textures/gui/sprites/move_same_button_highlighted.png");

    public MoveSameButton(AbstractInventoryButton.Builder<MoveSameButton> builder) {
        super(builder);
    }

    @Override
    protected ResourceLocation getButtonHoverTexture() {
        return this.buttonHoverTexture;
    }

    @Override
    protected ResourceLocation getButtonTexture() {
        return this.buttonTexture;
    }

    @Override
    public void m_5716_(double mouseX, double mouseY) {
        this.interactWithAllItems(ClickType.QUICK_MOVE, 0);
    }

    @Override
    protected KeyMapping getKeyMapping() {
        if (this.isInventoryButton) {
            return ModKeyMappings.MOVE_SAME_INVENTORY.get();
        }
        return ModKeyMappings.MOVE_SAME.get();
    }

    @Override
    @NotNull
    protected List<Integer> getItemSlotsToInteractWith(AbstractContainerMenu menu) {
        NonNullList slots = menu.f_38839_;
        int newEndIndex = this.calculateEndIndex();
        List<Item> itemsOutOfIndexRange = this.getItemsOutOfIndexRange((NonNullList<Slot>)slots, this.startIndex, newEndIndex);
        return IntStream.range(this.startIndex, newEndIndex).mapToObj(slotIndex -> Map.entry(slotIndex, ((Slot)slots.get(slotIndex)).m_7993_())).filter(itemStackEntry -> this.isItemInOtherContainer((ItemStack)itemStackEntry.getValue(), itemsOutOfIndexRange)).map(Map.Entry::getKey).toList();
    }

    private List<Item> getItemsOutOfIndexRange(NonNullList<Slot> slots, int startIndex, int endIndex) {
        return slots.stream().filter(slot -> startIndex != 0 && slot.f_40219_ < startIndex || startIndex == 0 && slot.f_40219_ >= endIndex).filter(slot -> !slot.m_7993_().m_150930_(Items.f_41852_)).map(slot -> slot.m_7993_().m_41720_()).distinct().toList();
    }

    private boolean isItemInOtherContainer(ItemStack itemStack, List<Item> itemsOutOfIndexRange) {
        return !itemStack.m_150930_(Items.f_41852_) && itemsOutOfIndexRange.contains(itemStack.m_41720_());
    }
}

