/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.mixin;

import com.devnemo.nemos.inventory.sorting.ModKeyMappings;
import com.devnemo.nemos.inventory.sorting.config.DefaultConfigValues;
import com.devnemo.nemos.inventory.sorting.config.model.ComponentConfig;
import com.devnemo.nemos.inventory.sorting.config.model.FilterConfig;
import com.devnemo.nemos.inventory.sorting.config.service.ConfigService;
import com.devnemo.nemos.inventory.sorting.factory.ButtonCreator;
import com.devnemo.nemos.inventory.sorting.factory.DropAllButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.FilterButtonCreator;
import com.devnemo.nemos.inventory.sorting.factory.MoveAllButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.MoveSameButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.SortButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.ToggleFilterPersistenceButtonFactory;
import com.devnemo.nemos.inventory.sorting.gui.components.FilterBox;
import com.devnemo.nemos.inventory.sorting.gui.components.buttons.AbstractFilterToggleButton;
import com.devnemo.nemos.inventory.sorting.gui.components.buttons.AbstractInventoryButton;
import com.devnemo.nemos.inventory.sorting.helper.ButtonTypeMapping;
import com.devnemo.nemos.inventory.sorting.model.FilterResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BlastFurnaceMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.FurnaceMenu;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SmokerMenu;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin
extends Screen {
    @Shadow
    protected int f_97735_;
    @Shadow
    protected int f_97736_;
    @Shadow
    protected int f_97731_;
    @Shadow
    protected int f_97726_;
    @Unique
    private FilterBox nemosInventorySorting$filterBox;
    @Unique
    private FilterConfig nemosInventorySorting$filterConfig;
    @Unique
    private static final ResourceLocation HIGHLIGHTED_SLOT = new ResourceLocation("nemos_inventory_sorting", "textures/gui/sprites/container/highlighted_slot.png");
    @Unique
    private static final ResourceLocation HIGHLIGHTED_SLOT_INCLUDED_ITEM = new ResourceLocation("nemos_inventory_sorting", "textures/gui/sprites/container/highlighted_slot_included_item.png");
    @Unique
    private static final ResourceLocation DIMMED_SLOT = new ResourceLocation("nemos_inventory_sorting", "textures/gui/sprites/container/dimmed_slot.png");
    @Unique
    private int nemosInventorySorting$inventoryEndIndex;
    @Unique
    private int nemosInventorySorting$containerSize;
    @Unique
    private int nemosInventorySorting$filterBoxWidth = 0;
    @Unique
    private final ConfigService nemosInventorySorting$configService = ConfigService.getInstance();
    @Unique
    private final List<AbstractWidget> nemosInventorySorting$widgets = new ArrayList<AbstractWidget>();

    @Shadow
    public abstract AbstractContainerMenu m_6262_();

    protected AbstractContainerScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        this.nemosInventorySorting$inventoryEndIndex = this.m_6262_().f_38839_.size() - 9;
        if (this.m_6262_() instanceof InventoryMenu) {
            --this.nemosInventorySorting$inventoryEndIndex;
        }
        this.nemosInventorySorting$containerSize = this.nemosInventorySorting$inventoryEndIndex - 27;
        List<ComponentConfig> componentConfigs = this.nemosInventorySorting$configService.readOrGetDefaultComponentConfigs();
        if (this.nemosInventorySorting$shouldHaveFilter()) {
            this.nemosInventorySorting$filterConfig = this.nemosInventorySorting$configService.readOrGetDefaultFilterConfig();
            this.nemosInventorySorting$initFilter(componentConfigs);
        }
        if (this.nemosInventorySorting$shouldHaveStorageContainerButtons()) {
            this.nemosInventorySorting$initStorageContainerButtons(componentConfigs);
        }
        if (this.nemosInventorySorting$shouldHaveInventoryButtons()) {
            this.nemosInventorySorting$initInventoryButtons(componentConfigs);
        }
        if (this.nemosInventorySorting$shouldHaveContainerInventorySortingButtons()) {
            this.nemosInventorySorting$initContainerInventoryButtons(componentConfigs);
        }
        for (AbstractWidget widget : this.nemosInventorySorting$widgets) {
            this.m_142416_((GuiEventListener)widget);
        }
    }

    protected void m_169413_() {
        this.nemosInventorySorting$widgets.clear();
        super.m_169413_();
    }

    @Unique
    private void nemosInventorySorting$initFilter(List<ComponentConfig> configs) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, DefaultConfigValues.ITEM_FILTER);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        this.nemosInventorySorting$filterBoxWidth = config.width();
        int xOffset = config.xOffset() != null ? config.xOffset() : 1;
        int yOffset = config.yOffset() != null ? config.yOffset() : DefaultConfigValues.Y_OFFSET_ITEM_FILTER;
        this.nemosInventorySorting$createSearchBox(xOffset, yOffset, this.nemosInventorySorting$filterBoxWidth, config.height(), this.nemosInventorySorting$filterConfig.getFilter());
        this.nemosInventorySorting$createButton(configs, DefaultConfigValues.FILTER_PERSISTENCE_TOGGLE, ToggleFilterPersistenceButtonFactory.getInstance());
    }

    @Inject(method={"onClose"}, at={@At(value="TAIL")})
    private void onClose(CallbackInfo ci) {
        if (this.nemosInventorySorting$filterBox == null) {
            return;
        }
        this.nemosInventorySorting$filterBox.updateAndSaveFilter(this.nemosInventorySorting$filterConfig);
    }

    @Unique
    private void nemosInventorySorting$createSearchBox(int xOffset, int yOffset, int width, int height, String filter) {
        this.nemosInventorySorting$filterBox = new FilterBox(this.f_96547_, this.f_97735_, this.f_97736_, xOffset, yOffset, width, height, (Component)Component.m_237115_((String)"nemos_inventory_sorting.itemFilter"));
        this.m_142416_((GuiEventListener)this.nemosInventorySorting$filterBox);
        this.nemosInventorySorting$filterBox.m_94144_(filter);
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.nemosInventorySorting$filterBox != null) {
            if (this.nemosInventorySorting$filterBox.m_93696_() && keyCode != 256) {
                cir.setReturnValue((Object)this.nemosInventorySorting$filterBox.m_7933_(keyCode, scanCode, modifiers));
                return;
            }
            if (!this.nemosInventorySorting$filterBox.m_93696_() && AbstractContainerScreenMixin.m_96637_() && keyCode == 70) {
                this.nemosInventorySorting$handleQuickSearch(cir);
                return;
            }
        }
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.m_7933_(keyCode, scanCode, modifiers))) {
            cir.setReturnValue((Object)true);
        }
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.m_7920_(keyCode, scanCode, modifiers))) {
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        Optional optional = this.m_94729_(mouseX, mouseY);
        if (optional.isEmpty()) {
            for (GuiEventListener guiEventListener : this.m_6702_()) {
                guiEventListener.m_93692_(false);
            }
        }
        if (this.nemosInventorySorting$filterBox != null && !this.nemosInventorySorting$filterBox.m_93696_() && AbstractContainerScreenMixin.m_96637_() && ModKeyMappings.QUICK_SEARCH.get().m_90830_(button)) {
            this.nemosInventorySorting$handleQuickSearch(cir);
            return;
        }
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.m_6375_(mouseX, mouseY, button))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private void nemosInventorySorting$handleQuickSearch(CallbackInfoReturnable<Boolean> cir) {
        int filterBoxY;
        int filterBoxX = this.nemosInventorySorting$filterBox.m_252754_();
        Optional optionalGuiEventListener = this.m_94729_(filterBoxX, filterBoxY = this.nemosInventorySorting$filterBox.m_252907_());
        if (optionalGuiEventListener.isEmpty()) {
            return;
        }
        this.m_7522_((GuiEventListener)optionalGuiEventListener.get());
        this.nemosInventorySorting$filterBox.m_93692_(true);
        this.nemosInventorySorting$filterBox.m_5716_(filterBoxX + this.nemosInventorySorting$filterBoxWidth, this.nemosInventorySorting$filterBox.m_252907_());
        cir.setReturnValue((Object)true);
    }

    @Unique
    private boolean nemosInventorySorting$triggerActionOnWidget(Function<AbstractWidget, Boolean> function) {
        for (AbstractWidget widget : this.nemosInventorySorting$widgets) {
            if (!function.apply(widget).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    void renderHighlightedSlot(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveFilter() || this.nemosInventorySorting$filterBox == null) {
            return;
        }
        String filter = this.nemosInventorySorting$filterBox.m_94155_();
        if (!filter.isEmpty()) {
            Map<FilterResult, List<Slot>> filteredSlotMap = this.nemosInventorySorting$filterBox.filterSlots((NonNullList<Slot>)this.m_6262_().f_38839_, filter);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.INCLUDED), guiGraphics, HIGHLIGHTED_SLOT);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.HAS_INCLUDED_ITEM), guiGraphics, HIGHLIGHTED_SLOT_INCLUDED_ITEM);
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderLabels(Lnet/minecraft/client/gui/GuiGraphics;II)V", shift=At.Shift.AFTER)})
    void renderDimmedSlot(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveFilter() || this.nemosInventorySorting$filterBox == null) {
            return;
        }
        String filter = this.nemosInventorySorting$filterBox.m_94155_();
        if (!filter.isEmpty()) {
            Map<FilterResult, List<Slot>> filteredSlotMap = this.nemosInventorySorting$filterBox.filterSlots((NonNullList<Slot>)this.m_6262_().f_38839_, filter);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.EXCLUDED), guiGraphics, DIMMED_SLOT);
        }
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveFilter() {
        return !(this.m_6262_() instanceof CreativeModeInventoryScreen.ItemPickerMenu);
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveStorageContainerButtons() {
        AbstractContainerMenu menu = this.m_6262_();
        return menu instanceof ChestMenu || menu instanceof ShulkerBoxMenu;
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveInventoryButtons() {
        return this.m_6262_() instanceof InventoryMenu;
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveContainerInventorySortingButtons() {
        AbstractContainerMenu menu = this.m_6262_();
        return menu instanceof EnchantmentMenu || menu instanceof FurnaceMenu || menu instanceof SmokerMenu || menu instanceof BlastFurnaceMenu || menu instanceof CraftingMenu || menu instanceof GrindstoneMenu || menu instanceof BrewingStandMenu;
    }

    @Unique
    private void nemosInventorySorting$markSlots(List<Slot> slots, GuiGraphics guiGraphics, ResourceLocation texture) {
        if (slots == null) {
            return;
        }
        for (Slot slot : slots) {
            int xPos = this.f_97735_ + slot.f_40220_;
            int yPos = this.f_97736_ + slot.f_40221_;
            if (texture == DIMMED_SLOT) {
                guiGraphics.m_280218_(texture, slot.f_40220_, slot.f_40221_, 0, 0, 16, 16);
                guiGraphics.m_285978_(RenderType.m_286086_(), slot.f_40220_, slot.f_40221_, slot.f_40220_ + 16, slot.f_40221_ + 16, -2139062142, -2139062142, 0);
                continue;
            }
            guiGraphics.m_280218_(texture, xPos, yPos, 0, 0, 16, 16);
        }
    }

    @Unique
    private void nemosInventorySorting$initStorageContainerButtons(List<ComponentConfig> componentConfigs) {
        int defaultInventoryYOffset = this.m_6262_() instanceof ShulkerBoxMenu ? this.f_97731_ - 1 : this.f_97731_ - 2;
        this.nemosInventorySorting$createButtons(componentConfigs, new ButtonTypeMapping(DefaultConfigValues.SORT_STORAGE_CONTAINER, SortButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.MOVE_SAME_STORAGE_CONTAINER, MoveSameButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.MOVE_ALL_STORAGE_CONTAINER, MoveAllButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_STORAGE_CONTAINER, DropAllButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.SORT_STORAGE_CONTAINER_INVENTORY, SortButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.MOVE_SAME_STORAGE_CONTAINER_INVENTORY, MoveSameButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.MOVE_ALL_STORAGE_CONTAINER_INVENTORY, MoveAllButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_STORAGE_CONTAINER_INVENTORY, DropAllButtonFactory.getInstance(), defaultInventoryYOffset, true));
    }

    @Unique
    private void nemosInventorySorting$initInventoryButtons(List<ComponentConfig> componentConfigs) {
        this.nemosInventorySorting$createButtons(componentConfigs, new ButtonTypeMapping(DefaultConfigValues.SORT_INVENTORY, SortButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_INVENTORY, true), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_INVENTORY, DropAllButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_INVENTORY, true));
    }

    @Unique
    private void nemosInventorySorting$initContainerInventoryButtons(List<ComponentConfig> componentConfigs) {
        int defaultInventoryYOffset = this.f_97731_ - 1;
        this.nemosInventorySorting$createButtons(componentConfigs, new ButtonTypeMapping(DefaultConfigValues.SORT_CONTAINER_INVENTORY, SortButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_CONTAINER_INVENTORY, DropAllButtonFactory.getInstance(), defaultInventoryYOffset, true));
    }

    @Unique
    private void nemosInventorySorting$createButton(List<ComponentConfig> configs, String componentName, FilterButtonCreator filterButtonCreator) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, componentName);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int width = config.width();
        int xOffset = config.xOffset() != null ? config.xOffset() : this.nemosInventorySorting$filterBoxWidth + 3;
        int yOffset = config.yOffset() != null ? config.yOffset() : DefaultConfigValues.Y_OFFSET_ITEM_FILTER;
        AbstractFilterToggleButton button = filterButtonCreator.createButton(this.f_97735_, this.f_97736_, xOffset, yOffset, width, config.height(), this.nemosInventorySorting$filterConfig);
        this.nemosInventorySorting$widgets.add(button);
    }

    @Unique
    private void nemosInventorySorting$createButtons(List<ComponentConfig> configs, ButtonTypeMapping ... mappings) {
        for (ButtonTypeMapping mapping : mappings) {
            ComponentConfig config;
            Optional<ComponentConfig> optionalConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, mapping.componentName());
            if (optionalConfig.isEmpty() || !(config = optionalConfig.get()).isEnabled()) continue;
            int yOffset = config.yOffset() != null ? config.yOffset().intValue() : mapping.defaultYOffset();
            int xOffset = config.xOffset() != null ? config.xOffset() : this.f_97726_ + config.rightXOffset();
            this.nemosInventorySorting$createButton(mapping.factory(), mapping.isInventoryButton(), xOffset, yOffset, config.width(), config.height());
        }
    }

    @Unique
    private void nemosInventorySorting$createButton(ButtonCreator buttonCreator, boolean isInventoryButton, int xOffset, int yOffset, int width, int height) {
        int startIndex = isInventoryButton ? this.nemosInventorySorting$containerSize : 0;
        int endIndex = isInventoryButton ? this.nemosInventorySorting$inventoryEndIndex : this.nemosInventorySorting$containerSize;
        this.nemosInventorySorting$createButton(buttonCreator, startIndex, endIndex, xOffset, yOffset, width, height, isInventoryButton);
    }

    @Unique
    private void nemosInventorySorting$createButton(ButtonCreator buttonCreator, int startIndex, int endIndex, int xOffset, int yOffset, int width, int height, boolean isInventoryButton) {
        AbstractInventoryButton sortButton = buttonCreator.createButton(startIndex, endIndex, this.f_97735_, this.f_97736_, xOffset, yOffset, width, height, this.m_6262_(), isInventoryButton);
        this.nemosInventorySorting$widgets.add(sortButton);
    }
}

