/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.service;

import com.devnemo.nemos.inventory.sorting.model.SlotItem;
import com.devnemo.nemos.inventory.sorting.service.MergingService;
import com.devnemo.nemos.inventory.sorting.service.SortingService;
import java.util.List;
import java.util.Map;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class InventoryService {
    private static InventoryService INSTANCE;
    private final MergingService inventoryMergeService;

    private InventoryService(MergingService inventoryMergeService) {
        this.inventoryMergeService = inventoryMergeService;
    }

    public static InventoryService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InventoryService(MergingService.getInstance());
        }
        return INSTANCE;
    }

    public void handleSorting(SortingService sortingService, AbstractContainerMenu menu, int startIndex, int endIndex) {
        int containerId = menu.f_38840_;
        List<SlotItem> sortedSlotItems = sortingService.sortSlotItems(menu, startIndex, endIndex);
        this.inventoryMergeService.mergeAllItems(menu, sortedSlotItems, containerId);
        List<SlotItem> sortedSlotItemsAfterMerge = sortingService.sortSlotItems(menu, startIndex, endIndex);
        Map<Integer, Integer> slotSwapMap = sortingService.retrieveSlotSwapMap(sortedSlotItemsAfterMerge, startIndex);
        sortingService.sortItemsInInventory(menu, slotSwapMap, containerId);
    }

    public int calculateEndIndex(boolean shouldIncludeHotbar, int endIndex) {
        if (shouldIncludeHotbar) {
            return endIndex + 9;
        }
        return endIndex;
    }
}

