/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.service;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class TooltipService {
    private static TooltipService INSTANCE;
    private final Minecraft minecraft;

    public TooltipService(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public static TooltipService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TooltipService(Minecraft.m_91087_());
        }
        return INSTANCE;
    }

    public List<Component> retrieveTooltipLines(ItemStack itemStack) {
        return itemStack.m_41651_((Player)this.minecraft.f_91074_, (TooltipFlag)(this.minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
    }

    public String retrieveEnchantmentNames(List<Component> tooltipComponents) {
        return tooltipComponents.stream().filter(component -> component.toString().contains("enchantment")).map(Component::getString).collect(Collectors.joining(","));
    }

    public String retrieveJukeboxSongName(List<Component> tooltipComponents) {
        return tooltipComponents.stream().filter(component -> component.toString().contains("jukebox_song")).map(Component::getString).findFirst().orElse("");
    }

    public String retrievePotionName(List<Component> tooltipComponents) {
        return tooltipComponents.stream().filter(component -> component.toString().contains("potion.withDuration") || component.toString().contains("potion.withAmplifier")).map(Component::getString).findFirst().orElse("");
    }
}

