/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.service;

import com.devnemo.nemos.inventory.sorting.model.FilterResult;
import com.devnemo.nemos.inventory.sorting.service.TooltipService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class FilterService {
    private static FilterService INSTANCE;
    private final TooltipService tooltipService;

    public static FilterService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FilterService(TooltipService.getInstance());
        }
        return INSTANCE;
    }

    public FilterService(TooltipService tooltipService) {
        this.tooltipService = tooltipService;
    }

    public Map<FilterResult, List<class_1735>> filterSlots(class_2371<class_1735> slots, String filter) {
        return slots.stream().collect(Collectors.groupingBy(slot -> this.filterSlot((class_1735)slot, filter)));
    }

    private FilterResult filterSlot(class_1735 slot, String filter) {
        class_1799 slotItem = slot.method_7677();
        if (slotItem.method_31574(class_1802.field_8162)) {
            return FilterResult.EXCLUDED;
        }
        if (this.itemContainerContentsMatchFilter(slotItem, filter)) {
            return FilterResult.HAS_INCLUDED_ITEM;
        }
        return this.matchesFilter(slotItem, filter) ? FilterResult.INCLUDED : FilterResult.EXCLUDED;
    }

    private boolean itemContainerContentsMatchFilter(class_1799 itemStack, String filter) {
        class_2487 compoundTag = itemStack.method_7969();
        if (compoundTag == null || !compoundTag.method_10545("BlockEntityTag")) {
            return false;
        }
        String containerItems = compoundTag.method_10580("BlockEntityTag").method_10714();
        return containerItems.contains(filter);
    }

    private boolean contentsMatchFilter(Stream<class_1799> stream, String filter) {
        return stream.anyMatch(itemStack -> this.matchesFilter((class_1799)itemStack, filter));
    }

    private boolean matchesFilter(class_1799 itemStack, String filter) {
        boolean itemNameMatchesFilter = this.componentMatchesFilter(itemStack.method_7909().method_7864(itemStack), filter);
        boolean itemDisplayNameMatchesFilter = this.componentMatchesFilter(itemStack.method_7954(), filter);
        boolean tooltipMatchesFilter = this.tooltipMatchesFilter(itemStack, filter);
        return itemNameMatchesFilter || itemDisplayNameMatchesFilter || tooltipMatchesFilter;
    }

    private boolean tooltipMatchesFilter(class_1799 itemStack, String filter) {
        List<class_2561> tooltipComponents = this.tooltipService.retrieveTooltipLines(itemStack);
        boolean itemEnchantsMatchesFilter = this.tooltipService.retrieveEnchantmentNames(tooltipComponents).toLowerCase().contains(filter.toLowerCase());
        boolean jukeboxSongMatchesFilter = this.tooltipService.retrieveJukeboxSongName(tooltipComponents).toLowerCase().contains(filter.toLowerCase());
        boolean potionMatchesFilter = this.tooltipService.retrievePotionName(tooltipComponents).toLowerCase().contains(filter.toLowerCase());
        return itemEnchantsMatchesFilter || jukeboxSongMatchesFilter || potionMatchesFilter;
    }

    private boolean componentMatchesFilter(class_2561 component, String filter) {
        return component.getString().toLowerCase().contains(filter.toLowerCase());
    }
}

