/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.service;

import com.devnemo.nemos.inventory.sorting.Constants;
import com.devnemo.nemos.inventory.sorting.helper.SortOrder;
import com.devnemo.nemos.inventory.sorting.model.SlotItem;
import com.devnemo.nemos.inventory.sorting.service.SlotSwappingService;
import com.devnemo.nemos.inventory.sorting.service.TooltipService;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class SortingService {
    private static SortingService INSTANCE;
    private final SlotSwappingService inventorySwapService;
    private final TooltipService tooltipService;
    private final class_310 minecraft;

    private SortingService(SlotSwappingService inventorySwapService, TooltipService tooltipService, class_310 minecraft) {
        this.inventorySwapService = inventorySwapService;
        this.tooltipService = tooltipService;
        this.minecraft = minecraft;
    }

    public static SortingService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SortingService(SlotSwappingService.getInstance(), TooltipService.getInstance(), class_310.method_1551());
        }
        return INSTANCE;
    }

    @NotNull
    public List<SlotItem> sortSlotItems(class_1703 menu, int startIndex, int endIndex) {
        return IntStream.range(startIndex, endIndex).mapToObj(slotIndex -> new SlotItem(slotIndex, ((class_1735)menu.field_7761.get(slotIndex)).method_7677())).filter(slotItem -> !slotItem.itemStack().method_7960()).sorted(this.comparatorByItemOrder()).toList();
    }

    protected Comparator<SlotItem> comparatorByItemOrder() {
        List<class_1792> sortOrder = SortOrder.getSortOrder();
        Comparator<SlotItem> comparator = Comparator.comparingInt(slotItem -> IntStream.range(0, sortOrder.size()).filter(i -> slotItem.itemStack().method_31574((class_1792)sortOrder.get(i))).findFirst().orElse(Integer.MAX_VALUE));
        return this.comparatorByName(comparator);
    }

    protected Comparator<SlotItem> comparatorByName(Comparator<SlotItem> comparator) {
        Comparator<SlotItem> nameComparator = comparator.thenComparing(slotItem -> slotItem.itemStack().method_7909().method_7864(slotItem.itemStack()).getString());
        return this.comparatorByTooltip(nameComparator);
    }

    private Comparator<SlotItem> comparatorByTooltip(Comparator<SlotItem> comparator) {
        Comparator<SlotItem> enchantmentComparator = comparator.thenComparing(slotItem -> {
            List<class_2561> tooltipComponents = this.tooltipService.retrieveTooltipLines(slotItem.itemStack());
            return this.tooltipService.retrieveEnchantmentNames(tooltipComponents);
        });
        Comparator<SlotItem> jukeboxSongComparator = enchantmentComparator.thenComparing(slotItem -> {
            List<class_2561> tooltipComponents = this.tooltipService.retrieveTooltipLines(slotItem.itemStack());
            return this.tooltipService.retrieveJukeboxSongName(tooltipComponents);
        });
        return jukeboxSongComparator.thenComparing(slotItem -> {
            List<class_2561> tooltipComponents = this.tooltipService.retrieveTooltipLines(slotItem.itemStack());
            return this.tooltipService.retrievePotionName(tooltipComponents);
        });
    }

    public Map<Integer, Integer> retrieveSlotSwapMap(List<SlotItem> slotItems, int startIndex) {
        LinkedHashMap<Integer, Integer> slotSwapMap = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < slotItems.size(); ++i) {
            int newSlot = i + startIndex;
            int currentSlot = slotItems.get(i).slotIndex();
            if (currentSlot == newSlot) continue;
            slotSwapMap.put(currentSlot, newSlot);
        }
        return slotSwapMap;
    }

    public void sortItemsInInventory(class_1703 menu, Map<Integer, Integer> slotSwapMap, int containerId) {
        Iterator<Map.Entry<Integer, Integer>> iterator;
        int remainingCyles = 1000;
        while (!slotSwapMap.isEmpty() && remainingCyles-- > 0 && (iterator = slotSwapMap.entrySet().iterator()).hasNext()) {
            int targetSlot;
            Map.Entry<Integer, Integer> entry = iterator.next();
            int currentSlot = entry.getKey();
            if (currentSlot == (targetSlot = entry.getValue().intValue())) {
                iterator.remove();
                continue;
            }
            this.inventorySwapService.performSlotSwap(menu, this.minecraft.field_1761, containerId, currentSlot, targetSlot, this.minecraft.field_1724);
            if (slotSwapMap.containsKey(targetSlot)) {
                slotSwapMap.put(currentSlot, slotSwapMap.get(targetSlot));
            } else {
                iterator.remove();
            }
            slotSwapMap.put(targetSlot, targetSlot);
        }
        if (remainingCyles <= 0) {
            Constants.LOG.warn("Slot swap cycle limit reached. Please report this");
        }
    }
}

