/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.gui.components.buttons;

import com.nemonotfound.nemos.inventory.sorting.gui.components.buttons.AbstractButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInventoryButton
extends AbstractButton {
    protected final AbstractContainerMenu menu;
    protected final Integer startIndex;
    protected final Integer endIndex;
    private final Component buttonName;
    private final Component shiftButtonName;
    protected final boolean isInventoryButton;
    protected int currentEndIndex;

    public AbstractInventoryButton(Builder<? extends AbstractInventoryButton> builder) {
        super(builder.x, builder.y, builder.xOffset, builder.width, builder.height, builder.buttonName);
        this.setTooltip(Tooltip.create((Component)builder.buttonName));
        this.buttonName = builder.buttonName;
        this.shiftButtonName = builder.shiftButtonName;
        this.menu = builder.menu;
        this.startIndex = builder.startIndex;
        this.endIndex = builder.endIndex;
        this.isInventoryButton = builder.isInventoryButton;
        this.currentEndIndex = this.endIndex;
    }

    @Override
    public boolean keyPressed(@NotNull KeyEvent keyEvent) {
        this.handleShiftKeyEvent(keyEvent);
        return super.keyPressed(keyEvent);
    }

    public boolean keyReleased(@NotNull KeyEvent keyEvent) {
        this.handleShiftKeyEvent(keyEvent);
        return super.keyReleased(keyEvent);
    }

    private void handleShiftKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.key() == 340 || keyEvent.key() == 344) {
            this.setTooltip();
            this.setEndIndex();
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return this.isHovered() ? this.getButtonHoverTexture() : this.getButtonTexture();
    }

    protected abstract ResourceLocation getButtonHoverTexture();

    protected abstract ResourceLocation getButtonTexture();

    private void setTooltip() {
        if (this.shouldIncludeHotbar()) {
            this.setTooltip(Tooltip.create((Component)this.shiftButtonName));
        } else {
            this.setTooltip(Tooltip.create((Component)this.buttonName));
        }
    }

    private void setEndIndex() {
        this.currentEndIndex = this.shouldIncludeHotbar() ? this.endIndex + 9 : this.endIndex;
    }

    private boolean shouldIncludeHotbar() {
        return Minecraft.getInstance().hasShiftDown() && this.isInventoryButton;
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    public static class Builder<T extends AbstractInventoryButton> {
        private Integer startIndex;
        private Integer endIndex;
        private Integer x;
        private Integer y;
        private Integer xOffset;
        private Integer width;
        private Integer height;
        private Component buttonName;
        private Component shiftButtonName;
        private AbstractContainerMenu menu;
        private boolean isInventoryButton = false;
        private final Class<T> clazz;

        public Builder(Class<T> clazz) {
            this.clazz = clazz;
        }

        public Builder<T> startIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public Builder<T> endIndex(int endIndex) {
            this.endIndex = endIndex;
            return this;
        }

        public Builder<T> x(int x) {
            this.x = x;
            return this;
        }

        public Builder<T> y(int y) {
            this.y = y;
            return this;
        }

        public Builder<T> xOffset(int xOffset) {
            this.xOffset = xOffset;
            return this;
        }

        public Builder<T> width(int width) {
            this.width = width;
            return this;
        }

        public Builder<T> height(int height) {
            this.height = height;
            return this;
        }

        public Builder<T> buttonName(Component buttonName) {
            this.buttonName = buttonName;
            return this;
        }

        public Builder<T> shiftButtonName(Component shiftButtonName) {
            this.shiftButtonName = shiftButtonName;
            return this;
        }

        public Builder<T> menu(AbstractContainerMenu menu) {
            this.menu = menu;
            return this;
        }

        public Builder<T> isInventoryButton(boolean isInventoryButton) {
            this.isInventoryButton = isInventoryButton;
            return this;
        }

        public T build() {
            this.checkRequiredFields();
            try {
                return (T)((AbstractInventoryButton)this.clazz.getDeclaredConstructor(Builder.class).newInstance(this));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create instance of " + this.clazz.getName(), e);
            }
        }

        private void checkRequiredFields() {
            if (this.startIndex == null || this.endIndex == null || this.x == null || this.y == null || this.xOffset == null || this.width == null || this.height == null || this.buttonName == null || this.menu == null) {
                throw new IllegalArgumentException("Not all fields were set!");
            }
        }
    }
}

